/*
 * Decompiled with CFR 0.152.
 */
package app;

import app.App;
import app.MainMenu;
import com.movilenio.game.Kernel;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import movilib.SPRManager;

public class TileMap {
    public static final int EMPTY = 0;
    public static final int SPIDER = 15;
    public static final int TILE_SIZE = 32;
    public static final int SHIFT = 5;
    Image[] tiles;
    public static final int MAX_MAP_SIZE = 1024;
    int mapWidth;
    int mapHeight;
    int mapPixelWidth;
    int mapPixelHeight;
    byte[] map = new byte[1024];
    byte[] map2 = new byte[1024];
    int wWidth;
    int wHeight;
    int wWidth2;
    int wHeight2;
    int old_x;
    int old_y;
    int x;
    int y;
    private int ox;
    private int oy;
    byte contadorTileAnimado;
    byte tipoEscenario;
    public static final byte scCUEVA = 2;
    public static final byte scBIBLIOTECA = 1;
    int xEnemigo;
    int yEnemigo;
    public static final int WIDTH = 240;
    public static final int LOOP = 16;
    public static final int VEL = 512;
    int base_x;
    Image[] line;

    public void loadResources() {
        try {
            this.tipoEscenario = App.fondos[App.game.nivel];
            Image img = Image.createImage((String)("/fase" + this.tipoEscenario + "_t.png"));
            int n = (img.getWidth() >> 5) * (img.getHeight() >> 5);
            this.tiles = new Image[n];
            int i = 0;
            for (int y = 0; y < img.getHeight(); y += 32) {
                for (int x = 0; x < img.getWidth(); x += 32) {
                    this.tiles[i] = Image.createImage((int)32, (int)32);
                    this.tiles[i].getGraphics().drawImage(img, -x, -y, 0);
                    ++i;
                }
            }
            img = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.loadSuelo("/suelo.dat", "/suelo" + this.tipoEscenario + ".pal", this.tipoEscenario);
        this.old_x = Integer.MAX_VALUE;
        this.old_y = Integer.MAX_VALUE;
    }

    public void freeResources() {
        int i;
        for (i = 0; i < this.tiles.length; ++i) {
            this.tiles[i] = null;
        }
        this.tiles = null;
        for (i = 0; i < this.line.length; ++i) {
            this.line[i] = null;
        }
        this.wWidth = 0;
        this.wHeight = 0;
    }

    public void init() {
    }

    public void done() {
    }

    public void setBounds(int width, int height) {
        if (width != this.wWidth || height != this.wHeight) {
            this.wWidth = width;
            this.wWidth2 = this.wWidth >> 1;
            this.wHeight = height;
            this.wHeight2 = this.wHeight >> 1;
        }
    }

    public final int scrX(int mapX) {
        return this.ox + mapX;
    }

    public final int scrY(int mapY) {
        return this.oy + mapY;
    }

    public final byte getTile(int x, int y) {
        return this.map[(y >> 5) * this.mapWidth + (x >> 5)];
    }

    public final int getTilePos(int x, int y) {
        return (y >> 5) * this.mapWidth + (x >> 5);
    }

    public boolean load(String tilemap) {
        try {
            InputStream is = this.getClass().getResourceAsStream(tilemap);
            if (is == null) {
                return false;
            }
            this.mapWidth = is.read();
            this.mapPixelWidth = this.mapWidth << 5;
            this.mapHeight = is.read();
            this.mapPixelHeight = this.mapHeight << 5;
            is.read(this.map, 0, this.mapWidth * this.mapHeight);
            is.close();
            is = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setViewPoint(0, 0, true);
        return true;
    }

    private final void updateRect(Graphics g, int x0, int y0, int w, int h) {
        if (w == 0 || h == 0) {
            return;
        }
        g.clipRect(x0, y0, w, h);
        int tx0 = this.x + x0 >> 5;
        int ty0 = this.y + y0 >> 5;
        int tx1 = this.x + x0 + w - 1 >> 5;
        int ty1 = this.y + y0 + h - 1 >> 5;
        int twidth = tx1 - tx0 + 1;
        int theight = ty1 - ty0 + 1;
        int incmapx = this.mapWidth - twidth;
        int xx0 = this.ox + (tx0 << 5);
        int yy0 = this.oy + (ty0 << 5);
        int i = ty0 * this.mapWidth + tx0;
        int yy = yy0;
        for (int hh = theight; hh != 0; --hh) {
            int xx = xx0;
            for (int ww = twidth; ww != 0; --ww) {
                byte tileID;
                if ((tileID = this.map[i++]) >= this.tiles.length) {
                    tileID = 0;
                }
                g.drawImage(this.tiles[tileID], xx, yy, 0);
                xx += 32;
            }
            i += incmapx;
            yy += 32;
        }
    }

    private final void postRender(Graphics g) {
        g.setClip(0, 0, this.wWidth, this.wHeight);
        int tx0 = this.x >> 5;
        int ty0 = this.y >> 5;
        int tx1 = this.x + this.wWidth - 1 >> 5;
        int ty1 = this.y + this.wHeight - 1 >> 5;
        int twidth = tx1 - tx0 + 1;
        int theight = ty1 - ty0 + 1;
        int incmapx = this.mapWidth - twidth;
        int xx0 = this.ox + (tx0 << 5);
        int yy0 = this.oy + (ty0 << 5);
        int i = ty0 * this.mapWidth + tx0;
        int yy = yy0;
        boolean id = false;
        this.xEnemigo = 0;
        for (int hh = theight; hh != 0; --hh) {
            int xx = xx0;
            int ww = twidth;
            while (ww != 0) {
                switch (this.tipoEscenario) {
                    case 2: {
                        if (this.map[i] == 0) {
                            g.drawImage(this.tiles[this.map[i] + this.contadorTileAnimado], xx, yy, 0);
                        }
                        if (this.map[i] != 15) break;
                        this.xEnemigo = App.game.scrollX + xx;
                        break;
                    }
                    case 1: {
                        if (this.map[i] != 0) break;
                        int n = i;
                        this.map2[n] = (byte)(this.map2[n] + 1);
                        if (this.map2[n] < 12) {
                            g.drawImage(this.tiles[this.map2[i] >> 2], xx, yy, 0);
                        } else if (this.map2[i] < 18) {
                            g.drawImage(this.tiles[2], xx, yy, 0);
                        } else if (this.map2[i] == 18) {
                            // empty if block
                        }
                        if (this.map2[i] < 24) {
                            g.drawImage(this.tiles[1], xx, yy, 0);
                            break;
                        }
                        if (this.map2[i] <= 104) break;
                        this.map2[i] = -1;
                    }
                }
                xx += 32;
                --ww;
                ++i;
            }
            i += incmapx;
            yy += 32;
        }
    }

    public final void setViewPoint(int x, int y, boolean repaint) {
        this.x = x = MainMenu.limit(x, 0, this.mapPixelWidth - this.wWidth);
        this.y = y = MainMenu.limit(y, 0, this.mapPixelHeight - this.wHeight);
        this.ox = -x;
        this.oy = -y;
        int updateH = this.wHeight;
        if (!repaint) {
            int scroll_w = Math.min(this.wWidth, Math.abs(this.old_x - x));
            int scroll_h = Math.min(updateH, Math.abs(this.old_y - y));
            if (scroll_w == 0 && scroll_h == 0) {
                return;
            }
            if (x < this.old_x) {
                boolean scroll_x = false;
            } else {
                int scroll_x = this.wWidth - scroll_w;
            }
            if (y < this.old_y) {
                boolean scroll_y = false;
            } else {
                int scroll_y = this.wHeight - scroll_h;
            }
        }
        this.old_x = x;
        this.old_y = y;
    }

    public final void paint(Graphics g, int x, int y) {
        g.translate(0, y);
        this.updateRect(g, 0, 0, this.wWidth, this.wHeight);
        g.translate(0, -y);
        switch (App.game.nivel) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                g.translate(x, y);
                this.postRender(g);
                g.translate(-x, -y);
                break;
            }
            case 3: {
                g.translate(x, y);
                this.postRender(g);
                g.translate(-x, -y);
                break;
            }
            case 4: {
                g.translate(x, y);
                this.postRender(g);
                g.translate(-x, -y);
            }
        }
    }

    public final void doFrame() {
        switch (this.tipoEscenario) {
            case 2: {
                this.contadorTileAnimado = (byte)(this.contadorTileAnimado + 1);
                if (this.contadorTileAnimado != 3) break;
                this.contadorTileAnimado = 0;
                break;
            }
            case 1: {
                if (this.contadorTileAnimado > 0) {
                    this.contadorTileAnimado = (byte)(this.contadorTileAnimado + 1);
                    if (this.contadorTileAnimado != 11) break;
                    this.contadorTileAnimado = 0;
                    break;
                }
                if ((System.currentTimeMillis() & 0x3FL) != 0L) break;
                this.contadorTileAnimado = 1;
            }
        }
    }

    public void loadSuelo(String imgName, String imgPaleta, byte tipoEscenario) {
        try {
            int i;
            SPRManager sprman = new SPRManager();
            Image img = sprman.loadIndexedImage(imgName, imgPaleta);
            sprman.unload();
            sprman = null;
            int anc = img.getWidth();
            this.base_x = img.getWidth() - 240 >> 1;
            this.line = new Image[img.getHeight()];
            for (i = 0; i < img.getHeight() - 1; ++i) {
                this.line[i] = Image.createImage((int)anc, (int)1);
                this.line[i].getGraphics().drawImage(img, 0, -i, 0);
            }
            Image valdosa = Kernel.instance.loadImage("/base" + tipoEscenario + ".png");
            this.line[i] = Image.createImage((int)anc, (int)valdosa.getHeight());
            Graphics gr = this.line[i].getGraphics();
            gr.drawImage(img, 0, -i, 0);
            int ancVal = valdosa.getWidth();
            for (int j = (anc - ancVal >> 1) % ancVal - ancVal; j < anc; j += ancVal) {
                gr.drawImage(valdosa, j, 1, 0);
            }
            valdosa = null;
            img = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void paintSuelo(Graphics g, int x, int y) {
        if ((x %= 16) < 0) {
            x += 16;
        }
        int inc = ((x <<= 8) + 256) / 16;
        for (int i = 0; i < this.line.length; ++i) {
            g.drawImage(this.line[i], (x >> 8) - this.base_x, y + i, 0);
            x += inc;
        }
    }

    protected void unload() {
        this.map = null;
        this.map2 = null;
        for (int i = this.tiles.length - 1; i >= 0; --i) {
            this.tiles[i] = null;
        }
        this.tiles = null;
    }
}

