/*
 * Decompiled with CFR 0.152.
 */
package com.sprintpcs.media;

import com.sprintpcs.media.Clip;
import com.sprintpcs.media.DualTone;
import com.sprintpcs.media.PlayerListener;
import com.sprintpcs.media.Vibrator;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.control.ToneControl;

public class Player {
    private static final int NONE_PLAYED = 0;
    private static final int CLIP_PLAYING = 1;
    private static final int CLIP_PAUSED = 2;
    private static final int BACKGROUND_PLAYING = 4;
    private static final int BACKGROUND_PAUSED = 5;
    private static final int TONE_PLAYING = 6;
    private static final int TONE_PAUSED = 7;
    private static final byte TEMPO = 60;
    private static final byte RESOLUTION = 96;
    private static final int INFINITE_LOOPCOUNT = -1;
    private static int currentState = 0;
    private static int previousState = 0;
    private static long savedMediaTime = 0L;
    private static long savedBGMediaTime = 0L;
    private static int currentPriority = 0;
    private static Object currentPlayed = null;
    private static int clipLoopcount = -2;
    private static int toneLoopcount = -2;
    private static int backgroundLoopcount = -2;
    private static PlayerListener listener = null;
    private static javax.microedition.media.Player pGlobal = null;
    private static javax.microedition.media.Player pBackground = null;
    private static javax.microedition.media.Player tGlobal = null;
    private static ToneControl tControl = null;
    private static Clip clipGlobal = null;
    private static DualTone dtGlobal = null;
    private static Clip bgClipGlobal = null;

    public static synchronized void addPlayerListener(PlayerListener oListener) {
        listener = oListener;
    }

    public static synchronized void play(Clip clip, int repeat) throws IllegalArgumentException {
        if (repeat < -1) {
            throw new IllegalArgumentException("Repeat must be -1 or greater");
        }
        if (clip == null || clip.getPriority() < currentPriority) {
            return;
        }
        try {
            switch (currentState) {
                case 0: {
                    break;
                }
                case 1: {
                    if (pGlobal != null) {
                        pGlobal.close();
                        pGlobal = null;
                    }
                    if (listener == null) break;
                    listener.playerUpdate(7, currentPlayed);
                    break;
                }
                case 6: {
                    if (tGlobal != null) {
                        tGlobal.close();
                        tGlobal = null;
                    }
                    if (listener == null) break;
                    listener.playerUpdate(7, currentPlayed);
                    break;
                }
                case 4: {
                    if (pBackground != null) {
                        pBackground.stop();
                    }
                    if (listener == null) break;
                    listener.playerUpdate(7, currentPlayed);
                    break;
                }
                default: {
                    return;
                }
            }
            pGlobal = clip.getPlayer();
            clipLoopcount = repeat != -1 ? repeat + 1 : -1;
            pGlobal.setLoopCount(clipLoopcount);
            PlayerListenerHandler handler = new PlayerListenerHandler(listener);
            handler.addListener(Player.pGlobal);
            currentPriority = clip.getPriority();
            clipGlobal = clip;
            currentState = 1;
            currentPlayed = clip;
            Vibrator.vibrate(clip.getVibration());
            pGlobal.start();
        }
        catch (MediaException e2) {
            if (listener != null) {
                listener.playerUpdate(2, currentPlayed);
            }
            System.out.println("Player.play() clip encountered a MediaException: " + e2.getMessage());
            e2.printStackTrace();
            currentState = 0;
            currentPlayed = null;
            clipGlobal = null;
            currentPriority = 0;
        }
        catch (Exception e3) {
            currentState = 0;
            currentPlayed = null;
            clipGlobal = null;
            currentPriority = 0;
            e3.printStackTrace();
        }
    }

    public static synchronized void play(DualTone dualTone, int repeat) throws IllegalArgumentException {
        if (repeat < -1) {
            throw new IllegalArgumentException("Repeat must be -1 or greater");
        }
        try {
            if (dualTone.priority < currentPriority) {
                return;
            }
            switch (currentState) {
                case 0: {
                    break;
                }
                case 1: {
                    if (pGlobal != null) {
                        pGlobal.close();
                        pGlobal = null;
                    }
                    if (listener == null) break;
                    listener.playerUpdate(7, currentPlayed);
                    break;
                }
                case 4: {
                    if (pBackground != null) {
                        pBackground.stop();
                    }
                    if (listener == null) break;
                    listener.playerUpdate(7, currentPlayed);
                    break;
                }
                case 6: {
                    if (tGlobal != null) {
                        tGlobal.close();
                        tGlobal = null;
                    }
                    if (listener == null) break;
                    listener.playerUpdate(7, currentPlayed);
                    break;
                }
                default: {
                    return;
                }
            }
            if (tGlobal != null) {
                tGlobal.close();
                tGlobal = null;
            }
            tGlobal = Manager.createPlayer((String)"device://tone");
            tGlobal.realize();
            tControl = (ToneControl)tGlobal.getControl("ToneControl");
            toneLoopcount = repeat != -1 ? repeat + 1 : -1;
            tGlobal.setLoopCount(toneLoopcount);
            tControl.setSequence(dualTone.toneSequence);
            PlayerListenerHandler handler = new PlayerListenerHandler(listener);
            handler.addListener(Player.tGlobal);
            currentPriority = dualTone.priority;
            currentPlayed = dualTone;
            dtGlobal = dualTone;
            currentState = 6;
            tGlobal.start();
        }
        catch (MediaException e2) {
            if (listener != null) {
                listener.playerUpdate(2, currentPlayed);
            }
            e2.printStackTrace();
            System.out.println("Player.play(DualTone) encountered an exception: " + e2.getMessage());
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
    }

    public static synchronized void playBackground(Clip clip, int repeat) throws IllegalArgumentException {
        if (repeat < -1) {
            throw new IllegalArgumentException("Repeat must be -1 or greater");
        }
        if (clip == null) {
            return;
        }
        try {
            switch (currentState) {
                case 0: {
                    currentState = 4;
                    break;
                }
                case 1: 
                case 4: 
                case 6: {
                    break;
                }
                default: {
                    return;
                }
            }
            if (pBackground != null) {
                pBackground.close();
            }
            pBackground = clip.getPlayer();
            backgroundLoopcount = repeat != -1 ? repeat + 1 : -1;
            pBackground.setLoopCount(backgroundLoopcount);
            PlayerListenerHandler handler = new PlayerListenerHandler(listener);
            handler.addListener(Player.pBackground);
            bgClipGlobal = clip;
            if (currentState != 1 && currentState != 6) {
                currentPlayed = bgClipGlobal;
                pBackground.start();
            }
        }
        catch (MediaException e2) {
            if (listener != null) {
                listener.playerUpdate(2, currentPlayed);
            }
            e2.printStackTrace();
            System.out.println("playBackground() encountered a MediaException: " + e2.getMessage());
            currentState = 0;
            currentPlayed = null;
            bgClipGlobal = null;
        }
        catch (Exception e3) {
            if (listener != null) {
                listener.playerUpdate(2, currentPlayed);
            }
            System.out.println("playBackground() encountered an IOException: " + e3.getMessage());
            currentState = 0;
            currentPlayed = null;
            bgClipGlobal = null;
            e3.printStackTrace();
        }
    }

    public static synchronized void pause() {
        try {
            switch (currentState) {
                case 1: {
                    if (pGlobal.getState() == 400) {
                        currentState = 2;
                        pGlobal.stop();
                    }
                    break;
                }
                case 4: {
                    if (pBackground.getState() == 400) {
                        currentState = 5;
                        pBackground.stop();
                    }
                    break;
                }
                case 6: {
                    if (tGlobal.getState() == 400) {
                        currentState = 7;
                        tGlobal.stop();
                    }
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (MediaException e2) {
            System.out.println("Player.pause encountered an exception: " + e2.getMessage());
            e2.printStackTrace();
            currentState = 0;
            currentPlayed = null;
            bgClipGlobal = null;
            if (listener != null) {
                listener.playerUpdate(2, currentPlayed);
            }
        }
        catch (Exception e3) {
            currentState = 0;
            currentPlayed = null;
            bgClipGlobal = null;
            e3.printStackTrace();
        }
    }

    public static synchronized void resume() {
        try {
            switch (currentState) {
                case 2: {
                    currentState = 1;
                    pGlobal.start();
                    break;
                }
                case 5: {
                    currentState = 4;
                    pBackground.start();
                    break;
                }
                case 7: {
                    currentState = 6;
                    tGlobal.start();
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception e2) {
            if (listener != null) {
                listener.playerUpdate(2, currentPlayed);
            }
            currentState = 0;
            currentPlayed = null;
            bgClipGlobal = null;
            e2.printStackTrace();
        }
    }

    public static synchronized void stop() {
        try {
            switch (currentState) {
                case 1: {
                    if (pGlobal != null) {
                        pGlobal.close();
                        pGlobal = null;
                    }
                    if (pBackground == null) break;
                    currentPlayed = bgClipGlobal;
                    pBackground.start();
                    break;
                }
                case 2: {
                    if (pGlobal == null) break;
                    pGlobal.close();
                    pGlobal = null;
                    break;
                }
                case 4: {
                    if (pBackground == null) break;
                    pBackground.close();
                    pBackground = null;
                    break;
                }
                case 5: {
                    if (pBackground == null) break;
                    pBackground.close();
                    pBackground = null;
                    break;
                }
                case 6: {
                    if (tGlobal == null) break;
                    tGlobal.close();
                    tGlobal = null;
                    break;
                }
                default: {
                    return;
                }
            }
            currentState = 0;
            if (pBackground == null) {
                currentPlayed = null;
            }
            currentPriority = 0;
        }
        catch (Exception e2) {
            if (listener != null) {
                listener.playerUpdate(2, currentPlayed);
            }
            currentState = 0;
            currentPlayed = null;
            currentPriority = 0;
            e2.printStackTrace();
        }
    }

    private static class PlayerListenerHandler
    implements javax.microedition.media.PlayerListener {
        PlayerListenerHandler(PlayerListener oListener) {
            listener = oListener;
        }

        private void addListener(javax.microedition.media.Player player) {
            try {
                player.addPlayerListener((javax.microedition.media.PlayerListener)this);
            }
            catch (Exception e2) {
                System.out.println("Exception in addPlayerListener");
            }
        }

        public void playerUpdate(javax.microedition.media.Player player, String event, Object eventData) {
            if (currentPlayed == null && event != "closed") {
                System.out.println("ERROR: currentPlayed is null!");
            }
            if (event == "started") {
                long mediaTime = Long.parseLong(eventData.toString());
                if (mediaTime > 0L) {
                    if (listener != null) {
                        listener.playerUpdate(6, currentPlayed);
                    }
                } else if (mediaTime == 0L) {
                    if (listener != null) {
                        listener.playerUpdate(3, currentPlayed);
                    }
                } else {
                    System.out.println("com.sprintpcs.media.Player: media time is not supported");
                }
            } else if (event == "stopped") {
                if (currentState == 2 || currentState == 5) {
                    if (listener != null) {
                        listener.playerUpdate(5, currentPlayed);
                    }
                } else if (listener != null) {
                    listener.playerUpdate(4, currentPlayed);
                }
            } else if (event == "endOfMedia") {
                if (listener != null) {
                    listener.playerUpdate(1, currentPlayed);
                }
                if (player == pGlobal) {
                    if (clipLoopcount != -1) {
                        clipLoopcount--;
                    }
                    if (clipLoopcount > 0 || clipLoopcount == -1) {
                        return;
                    }
                } else if (player == tGlobal) {
                    if (toneLoopcount != -1) {
                        toneLoopcount--;
                    }
                    if (toneLoopcount > 0 || toneLoopcount == -1) {
                        return;
                    }
                } else if (player == pBackground) {
                    if (backgroundLoopcount != -1) {
                        backgroundLoopcount--;
                    }
                    if (backgroundLoopcount == 0) {
                        pBackground.close();
                        pBackground = null;
                        currentPlayed = null;
                    }
                    if (backgroundLoopcount > 0 || backgroundLoopcount == -1) {
                        return;
                    }
                }
                try {
                    switch (currentState) {
                        case 1: {
                            pGlobal.close();
                            pGlobal = null;
                            clipGlobal = null;
                            currentPlayed = null;
                            currentState = 0;
                            currentPriority = 0;
                            if (pBackground != null) {
                                currentPriority = 0;
                                currentState = 4;
                                currentPlayed = bgClipGlobal;
                                pBackground.start();
                                return;
                            }
                            break;
                        }
                        case 6: {
                            tGlobal.close();
                            tGlobal = null;
                            dtGlobal = null;
                            currentPlayed = null;
                            currentState = 0;
                            currentPriority = 0;
                            if (pBackground != null) {
                                currentPriority = 0;
                                currentState = 4;
                                currentPlayed = bgClipGlobal;
                                pBackground.start();
                                return;
                            }
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                }
                catch (MediaException e2) {
                    if (listener != null) {
                        listener.playerUpdate(2, currentPlayed);
                        System.out.println("play background clip encountered a MediaException: " + e2.getMessage());
                    }
                    e2.printStackTrace();
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
            } else if (event == "deviceUnavailable") {
                if (listener != null) {
                    listener.playerUpdate(0, currentPlayed);
                }
            } else if (event == "error" && listener != null) {
                listener.playerUpdate(2, currentPlayed);
            }
        }
    }
}

