/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;

public class SoundPlayer
implements PlayerListener {
    private static SoundPlayer instance = null;
    public static int PLAYERSTATE = 0;
    public static int PLAYERMODE = 1;
    public int lastPlayingSound = -1;
    public int[][] playerState;
    private Player[] player;
    private String[] sources = new String[]{"/bgm0.mid", "/bgm1.mid", "/bgm5.mid", "/bgm6.mid", "/sp_bgm0.mid", "/sp_bgm1.mid", "/ending.mid", "/finish.mid", "/gameover.mid", "/title.mid"};
    private byte[][] sourceBuff = null;

    public static SoundPlayer getSoundPlayer() {
        block2: {
            if (instance != null) break block2;
            try {
                instance = new SoundPlayer();
            }
            catch (Exception e) {}
        }
        return instance;
    }

    private SoundPlayer() {
        this.player = new Player[this.sources.length];
        this.playerState = new int[this.sources.length][2];
        this.sourceBuff = new byte[this.sources.length][];
        int i = 0;
        while (i < this.sources.length) {
            this.sourceBuff[i] = this.readDataFromJar(this.sources[i]);
            ++i;
        }
    }

    public void playerUpdate(Player pl, String event, Object eventData) {
        block9: {
            try {
                int playerID = 0;
                int i = 0;
                while (i < this.player.length) {
                    if (this.player[i] != null && this.player[i] == pl) {
                        playerID = i;
                    }
                    ++i;
                }
                if (event == "started") {
                    this.playerState[playerID][SoundPlayer.PLAYERSTATE] = 1;
                    this.lastPlayingSound = playerID;
                } else if (event == "stopped") {
                    this.playerState[playerID][SoundPlayer.PLAYERSTATE] = 0;
                }
                if (event != "deviceUnavailable") break block9;
                try {
                    this.stopAllSounds();
                    Thread.sleep(3000L);
                    this.playSoundIfNotPlayingYet(playerID, -1, true);
                }
                catch (Exception e) {
                }
            }
            catch (Exception e) {
                this.warn("Error: playerUpdate()");
                e.printStackTrace();
            }
        }
    }

    public void playSoundIfNotPlayingYet(int playerNr, int count) {
        this.playSoundIfNotPlayingYet(playerNr, count, false);
    }

    public void playSoundIfNotPlayingYet(int playerNr, int count, boolean reload) {
        block5: {
            try {
                if (!reload && this.playerState[playerNr][PLAYERSTATE] == 1) {
                    return;
                }
                if (reload) {
                    int i = 0;
                    while (i < 3) {
                        this.loadAndUnloadSound(playerNr);
                        ++i;
                    }
                    this.play(playerNr, count);
                    break block5;
                }
                this.play(playerNr, count);
            }
            catch (Exception e) {
                this.warn("Error: playSound()");
                e.printStackTrace();
            }
        }
    }

    private void play(int playerNr, int count) {
        try {
            this.stopAllSounds();
            ByteArrayInputStream in = new ByteArrayInputStream(this.sourceBuff[playerNr]);
            this.player[playerNr] = Manager.createPlayer((InputStream)in, (String)"audio/midi");
            this.player[playerNr].realize();
            this.player[playerNr].prefetch();
            this.player[playerNr].setLoopCount(count);
            this.player[playerNr].addPlayerListener((PlayerListener)this);
            this.player[playerNr].start();
            this.playerState[playerNr][SoundPlayer.PLAYERSTATE] = 1;
            this.lastPlayingSound = playerNr;
        }
        catch (Exception e) {
            this.warn("Error: play()");
            e.printStackTrace();
        }
    }

    public void loadAndUnloadSound(int playerNr) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(this.sourceBuff[playerNr]);
            this.player[playerNr] = Manager.createPlayer((InputStream)in, (String)"audio/midi");
            this.player[playerNr].realize();
            this.player[playerNr].prefetch();
            this.player[playerNr].setLoopCount(1);
            this.player[playerNr].addPlayerListener((PlayerListener)this);
            this.player[playerNr].start();
            this.playerState[playerNr][SoundPlayer.PLAYERSTATE] = 1;
            this.stopAllSounds();
        }
        catch (Exception e) {
            this.warn("Error: loadAndUnloadSOund()");
            e.printStackTrace();
        }
    }

    public void playLastPlayingSound() {
        this.playSoundIfNotPlayingYet(this.lastPlayingSound, -1);
    }

    public void stopAllSounds() {
        int i = 0;
        while (i < this.player.length) {
            try {
                if (this.player[i] != null && this.playerState[i][PLAYERSTATE] == 1) {
                    this.player[i].removePlayerListener((PlayerListener)this);
                    this.player[i].deallocate();
                    this.player[i].stop();
                    this.player[i].close();
                    this.player[i] = null;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.playerState[i][SoundPlayer.PLAYERSTATE] = 0;
            ++i;
        }
    }

    public byte[] readDataFromJar(String name) {
        byte[] res = null;
        try {
            InputStream in = this.getClass().getResourceAsStream(name);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            int ret = in.read();
            while (ret >= 0) {
                bout.write(ret);
                ret = in.read();
            }
            res = bout.toByteArray();
            in.close();
            in = null;
            System.gc();
        }
        catch (Exception e) {
            this.warn("Error: readDataFromJar()  ");
            this.warn("Reource: " + name);
        }
        return res;
    }

    public void warn(Object obj) {
        System.out.println(obj);
    }
}

