/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;

public class Bundle {
    Hashtable hash = new Hashtable();
    StringBuffer buf = new StringBuffer();
    String locale = null;

    public Bundle() {
    }

    public Bundle(String res) throws IOException {
        this.load(res);
    }

    public void load(String res) throws IOException {
        int index = 0;
        int pIndex = 0;
        String lines = null;
        String line = null;
        String key = null;
        Vector<String> vector = new Vector<String>();
        lines = this.read(res);
        while (true) {
            line = lines.substring(pIndex, (index = lines.indexOf("\n", index)) == -1 ? lines.length() : index - 1);
            if (index == -1 && key != null && line != null && line.trim().length() > 0) {
                vector.addElement(line);
            }
            if (line.startsWith("[") && line.endsWith("]") || index == -1) {
                if (key != null && vector.size() > 0) {
                    Object[] s = new String[vector.size()];
                    vector.copyInto(s);
                    this.hash.put(key, s);
                    vector = new Vector();
                }
                if (index == -1) {
                    return;
                }
                key = line.substring(1, line.length() - 1);
                vector = new Vector();
            } else if (key != null && line != null && line.trim().length() > 0) {
                vector.addElement(line);
            }
            pIndex = ++index;
        }
    }

    String read(String res) throws IOException {
        byte[] bytearr = this.readBytes(res);
        if (bytearr == null) {
            throw new IOException("resource not found: " + res);
        }
        int utflen = bytearr.length;
        char[] str = new char[utflen];
        int count = 0;
        int strlen = 0;
        while (count < utflen) {
            int c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str[strlen++] = (char)c;
                    break;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        return new String(bytearr, 0, utflen);
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        return new String(bytearr, 0, utflen);
                    }
                    str[strlen++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    break;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        return new String(bytearr, 0, utflen);
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        return new String(bytearr, 0, utflen);
                    }
                    str[strlen++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    break;
                }
                default: {
                    return new String(bytearr, 0, utflen);
                }
            }
        }
        count = 0;
        while (count < strlen) {
            if (str[count] == '[') break;
            ++count;
        }
        return new String(str, count, strlen - count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] readBytes(String name) {
        ByteArrayOutputStream bout = null;
        InputStream in = null;
        byte[] res = null;
        try {
            in = this.getClass().getResourceAsStream(name);
            if (in != null) {
                bout = new ByteArrayOutputStream();
                int ret = in.read();
                while (ret >= 0) {
                    bout.write(ret);
                    ret = in.read();
                }
                res = bout.toByteArray();
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {}
            try {
                if (bout != null) {
                    bout.close();
                }
            }
            catch (Exception e) {}
        }
        return res;
    }

    public String get(String key) {
        try {
            if (key == null) {
                throw new NullPointerException("key is null");
            }
            if (key.indexOf(".") == -1) {
                return this.get(key, 0);
            }
            String k1 = key.substring(0, key.indexOf("."));
            String k2 = key.substring(key.indexOf(".") + 1, key.length());
            if (this.hash.get(k1) == null) {
                return "null: " + key;
            }
            String[] s = (String[])this.hash.get(k1);
            int i = 0;
            while (i < s.length) {
                String k;
                if (s[i].indexOf("=") != -1 && (k = s[i].substring(0, s[i].indexOf("=")).trim()).equals(k2)) {
                    return s[i].substring(s[i].indexOf("=") + 1, s[i].length()).trim();
                }
                ++i;
            }
            return "null: " + key;
        }
        catch (Exception e) {
            return "error: " + key;
        }
    }

    public String get(String key, int index) {
        try {
            if (key == null) {
                throw new NullPointerException("key is null");
            }
            if (this.hash.get(key) == null) {
                return "null: " + key + "[" + index + "]";
            }
            String[] s = (String[])this.hash.get(key);
            if (index >= s.length) {
                return "out: " + key + "[" + index + "]";
            }
            if (s[index].indexOf("=") == -1) {
                return s[index];
            }
            return s[index].substring(s[index].indexOf("=") + 1, s[index].length()).trim();
        }
        catch (Exception e) {
            return "error: " + key + "[" + index + "]";
        }
    }

    public String[] getArray(String key) {
        try {
            if (key == null) {
                throw new NullPointerException("key is null");
            }
            if (this.hash.get(key) == null) {
                return new String[]{"null: " + key};
            }
            return (String[])this.hash.get(key);
        }
        catch (Exception e) {
            return new String[]{"error: " + key};
        }
    }
}

