/*
 * Decompiled with CFR 0.152.
 */
package DarkEngines;

import DarkEngines.BitmapParticleEffect;
import DarkEngines.Particle;
import java.util.Random;

public class FountainEffect
extends BitmapParticleEffect {
    private int angle = 90;
    private float[] trig = new float[]{1.0f, 0.0f};
    private float[] pos = new float[]{0.0f, 0.0f, 0.0f};
    Random rand = null;

    public FountainEffect(int angle) {
        super("/specials.png", 0.05f);
        this.setAngle(angle);
        this.rand = new Random();
    }

    public void init(Particle p) {
        p.setLife(1.0f);
        p.setPos(this.pos);
        float[] vel = new float[3];
        float xyvel = this.rand.nextFloat() * 8.0f + 2.0f;
        p.setDegradation(xyvel / 18.0f);
        vel[0] = xyvel * this.trig[1] + this.rand.nextFloat() * 0.125f - 0.0625f;
        vel[1] = xyvel * this.trig[0] + this.rand.nextFloat() * 0.125f - 0.0625f;
        vel[2] = 0.0f;
        p.setVel(vel);
        int r = (int)(120.0f * this.rand.nextFloat()) + 135;
        int g = (int)(120.0f * this.rand.nextFloat()) + 135;
        int b = (int)(120.0f * this.rand.nextFloat()) + 135;
        int col = r << 16 | g << 8 | b;
        p.setColor(col);
    }

    public void update(Particle p) {
        float[] ppos = p.getPos();
        float[] vel = p.getVel();
        ppos[0] = ppos[0] + vel[0];
        ppos[1] = ppos[1] + vel[1];
        ppos[2] = ppos[2] + vel[2];
        p.setLife(p.getLife() - p.getDegradation());
        if (p.getLife() < -0.001f) {
            this.init(p);
        }
    }

    public void setAngle(int angle) {
        this.angle = angle;
        this.trig[0] = (float)Math.sin(Math.toRadians(angle));
        this.trig[1] = (float)Math.cos(Math.toRadians(angle));
    }

    public int getAngle() {
        return this.angle;
    }

    void setEmittingOrigin(float[] pos) {
        this.pos = pos;
    }

    float[] getEmittingOrigin() {
        return this.pos;
    }
}

