/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class CCharReader {
    private static final String[] charTst = new String[]{" 0", "1", "ABC2", "DEF3", "GHI4", "JKL5", "MNO6", "PQRS7", "TUV8", "WXYZ9"};
    private static final long DELAY = 1000L;
    private static final int MAX_NAME_LENGHT = 10;
    private boolean drawcursor = false;
    private long cursortime = 0L;
    String currentName = "";
    char currentChar = (char)32;
    int oldKey = -1;
    int keyRepeated = 0;
    long lasttime;

    public CCharReader(String s) {
        this.currentName = new String(s);
    }

    private int translateKeyCode(int keyCode) {
        switch (keyCode) {
            case 512: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 8: {
                return 4;
            }
            case 16: {
                return 5;
            }
            case 32: {
                return 6;
            }
            case 64: {
                return 7;
            }
            case 128: {
                return 8;
            }
            case 256: {
                return 9;
            }
            case 8192: {
                return 8192;
            }
            case 32768: {
                return 32768;
            }
        }
        return -1;
    }

    public String getString() {
        return this.currentName;
    }

    public void update(int keyCode, long time) {
        if (time - this.cursortime > 500L) {
            this.drawcursor = !this.drawcursor;
            this.cursortime = time;
        }
        int key = this.translateKeyCode(keyCode);
        switch (key) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                if (this.oldKey != key) {
                    if (this.currentName.length() >= 10) break;
                    this.lasttime = time;
                    this.oldKey = key;
                    this.keyRepeated = 0;
                    this.currentName = this.currentName + charTst[this.oldKey].charAt(this.keyRepeated);
                    break;
                }
                this.lasttime = time;
                this.keyRepeated = (this.keyRepeated + 1) % charTst[this.oldKey].length();
                if (this.currentName.length() > 1) {
                    this.currentName = this.currentName.substring(0, this.currentName.length() - 1) + charTst[this.oldKey].charAt(this.keyRepeated);
                    break;
                }
                this.currentName = "" + charTst[this.oldKey].charAt(this.keyRepeated);
                break;
            }
            case 8192: {
                this.oldKey = -1;
                break;
            }
            case 32768: {
                if (this.currentName.length() > 0) {
                    this.currentName = this.currentName.substring(0, this.currentName.length() - 1);
                }
                this.oldKey = -1;
                break;
            }
            default: {
                if (time - this.lasttime <= 1000L || this.oldKey <= 0) break;
                this.oldKey = -1;
            }
        }
    }

    public void drawName(Graphics g, int x, int y, CFont font, int anchor) {
        int lenght1 = font.substringWidth(this.currentName);
        if (anchor == 1) {
            anchor = 0;
            x -= lenght1 / 2;
        } else if (anchor == 2) {
            anchor = 0;
            x -= lenght1;
        }
        if (this.oldKey >= 0) {
            int lenght2 = font.substringWidth(this.currentName.substring(0, this.currentName.length() - 1));
            int lenght3 = font.substringWidth("" + charTst[this.oldKey].charAt(this.keyRepeated));
            int lenght4 = font.substringWidth(charTst[this.oldKey]);
            int lenght5 = font.substringWidth(charTst[this.oldKey].substring(0, this.keyRepeated));
            g.setColor(0xAAAAFF);
            g.fillRect(x + lenght2, y - 1, lenght3, font.LETTER_A_HEIGHT + 2);
            g.setColor(0xAAAAAA);
            g.fillRect(x + lenght2 - 1, y + 3 + font.LETTER_A_HEIGHT, lenght4 + 2, font.LETTER_A_HEIGHT + 2);
            g.setColor(0xFFFFFF);
            g.drawRect(x + lenght2 - 1, y + 3 + font.LETTER_A_HEIGHT, lenght4 + 2, font.LETTER_A_HEIGHT + 2);
            g.setColor(0xAAAAFF);
            g.fillRect(x + lenght2 + lenght5, y + 4 + font.LETTER_A_HEIGHT, lenght3, font.LETTER_A_HEIGHT);
            font.drawString(g, charTst[this.oldKey], x + lenght2, y + 4 + font.LETTER_A_HEIGHT, 0);
        }
        font.drawString(g, this.currentName, x, y, anchor);
        if (this.drawcursor) {
            g.setColor(0);
            g.drawLine(x + font.substringWidth(this.currentName) + 1, y, x + font.substringWidth(this.currentName) + 1, y + font.LETTER_A_HEIGHT);
        }
    }
}

