/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory;

import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.memory.CodeBlockCache;
import org.jpc.emulator.memory.CodeBlockMemory;
import org.jpc.emulator.memory.LazyCodeBlockMemory;
import org.jpc.emulator.memory.LinearAddressSpace;
import org.jpc.emulator.memory.Memory;
import org.jpc.emulator.memory.PhysicalAddressSpace;
import org.jpc.emulator.memory.codeblock.ByteSourceWrappedMemory;
import org.jpc.emulator.memory.codeblock.CodeBlock;
import org.jpc.emulator.memory.codeblock.CodeBlockFactory;
import org.jpc.emulator.memory.codeblock.CodeBlockReplacementException;
import org.jpc.emulator.memory.codeblock.DefaultCodeBlockFactory;
import org.jpc.emulator.memory.codeblock.ObjectTreeCache;
import org.jpc.emulator.memory.codeblock.ProtectedModeCodeBlock;
import org.jpc.emulator.memory.codeblock.RealModeCodeBlock;
import org.jpc.emulator.memory.codeblock.SpanningProtectedModeCodeBlock;
import org.jpc.emulator.memory.codeblock.SpanningRealModeCodeBlock;
import org.jpc.emulator.memory.codeblock.optimised.OptimisedCompiler;
import org.jpc.emulator.memory.codeblock.optimised.ProtectedModeUDecoder;
import org.jpc.emulator.memory.codeblock.optimised.RealModeUDecoder;
import org.jpc.emulator.processor.Processor;

public class MemoryManager
implements HardwareComponent {
    private PhysicalAddressSpace physicalAddr;
    private LinearAddressSpace linearAddr;
    private Processor cpu;
    private boolean factoriesValid;
    private CodeBlockFactory realModeChain;
    private CodeBlockFactory protectedModeChain;
    private CodeBlockFactory optimisedRealModeChain;
    private CodeBlockFactory optimisedProtectedModeChain;
    private ByteSourceWrappedMemory byteSource;
    private static MemoryManager singletonInstance = new MemoryManager();
    private RealModeCodeBlock spanningRealMode;
    private ProtectedModeCodeBlock spanningProtectedMode;
    private CodeBlockCache codeBlockCache;
    private int single;
    private long singleTime;

    public static MemoryManager getInstance() {
        return singletonInstance;
    }

    private MemoryManager() {
        this.buildFactories();
        this.codeBlockCache = new CodeBlockCache(50);
    }

    private synchronized void buildFactories() {
        this.byteSource = new ByteSourceWrappedMemory();
        this.optimisedRealModeChain = new DefaultCodeBlockFactory(new RealModeUDecoder(), new OptimisedCompiler());
        this.optimisedProtectedModeChain = new DefaultCodeBlockFactory(new ProtectedModeUDecoder(), new OptimisedCompiler());
        this.spanningRealMode = new SpanningRealModeCodeBlock(new CodeBlockFactory[]{this.optimisedRealModeChain});
        this.spanningProtectedMode = new SpanningProtectedModeCodeBlock(new CodeBlockFactory[]{this.optimisedProtectedModeChain});
        this.factoriesValid = true;
    }

    public ObjectTreeCache getObjectTreeCache() {
        return null;
    }

    private RealModeCodeBlock tryFactory(CodeBlockFactory codeBlockFactory, Memory memory, int n, RealModeCodeBlock realModeCodeBlock) {
        try {
            this.byteSource.set(memory, n & 0xFFF);
            return codeBlockFactory.getRealModeCodeBlock(this.byteSource);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return realModeCodeBlock;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public RealModeCodeBlock getRealModeCodeBlockAt(Memory memory, int n) {
        this.byteSource.set(memory, n & 0xFFF);
        RealModeCodeBlock realModeCodeBlock = this.tryFactory(this.optimisedRealModeChain, memory, n, this.spanningRealMode);
        ((CodeBlockMemory)memory).setCodeBlockAt(n & 0xFFF, realModeCodeBlock);
        return realModeCodeBlock;
    }

    public ProtectedModeCodeBlock getProtectedModeCodeBlockAt(Memory memory, int n) {
        this.byteSource.set(memory, n & 0xFFF);
        ProtectedModeCodeBlock protectedModeCodeBlock = null;
        try {
            protectedModeCodeBlock = this.optimisedProtectedModeChain.getProtectedModeCodeBlock(this.byteSource, this.cpu.cs.getDefaultSizeFlag());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            protectedModeCodeBlock = this.spanningProtectedMode;
        }
        ((CodeBlockMemory)memory).setCodeBlockAt(n & 0xFFF, protectedModeCodeBlock);
        return protectedModeCodeBlock;
    }

    public Memory convertMemory(Memory memory) {
        if (!(memory instanceof LazyCodeBlockMemory)) {
            LazyCodeBlockMemory lazyCodeBlockMemory = new LazyCodeBlockMemory(memory);
            this.physicalAddr.replaceBlocks(memory, lazyCodeBlockMemory);
            this.linearAddr.replaceBlocks(memory, lazyCodeBlockMemory);
            return lazyCodeBlockMemory;
        }
        return memory;
    }

    public CodeBlock handleCodeBlockReplacement(int n, CodeBlockReplacementException codeBlockReplacementException) {
        CodeBlock codeBlock = codeBlockReplacementException.getReplacement();
        Memory memory = this.physicalAddr.getReadMemoryBlockAt(n);
        int n2 = n & 0xFFF;
        ((CodeBlockMemory)memory).setCodeBlockAt(n2, codeBlock);
        return codeBlock;
    }

    public CodeBlock[] getCodeBlockCacheArray(CodeBlockMemory codeBlockMemory) {
        return this.codeBlockCache.getCacheFor(codeBlockMemory);
    }

    public void reset() {
        this.physicalAddr = null;
        this.linearAddr = null;
        this.cpu = null;
    }

    public synchronized void flushReferences() {
        this.physicalAddr = null;
        this.linearAddr = null;
        this.cpu = null;
        this.optimisedProtectedModeChain = null;
        this.optimisedRealModeChain = null;
        this.protectedModeChain = null;
        this.realModeChain = null;
        this.spanningRealMode = null;
        this.spanningProtectedMode = null;
        this.byteSource = null;
        this.factoriesValid = false;
    }

    public boolean initialised() {
        return this.factoriesValid && this.physicalAddr != null && this.linearAddr != null && this.cpu != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptComponent(HardwareComponent hardwareComponent) {
        MemoryManager memoryManager = this;
        synchronized (memoryManager) {
            if (!this.factoriesValid) {
                this.buildFactories();
            }
        }
        if (hardwareComponent instanceof PhysicalAddressSpace) {
            this.physicalAddr = (PhysicalAddressSpace)hardwareComponent;
        }
        if (hardwareComponent instanceof LinearAddressSpace) {
            this.linearAddr = (LinearAddressSpace)hardwareComponent;
        }
        if (hardwareComponent instanceof Processor) {
            this.cpu = (Processor)hardwareComponent;
        }
    }
}

