/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory.codeblock;

import org.jpc.emulator.memory.Memory;
import org.jpc.emulator.memory.MemoryManager;
import org.jpc.emulator.memory.codeblock.CodeBlock;
import org.jpc.emulator.memory.codeblock.ProtectedModeCodeBlock;
import org.jpc.emulator.memory.codeblock.RealModeCodeBlock;
import org.jpc.emulator.processor.Processor;

public class CodeBlockTrigger
implements RealModeCodeBlock,
ProtectedModeCodeBlock {
    private Memory home;
    private CodeBlock result;

    public CodeBlockTrigger(Memory memory) {
        this.home = memory;
    }

    public int getX86Length() {
        try {
            return this.result.getX86Length();
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    public int getX86Count() {
        try {
            return this.result.getX86Count();
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    public int execute(Processor processor) {
        return this.construct(processor).execute(processor);
    }

    public String getDisplayString() {
        try {
            return this.result.getDisplayString();
        }
        catch (NullPointerException nullPointerException) {
            return "Undecoded Trigger Block";
        }
    }

    private CodeBlock construct(Processor processor) {
        if ((processor.getCR0() & 1) == 0) {
            this.result = MemoryManager.getInstance().getRealModeCodeBlockAt(this.home, processor.getInstructionPointer());
            return this.result;
        }
        this.result = MemoryManager.getInstance().getProtectedModeCodeBlockAt(this.home, processor.getInstructionPointer());
        return this.result;
    }

    public boolean handleMemoryRegionChange(int n, int n2) {
        return true;
    }
}

