/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.pci;

import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.memory.PhysicalAddressSpace;
import org.jpc.emulator.motherboard.IOPortHandler;
import org.jpc.emulator.pci.IOPortIORegion;
import org.jpc.emulator.pci.IORegion;
import org.jpc.emulator.pci.IRQBouncer;
import org.jpc.emulator.pci.MemoryMappedIORegion;
import org.jpc.emulator.pci.PCIDevice;
import org.jpc.emulator.pci.PCIISABridge;

public class PCIBus
implements HardwareComponent {
    private int busNumber = 0;
    private int devFNMinimum = 8;
    private PCIDevice[] devices = new PCIDevice[256];
    private PCIISABridge isaBridge;
    private IOPortHandler ioportHandler;
    private PhysicalAddressSpace memory;
    private int pciIRQIndex = 0;
    private int[][] pciIRQLevels = new int[4][2];
    public static final int PCI_COMMAND = 4;
    private static final int PCI_VENDOR_ID = 0;
    private static final int PCI_DEVICE_ID = 2;
    private static final int PCI_COMMAND_IO = 1;
    private static final int PCI_COMMAND_MEMORY = 2;
    private static final int PCI_CLASS_DEVICE = 10;
    private static final int PCI_INTERRUPT_LINE = 60;
    private static final int PCI_INTERRUPT_PIN = 61;
    private static final int PCI_MIN_GNT = 62;
    private static final int PCI_MAX_LAT = 63;
    private static final int PCI_DEVICES_MAX = 64;
    public static final int PCI_IRQ_WORDS = 2;
    private static final byte[] pciIRQs = new byte[]{11, 9, 11, 9};
    private int biosIOAddress;
    private int biosMemoryAddress;

    public boolean registerDevice(PCIDevice pCIDevice) {
        if (this.pciIRQIndex >= 64) {
            return false;
        }
        if (pCIDevice.autoAssignDevFN()) {
            int n = this.findFreeDevFN();
            if (0 <= n) {
                pCIDevice.assignDevFN(n);
            }
        } else {
            PCIDevice pCIDevice2 = this.devices[pCIDevice.getCurrentDevFN()];
            if (pCIDevice2 != null) {
                System.err.println("Trying to temporarily unregister a pci device, this may not work.");
                pCIDevice2.deassignDevFN();
            }
        }
        pCIDevice.setIRQIndex(this.pciIRQIndex++);
        this.addDevice(pCIDevice);
        IRQBouncer iRQBouncer = this.isaBridge.makeBouncer(pCIDevice);
        pCIDevice.addIRQBouncer(iRQBouncer);
        return this.registerPCIIORegions(pCIDevice);
    }

    private int findFreeDevFN() {
        for (int i = this.devFNMinimum; i < 256; i += 8) {
            if (null != this.devices[i]) continue;
            return i;
        }
        return -1;
    }

    private boolean registerPCIIORegions(PCIDevice pCIDevice) {
        IORegion[] iORegionArray = pCIDevice.getIORegions();
        if (iORegionArray == null) {
            return true;
        }
        boolean bl = true;
        for (int i = 0; i < iORegionArray.length; ++i) {
            IORegion iORegion = iORegionArray[i];
            if (7 <= iORegion.getRegionNumber()) {
                bl = false;
                continue;
            }
            iORegion.setAddress(-1);
            if (iORegion.getRegionNumber() == 6) {
                pCIDevice.putConfigInt(48, iORegion.getType());
                continue;
            }
            pCIDevice.putConfigInt(16 + iORegion.getRegionNumber() * 4, iORegion.getType());
        }
        return bl;
    }

    private void updateMappings(PCIDevice pCIDevice) {
        IORegion[] iORegionArray = pCIDevice.getIORegions();
        if (iORegionArray == null) {
            return;
        }
        short s = pCIDevice.getConfigShort(4);
        for (int i = 0; i < iORegionArray.length; ++i) {
            int n;
            int n2;
            IORegion iORegion = iORegionArray[i];
            if (null == iORegion || 7 <= iORegion.getRegionNumber()) continue;
            int n3 = 6 == iORegion.getRegionNumber() ? 48 : 16 + iORegion.getRegionNumber() * 4;
            if (iORegion instanceof IOPortIORegion) {
                if (0 != (s & 1)) {
                    n2 = pCIDevice.getConfigInt(n3);
                    n = (n2 = (int)((long)n2 & (iORegion.getSize() - 1L ^ 0xFFFFFFFFFFFFFFFFL))) + (int)iORegion.getSize() - 1;
                    if ((long)n <= (0xFFFFFFFFL & (long)n2) || 0 == n2 || 65536L <= (0xFFFFFFFFL & (long)n)) {
                        n2 = -1;
                    }
                } else {
                    n2 = -1;
                }
            } else if (iORegion instanceof MemoryMappedIORegion) {
                if (0 != (s & 2)) {
                    n2 = pCIDevice.getConfigInt(n3);
                    if (6 == iORegion.getRegionNumber() && 0 == (n2 & 1)) {
                        n2 = -1;
                    } else {
                        n = (n2 = (int)((long)n2 & (iORegion.getSize() - 1L ^ 0xFFFFFFFFFFFFFFFFL))) + (int)iORegion.getSize() - 1;
                        if (n <= n2 || 0 == n2 || -1 == n) {
                            n2 = -1;
                        }
                    }
                } else {
                    n2 = -1;
                }
            } else {
                throw new IllegalStateException("Unknown IORegion Type");
            }
            if (iORegion.getAddress() == n2) continue;
            if (iORegion.getAddress() != -1) {
                if (iORegion instanceof IOPortIORegion) {
                    int n4 = pCIDevice.getConfigByte(10) | pCIDevice.getConfigByte(11) << 8;
                    if (257 == n4 && 4L == iORegion.getSize()) {
                        System.err.println("Supposed to partially unmap");
                        this.ioportHandler.deregisterIOPortCapable((IOPortIORegion)iORegion);
                    } else {
                        this.ioportHandler.deregisterIOPortCapable((IOPortIORegion)iORegion);
                    }
                } else if (iORegion instanceof MemoryMappedIORegion) {
                    this.memory.unmap(iORegion.getAddress(), (int)iORegion.getSize());
                }
            }
            iORegion.setAddress(n2);
            if (iORegion.getAddress() == -1) continue;
            if (iORegion instanceof IOPortIORegion) {
                IOPortIORegion iOPortIORegion = (IOPortIORegion)iORegion;
                this.ioportHandler.registerIOPortCapable((IOPortIORegion)iORegion);
                continue;
            }
            if (!(iORegion instanceof MemoryMappedIORegion)) continue;
            MemoryMappedIORegion memoryMappedIORegion = (MemoryMappedIORegion)iORegion;
            this.memory.mapMemoryRegion(memoryMappedIORegion, iORegion.getAddress(), (int)iORegion.getSize());
        }
    }

    private void addDevice(PCIDevice pCIDevice) {
        this.devices[pCIDevice.getCurrentDevFN()] = pCIDevice;
    }

    private PCIDevice validPCIDataAccess(int n) {
        int n2 = n >>> 16 & 0xFF;
        if (0 != n2) {
            return null;
        }
        return this.devices[n >>> 8 & 0xFF];
    }

    public void writePCIDataByte(int n, byte by) {
        PCIDevice pCIDevice = this.validPCIDataAccess(n);
        if (null == pCIDevice) {
            return;
        }
        if (pCIDevice.configWriteByte(n & 0xFF, by)) {
            this.updateMappings(pCIDevice);
        }
    }

    public void writePCIDataWord(int n, short s) {
        PCIDevice pCIDevice = this.validPCIDataAccess(n);
        if (null == pCIDevice) {
            return;
        }
        if (pCIDevice.configWriteWord(n & 0xFF, s)) {
            this.updateMappings(pCIDevice);
        }
    }

    public void writePCIDataLong(int n, int n2) {
        PCIDevice pCIDevice = this.validPCIDataAccess(n);
        if (null == pCIDevice) {
            return;
        }
        if (pCIDevice.configWriteLong(n & 0xFF, n2)) {
            this.updateMappings(pCIDevice);
        }
    }

    public byte readPCIDataByte(int n) {
        PCIDevice pCIDevice = this.validPCIDataAccess(n);
        if (null == pCIDevice) {
            return -1;
        }
        return pCIDevice.configReadByte(n & 0xFF);
    }

    public short readPCIDataWord(int n) {
        PCIDevice pCIDevice = this.validPCIDataAccess(n);
        if (null == pCIDevice) {
            return -1;
        }
        return pCIDevice.configReadWord(n & 0xFF);
    }

    public int readPCIDataLong(int n) {
        PCIDevice pCIDevice = this.validPCIDataAccess(n);
        if (null == pCIDevice) {
            return -1;
        }
        return pCIDevice.configReadLong(n & 0xFF);
    }

    private int getBusNumber() {
        return this.busNumber;
    }

    public void biosInit() {
        int n;
        this.biosIOAddress = 49152;
        this.biosMemoryAddress = -268435456;
        byte[] byArray = new byte[]{0, 0};
        for (n = 0; n < 4; ++n) {
            byte by = pciIRQs[n];
            int n2 = by >> 3;
            byArray[n2] = (byte)(byArray[n2] | 1 << (by & 7));
            this.configWriteByte(this.isaBridge, 96 + n, by);
        }
        this.ioportHandler.ioPortWriteByte(1232, byArray[0]);
        this.ioportHandler.ioPortWriteByte(1233, byArray[1]);
        for (n = 0; n < 256; ++n) {
            PCIDevice pCIDevice = this.devices[n];
            if (pCIDevice == null) continue;
            this.biosInitDevice(pCIDevice);
        }
    }

    private final void biosInitDevice(PCIDevice pCIDevice) {
        int n = 0xFFFF & this.configReadWord(pCIDevice, 10);
        int n2 = 0xFFFF & this.configReadWord(pCIDevice, 0);
        int n3 = 0xFFFF & this.configReadWord(pCIDevice, 2);
        switch (n) {
            case 257: {
                if ((0xFFFF & n2) == 32902 && (0xFFFF & n3) == 28688) {
                    this.configWriteWord(pCIDevice, 64, (short)Short.MIN_VALUE);
                    this.configWriteWord(pCIDevice, 66, (short)Short.MIN_VALUE);
                    this.defaultIOMap(pCIDevice);
                    break;
                }
                this.setIORegionAddress(pCIDevice, 0, 496);
                this.setIORegionAddress(pCIDevice, 1, 1012);
                this.setIORegionAddress(pCIDevice, 2, 368);
                this.setIORegionAddress(pCIDevice, 3, 884);
                break;
            }
            case 768: {
                if (n2 != 4660) {
                    this.defaultIOMap(pCIDevice);
                    break;
                }
                this.setIORegionAddress(pCIDevice, 0, -536870912);
                break;
            }
            case 2048: {
                if (n2 != 4116 || n3 != 70 && n3 != 65535) break;
                this.setIORegionAddress(pCIDevice, 0, -2138832896);
                break;
            }
            case 65280: {
                if (n2 != 4203 || n3 != 23 && n3 != 34) break;
                this.setIORegionAddress(pCIDevice, 0, -2139095040);
                break;
            }
            default: {
                this.defaultIOMap(pCIDevice);
            }
        }
        int n4 = this.configReadByte(pCIDevice, 61);
        if (n4 != 0) {
            n4 = this.isaBridge.slotGetPIRQ(pCIDevice, n4 - 1);
            this.configWriteByte(pCIDevice, 60, pciIRQs[n4]);
        }
    }

    private void defaultIOMap(PCIDevice pCIDevice) {
        IORegion[] iORegionArray = pCIDevice.getIORegions();
        if (iORegionArray == null) {
            return;
        }
        for (int i = 0; i < iORegionArray.length; ++i) {
            int n;
            if (iORegionArray[i] == null) continue;
            if (iORegionArray[i] instanceof IOPortIORegion) {
                n = this.biosIOAddress;
                n = (int)((long)n + iORegionArray[i].getSize() - 1L & (iORegionArray[i].getSize() - 1L ^ 0xFFFFFFFFFFFFFFFFL));
                this.setIORegionAddress(pCIDevice, iORegionArray[i].getRegionNumber(), n);
                this.biosIOAddress = (int)((long)this.biosIOAddress + iORegionArray[i].getSize());
                continue;
            }
            if (!(iORegionArray[i] instanceof MemoryMappedIORegion)) continue;
            n = this.biosMemoryAddress;
            n = (int)((long)n + iORegionArray[i].getSize() - 1L & (iORegionArray[i].getSize() - 1L ^ 0xFFFFFFFFFFFFFFFFL));
            this.setIORegionAddress(pCIDevice, iORegionArray[i].getRegionNumber(), n);
            this.biosMemoryAddress = (int)((long)this.biosMemoryAddress + iORegionArray[i].getSize());
        }
    }

    private void configWriteByte(PCIDevice pCIDevice, int n, byte by) {
        this.writePCIDataByte(n |= this.getBusNumber() << 16 | pCIDevice.getCurrentDevFN() << 8, by);
    }

    private byte configReadByte(PCIDevice pCIDevice, int n) {
        return this.readPCIDataByte(n |= this.getBusNumber() << 16 | pCIDevice.getCurrentDevFN() << 8);
    }

    private void configWriteWord(PCIDevice pCIDevice, int n, short s) {
        this.writePCIDataWord(n |= this.getBusNumber() << 16 | pCIDevice.getCurrentDevFN() << 8, s);
    }

    private short configReadWord(PCIDevice pCIDevice, int n) {
        return this.readPCIDataWord(n |= this.getBusNumber() << 16 | pCIDevice.getCurrentDevFN() << 8);
    }

    private void configWriteLong(PCIDevice pCIDevice, int n, int n2) {
        this.writePCIDataLong(n |= this.getBusNumber() << 16 | pCIDevice.getCurrentDevFN() << 8, n2);
    }

    private void setIORegionAddress(PCIDevice pCIDevice, int n, int n2) {
        int n3 = n == 6 ? 48 : 16 + n * 4;
        this.configWriteLong(pCIDevice, n3, n2);
        IORegion iORegion = pCIDevice.getIORegion(n);
        if (iORegion == null) {
            return;
        }
        short s = this.configReadWord(pCIDevice, 4);
        s = iORegion.getRegionNumber() == 6 ? (short)(s | 2) : (iORegion instanceof IOPortIORegion ? (short)(s | 1) : (short)(s | 2));
        this.configWriteWord(pCIDevice, 4, s);
    }

    public void reset() {
        this.isaBridge = null;
        this.ioportHandler = null;
        this.memory = null;
        this.pciIRQIndex = 0;
        this.devices = new PCIDevice[256];
        this.pciIRQLevels = new int[4][2];
    }

    public boolean initialised() {
        return this.isaBridge != null && this.ioportHandler != null && this.memory != null;
    }

    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof PCIISABridge) {
            this.isaBridge = (PCIISABridge)hardwareComponent;
        }
        if (hardwareComponent instanceof IOPortHandler && hardwareComponent.initialised()) {
            this.ioportHandler = (IOPortHandler)hardwareComponent;
        }
        if (hardwareComponent instanceof PhysicalAddressSpace && hardwareComponent.initialised()) {
            this.memory = (PhysicalAddressSpace)hardwareComponent;
        }
    }
}

