/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.pci;

import org.jpc.emulator.AbstractHardwareComponent;
import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.pci.IORegion;
import org.jpc.emulator.pci.IRQBouncer;
import org.jpc.emulator.pci.PCIBus;
import org.jpc.emulator.pci.PCIDevice;

public abstract class AbstractPCIDevice
extends AbstractHardwareComponent
implements PCIDevice {
    private int deviceNumber;
    private byte[] config = new byte[256];
    private int irq;
    private IRQBouncer irqBouncer;
    private boolean pciRegistered = false;

    public int getCurrentDevFN() {
        return this.deviceNumber;
    }

    public void assignDevFN(int n) {
        this.deviceNumber = n;
    }

    public boolean autoAssignDevFN() {
        return true;
    }

    public void deassignDevFN() {
        this.pciRegistered = false;
        this.assignDevFN(-1);
    }

    public boolean configWriteByte(int n, byte by) {
        boolean bl;
        block0 : switch (0xFF & this.getConfigByte(14)) {
            case 0: 
            case 128: {
                switch (n) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 14: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 61: {
                        bl = false;
                        break block0;
                    }
                }
                bl = true;
                break;
            }
            default: {
                switch (n) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 14: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 61: {
                        bl = false;
                        break block0;
                    }
                }
                bl = true;
            }
        }
        if (bl) {
            this.putConfigByte(n, by);
        }
        return n + 1 > 4 && n < 6;
    }

    public boolean configWriteWord(int n, short s) {
        int n2 = n;
        for (int i = 0; i < 2; ++i) {
            boolean bl;
            block0 : switch (0xFF & this.getConfigByte(14)) {
                case 0: 
                case 128: {
                    switch (n2) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 14: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: 
                        case 31: 
                        case 32: 
                        case 33: 
                        case 34: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 61: {
                            bl = false;
                            break block0;
                        }
                    }
                    bl = true;
                    break;
                }
                default: {
                    switch (n2) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 14: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 61: {
                            bl = false;
                            break block0;
                        }
                    }
                    bl = true;
                }
            }
            if (bl) {
                this.putConfigByte(n2, (byte)s);
            }
            ++n2;
            s = (short)(s >>> 8);
        }
        return n2 > 4 && n < 6;
    }

    public boolean configWriteLong(int n, int n2) {
        int n3;
        IORegion iORegion;
        if ((n >= 16 && n < 40 || n >= 48 && n < 52) && (iORegion = this.getIORegion(n3 = n >= 48 ? 6 : n - 16 >>> 2)) != null) {
            if (n3 == 6) {
                n2 = (int)((long)n2 & (iORegion.getSize() - 1L ^ 0xFFFFFFFFFFFFFFFFL | 1L));
            } else {
                n2 = (int)((long)n2 & (iORegion.getSize() - 1L ^ 0xFFFFFFFFFFFFFFFFL));
                n2 |= iORegion.getType();
            }
            this.putConfigInt(n, n2);
            return true;
        }
        int n4 = n;
        for (n3 = 0; n3 < 4; ++n3) {
            boolean bl;
            block0 : switch (0xFF & this.getConfigByte(14)) {
                case 0: 
                case 128: {
                    switch (n4) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 14: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: 
                        case 31: 
                        case 32: 
                        case 33: 
                        case 34: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 61: {
                            bl = false;
                            break block0;
                        }
                    }
                    bl = true;
                    break;
                }
                default: {
                    switch (n4) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 14: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 61: {
                            bl = false;
                            break block0;
                        }
                    }
                    bl = true;
                }
            }
            if (bl) {
                this.putConfigByte(n4, (byte)n2);
            }
            ++n4;
            n2 >>>= 8;
        }
        return n4 > 4 && n < 6;
    }

    public byte configReadByte(int n) {
        return this.getConfigByte(n);
    }

    public short configReadWord(int n) {
        return this.getConfigShort(n);
    }

    public int configReadLong(int n) {
        return this.getConfigInt(n);
    }

    public byte getConfigByte(int n) {
        return this.config[n];
    }

    public short getConfigShort(int n) {
        int n2 = 0xFF & this.getConfigByte(n + 1);
        n2 <<= 8;
        return (short)(n2 |= 0xFF & this.getConfigByte(n));
    }

    public int getConfigInt(int n) {
        int n2 = 0xFFFF & this.getConfigShort(n + 2);
        n2 <<= 16;
        return n2 |= 0xFFFF & this.getConfigShort(n);
    }

    public long getConfigLong(int n) {
        long l = 0xFFFFFFFFL & (long)this.getConfigInt(n + 4);
        l <<= 32;
        return l |= 0xFFFFFFFFL & (long)this.getConfigInt(n);
    }

    public byte[] getConfig(int n, int n2) {
        byte[] byArray = new byte[n2];
        System.arraycopy(this.config, n, byArray, 0, n2);
        return byArray;
    }

    public void putConfigByte(int n, byte by) {
        this.config[n] = by;
    }

    public void putConfigShort(int n, short s) {
        this.putConfigByte(n, (byte)s);
        s = (short)(s >> 8);
        this.putConfigByte(++n, (byte)s);
    }

    public void putConfigInt(int n, int n2) {
        this.putConfigByte(n, (byte)n2);
        this.putConfigByte(++n, (byte)(n2 >>= 8));
        this.putConfigByte(++n, (byte)(n2 >>= 8));
        this.putConfigByte(++n, (byte)(n2 >>= 8));
    }

    public void putConfigLong(int n, long l) {
        this.putConfigByte(n, (byte)l);
        this.putConfigByte(++n, (byte)(l >>= 8));
        this.putConfigByte(++n, (byte)(l >>= 8));
        this.putConfigByte(++n, (byte)(l >>= 8));
        this.putConfigByte(++n, (byte)(l >>= 8));
        this.putConfigByte(++n, (byte)(l >>= 8));
        this.putConfigByte(++n, (byte)(l >>= 8));
        this.putConfigByte(++n, (byte)(l >>= 8));
    }

    public void putConfig(int n, byte[] byArray) {
        System.arraycopy(byArray, 0, this.config, n, byArray.length);
    }

    public void setIRQIndex(int n) {
        this.irq = n;
    }

    public int getIRQIndex() {
        return this.irq;
    }

    public void addIRQBouncer(IRQBouncer iRQBouncer) {
        this.irqBouncer = iRQBouncer;
    }

    public IRQBouncer getIRQBouncer() {
        return this.irqBouncer;
    }

    public abstract IORegion[] getIORegions();

    public abstract IORegion getIORegion(int var1);

    public boolean initialised() {
        return this.pciRegistered;
    }

    public void reset() {
        this.pciRegistered = false;
    }

    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof PCIBus && hardwareComponent.initialised() && !this.pciRegistered) {
            this.pciRegistered = ((PCIBus)hardwareComponent).registerDevice(this);
        }
    }
}

