/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator;

import org.jpc.emulator.ComparableObject;
import org.jpc.emulator.TimerResponsive;
import org.jpc.support.Clock;

public class Timer
implements ComparableObject {
    private long expireTime;
    private TimerResponsive callback;
    private boolean enabled;
    private Clock myOwner;

    public Timer(TimerResponsive timerResponsive, Clock clock) {
        this.myOwner = clock;
        this.callback = timerResponsive;
        this.enabled = false;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public void setStatus(boolean bl) {
        this.enabled = bl;
        this.myOwner.update(this);
    }

    public void setExpiry(long l) {
        this.expireTime = l;
        this.setStatus(true);
    }

    public boolean check(long l) {
        return this.enabled && l >= this.expireTime;
    }

    public void runCallback() {
        this.callback.timerCallback();
    }

    public long getExpiry() {
        return this.expireTime;
    }

    public int compareTo(Object object) {
        if (!(object instanceof Timer)) {
            return -1;
        }
        if (this.enabled()) {
            if (!((Timer)object).enabled()) {
                return -1;
            }
            if (this.getExpiry() - ((Timer)object).getExpiry() < 0L) {
                return -1;
            }
            if (this.getExpiry() - ((Timer)object).getExpiry() > 0L) {
                return 1;
            }
            return 0;
        }
        return 1;
    }
}

