/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory;

import java.util.Random;
import org.jpc.emulator.memory.CodeBlockMemory;
import org.jpc.emulator.memory.codeblock.CodeBlock;

public class CodeBlockCache {
    private final CodeBlock[][] caches;
    private final CodeBlockMemory[] users;
    private final Random rndm = new Random();

    public CodeBlockCache(int n) {
        this.caches = new CodeBlock[n][];
        for (int i = 0; i < this.caches.length; ++i) {
            this.caches[i] = new CodeBlock[4096];
        }
        this.users = new CodeBlockMemory[n];
    }

    public CodeBlock[] getCacheFor(CodeBlockMemory codeBlockMemory) {
        int n = this.rndm.nextInt(this.caches.length);
        try {
            this.users[n].relinquishCache();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        CodeBlock[] codeBlockArray = this.caches[n];
        CodeBlockCache.cleanCache(codeBlockArray);
        this.users[n] = codeBlockMemory;
        return codeBlockArray;
    }

    private static void cleanCache(CodeBlock[] codeBlockArray) {
        for (int i = 0; i < codeBlockArray.length; ++i) {
            codeBlockArray[i] = null;
        }
    }
}

