/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.motherboard;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jpc.emulator.AbstractHardwareComponent;
import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.memory.EPROMMemory;
import org.jpc.emulator.memory.PhysicalAddressSpace;
import org.jpc.emulator.motherboard.IOPortCapable;
import org.jpc.emulator.motherboard.IOPortHandler;

public class SystemBIOS
extends AbstractHardwareComponent
implements IOPortCapable {
    private byte[] imageData;
    private boolean ioportRegistered;
    private boolean loaded;

    public SystemBIOS(byte[] byArray) {
        this.loaded = false;
        this.ioportRegistered = false;
        this.imageData = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.imageData, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SystemBIOS(String string) throws IOException {
        InputStream inputStream = null;
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            inputStream = this.getClass().getResourceAsStream("/" + string);
            while ((n = inputStream.read()) >= 0) {
                byteArrayOutputStream.write((byte)n);
            }
            this.imageData = byteArrayOutputStream.toByteArray();
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public int[] ioPortsRequested() {
        return new int[]{1024, 1025, 1026, 1027, 35072};
    }

    public int ioPortReadByte(int n) {
        return 255;
    }

    public int ioPortReadWord(int n) {
        return 65535;
    }

    public int ioPortReadLong(int n) {
        return -1;
    }

    public void ioPortWriteByte(int n, int n2) {
        switch (n) {
            case 1026: 
            case 1027: {
                try {
                    System.out.print(new String(new byte[]{(byte)n2}, "US-ASCII"));
                }
                catch (Exception exception) {
                    System.out.print(new String(new byte[]{(byte)n2}));
                }
                break;
            }
            case 35072: {
                System.err.println("Attempt to call Shutdown");
                break;
            }
        }
    }

    public void ioPortWriteWord(int n, int n2) {
        switch (n) {
            case 1024: 
            case 1025: {
                System.err.println("BIOS panic at rombios.c, line " + n2);
            }
        }
    }

    public void ioPortWriteLong(int n, int n2) {
    }

    public void load(PhysicalAddressSpace physicalAddressSpace) {
        int n = 4096;
        int n2 = ((this.imageData.length - 1) / n + 1) * n;
        int n3 = n2 - this.imageData.length;
        int n4 = n - n3;
        EPROMMemory ePROMMemory = new EPROMMemory(n, n3, this.imageData, 0, n4);
        physicalAddressSpace.allocateMemory(0x100000 - n2, ePROMMemory);
        for (int i = 1; i < n2 / n; ++i) {
            ePROMMemory = new EPROMMemory(n, 0, this.imageData, n4, n);
            physicalAddressSpace.allocateMemory(0x100000 - n2 + i * n, ePROMMemory);
            n4 += n;
        }
    }

    public byte[] getImage() {
        return (byte[])this.imageData.clone();
    }

    public boolean initialised() {
        return this.loaded && this.ioportRegistered;
    }

    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof PhysicalAddressSpace && hardwareComponent.initialised()) {
            this.load((PhysicalAddressSpace)hardwareComponent);
            this.loaded = true;
        }
        if (hardwareComponent instanceof IOPortHandler && hardwareComponent.initialised()) {
            ((IOPortHandler)hardwareComponent).registerIOPortCapable(this);
            this.ioportRegistered = true;
        }
    }

    public void reset() {
        this.loaded = false;
        this.ioportRegistered = false;
    }
}

