/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.processor;

public final class ProcessorException
extends RuntimeException {
    private int vector;
    private int errorCode;
    private boolean pointsToSelf;
    private boolean hasErrorCode;

    public ProcessorException(int n, int n2, boolean bl) {
        this.vector = n;
        this.hasErrorCode = true;
        this.errorCode = n2;
        this.pointsToSelf = bl;
    }

    public ProcessorException(int n, boolean bl) {
        this.vector = n;
        this.hasErrorCode = false;
        this.errorCode = 0;
        this.pointsToSelf = bl;
    }

    public int getVector() {
        return this.vector;
    }

    public boolean hasErrorCode() {
        return this.hasErrorCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public boolean pointsToSelf() {
        return this.pointsToSelf;
    }

    private static final boolean isContributory(int n) {
        switch (n) {
            case 0: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    private static final boolean isPageFault(int n) {
        return n == 14;
    }

    public boolean combinesToDoubleFault(int n) {
        return ProcessorException.isContributory(n) && ProcessorException.isContributory(this.getVector()) || ProcessorException.isPageFault(n) && (ProcessorException.isContributory(this.getVector()) || ProcessorException.isPageFault(this.getVector()));
    }

    public String toString() {
        if (this.hasErrorCode()) {
            return "Processor Exception: " + this.getVector() + " [errorcode:0x" + Integer.toHexString(this.getErrorCode()) + "]";
        }
        return "Processor Exception: " + this.getVector();
    }
}

