/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.support;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jpc.support.SeekableIODevice;

public class ArrayBackedSeekableIODevice
implements SeekableIODevice {
    private String fileName;
    private byte[] imageData;
    private int imageOffset;
    private boolean readOnly;

    public ArrayBackedSeekableIODevice() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(String string) {
        this.fileName = string;
        this.imageOffset = 0;
        this.readOnly = false;
        InputStream inputStream = null;
        try {
            int n;
            byte[] byArray = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            inputStream = this.getClass().getResourceAsStream("/" + string);
            while ((n = inputStream.read(byArray)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            this.imageData = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            System.out.println("ArrayBackedSeekableIODevice: could not load file");
            exception.printStackTrace();
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayBackedSeekableIODevice(String string) {
        this.fileName = string;
        this.imageOffset = 0;
        this.readOnly = false;
        InputStream inputStream = null;
        try {
            int n;
            byte[] byArray = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            inputStream = this.getClass().getResourceAsStream("/" + string);
            while ((n = inputStream.read(byArray)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            this.imageData = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            System.out.println("ArrayBackedSeekableIODevice: could not load file");
            exception.printStackTrace();
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public ArrayBackedSeekableIODevice(String string, byte[] byArray) {
        this.fileName = string;
        this.imageOffset = 0;
        this.imageData = byArray;
    }

    public void seek(int n) throws IOException {
        if (n < 0 || n >= this.imageData.length) {
            throw new IOException("seek offset out of range: " + n + " not in [0," + this.imageData.length + "]");
        }
        this.imageOffset = n;
    }

    public int write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        try {
            try {
                for (int i = n; i < n + n2; ++i) {
                    this.imageData[this.imageOffset] = byArray[i];
                    ++this.imageOffset;
                    ++n3;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IOException("write out of range");
            }
        }
        catch (Throwable throwable) {}
        return n3;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        try {
            try {
                for (int i = n; i < n + n2; ++i) {
                    byArray[i] = this.imageData[this.imageOffset];
                    ++this.imageOffset;
                    ++n3;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IOException("read out of range");
            }
        }
        catch (Throwable throwable) {}
        return n3;
    }

    public int length() {
        return this.imageData.length;
    }

    public boolean readOnly() {
        return this.readOnly;
    }

    public String toString() {
        return this.fileName;
    }
}

