/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.lq3d.lq_particle_system;

import com.lemonquest.lq3d.LQAppearance;
import com.lemonquest.lq3d.LQBillboardGroup;
import com.lemonquest.lq3d.LQFactory;
import com.lemonquest.lq3d.LQGraphics3D;
import com.lemonquest.lq3d.LQTransform;
import com.lemonquest.lq3d.lq_particle_system.LQParticle;
import com.lemonquest.lq3d.lq_particle_system.LQParticleEffect;
import com.lemonquest.lq3d.lq_particle_system.LQParticleSystem;

public abstract class LQBitmapParticleEffect
implements LQParticleEffect {
    byte mode = 0;
    public static final byte Mode_Color = 0;
    public static final byte Mode_Texture = 1;
    LQBillboardGroup billboard = null;
    float[] bbScaleX;
    float[] bbScaleY;
    float[] bbPos;
    float[] bbCenter = new float[]{0.0f, 0.0f, 0.0f};
    LQTransform trans = LQFactory.LQTransform();
    protected float scale = 1.0f;
    protected short texSrcX;
    protected short texSrcY;
    protected short texelSize;
    protected int texelFrameNum;
    short[] texels;
    byte[] colors;

    public LQBitmapParticleEffect(int particleCapacity, byte mode, String filename, int pixelBlendMode, float scale, int texSrcX, int texSrcY, int texelSize, int texFrame) {
        LQAppearance appear = null;
        if (mode == 0) {
            appear = LQFactory.LQAppearance(1, filename, 2, pixelBlendMode, 0);
        } else if (mode == 1) {
            appear = LQFactory.LQAppearance(1, filename, 0, pixelBlendMode, 0);
        }
        this.init(particleCapacity, mode, appear, scale, texSrcX, texSrcY, texelSize, texFrame);
    }

    public LQBitmapParticleEffect(int particleCapacity, byte mode, LQAppearance app, float scale, int texSrcX, int texSrcY, int texelSize, int texFrame) {
        this.init(particleCapacity, mode, app, scale, texSrcX, texSrcY, texelSize, texFrame);
    }

    private void init(int particleCapacity, byte mode, LQAppearance app, float scale, int texSrcX, int texSrcY, int texelSize, int texFrame) {
        this.mode = mode;
        this.texSrcX = (short)texSrcX;
        this.texSrcY = (short)texSrcY;
        this.texelSize = (short)texelSize;
        this.texelFrameNum = texFrame;
        this.billboard = LQFactory.BillBoardGroup((byte)0, app, particleCapacity * 4);
        this.bbScaleX = new float[particleCapacity];
        this.bbScaleY = new float[particleCapacity];
        this.bbPos = new float[particleCapacity * 3];
        this.texels = new short[particleCapacity * 4 * 2];
        this.colors = new byte[particleCapacity * 4 * 4];
        short[] vert = new short[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        short[] t = new short[]{this.texSrcX, (short)(this.texSrcY + this.texelSize), (short)(this.texSrcX + this.texelSize), (short)(this.texSrcY + this.texelSize), this.texSrcX, this.texSrcY, (short)(this.texSrcX + this.texelSize), this.texSrcY};
        for (int i = 0; i < particleCapacity; ++i) {
            this.billboard.addBillboard(vert, t);
            for (int j = 0; j < t.length; ++j) {
                this.texels[i * 8 + j] = t[j];
            }
        }
        this.scale = scale;
    }

    public void render(LQGraphics3D g3d, LQParticleSystem ps) {
        LQParticle[] p = ps.getParticles();
        for (int i = 0; i < p.length; ++i) {
            int index;
            this.bbScaleX[i] = this.bbScaleY[i] = p[i].getSize();
            this.bbPos[i * 3] = p[i].getPos()[0];
            this.bbPos[i * 3 + 1] = p[i].getPos()[1];
            this.bbPos[i * 3 + 2] = p[i].getPos()[2];
            if (this.mode == 0) {
                index = i * 4 * 4;
                int c = p[i].getColor();
                byte a = (byte)(c >> 24 & 0xFF);
                byte r = (byte)(c >> 16 & 0xFF);
                byte g = (byte)(c >> 8 & 0xFF);
                byte b = (byte)(c & 0xFF);
                for (int j = index; j < index + 16; j += 4) {
                    this.colors[j] = r;
                    this.colors[j + 1] = g;
                    this.colors[j + 2] = b;
                    this.colors[j + 3] = a;
                }
                continue;
            }
            if (this.mode != 1) continue;
            index = i * 8;
            short[] t = p[i].getTexels();
            for (int j = index; j < index + 8; ++j) {
                this.texels[j] = t[j - index];
            }
        }
        this.billboard.update(g3d.getCamera(), this.bbScaleX, this.bbScaleY, this.bbPos, ps.getTransform(), this.texels, this.colors);
        this.billboard.draw(g3d);
    }

    public LQAppearance getAppearance() {
        return this.billboard.getPrimitive().getAppearance();
    }
}

