/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.lq3d.lq_particle_system;

import com.lemonquest.lq3d.LQGraphics3D;
import com.lemonquest.lq3d.lq_particle_system.LQParticle;
import com.lemonquest.lq3d.lq_particle_system.LQParticleEffect;

public class LQParticleSystem {
    private String m_name;
    private float[] emitPos = new float[]{0.0f, 0.0f, 0.0f};
    private float[] transform = new float[]{0.0f, 0.0f, 0.0f};
    private LQParticleEffect effect = null;
    private LQParticle[] parts = null;
    private float currentTime;
    private float emitTime;
    private float generateTime;
    private boolean isLoop = true;
    private int loopTimes;
    float[] params = new float[4];
    public static final short Param_EmitStart = 0;
    public static final short Param_EmitStop = 1;
    public static final short Param_CycleTime = 2;
    public static final short Param_StepTime = 3;
    public static final int MaxParam = 4;

    public LQParticleSystem(LQParticleEffect effect, int numParticles, float[] psParams, float[] emitPos) {
        this.setEffect(effect);
        this.parts = new LQParticle[numParticles];
        for (int i = 0; i < numParticles; ++i) {
            this.parts[i] = new LQParticle(this);
        }
        this.reset(psParams, emitPos);
    }

    public void reset(float[] psParams, float[] emitPos) {
        this.currentTime = 0.0f;
        this.emitTime = 0.0f;
        this.generateTime = 0.0f;
        this.loopTimes = 0;
        this.setParams(psParams);
        if (emitPos != null) {
            this.setEmitPos(emitPos);
        }
        for (int i = 0; i < this.parts.length; ++i) {
            this.effect.init(this.parts[i], this.currentTime);
        }
    }

    public boolean update() {
        int i;
        if (this.currentTime >= this.params[0] && this.currentTime <= this.params[1]) {
            this.generateTime += this.params[3];
            for (i = 0; i < this.parts.length && !(this.generateTime < this.emitTime); ++i) {
                if (this.parts[i].isActive()) continue;
                this.parts[i].setActive(true);
                this.generateTime -= this.emitTime;
            }
        }
        for (i = 0; i < this.parts.length; ++i) {
            if (!this.parts[i].isActive()) continue;
            this.getEffect().update(this.parts[i], this.currentTime);
        }
        this.currentTime += this.params[3];
        if (this.currentTime >= this.params[2]) {
            this.currentTime = this.isLoop ? 0.0f : this.params[2];
            ++this.loopTimes;
            return true;
        }
        return false;
    }

    public void draw(LQGraphics3D g3d) {
        this.getEffect().render(g3d, this);
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public LQParticle[] getParticles() {
        return this.parts;
    }

    public void setEmitPos(float[] pos) {
        System.arraycopy(pos, 0, this.emitPos, 0, this.emitPos.length);
    }

    public float[] getEmitPos() {
        return this.emitPos;
    }

    public void setTransform(float[] pos) {
        System.arraycopy(pos, 0, this.transform, 0, this.transform.length);
    }

    public float[] getTransform() {
        return this.transform;
    }

    public void setEffect(LQParticleEffect effect) {
        this.effect = effect;
    }

    public LQParticleEffect getEffect() {
        return this.effect;
    }

    public float[] getParam() {
        return this.params;
    }

    public void setParam(short paramType, float value) {
        this.params[paramType] = value;
    }

    private void setParams(float[] params) {
        for (int i = 0; i < params.length; ++i) {
            this.setParam((short)i, params[i]);
        }
        float emitTimeLen = params[1] - params[0];
        if (emitTimeLen > 0.0f) {
            this.emitTime = emitTimeLen / (float)this.parts.length;
        }
        this.generateTime = 0.0f;
        this.currentTime = 0.0f;
        for (int i = 0; i < this.parts.length; ++i) {
            this.effect.init(this.parts[i], this.currentTime);
        }
    }

    public boolean isLoop() {
        return this.isLoop;
    }

    public void setLoop(boolean isLoop) {
        this.isLoop = isLoop;
    }

    public int getLoopTimes() {
        return this.loopTimes;
    }
}

