/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.lq3d_mcv3;

import com.lemonquest.lq3d.LQAppearance;
import com.lemonquest.lq3d.LQPrimitive;
import com.lemonquest.lq3d.renderlist.LQRenderNode;
import com.lemonquest.lq3d_mcv3.LQAppearance_mcv3;
import java.io.DataInputStream;
import java.io.IOException;

public class LQPrimitive_mcv3
extends LQPrimitive {
    int vertexPerFace = 3;
    protected int m_maxVertices;
    protected int m_curVerticesNumber;
    private boolean noTexture = false;
    protected MeshData meshData;

    public LQPrimitive_mcv3(int primitiveType, LQAppearance appearance, int maxVertices) {
        this.init(primitiveType, appearance, maxVertices);
    }

    public LQPrimitive_mcv3(short[] vertices, short[] normals, byte[] colors, short[] texels, int primitiveType, LQAppearance appearance) {
        this.init(primitiveType, appearance, vertices.length / 3);
        this.addSubPrim(vertices, normals, colors, texels);
    }

    public LQPrimitive_mcv3(LQRenderNode renderNode, LQAppearance app) {
        this.init(0, app, renderNode.getVertex().length / 3);
        this.addSubPrim(renderNode.getVertex(), null, renderNode.getColor(), renderNode.getTexels());
    }

    public LQPrimitive_mcv3(String fileName, String name, LQAppearance appearance) {
        DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream(fileName));
        try {
            this.v2FromFileStream(dis, name, appearance);
            dis.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void v2FromFileStream(DataInputStream dis, String meshName, LQAppearance appearance) throws Exception {
        if (dis == null) {
            throw new IOException();
        }
        int version = dis.readInt();
        int vertNum = dis.readInt();
        short[] vertices = new short[vertNum * 3];
        for (int i = 0; i < vertNum * 3; ++i) {
            vertices[i] = dis.readShort();
        }
        int faceNum = dis.readInt();
        int vertPerFace = 3;
        int[] faces = new int[faceNum * 3];
        for (int i = 0; i < faceNum * 3; ++i) {
            faces[i] = dis.readInt();
        }
        int stripNum = dis.readInt();
        int stripIndicesNum = dis.readInt();
        int[] stripIndices = new int[stripIndicesNum];
        int[] stripLengths = new int[stripNum];
        int count = 0;
        for (int stripIndex = 0; stripIndex < stripNum; ++stripIndex) {
            stripLengths[stripIndex] = dis.readInt();
            for (int vertexIndex = 0; vertexIndex < stripLengths[stripIndex]; ++vertexIndex) {
                stripIndices[count++] = dis.readInt();
            }
        }
        byte[] colors = new byte[vertNum * 4];
        for (int i = 0; i < vertNum * 4; ++i) {
            colors[i] = -1;
        }
        this.meshData = new MeshData();
        this.m_primitiveType = 0;
        this.setAppearance(appearance);
        this.meshData.command |= 0x3000000;
        this.vertexPerFace = 3;
        this.m_maxVertices = vertNum;
        this.meshData.numTriangles = this.m_maxVertices / this.vertexPerFace;
        int faceNumber = stripIndicesNum - stripNum * 2;
        this.meshData.vertices = new int[faceNumber * 3];
        for (int i = 0; i < faceNumber; ++i) {
            this.meshData.vertices[i * 3] = vertices[stripIndices[i] * 3];
            this.meshData.vertices[i * 3 + 1] = vertices[stripIndices[i] * 3 + 1];
            this.meshData.vertices[i * 3 + 2] = vertices[stripIndices[i] * 3 + 2];
        }
        if (colors != null) {
            this.fastUpdateColors(colors);
        }
        this.meshData.normals = this.meshData.vertices;
        if (colors == null) {
            int[] ctmp = new int[]{0xFFFFFF};
            this.meshData.colors = ctmp;
        }
        this.noTexture = true;
        this.meshData.texels = new int[this.m_maxVertices * 2];
        this.m_curVerticesNumber = this.m_maxVertices;
    }

    public Object data() {
        return this.meshData;
    }

    protected void init(int primitiveType, LQAppearance appearance, int maxVertices) {
        this.meshData = new MeshData();
        this.m_primitiveType = primitiveType;
        this.setAppearance(appearance);
        if (primitiveType == 0) {
            this.meshData.command |= 0x3000000;
            this.vertexPerFace = 3;
        } else if (primitiveType == 1) {
            this.meshData.command |= 0x4000000;
            this.vertexPerFace = 4;
        }
        this.m_maxVertices = maxVertices;
        this.meshData.numTriangles = this.m_maxVertices / this.vertexPerFace;
        this.meshData.vertices = new int[this.m_maxVertices * 3];
        this.meshData.normals = new int[this.m_maxVertices * 3];
    }

    public int addSubPrim(short[] vertices, short[] normals, byte[] colors, short[] texels) {
        int i;
        if (vertices == null) {
            return -1;
        }
        int verticesNumber = vertices.length / 3;
        if (this.m_curVerticesNumber + verticesNumber > this.m_maxVertices) {
            return -1;
        }
        int vertIndex = this.m_curVerticesNumber * 3;
        for (i = 0; i < vertices.length; ++i) {
            this.meshData.vertices[i + vertIndex] = vertices[i];
        }
        if (normals != null) {
            if (this.meshData.normals == null) {
                this.meshData.normals = new int[this.m_maxVertices * 3];
            }
            for (i = 0; i < normals.length; ++i) {
                this.meshData.normals[i + vertIndex] = normals[i];
            }
        }
        if (colors != null) {
            this.fastUpdateColors(colors);
        }
        if (texels != null) {
            this.fastUpdateTexels(this.m_curVerticesNumber, texels);
        }
        if (this.m_primitiveType != 0 && this.m_primitiveType == 1) {
            this.convertQuadVertex(this.meshData.vertices, this.m_curVerticesNumber / 4, verticesNumber / 4);
        }
        if (normals != null) {
            if (normals.length == vertices.length) {
                this.meshData.command |= 768;
            } else if (this.m_primitiveType == 0 && normals.length == verticesNumber || this.m_primitiveType == 1 && normals.length / 3 == verticesNumber / 4) {
                this.meshData.command |= 512;
            }
        } else {
            this.meshData.normals = this.meshData.vertices;
        }
        if (colors == null) {
            int[] ctmp = new int[]{0xFFFFFF};
            this.meshData.colors = ctmp;
        }
        if (texels != null) {
            this.noTexture = false;
        } else {
            this.noTexture = true;
            this.meshData.texels = new int[this.m_maxVertices * 2];
        }
        this.m_curVerticesNumber += verticesNumber;
        return this.m_curVerticesNumber - verticesNumber;
    }

    public void create(short[] vertices, short[] normals, byte[] colors, short[] texels, int primitiveType, LQAppearance appearance) {
    }

    public void fastUpdateVert(short[] vertices) {
        if (this.meshData.vertices.length != vertices.length) {
            return;
        }
        for (int i = 0; i < vertices.length; ++i) {
            this.meshData.vertices[i] = vertices[i];
        }
        if ((this.meshData.command & 0x3000000) == 0 && (this.meshData.command & 0x4000000) != 0) {
            this.convertQuadVertex(this.meshData.vertices, 0, this.m_curVerticesNumber / 4);
        }
    }

    public int getTotalVertNum() {
        return this.m_maxVertices;
    }

    public void fastUpdateVert(int vertexIndex, short[] vertices) {
        this.fastUpdateVert(vertexIndex, vertices, vertices.length / 3);
    }

    public void fastUpdateVert(int vertexIndex, short[] vertices, int vertexNum) {
        int len = vertexNum * 3;
        int start = vertexIndex * 3;
        for (int i = 0; i < len; ++i) {
            this.meshData.vertices[start + i] = vertices[i];
        }
        if (this.m_primitiveType != 0 && this.m_primitiveType == 1) {
            this.convertQuadVertex(this.meshData.vertices, vertexIndex >> 2, vertexNum >> 2);
        }
    }

    public void fastUpdateTexels(short[] texels) {
        for (int i = 0; i < texels.length; ++i) {
            this.meshData.texels[i] = texels[i];
        }
        if (this.m_primitiveType != 0 && this.m_primitiveType == 1) {
            this.convertQuadTexel(this.meshData.texels, 0, this.m_curVerticesNumber >> 2);
        }
    }

    public void fastUpdateTexels(int vertexIndex, short[] texels) {
        this.fastUpdateTexels(vertexIndex, texels, texels.length >> 1);
    }

    public void fastUpdateTexels(int vertexIndex, short[] texels, int vertNum) {
        if (this.meshData.texels == null) {
            this.meshData.texels = new int[this.m_maxVertices * 2];
        }
        int start = vertexIndex * 2;
        int len = vertNum * 2;
        for (int i = 0; i < len; ++i) {
            this.meshData.texels[start + i] = texels[i];
        }
        if (this.m_primitiveType != 0 && this.m_primitiveType == 1) {
            this.convertQuadTexel(this.meshData.texels, vertexIndex >> 2, vertNum >> 2);
        }
    }

    public void fastUpdateColors(int vertexIndex, byte[] colors) {
        if (this.meshData.colors == null || this.meshData.colors.length == 1) {
            this.meshData.colors = new int[this.meshData.numTriangles];
        }
        if (colors == null) {
            return;
        }
        int faceIndex = vertexIndex / this.vertexPerFace;
        int faceNum = colors.length / 4 / this.vertexPerFace;
        for (int i = 0; i < faceNum; ++i) {
            int r = ((colors[i * 12] & 0xFF) + (colors[i * 12 + 4] & 0xFF) + (colors[i * 12 + 8] & 0xFF)) / 3;
            int g = ((colors[i * 12 + 1] & 0xFF) + (colors[i * 12 + 5] & 0xFF) + (colors[i * 12 + 9] & 0xFF)) / 3;
            int b = ((colors[i * 12 + 2] & 0xFF) + (colors[i * 12 + 6] & 0xFF) + (colors[i * 12 + 10] & 0xFF)) / 3;
            this.meshData.colors[i + faceIndex] = r << 16 | g << 8 | b;
        }
    }

    public void fastUpdateColors(byte[] colors) {
        this.fastUpdateColors(0, colors);
    }

    public void setARGBColor(int color) {
    }

    private int[] convert_mcv3(float[] vec) {
        if (vec == null) {
            return null;
        }
        int[] v = new int[vec.length];
        for (int i = 0; i < vec.length; ++i) {
            v[i] = (int)vec[i] * 4096;
        }
        return v;
    }

    private void convertQuadVertex(int[] v, int startQuadIndex, int quadNum) {
        for (int i = startQuadIndex; i < startQuadIndex + quadNum; ++i) {
            int tmpX = v[i * 12 + 6];
            int tmpY = v[i * 12 + 7];
            int tmpZ = v[i * 12 + 8];
            v[i * 12 + 6] = v[i * 12 + 9];
            v[i * 12 + 7] = v[i * 12 + 10];
            v[i * 12 + 8] = v[i * 12 + 11];
            v[i * 12 + 9] = tmpX;
            v[i * 12 + 10] = tmpY;
            v[i * 12 + 11] = tmpZ;
        }
    }

    private void convertQuadTexel(int[] tex, int startQuadIndex, int quadNum) {
        for (int i = startQuadIndex; i < startQuadIndex + quadNum; ++i) {
            int tmpX = tex[i * 8 + 4];
            int tmpY = tex[i * 8 + 5];
            tex[i * 8 + 4] = tex[i * 8 + 6];
            tex[i * 8 + 5] = tex[i * 8 + 7];
            tex[i * 8 + 6] = tmpX;
            tex[i * 8 + 7] = tmpY;
        }
    }

    private int[] convert_colors(byte[] colors, int numTriangles) {
        if (colors == null) {
            return null;
        }
        int[] c = new int[numTriangles];
        for (int i = 0; i < numTriangles; ++i) {
            int r = ((colors[i * 9] >> 16 & 0xFF) + (colors[i * 9 + 3] >> 16 & 0xFF) + (colors[i * 9 + 6] >> 16 & 0xFF)) / 3;
            int g = ((colors[i * 9 + 1] >> 8 & 0xFF) + (colors[i * 9 + 4] >> 8 & 0xFF) + (colors[i * 9 + 7] >> 8 & 0xFF)) / 3;
            int b = ((colors[i * 9 + 2] & 0xFF) + (colors[i * 9 + 5] & 0xFF) + (colors[i * 9 + 8] & 0xFF)) / 3;
            c[i] = r << 16 | g << 8 | b;
        }
        return c;
    }

    public void setAppearance(LQAppearance appearance) {
        this.m_appearance = null;
        this.m_appearance = appearance;
        this.meshData.command |= ((LQAppearance_mcv3)this.m_appearance).makeRenderCommand();
    }

    public int getCommand() {
        if (!this.noTexture) {
            this.meshData.command |= 12288;
        } else {
            this.meshData.command |= 2048;
        }
        return this.meshData.command | ((LQAppearance_mcv3)this.m_appearance).makeRenderCommand();
    }

    public static class MeshData {
        public int[] vertices;
        public int[] normals;
        public int[] colors;
        public int[] texels;
        private int command;
        public int numTriangles;
    }
}

