/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.util;

public class LQKey {
    private static boolean m_isDebugEnabled = false;
    private static final byte GAMEKEY_QUEUE_SIZE = 6;
    private static final int GAMEKEY_COMBO_INTERVAL = 3;
    public static final int GK_UP = 1;
    public static final int GK_DOWN = 2;
    public static final int GK_LEFT = 4;
    public static final int GK_RIGHT = 8;
    public static final int GK_NUM0 = 16;
    public static final int GK_NUM1 = 32;
    public static final int GK_NUM2 = 64;
    public static final int GK_NUM3 = 128;
    public static final int GK_NUM4 = 256;
    public static final int GK_NUM5 = 512;
    public static final int GK_NUM6 = 1024;
    public static final int GK_NUM7 = 2048;
    public static final int GK_NUM8 = 4096;
    public static final int GK_NUM9 = 8192;
    public static final int GK_STAR = 16384;
    public static final int GK_POUND = 32768;
    public static final int GK_LEFT_SOFT = 65536;
    public static final int GK_RIGHT_SOFT = 131072;
    public static final int GK_CENTER_SOFT = 262144;
    public static final int GK_M = 0x100000;
    private static int[] keyMap = new int[]{1, 2, 4, 8, 0x100000, 65536, 131072, 16, 32, 1, 128, 4, 0x100000, 8, 2048, 2, 8192, 16384, 32768, 262144};
    public static final int STD_UP_ARROW = -1;
    public static final int STD_DOWN_ARROW = -2;
    public static final int STD_LEFT_ARROW = -3;
    public static final int STD_RIGTH_ARROW = -4;
    public static final int STD_LEFT_SOFT = -6;
    public static final int STD_RIGHT_SOFT = -7;
    public static final int STD_M = -5;
    public static int s_keyCurrent;
    public static int s_keyPressed;
    public static int s_keyReleased;
    static int s_keyDblPressed;
    public static int s_lastPressed;
    static int s_keyTick;
    public static int s_fastCurrentKey;
    private static int[] s_gkQueue;
    private static int s_queueStart;
    private static int s_queueEnd;
    private static final int ComboLastingTime = 10;
    private static int keyComboTick;
    private static final int MaxComboKey = 4;
    private static int[] keyComboQueue;
    private static int comboQueuePos;

    public static void ClearKey() {
        LQKey.InitKey();
    }

    public static void InitKey() {
        s_keyCurrent = 0;
        s_keyPressed = 0;
        s_keyReleased = 0;
        s_keyDblPressed = 0;
        s_lastPressed = 0;
        s_keyTick = 0;
        s_fastCurrentKey = 0;
        for (int i = 0; i < 6; ++i) {
            LQKey.s_gkQueue[i] = 0;
        }
        s_queueEnd = 0;
        s_queueStart = 0;
    }

    public static void mapKeys(int[] keys) {
        for (int i = 0; i < keyMap.length; ++i) {
            if (keys[i] < 0) continue;
            LQKey.keyMap[i] = keys[i];
        }
    }

    private static boolean PushQueue(int key) {
        if ((s_queueStart + 1) % 6 == s_queueEnd) {
            return false;
        }
        LQKey.s_gkQueue[LQKey.s_queueStart] = key;
        if (m_isDebugEnabled) {
            System.out.println("push key " + Integer.toHexString(key));
        }
        s_queueStart = (s_queueStart + 1) % 6;
        return true;
    }

    private static int PopQueue() {
        if (s_queueStart == s_queueEnd) {
            return s_fastCurrentKey;
        }
        int key = s_gkQueue[s_queueEnd];
        s_queueEnd = (s_queueEnd + 1) % 6;
        if (m_isDebugEnabled) {
            System.out.println("pop key " + Integer.toHexString(key));
        }
        return key;
    }

    public static void UpdateKey() {
        int currentKey = LQKey.PopQueue();
        s_keyPressed = ~s_keyCurrent & currentKey;
        s_keyReleased = s_keyCurrent & ~currentKey;
        s_keyCurrent = currentKey;
        ++s_keyTick;
        if (s_keyPressed != 0) {
            if (s_lastPressed != 0 && s_keyTick < 4 && s_lastPressed == s_keyPressed) {
                s_keyDblPressed = s_keyPressed;
                s_lastPressed = 0;
            } else {
                s_keyTick = 0;
                s_keyDblPressed = 0;
                s_lastPressed = s_keyPressed;
            }
        } else if (s_keyDblPressed != 0) {
            s_keyDblPressed = 0;
        }
        if (keyComboTick > 0) {
            --keyComboTick;
        } else {
            LQKey.pushComboQueue(0);
        }
    }

    public static boolean IsKeyCombo(int[] combo) {
        int comboIndex = 0;
        for (int i = 0; i < keyComboQueue.length; ++i) {
            if (combo[comboIndex] != keyComboQueue[i]) {
                if (comboIndex <= 0) continue;
                return false;
            }
            ++comboIndex;
        }
        if (comboIndex <= combo.length - 1) {
            return false;
        }
        LQKey.clearKeyCombo();
        return true;
    }

    public static void clearKeyCombo() {
        for (int i = 0; i < 4; ++i) {
            LQKey.keyComboQueue[i] = 0;
        }
    }

    public static boolean IsKeyHold(int gameKey) {
        return (s_keyCurrent & gameKey) != 0;
    }

    public static boolean IsAnyKeyPressed() {
        return s_keyPressed != 0;
    }

    public static boolean IsAnyKeyHold() {
        return s_keyCurrent != 0;
    }

    public static boolean IsKeyDblPressed(int gameKey) {
        return (s_keyDblPressed & gameKey) != 0;
    }

    public static boolean IsKeyPressed(int gKey) {
        return (s_keyPressed & gKey) != 0;
    }

    static void ClearKeyHold(int gKey) {
        s_fastCurrentKey &= ~gKey;
        if (m_isDebugEnabled) {
            System.out.print("manual release <----- ");
        }
        LQKey.PushQueue(s_fastCurrentKey);
    }

    public static void keyPressed(int keyCode) {
        int key = LQKey.GetKey(keyCode);
        s_fastCurrentKey |= key;
        if (m_isDebugEnabled) {
            System.out.print("press -----> ");
        }
        LQKey.PushQueue(s_fastCurrentKey);
        LQKey.pushComboQueue(key);
    }

    public static void keyReleased(int keyCode) {
        s_fastCurrentKey &= ~LQKey.GetKey(keyCode);
        if (m_isDebugEnabled) {
            System.out.print("release <----- ");
        }
        LQKey.PushQueue(s_fastCurrentKey);
    }

    private static void pushComboQueue(int key) {
        for (int i = 0; i < 3; ++i) {
            LQKey.keyComboQueue[i] = keyComboQueue[i + 1];
        }
        LQKey.keyComboQueue[3] = key;
        keyComboTick = 10;
    }

    private static int GetKey(int keyCode) {
        switch (keyCode) {
            case -1: {
                return keyMap[0];
            }
            case -2: {
                return keyMap[1];
            }
            case -3: {
                return keyMap[2];
            }
            case -4: {
                return keyMap[3];
            }
            case -5: {
                return keyMap[4];
            }
            case -6: {
                return keyMap[5];
            }
            case -7: {
                return keyMap[6];
            }
            case 48: {
                return keyMap[7];
            }
            case 49: {
                return keyMap[8];
            }
            case 50: {
                return keyMap[9];
            }
            case 51: {
                return keyMap[10];
            }
            case 52: {
                return keyMap[11];
            }
            case 53: {
                return keyMap[12];
            }
            case 54: {
                return keyMap[13];
            }
            case 55: {
                return keyMap[14];
            }
            case 56: {
                return keyMap[15];
            }
            case 57: {
                return keyMap[16];
            }
            case 42: {
                return keyMap[17];
            }
            case 35: {
                return keyMap[18];
            }
        }
        return 0;
    }

    public static void rotateKey(byte dir) {
        switch (dir) {
            case -1: {
                int[] keymap = new int[]{1, 2, 4, 8, 0x100000, 65536, 131072, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 262144};
                LQKey.mapKeys(keymap);
                break;
            }
            case 0: {
                int[] keymap = new int[]{4, 8, 2, 1, 0x100000, 65536, 131072, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 262144};
                LQKey.mapKeys(keymap);
                break;
            }
            case 1: {
                int[] keymap = new int[]{2, 1, 8, 4, 0x100000, 65536, 131072, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 262144};
                LQKey.mapKeys(keymap);
                break;
            }
            case 2: {
                int[] keymap = new int[]{8, 4, 1, 2, 0x100000, 65536, 131072, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 262144};
                LQKey.mapKeys(keymap);
                break;
            }
        }
    }

    static {
        s_gkQueue = new int[6];
        keyComboQueue = new int[4];
    }
}

