/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.lemonquest.math.LQMath;
import com.lemonquest.math.MathFP;
import com.lemonquest.math.Vec2D;
import com.lemonquest.physics_v2.DynamicObj;
import com.lemonquest.physics_v2.RaceWorld;
import com.lemonquest.physics_v2.StaticObj;
import com.lemonquest.util.LQConsole;
import game.Bike;
import game.Design;
import game.Effects;
import game.GameMain;
import game.LevelMap;
import game.Profile;
import game.Res;
import game.RiderInfo;
import java.util.Random;

public class Level {
    private Res res = Res.instance();
    private GameMain game;
    private Bike[] bikes;
    private Bike playerBike;
    private int aiNum;
    private int[] bikeRanks;
    private boolean isReplayMode = false;
    private boolean isFinished = false;
    private int replayFrameNum;
    private int frame;
    public static final byte StateOpeningShow = 0;
    public static final byte StateCounting = 1;
    public static final byte StateRacing = 2;
    private byte levelState = 0;
    private int showTick;
    private RaceWorld world;
    int[] activeGroundIds = new int[30];
    int activeGroundCount;
    public static Random rand = new Random();

    public void releaseBike() {
        this.playerBike = null;
        if (this.bikes != null) {
            for (int i = 0; i < this.bikes.length; ++i) {
                this.bikes[i] = null;
            }
        }
        this.bikes = null;
        System.gc();
    }

    public Level(GameMain game, int aiNum, int levelIndex) {
        try {
            this.game = game;
            this.aiNum = aiNum;
            GameMain.levelMap = null;
            GameMain.levelMap = new LevelMap(levelIndex);
            this.reset((byte)0, levelIndex);
        }
        catch (Exception e) {
            GameMain.errMessage3 = e.getMessage();
            e.printStackTrace();
        }
    }

    public void reset(byte state, int levelIndex) {
        int i;
        GameMain.setLoading(2000);
        int staticObjNum = 0;
        int dynObjNum = this.aiNum + 1;
        if (this.game.getLevelCustom().typeOfRace == 3) {
            dynObjNum = 2;
        }
        GameMain.setLoading(2001);
        LevelMap.Ground[] grounds = GameMain.levelMap.getGrounds();
        for (i = 0; i < grounds.length; ++i) {
            staticObjNum += this.getGroundCollisionNum(i);
        }
        GameMain.setLoading(2001);
        this.world = new RaceWorld(dynObjNum, staticObjNum);
        LQConsole.println("create physics world: dyn -> " + dynObjNum + "    static -> " + staticObjNum);
        GameMain.setLoading(2002);
        for (i = 0; i < grounds.length; ++i) {
            this.addGroundCollision(i);
        }
        GameMain.setLoading(2003);
        this.bikeRanks = new int[dynObjNum];
        for (i = 0; i < this.bikeRanks.length; ++i) {
            this.bikeRanks[i] = i;
        }
        GameMain.setLoading(2004);
        this.releaseBike();
        this.bikes = new Bike[dynObjNum];
        for (i = 0; i < this.bikes.length; ++i) {
            int pointIndex = i;
            if (this.game.getLevelCustom().typeOfRace == 3) {
                pointIndex = 0;
            }
            short x = GameMain.levelMap.getStartPoint(pointIndex)[0];
            short y = GameMain.levelMap.getStartPoint(pointIndex)[1];
            short dir_x = GameMain.levelMap.getStartPoint(pointIndex)[2];
            short dir_y = GameMain.levelMap.getStartPoint(pointIndex)[3];
            int bikeObjID = this.world.addBall(new Vec2D(MathFP.toFP(x), MathFP.toFP(y)), MathFP.toFP(7), null);
            DynamicObj bikeObj = this.world.getDynObj(bikeObjID);
            bikeObj.resetDir(new Vec2D(MathFP.toFP(dir_x), MathFP.toFP(dir_y)));
            this.bikes[i] = new Bike(this.game, bikeObj);
            this.bikes[i].setMode((byte)2);
        }
        GameMain.setLoading(2005);
        this.playerBike = this.bikes[this.bikes.length - 1];
        this.playerBike.lockGear(true);
        this.playerBike.setMode((byte)0);
        this.playerBike.setRiderInfo(RiderInfo.infos[RiderInfo.infos.length - 1]);
        for (i = 0; i < this.bikes.length; ++i) {
            if (this.bikes[i] == this.playerBike) continue;
            int infoIndex = i;
            if (infoIndex > RiderInfo.infos.length - 1 - 1) {
                infoIndex -= RiderInfo.infos.length - 1;
            }
            this.bikes[i].setRiderInfo(RiderInfo.infos[infoIndex]);
        }
        GameMain.setLoading(2006);
        Profile profile = Res.instance().userProfile;
        int accLevel = profile.getBikeProper(1);
        int speedLevel = profile.getBikeProper(0);
        int handlingLevel = profile.getBikeProper(2);
        int brakeLevel = profile.getBikeProper(3);
        this.playerBike.setPerformance(accLevel, speedLevel, handlingLevel, brakeLevel);
        int playerAveragePerform = (accLevel + speedLevel + handlingLevel + brakeLevel) / 4;
        this.playerBike.setBikeCustom(this.game.getPlayerBikeCustom());
        GameMain.setLoading(2007);
        if (this.game.getLevelCustom().typeOfRace == 3) {
            this.bikes[0].enterGhostMode();
            if (this.game.isGhostDataFromOnLine) {
                Res.instance().userProfile.loadGhostDataFromNet(this.bikes[0], levelIndex);
            } else {
                Res.instance().userProfile.loadGhostData(this.bikes[0], levelIndex);
            }
        } else {
            int i2;
            int aiPerform = playerAveragePerform + 3;
            for (i2 = 0; i2 < this.bikes.length; ++i2) {
                if (this.bikes[i2] == this.playerBike) continue;
                this.bikes[i2].setPerformance(aiPerform, aiPerform, aiPerform, aiPerform);
                int oldPower = this.bikes[i2].getPhysicsObj().getNormEnginePower();
                int newEnginePower = oldPower * ((6 - this.bikes[i2].getRiderInfo().level) * 4 + 100) / 100;
                this.bikes[i2].getPhysicsObj().setEnginePower(newEnginePower);
            }
            for (i2 = 0; i2 < this.bikes.length; ++i2) {
                if (this.bikes[i2] == this.playerBike) continue;
                Bike.BikeCustom custom = new Bike.BikeCustom();
                custom.tireType = 0;
                custom.tireHardness = 1;
                if (this.game.getLevelCustom().weather == 1) {
                    custom.tireType = 1;
                    custom.tireHardness = 1;
                }
                this.bikes[i2].setBikeCustom(custom);
                custom = null;
            }
        }
        GameMain.setLoading(2008);
        this.updateBikeRanks();
        this.isReplayMode = false;
        this.frame = 0;
        GameMain.setLoading(2009);
        if (this.game.getLevelCustom().typeOfRace == 6 || this.game.getLevelCustom().typeOfRace == 7 || this.game.getLevelCustom().typeOfRace == 8) {
            int playerY = 0;
            playerY = this.game.getLevelCustom().typeOfRace == 6 ? LQMath.round(this.playerBike.getYf() * (float)MathFP.ONE) : MathFP.toFP(640);
            this.playerBike.resetToPos(new Vec2D(MathFP.toFP(-2000), playerY), new Vec2D(MathFP.ONE, 0));
            this.playerBike.setMode((byte)5);
            if (this.game.getLevelCustom().typeOfRace == 8) {
                this.game.brakeBikeInitPos = this.playerBike.getXf();
            }
            if (this.game.getLevelCustom().typeOfRace == 7) {
                this.playerBike.getPhysicsObj().setEnginePower(MathFP.toFP(105));
            }
        }
        GameMain.setLoading(2010);
        this.game.getCamera().setTargetBike(this.playerBike);
        this.game.getCamera().setType(this.getCameraType());
        GameMain.setLoading(2011);
        this.levelState = state;
    }

    private byte getCameraType() {
        if (this.game.getLevelCustom().typeOfRace == 6) {
            return 3;
        }
        return 2;
    }

    public byte getState() {
        return this.levelState;
    }

    public Bike getNoPlayerBike() {
        for (int i = 0; i < this.bikes.length; ++i) {
            if (this.bikes[i] == this.playerBike) continue;
            return this.bikes[i];
        }
        return this.bikes[0];
    }

    public Bike getPlayerBike() {
        return this.playerBike;
    }

    public Bike[] getBikes() {
        return this.bikes;
    }

    public int[] getBikeRanks() {
        return this.bikeRanks;
    }

    public RaceWorld getPhyWorld() {
        return this.world;
    }

    public int getFrame() {
        return this.frame;
    }

    public void pause() {
        if (!this.world.isPause()) {
            this.world.pause();
            this.game.setGameState(201);
        } else {
            this.world.pause();
            this.game.setGameState(501);
        }
    }

    public boolean isPause() {
        return this.world.isPause();
    }

    public void enterReplayMode() {
        this.replayFrameNum = this.frame;
        Bike.ReplayNode list = this.playerBike.getReplayList();
        this.reset((byte)0, this.game.getLevelIndex());
        this.playerBike.setReplayList(list);
        this.playerBike.setMode((byte)1);
        this.isReplayMode = true;
        LQConsole.println("--------begin replay--------");
    }

    public void enterGhostMode() {
    }

    public int getShowTick() {
        return this.showTick;
    }

    public void update() {
        switch (this.levelState) {
            case 0: {
                if (this.showTick == 0) {
                    this.game.getCamera().setTargetBike(this.getPlayerBike());
                    this.game.getCamera().setType((byte)-4);
                }
                if (this.showTick == 90) {
                    this.game.getCamera().setTargetBike(this.getPlayerBike());
                    this.game.getCamera().setType(this.getCameraType());
                }
                if (this.showTick > 100) {
                    this.showTick = 0;
                    this.levelState = 1;
                    if (this.game.getLevelCustom().typeOfRace != 4 && this.game.getLevelCustom().typeOfRace != 5 && this.game.getLevelCustom().typeOfRace != 6 && this.game.getLevelCustom().typeOfRace != 7 && this.game.getLevelCustom().typeOfRace != 8 && this.game.isFirstClew_Champion && this.game.getLevelCustom().gameMode == 1) {
                        this.game.isFirstClew_Champion = false;
                        this.game.msgt.addNewMessage(this.res.fontWhiteSmall, this.res.txt[25], true, -1);
                    }
                    if (!this.game.isFirstClew_QuickRace || this.game.getLevelCustom().gameMode != 2) break;
                    this.game.isFirstClew_QuickRace = false;
                    this.game.msgt.addNewMessage(this.res.fontWhiteSmall, this.res.txt[25], true, -1);
                    break;
                }
                this.game.camera.update();
                Res.instance().groundRenderList.update();
                if (!Res.isSBmemory()) {
                    Res.instance().treeRenderList.update();
                }
                ++this.showTick;
                break;
            }
            case 1: {
                if (this.showTick++ <= 40) break;
                this.showTick = 0;
                this.levelState = (byte)2;
                break;
            }
            case 2: {
                this.updateRacing();
            }
        }
    }

    private void updateRacing() {
        boolean isRainy;
        int i;
        for (i = 0; i < this.bikes.length; ++i) {
            if (this.bikes[i].isDisabled()) continue;
            this.bikes[i].update(this.frame);
        }
        if (!this.isFinished) {
            this.isFinished = this.updateWinLose();
        }
        for (i = 0; i < this.activeGroundCount; ++i) {
            this.world.sleepGroundCollision(this.activeGroundIds[i]);
        }
        this.activeGroundCount = 0;
        LevelMap.Ground[] grounds = GameMain.levelMap.getGrounds();
        for (int bikeIndex = 0; bikeIndex < this.bikes.length; ++bikeIndex) {
            int groundID = this.bikes[bikeIndex].getGroundID();
            for (int i2 = groundID - 2; i2 <= groundID + 1; ++i2) {
                int id = i2;
                if (id < 0) {
                    id += grounds.length;
                }
                if (id > grounds.length - 1) {
                    id -= grounds.length;
                }
                this.addToGroundIdList(id);
            }
        }
        for (int i3 = 0; i3 < this.activeGroundCount; ++i3) {
            this.world.activateGroundCollision(this.activeGroundIds[i3]);
        }
        this.world.update();
        this.updateBikeRanks();
        if (this.playerBike.isInSand() && this.playerBike.getSpeedFP() > RaceWorld.CONST_2) {
            Effects.instance().addBikeSand(this.playerBike.getSandPos());
        }
        boolean bl = isRainy = this.game.getLevelCustom().weather == 1;
        if (isRainy && this.playerBike.getSpeedFP() > RaceWorld.CONST_5 || Math.abs(this.playerBike.getTurnAngle()) > 20 && this.playerBike.getSpeedFP() > RaceWorld.CONST_20) {
            int frameLen = 3;
            if (isRainy) {
                frameLen = 1;
            }
            Effects.instance().addBikeSmoke(this.playerBike.getSmokePos(), frameLen);
        }
        this.game.camera.update();
        ++this.frame;
    }

    private boolean updateWinLose() {
        switch (this.game.getLevelCustom().typeOfRace) {
            case 0: {
                if (this.game.gameState != 501 || !this.playerBike.hasFinishedRace()) break;
                this.game.normalRaceWin();
                this.game.setGameState(541);
                return true;
            }
            case 1: {
                if (this.game.gameState != 501 || this.frame < this.game.getLevelCustom().lapNum * Design.AgainstClockTime[this.game.getLevelIndex()] && !this.playerBike.hasFinishedRace()) break;
                if (this.playerBike.hasFinishedRace()) {
                    this.game.againstClockWin();
                } else {
                    this.game.againstClockFail();
                }
                for (int i = 0; i < this.bikes.length; ++i) {
                    this.bikes[i].setFinished(true);
                }
                this.game.setGameState(541);
                return true;
            }
            case 2: {
                int i;
                Bike lastBike = this.bikes[this.bikeRanks[this.bikeRanks.length - 1]];
                if (this.bikes[this.bikeRanks[this.bikeRanks.length - 2]].getFinishedLaps() <= lastBike.getFinishedLaps()) break;
                lastBike.setFinished(true);
                int newBikeNum = this.bikes.length - 1;
                if (lastBike == this.playerBike || newBikeNum <= 1) {
                    for (int i2 = 0; i2 < this.bikes.length; ++i2) {
                        this.bikes[i2].setFinished(true);
                    }
                    if (lastBike == this.playerBike) {
                        this.game.eliminationFail();
                    } else {
                        this.game.eliminationWin();
                    }
                    this.game.setGameState(541);
                    return true;
                }
                Bike[] newBikes = new Bike[newBikeNum];
                int[] newRanks = new int[newBikeNum];
                int count = 0;
                for (i = 0; i < this.bikes.length; ++i) {
                    if (this.bikes[i] == lastBike) continue;
                    newBikes[count] = this.bikes[i];
                    ++count;
                }
                this.bikes = newBikes;
                for (i = 0; i < newBikeNum; ++i) {
                    newRanks[i] = i;
                }
                this.bikeRanks = newRanks;
                this.updateBikeRanks();
                break;
            }
            case 3: {
                if (this.game.gameState != 501 || !this.playerBike.hasFinishedRace()) break;
                this.updateBikeRanks();
                if (this.playerBike.getRank() == 0) {
                    this.game.ghostModeWin();
                } else {
                    this.game.ghostModeFail();
                }
                this.game.setGameState(541);
                return true;
            }
            case 4: {
                if (this.playerBike.hasFinishedRace()) {
                    return false;
                }
                if (this.playerBike.getFinishedGround() >= 20) {
                    this.playerBike.setFinished(true);
                    this.game.zigzagWin();
                    this.game.setGameState(541);
                    return false;
                }
                if (this.frame < 600 && this.playerBike.getFinishedGround() >= -1) break;
                this.playerBike.setFinished(true);
                this.game.zigzagFail();
                this.game.setGameState(541);
                return false;
            }
            case 5: {
                if (this.frame < 1680 && !this.playerBike.hasFinishedRace()) break;
                this.playerBike.setFinished(true);
                this.game.miniCircuitWin();
                this.game.setGameState(541);
                return true;
            }
            case 6: {
                if (this.frame <= 60 || !(this.game.wheelieAngle > 70.0f) && !(this.game.wheelieAngle <= 5.0f) && this.playerBike.getFinishedGround() <= 10) break;
                if (this.game.wheelieAngle > 90.0f) {
                    // empty if block
                }
                this.playerBike.setFinished(true);
                this.game.wheelieWin();
                this.game.setGameState(541);
                return true;
            }
            case 8: {
                if (this.frame <= 60) break;
                if (this.frame - 60 > 320 || this.playerBike.getXf() - this.game.brakeBikeInitPos >= 3600.0f) {
                    this.playerBike.setFinished(true);
                    this.game.brakeGameFail();
                    this.game.setGameState(541);
                    return true;
                }
                if (this.playerBike.getSpeedFP() != 0) break;
                this.playerBike.setFinished(true);
                this.game.brakeGameWin();
                this.game.setGameState(541);
                return true;
            }
            case 7: {
                if (this.playerBike.hasFinishedRace() || this.playerBike.getGear() != 6 || this.showTick++ <= 15) break;
                this.playerBike.setFinished(true);
                this.game.accelerationGameWin();
                this.game.setGameState(541);
                return true;
            }
        }
        return false;
    }

    private void updateBikeRanks() {
        int i;
        int tmp = 0;
        int nextID = 0;
        int dx_i = 0;
        int dy_i = 0;
        int dist_i = 0;
        int dx_j = 0;
        int dy_j = 0;
        int dist_j = 0;
        boolean needToSwap = false;
        for (i = 0; i < this.bikeRanks.length; ++i) {
            for (int j = i + 1; j < this.bikeRanks.length; ++j) {
                needToSwap = false;
                if (this.bikes[this.bikeRanks[i]].hasFinishedRace() && this.bikes[this.bikeRanks[j]].hasFinishedRace()) {
                    if (this.bikes[this.bikeRanks[i]].getTotalUsedTime() > this.bikes[this.bikeRanks[j]].getTotalUsedTime()) {
                        needToSwap = true;
                    }
                } else if (!this.bikes[this.bikeRanks[i]].hasFinishedRace() && this.bikes[this.bikeRanks[j]].hasFinishedRace()) {
                    needToSwap = true;
                } else {
                    if (this.bikes[this.bikeRanks[i]].getFinishedLaps() > this.bikes[this.bikeRanks[j]].getFinishedLaps()) continue;
                    if (this.bikes[this.bikeRanks[i]].getFinishedLaps() < this.bikes[this.bikeRanks[j]].getFinishedLaps()) {
                        needToSwap = true;
                    } else {
                        if (this.bikes[this.bikeRanks[i]].getFinishedGround() > this.bikes[this.bikeRanks[j]].getFinishedGround()) continue;
                        if (this.bikes[this.bikeRanks[i]].getFinishedGround() < this.bikes[this.bikeRanks[j]].getFinishedGround()) {
                            needToSwap = true;
                        } else {
                            nextID = this.bikes[this.bikeRanks[i]].getGroundID() + 1;
                            LevelMap.Ground[] grounds = GameMain.levelMap.getGrounds();
                            if (nextID >= grounds.length) {
                                nextID -= grounds.length;
                            }
                            if ((dist_i = (dx_i = (int)this.bikes[this.bikeRanks[i]].getXf() - grounds[nextID].x) * dx_i + (dy_i = (int)this.bikes[this.bikeRanks[i]].getYf() - grounds[nextID].y) * dy_i) > (dist_j = (dx_j = (int)this.bikes[this.bikeRanks[j]].getXf() - grounds[nextID].x) * dx_j + (dy_j = (int)this.bikes[this.bikeRanks[j]].getYf() - grounds[nextID].y) * dy_j)) {
                                needToSwap = true;
                            }
                        }
                    }
                }
                if (!needToSwap) continue;
                tmp = this.bikeRanks[j];
                this.bikeRanks[j] = this.bikeRanks[i];
                this.bikeRanks[i] = tmp;
            }
        }
        for (i = 0; i < this.bikeRanks.length; ++i) {
            int bikeIndex = this.bikeRanks[i];
            this.bikes[bikeIndex].setRank(i);
        }
    }

    public void finishRace() {
        this.finishRaceBogus();
    }

    public static int getRandomNum(int min, int max) {
        try {
            if (max == min) {
                return min;
            }
            if (max < min) {
                int temp1 = min;
                min = max;
                max = temp1;
            }
            int temp = max - min + 1;
            temp = Math.abs(rand.nextInt() % temp);
            return temp += min;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void finishRaceBogus() {
        int i;
        int[] addTime = new int[20];
        int time1 = 0;
        for (i = 0; i < addTime.length; ++i) {
            addTime[i] = time1 += Level.getRandomNum(10, 80);
        }
        for (i = 0; i < this.bikes.length; ++i) {
            if (this.bikes[i] == this.playerBike || this.bikes[i].hasFinishedRace()) continue;
            int addTime1 = addTime[this.bikes[i].getRank()];
            this.bikes[i].setTotalUseTime(addTime1);
            this.bikes[i].setFinished(true);
        }
    }

    private void addToGroundIdList(int groundID) {
        int k;
        for (k = 0; k < this.activeGroundCount && this.activeGroundIds[k] != groundID; ++k) {
        }
        if (k == this.activeGroundCount) {
            this.activeGroundIds[this.activeGroundCount++] = groundID;
        }
    }

    private int getGroundCollisionNum(int groundID) {
        int num = 0;
        LevelMap.Ground ground = GameMain.levelMap.getGrounds()[groundID];
        short meshID = ground.meshID;
        LevelMap.CollideShape[] collideShapes = GameMain.levelMap.getGroundCollision(meshID);
        for (int i = 0; i < collideShapes.length; ++i) {
            if (collideShapes[i].shapeType == 0) {
                int lineNum = collideShapes[i].pointsFP.length / 2 - 1;
                num += lineNum;
                continue;
            }
            if (collideShapes[i].shapeType != 1) continue;
        }
        LevelMap.Tree[] trees = GameMain.levelMap.getTrees()[groundID];
        for (int treeIndex = 0; treeIndex < trees.length; ++treeIndex) {
            LevelMap.CollideShape[] treeCollides = GameMain.levelMap.getTreeCollision(trees[treeIndex].meshID);
            if (treeCollides == null) continue;
            for (int i = 0; i < treeCollides.length; ++i) {
                if (treeCollides[i].shapeType == 0) {
                    int lineNum = treeCollides[i].pointsFP.length / 2 - 1;
                    num += lineNum;
                    continue;
                }
                if (treeCollides[i].shapeType != 1) continue;
            }
        }
        LevelMap.CollideShape[] collides = GameMain.levelMap.getFreeCollision(groundID);
        if (collides != null) {
            for (int i = 0; i < collides.length; ++i) {
                if (collides[i].shapeType == 0) {
                    int lineNum = collides[i].pointsFP.length / 2 - 1;
                    num += lineNum;
                    continue;
                }
                if (collides[i].shapeType != 1) continue;
            }
        }
        return num;
    }

    private void addGroundCollision(int groundID) {
        LevelMap.Ground ground = GameMain.levelMap.getGrounds()[groundID];
        Vec2D p1 = new Vec2D();
        Vec2D p2 = new Vec2D();
        short meshID = ground.meshID;
        LevelMap.CollideShape[] collideShapes = GameMain.levelMap.getGroundCollision(meshID);
        for (int i = 0; i < collideShapes.length; ++i) {
            if (collideShapes[i].shapeType == 0) {
                int lineNum = collideShapes[i].pointsFP.length / 2 - 1;
                int groundX = MathFP.toFP(ground.x);
                int groundY = MathFP.toFP(ground.y);
                int lineIndex = 0;
                int index = 0;
                while (lineIndex < lineNum) {
                    p1.set(collideShapes[i].pointsFP[index] + groundX, collideShapes[i].pointsFP[index + 1] + groundY);
                    p2.set(collideShapes[i].pointsFP[index + 2] + groundX, collideShapes[i].pointsFP[index + 3] + groundY);
                    StaticObj line = this.world.getStaticObj(this.world.addLine(p1, p2));
                    line.setGroundID(groundID);
                    if (collideShapes[i].roadType == 0) {
                        line.setEventHandler((byte)0, this.game.roadEventHandler);
                        line.setEventOnly(true);
                    } else if (collideShapes[i].roadType == 1) {
                        line.setEventHandler((byte)1, this.game.roadEventHandler);
                    }
                    ++lineIndex;
                    index += 2;
                }
                continue;
            }
            if (collideShapes[i].shapeType != 1) continue;
        }
        LevelMap.Tree[] trees = GameMain.levelMap.getTrees()[groundID];
        for (int treeIndex = 0; treeIndex < trees.length; ++treeIndex) {
            LevelMap.CollideShape[] treeCollides = GameMain.levelMap.getTreeCollision(trees[treeIndex].meshID);
            if (treeCollides == null) continue;
            for (int i = 0; i < treeCollides.length; ++i) {
                if (treeCollides[i].shapeType == 0) {
                    int lineNum = treeCollides[i].pointsFP.length / 2 - 1;
                    int treeX = MathFP.toFP(trees[treeIndex].x);
                    int treeY = MathFP.toFP(trees[treeIndex].y);
                    int lineIndex = 0;
                    int index = 0;
                    while (lineIndex < lineNum) {
                        p1.set(treeCollides[i].pointsFP[index] + treeX, treeCollides[i].pointsFP[index + 1] + treeY);
                        p2.set(treeCollides[i].pointsFP[index + 2] + treeX, treeCollides[i].pointsFP[index + 3] + treeY);
                        StaticObj line = this.world.getStaticObj(this.world.addLine(p1, p2));
                        line.setGroundID(groundID);
                        ++lineIndex;
                        index += 2;
                    }
                    continue;
                }
                if (treeCollides[i].shapeType != 1) continue;
            }
        }
        LevelMap.CollideShape[] collides = GameMain.levelMap.getFreeCollision(groundID);
        if (collides != null) {
            for (int i = 0; i < collides.length; ++i) {
                if (collides[i].shapeType == 0) {
                    int lineNum = collides[i].pointsFP.length / 2 - 1;
                    int lineIndex = 0;
                    int index = 0;
                    while (lineIndex < lineNum) {
                        p1.set(collides[i].pointsFP[index], collides[i].pointsFP[index + 1]);
                        p2.set(collides[i].pointsFP[index + 2], collides[i].pointsFP[index + 3]);
                        StaticObj line = this.world.getStaticObj(this.world.addLine(p1, p2));
                        line.setGroundID(groundID);
                        ++lineIndex;
                        index += 2;
                    }
                    continue;
                }
                if (collides[i].shapeType != 1) continue;
            }
        }
    }

    public static class LevelCustom {
        public static final byte GameModeStory = 0;
        public static final byte GameModeChampionship = 1;
        public static final byte GameModeQuickRace = 2;
        public static final byte RaceTypeNormal = 0;
        public static final byte RaceTypeAgainstClock = 1;
        public static final byte RaceTypeElimination = 2;
        public static final byte RaceTypeGhost = 3;
        public static final byte RaceTypeZigZag = 4;
        public static final byte RaceTypeMiniCircuit = 5;
        public static final byte RaceTypeWheelie = 6;
        public static final byte RaceTypeAcceleration = 7;
        public static final byte RaceTypeBrake = 8;
        public static final byte WeatherDry = 0;
        public static final byte WeatherRain = 1;
        public byte gameMode;
        public byte typeOfRace;
        public int curcuit;
        public int lapNum;
        public int opponentNum;
        public byte weather = 0;
    }
}

