/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.lq3d;

import com.lemonquest.math.LQMath;

public class LQQuat {
    public float X;
    public float Y;
    public float Z;
    public float W;

    public LQQuat() {
        this.setIdentity();
    }

    public LQQuat(float x, float y, float z, float w) {
        this.set(x, y, z, w);
    }

    public void setIdentity() {
        this.set(0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void set(float x, float y, float z, float w) {
        this.X = x;
        this.Y = y;
        this.Z = z;
        this.W = w;
    }

    public double length() {
        return Math.sqrt(this.W * this.W + this.X * this.X + this.Y * this.Y + this.Z * this.Z);
    }

    public LQQuat setAxisAngle(float angle, float ax, float ay, float az) {
        double length = Math.sqrt(ax * ax + ay * ay + az * az);
        if (length == 0.0) {
            this.setIdentity();
        } else {
            angle = (float)((double)angle * (Math.PI / 360));
            double cangle = Math.cos(angle);
            double sangle = Math.sin(angle);
            double scale = sangle / length;
            this.set((float)(scale * (double)ax), (float)(scale * (double)ay), (float)(scale * (double)az), (float)cangle);
        }
        return this;
    }

    public LQQuat setEuler(float rx, float ry, float rz) {
        rx = (float)((double)rx * (Math.PI / 360));
        ry = (float)((double)ry * (Math.PI / 360));
        rz = (float)((double)rz * (Math.PI / 360));
        double cx = Math.cos(rx);
        double cy = Math.cos(ry);
        double cz = Math.cos(rz);
        double sx = Math.sin(rx);
        double sy = Math.sin(ry);
        double sz = Math.sin(rz);
        double cxsy = cx * sy;
        double cxcy = cx * cy;
        double sxsy = sx * sy;
        this.set((float)(cxsy * sz + cz * cy * sx), (float)(cxsy * cz - sx * cy * sz), (float)(cxcy * sz + sxsy * cz), (float)(cxcy * cz - sxsy * sz));
        return this;
    }

    public LQQuat conjugate() {
        this.X = -this.X;
        this.Y = -this.Y;
        this.Z = -this.Z;
        return this;
    }

    public LQQuat crossProduct(LQQuat rhs) {
        float x = this.W * rhs.X + this.X * rhs.W + this.Y * rhs.Z - this.Z * rhs.Y;
        float y = this.W * rhs.Y - this.X * rhs.Z + this.Y * rhs.W + this.Z * rhs.X;
        float z = this.W * rhs.Z + this.X * rhs.Y - this.Y * rhs.X + this.Z * rhs.W;
        float w = this.W * rhs.W - this.X * rhs.X - this.Y * rhs.Y - this.Z * rhs.Z;
        this.set(x, y, z, w);
        return this;
    }

    public double dotProduct(LQQuat quat) {
        return this.W * quat.W + this.X * quat.X + this.Y * quat.Y + this.Z * quat.Z;
    }

    public void mul(float scalar) {
        this.W *= scalar;
        this.X *= scalar;
        this.Y *= scalar;
        this.Z *= scalar;
    }

    public LQQuat normalize() {
        float inorm = (float)(1.0 / Math.sqrt(this.W * this.W + this.X * this.X + this.Y * this.Y + this.Z * this.Z));
        this.set(this.X * inorm, this.Y * inorm, this.Z * inorm, this.W * inorm);
        return this;
    }

    public void Slerp(LQQuat a, LQQuat b, float t) {
        float w2;
        float w1;
        double cosTheta = a.dotProduct(b);
        float theta = (float)LQMath.acos(cosTheta);
        float sinTheta = (float)Math.sin(theta);
        if (sinTheta > 0.001f) {
            w1 = (float)(Math.sin((1.0f - t) * theta) / (double)sinTheta);
            w2 = (float)(Math.sin(t * theta) / (double)sinTheta);
        } else {
            w1 = 1.0f - t;
            w2 = t;
        }
        this.W = a.W * w1 + b.W * w2;
        this.X = a.X * w1 + b.X * w2;
        this.Y = a.Y * w1 + b.Y * w2;
        this.Z = a.Z * w1 + b.Z * w2;
    }

    public void NLerp(LQQuat a, LQQuat b, float w2) {
        float w1 = 1.0f - w2;
        this.W = a.W * w1 + b.W * w2;
        this.X = a.X * w1 + b.X * w2;
        this.Y = a.Y * w1 + b.Y * w2;
        this.Z = a.Z * w1 + b.Z * w2;
        this.normalize();
    }

    public void ToMatrix(float[] mf) {
        float x2 = 2.0f * this.X;
        float y2 = 2.0f * this.Y;
        float z2 = 2.0f * this.Z;
        float xy = x2 * this.Y;
        float xz = x2 * this.Z;
        float yy = y2 * this.Y;
        float yw = y2 * this.W;
        float zw = z2 * this.W;
        float zz = z2 * this.Z;
        mf[0] = 1.0f - (yy + zz);
        mf[1] = xy - zw;
        mf[2] = xz + yw;
        mf[3] = 0.0f;
        float xx = x2 * this.X;
        float xw = x2 * this.W;
        float yz = y2 * this.Z;
        mf[4] = xy + zw;
        mf[5] = 1.0f - (xx + zz);
        mf[6] = yz - xw;
        mf[7] = 0.0f;
        mf[8] = xz - yw;
        mf[9] = yz + xw;
        mf[10] = 1.0f - (xx + yy);
        mf[11] = 0.0f;
        mf[12] = 0.0f;
        mf[13] = 0.0f;
        mf[14] = 0.0f;
        mf[15] = 1.0f;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[x=");
        buffer.append(this.X);
        buffer.append(", y=");
        buffer.append(this.Y);
        buffer.append(", z=");
        buffer.append(this.Z);
        buffer.append(", w=");
        buffer.append(this.W);
        buffer.append(']');
        return buffer.toString();
    }
}

