/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.lq3d.lq_particle_system;

import com.lemonquest.lq3d.lq_particle_system.LQPSEventHandler;
import com.lemonquest.lq3d.lq_particle_system.LQParticle;
import com.lemonquest.lq3d.lq_particle_system.LQSpaceWrap;

public class LQTractionWrap
implements LQSpaceWrap {
    float[] tractionPos = new float[]{0.0f, 0.0f, 0.0f};
    LQPSEventHandler m_eventHandler;
    float[] params = new float[3];
    public static final short Param_TractionStrength = 0;
    public static final short Param_StartLife = 1;
    public static final short Param_VelChangeSpeed = 2;
    public static final int MaxParam = 3;

    public LQTractionWrap() {
        this.params[0] = 49152.0f;
        this.params[1] = 1.0f;
        this.params[2] = 0.1f;
    }

    public void setPSEventHandler(LQPSEventHandler eventHandler) {
        this.m_eventHandler = eventHandler;
    }

    public void UpdateAcc(LQParticle p) {
    }

    public void UpdateVel(LQParticle p) {
        float[] psTranslation = p.getPS().getTransform();
        float[] ppos = p.getPos();
        float[] vel = p.getVel();
        float[] destVel = new float[3];
        float dx = this.tractionPos[0] - psTranslation[0] - ppos[0];
        float dy = this.tractionPos[1] - psTranslation[1] - ppos[1];
        float dz = this.tractionPos[2] - psTranslation[2] - ppos[2];
        float dis = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
        float speed = (float)Math.sqrt(vel[0] * vel[0] + vel[1] * vel[1] + vel[2] * vel[2]);
        if (dis < p.getSize() + speed) {
            p.setLife(0.0f);
            if (this.m_eventHandler != null) {
                this.m_eventHandler.onReachedWrapPoint(p);
            }
            return;
        }
        float distance_factor = this.params[0] / (dis * dis);
        destVel[0] = dx * distance_factor;
        destVel[1] = dy * distance_factor;
        destVel[2] = dz * distance_factor;
        for (int i = 0; i < 3; ++i) {
            vel[i] = vel[i] + (destVel[i] - vel[i]) * this.params[2];
        }
    }

    public void UpdatePos(LQParticle p) {
    }

    public float[] getTractionPoint() {
        return this.tractionPos;
    }

    public void setTractionPoint(float[] pos) {
        this.tractionPos[0] = pos[0];
        this.tractionPos[1] = pos[1];
        this.tractionPos[2] = pos[2];
    }

    public void setParam(short paramType, float value) {
        this.params[paramType] = value;
    }

    public float[] getParam() {
        return this.params;
    }

    public void setParams(float[] params) {
        for (int i = 0; i < params.length; ++i) {
            this.setParam((short)i, params[i]);
        }
    }
}

