/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.lq3d.renderlist;

import com.lemonquest.lq3d.LQAppearance;
import com.lemonquest.lq3d.LQFactory;
import com.lemonquest.lq3d.LQGraphics3D;
import com.lemonquest.lq3d.LQPrimitive;
import com.lemonquest.lq3d.LQTransform;
import com.lemonquest.lq3d.renderlist.LQObjClipper;
import com.lemonquest.lq3d.renderlist.LQRenderNode;

public class LQRenderList {
    private int appearanceNum;
    private LQObjClipper clipper;
    private LQAppearance[] appearanceList;
    private LQPrimitive[] primitives;
    private int[] primitiveVertIndex;
    private LQRenderNode meshListFrontNode;
    private LQRenderNode meshListBackNode;
    protected LQRenderNode[] nodes;

    public LQRenderList(LQAppearance[] appearances, int[] maxVertNum, LQRenderNode[] nodeList) {
        this.appearanceList = appearances;
        this.nodes = nodeList;
        this.appearanceNum = appearances.length;
        this.primitives = new LQPrimitive[this.appearanceNum];
        this.primitiveVertIndex = new int[this.appearanceNum];
        for (int i = 0; i < this.appearanceNum; ++i) {
            this.primitives[i] = LQFactory.LQPrimitive(0, this.appearanceList[i], maxVertNum[i]);
        }
    }

    public void setClipper(LQObjClipper clipper) {
        this.clipper = clipper;
    }

    public void setNodeList(LQRenderNode[] nodeList) {
        this.nodes = nodeList;
    }

    public void pushBackRenderList(LQRenderNode node) {
        if (this.meshListBackNode == null) {
            this.meshListFrontNode = this.meshListBackNode = node;
        } else {
            this.meshListBackNode.nextNode = node;
            node.prevNode = this.meshListBackNode;
            node.nextNode = null;
            this.meshListBackNode = node;
        }
    }

    public void pushFrontRenderList(LQRenderNode node) {
        if (this.meshListFrontNode == null) {
            this.meshListFrontNode = this.meshListBackNode = node;
        } else {
            this.meshListFrontNode.prevNode = node;
            node.nextNode = this.meshListFrontNode;
            node.prevNode = null;
            this.meshListFrontNode = node;
        }
    }

    private void clearRenderList() {
        this.meshListFrontNode = null;
        this.meshListBackNode = null;
    }

    public void update() {
        int i;
        this.clearRenderList();
        if (this.clipper != null) {
            this.clipper.update(this, this.nodes);
        } else {
            for (i = 0; i < this.nodes.length; ++i) {
                this.pushBackRenderList(this.nodes[i]);
            }
        }
        for (i = 0; i < this.primitiveVertIndex.length; ++i) {
            this.primitiveVertIndex[i] = 0;
        }
        LQRenderNode pNode = this.meshListFrontNode;
        LQRenderNode oldNode = null;
        short[] vertices = null;
        int appID = 0;
        while (pNode != null) {
            vertices = pNode.getVertex();
            appID = pNode.getAppearanceID();
            this.primitives[appID].fastUpdateVert(this.primitiveVertIndex[appID], vertices);
            this.primitives[appID].fastUpdateTexels(this.primitiveVertIndex[appID], pNode.getTexels());
            this.primitives[appID].fastUpdateColors(this.primitiveVertIndex[appID], pNode.getColor());
            int n = appID;
            this.primitiveVertIndex[n] = this.primitiveVertIndex[n] + vertices.length / 3;
            oldNode = pNode;
            pNode = pNode.nextNode;
            oldNode.nextNode = null;
        }
        for (int i2 = 0; i2 < this.primitives.length; ++i2) {
            int vertNum = this.primitives[i2].getTotalVertNum() - this.primitiveVertIndex[i2];
            short[] resetV = new short[vertNum * 3];
            this.primitives[i2].fastUpdateVert(this.primitiveVertIndex[i2], resetV);
        }
    }

    public void draw(LQGraphics3D g3d, LQTransform trans) {
        if (this.meshListFrontNode == null) {
            return;
        }
        for (int i = 0; i < this.primitives.length; ++i) {
            if (i != 0 || this.primitiveVertIndex[i] <= 0) continue;
            g3d.render(this.primitives[i], trans);
            g3d.flush();
        }
    }
}

