/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.lq3d.renderlist;

import com.lemonquest.lq3d.renderlist.LQMeshBuffer;

public class LQRenderNode {
    private boolean bufferEnabled = false;
    private LQMeshBuffer meshBuffer;
    private byte appearanceID;
    private short[] verticesBuf;
    private short[] texelsBuf;
    private byte[] colorsBuf;
    private int transX;
    private int transY;
    private int transZ;
    public LQRenderNode prevNode;
    public LQRenderNode nextNode;

    public LQRenderNode(LQMeshBuffer meshBuf, byte appID) {
        this.meshBuffer = meshBuf;
        this.appearanceID = appID;
    }

    public void createDataBuffer(int x, int y, int z) {
        this.translate(x, y, z);
        this.verticesBuf = this.getVertex();
        this.texelsBuf = this.getTexels();
        this.colorsBuf = this.getColor();
        this.meshBuffer.release();
        this.meshBuffer = null;
        this.bufferEnabled = true;
    }

    public void translate(int x, int y, int z) {
        this.transX = x;
        this.transY = y;
        this.transZ = z;
    }

    public int getAppearanceID() {
        return this.appearanceID;
    }

    public short[] getVertex() {
        if (this.bufferEnabled) {
            return this.verticesBuf;
        }
        return this.meshBuffer.getVertex(this.transX, this.transY, this.transZ);
    }

    public short[] getTexels() {
        if (this.bufferEnabled) {
            return this.texelsBuf;
        }
        return this.meshBuffer.getTexels();
    }

    public byte[] getColor() {
        if (this.bufferEnabled) {
            return this.colorsBuf;
        }
        return this.meshBuffer.getColor();
    }

    public void updateTexels(short[] texels) {
        this.texelsBuf = null;
        this.texelsBuf = texels;
    }
}

