/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.lq3d_mcv3;

import com.lemonquest.lq3d.LQCamera;
import com.lemonquest.lq3d.LQConfig;
import com.lemonquest.lq3d.LQGraphics3D;
import com.lemonquest.lq3d.LQMesh;
import com.lemonquest.lq3d.LQPrimitive;
import com.lemonquest.lq3d.LQTransform;
import com.lemonquest.lq3d_mcv3.LQAppearance_mcv3;
import com.lemonquest.lq3d_mcv3.LQPrimitive_mcv3;
import com.lemonquest.lq3d_mcv3.LQTransform_mcv3;
import com.mascotcapsule.micro3d.v3.AffineTrans;
import com.mascotcapsule.micro3d.v3.Figure;
import com.mascotcapsule.micro3d.v3.FigureLayout;
import com.mascotcapsule.micro3d.v3.Graphics3D;
import com.mascotcapsule.micro3d.v3.Texture;
import javax.microedition.lcdui.Graphics;

public class LQGraphics3D_mcv3
extends LQGraphics3D {
    protected Graphics3D m_g3d = new Graphics3D();
    protected Graphics m_g;
    protected LQCamera m_camera;
    protected AffineTrans m_transBuffer = new AffineTrans();

    public void bindTarget(Object target) {
        this.m_g = (Graphics)target;
        this.m_g.setClip(0, 0, LQConfig.ScreenWidth, 500);
        this.m_g3d.bind(this.m_g);
        renderedVertNum = 0;
    }

    public void clear() {
    }

    public void flush() {
        this.m_g3d.flush();
    }

    public void releaseTarget() {
        this.m_g3d.release(this.m_g);
    }

    public void render(LQMesh mesh, LQTransform transform) {
        FigureLayout camLayout = (FigureLayout)this.m_camera.data();
        AffineTrans camTrans = camLayout.getAffineTrans();
        this.fixCamera(transform, camTrans, camLayout);
        this.m_g3d.renderFigure((Figure)mesh.data(), 0, 0, camLayout, ((LQAppearance_mcv3)mesh.getAppearance()).getEffect3D());
        camLayout.setAffineTrans(camTrans);
    }

    void fixCamera(LQTransform transform, AffineTrans view, FigureLayout camLayout) {
        AffineTrans tmp = new AffineTrans();
        tmp.setIdentity();
        if (transform != null) {
            tmp.mul((AffineTrans)transform.data());
        }
        LQTransform_mcv3.scale(tmp, 10.0f, 10.0f, 10.0f);
        this.m_transBuffer.mul(view, tmp);
        camLayout.setAffineTrans(this.m_transBuffer);
    }

    public void render(LQPrimitive primitive, LQTransform transform) {
        FigureLayout camLayout = (FigureLayout)this.m_camera.data();
        AffineTrans camTrans = camLayout.getAffineTrans();
        LQPrimitive_mcv3.MeshData arr = (LQPrimitive_mcv3.MeshData)primitive.data();
        this.fixCamera(transform, camTrans, camLayout);
        int command = ((LQPrimitive_mcv3)primitive).getCommand();
        if (arr.numTriangles > 255) {
            int ver_start = 0;
            int tex_start = 0;
            int col_start = 0;
            for (int i = 0; i <= arr.numTriangles; i += 255) {
                int index = i;
                int numPrims = 255;
                if (index + numPrims > arr.numTriangles) {
                    numPrims = arr.numTriangles - index;
                }
                int ver_len = numPrims * 3 * 3;
                int tex_len = numPrims * 3 * 2;
                int col_len = numPrims;
                int[] v = new int[ver_len];
                int[] n = new int[ver_len];
                for (int j = 0; j < v.length; ++j) {
                    v[j] = arr.vertices[ver_start + j];
                }
                int[] t = new int[tex_len];
                for (int j = 0; j < t.length; ++j) {
                    t[j] = arr.texels[tex_start + j];
                }
                int[] c = new int[col_len];
                for (int j = 0; j < c.length; ++j) {
                    c[j] = arr.colors[col_start + j];
                }
                this.m_g3d.renderPrimitives((Texture)primitive.getAppearance().getTexture().data(), 0, 0, camLayout, ((LQAppearance_mcv3)primitive.getAppearance()).getEffect3D(), command, numPrims, v, n, t, c);
                ver_start += ver_len;
                tex_start += tex_len;
                col_start += col_len;
            }
        } else {
            this.m_g3d.renderPrimitives((Texture)primitive.getAppearance().getTexture().data(), 0, 0, camLayout, ((LQAppearance_mcv3)primitive.getAppearance()).getEffect3D(), command, arr.numTriangles, arr.vertices, arr.normals, arr.texels, arr.colors);
        }
        camLayout.setAffineTrans(camTrans);
        renderedVertNum += primitive.getTotalVertNum();
    }

    public void render(LQMesh mesh, int pixelBlendingMode, LQTransform transform) {
        int oldPixelBlendingMode = mesh.getAppearance().getPixelBlending();
        mesh.getAppearance().setPixelBlending(pixelBlendingMode);
        this.render(mesh, transform);
        mesh.getAppearance().setPixelBlending(oldPixelBlendingMode);
    }

    public void render(LQPrimitive primitive, int pixelBlendingMode, LQTransform transform) {
        int oldPixelBlendingMode = primitive.getAppearance().getPixelBlending();
        primitive.getAppearance().setPixelBlending(pixelBlendingMode);
        this.render(primitive, transform);
        primitive.getAppearance().setPixelBlending(oldPixelBlendingMode);
        renderedVertNum += primitive.getTotalVertNum();
    }

    public void setCamera(LQCamera camera) {
        this.m_camera = camera;
    }

    public LQCamera getCamera() {
        return this.m_camera;
    }

    public Object data() {
        return this.m_g3d;
    }
}

