/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.lq3d_mcv3;

import com.lemonquest.lq3d.LQTransform;
import com.lemonquest.math.LQMath;
import com.mascotcapsule.micro3d.v3.AffineTrans;
import com.mascotcapsule.micro3d.v3.Vector3D;

public class LQTransform_mcv3
implements LQTransform {
    private AffineTrans trans = null;

    public LQTransform_mcv3() {
        this.trans = new AffineTrans();
        this.trans.setIdentity();
    }

    public LQTransform_mcv3(LQTransform copy) {
        this.trans = new AffineTrans(((LQTransform_mcv3)copy).trans);
    }

    public LQTransform_mcv3(AffineTrans trans) {
        this.trans = new AffineTrans();
        this.trans.set(trans);
    }

    public Object data() {
        return this.trans;
    }

    public void identity() {
        this.trans.set(4096, 0, 0, 0, 0, 4096, 0, 0, 0, 0, 4096, 0);
    }

    public void mul(LQTransform t) {
        this.trans.mul(((LQTransform_mcv3)t).trans);
    }

    public void mul(LQTransform t1, LQTransform t2) {
        this.trans.setIdentity();
        this.trans.mul((AffineTrans)t1.data(), (AffineTrans)t2.data());
    }

    public void transform(float[] quaternion) {
        Vector3D v = new Vector3D(LQMath.round(quaternion[0] * 4096.0f), LQMath.round(quaternion[1] * 4096.0f), LQMath.round(quaternion[2] * 4096.0f));
        this.trans.transPoint(v);
        quaternion[0] = v.x >> 12;
        quaternion[1] = v.y >> 12;
        quaternion[2] = v.z >> 12;
    }

    public void rotateWorldX(float deg) {
        AffineTrans old = new AffineTrans(this.trans);
        this.trans.m23 = 0;
        this.trans.m13 = 0;
        this.trans.m03 = 0;
        this.trans.rotationX((int)(deg * 11.377778f + 0.5f));
        this.trans.mul(old);
    }

    public void rotateWorldY(float deg) {
        AffineTrans old = new AffineTrans(this.trans);
        this.trans.m23 = 0;
        this.trans.m13 = 0;
        this.trans.m03 = 0;
        this.trans.rotationY((int)(deg * 11.377778f + 0.5f));
        this.trans.mul(old);
    }

    public void rotateWorldZ(float deg) {
        AffineTrans old = new AffineTrans(this.trans);
        this.trans.m23 = 0;
        this.trans.m13 = 0;
        this.trans.m03 = 0;
        this.trans.rotationZ((int)(deg * 11.377778f + 0.5f));
        this.trans.mul(old);
    }

    public void rotateX(float deg) {
        deg = -deg;
        AffineTrans old = new AffineTrans(this.trans);
        this.trans.setIdentity();
        this.trans.rotationX((int)(deg * 11.377778f + 0.5f));
        old.mul(this.trans);
        this.trans.set(old);
    }

    public void rotateY(float deg) {
        AffineTrans old = new AffineTrans(this.trans);
        this.trans.setIdentity();
        this.trans.rotationY((int)(deg * 11.377778f + 0.5f));
        old.mul(this.trans);
        this.trans.set(old);
    }

    public void rotateZ(float deg) {
        AffineTrans old = new AffineTrans(this.trans);
        this.trans.setIdentity();
        this.trans.rotationZ((int)(deg * 11.377778f + 0.5f));
        old.mul(this.trans);
        this.trans.set(old);
    }

    public static void scale(AffineTrans t, float x, float y, float z) {
        int[] i_mat = new int[12];
        t.get(i_mat);
        i_mat[0] = (int)((float)i_mat[0] * x);
        i_mat[1] = (int)((float)i_mat[1] * x);
        i_mat[2] = (int)((float)i_mat[2] * x);
        i_mat[4] = (int)((float)i_mat[4] * y);
        i_mat[5] = (int)((float)i_mat[5] * y);
        i_mat[6] = (int)((float)i_mat[6] * y);
        i_mat[8] = (int)((float)i_mat[8] * z);
        i_mat[9] = (int)((float)i_mat[9] * z);
        i_mat[10] = (int)((float)i_mat[10] * z);
        t.set(i_mat);
    }

    public void scale(float x, float y, float z) {
        LQTransform_mcv3.scale(this.trans, x, y, z);
    }

    public float determinant() {
        return this.trans.m00 * (this.trans.m11 * this.trans.m22 - this.trans.m12 * this.trans.m21) + this.trans.m01 * (this.trans.m12 * this.trans.m20 - this.trans.m10 * this.trans.m22) + this.trans.m02 * (this.trans.m10 * this.trans.m21 - this.trans.m11 * this.trans.m20);
    }

    public void invert() {
        float det = this.determinant();
        if (Math.abs(det) <= 1.0E-6f) {
            return;
        }
        float oneOverDet = 1.0f / det;
        int[] i_mat = new int[12];
        i_mat[0] = (int)((float)(this.trans.m11 * this.trans.m22 - this.trans.m12 * this.trans.m21) * oneOverDet + 0.5f);
        i_mat[1] = (int)((float)(this.trans.m02 * this.trans.m21 - this.trans.m01 * this.trans.m22) * oneOverDet + 0.5f);
        i_mat[2] = (int)((float)(this.trans.m01 * this.trans.m12 - this.trans.m02 * this.trans.m11) * oneOverDet + 0.5f);
        i_mat[4] = (int)((float)(this.trans.m12 * this.trans.m20 - this.trans.m10 * this.trans.m22) * oneOverDet + 0.5f);
        i_mat[5] = (int)((float)(this.trans.m00 * this.trans.m22 - this.trans.m02 * this.trans.m20) * oneOverDet + 0.5f);
        i_mat[6] = (int)((float)(this.trans.m02 * this.trans.m10 - this.trans.m00 * this.trans.m12) * oneOverDet + 0.5f);
        i_mat[8] = (int)((float)(this.trans.m10 * this.trans.m21 - this.trans.m11 * this.trans.m20) * oneOverDet + 0.5f);
        i_mat[9] = (int)((float)(this.trans.m01 * this.trans.m20 - this.trans.m00 * this.trans.m21) * oneOverDet + 0.5f);
        i_mat[10] = (int)((float)(this.trans.m00 * this.trans.m11 - this.trans.m01 * this.trans.m10) * oneOverDet + 0.5f);
        i_mat[3] = -(this.trans.m03 * i_mat[0] + this.trans.m13 * i_mat[4] + this.trans.m23 * i_mat[8]);
        i_mat[7] = -(this.trans.m03 * i_mat[1] + this.trans.m13 * i_mat[5] + this.trans.m23 * i_mat[9]);
        i_mat[11] = -(this.trans.m03 * i_mat[2] + this.trans.m13 * i_mat[6] + this.trans.m23 * i_mat[10]);
        this.trans.set(i_mat);
    }

    public void set(float[] matrix) {
        int[] i_mat = new int[]{(int)(matrix[0] * 4096.0f + 0.5f), (int)(matrix[1] * 4096.0f + 0.5f), (int)(matrix[2] * 4096.0f + 0.5f), (int)(matrix[3] * 10.0f + 0.5f), (int)(matrix[4] * 4096.0f + 0.5f), (int)(matrix[5] * 4096.0f + 0.5f), (int)(matrix[6] * 4096.0f + 0.5f), (int)(matrix[7] * 10.0f + 0.5f), (int)(matrix[8] * 4096.0f + 0.5f), (int)(matrix[9] * 4096.0f + 0.5f), (int)(matrix[10] * 4096.0f + 0.5f), (int)(matrix[11] * 10.0f + 0.5f)};
        this.trans.set(i_mat);
        i_mat = null;
    }

    public void set(LQTransform trans) {
        this.trans.set((AffineTrans)trans.data());
    }

    public void translateWorld(float dx, float dy, float dz) {
        this.trans.m03 += (int)(dx * 10.0f + 0.5f);
        this.trans.m13 += (int)(dy * 10.0f + 0.5f);
        this.trans.m23 += (int)(dz * 10.0f + 0.5f);
    }

    public void translate(float dx, float dy, float dz) {
        AffineTrans old = new AffineTrans(this.trans);
        this.trans.setIdentity();
        this.trans.m03 += (int)(dx * 10.0f + 0.5f);
        this.trans.m13 += (int)(dy * 10.0f + 0.5f);
        this.trans.m23 += (int)(dz * 10.0f + 0.5f);
        old.mul(this.trans);
        this.trans.set(old);
    }

    public void get(float[] matrix) {
        int[] tmp = new int[12];
        this.trans.get(tmp);
        matrix[0] = (float)tmp[0] / 4096.0f;
        matrix[1] = (float)tmp[1] / 4096.0f;
        matrix[2] = (float)tmp[2] / 4096.0f;
        matrix[3] = (float)tmp[3] / 10.0f;
        matrix[4] = (float)tmp[4] / 4096.0f;
        matrix[5] = (float)tmp[5] / 4096.0f;
        matrix[6] = (float)tmp[6] / 4096.0f;
        matrix[7] = (float)tmp[7] / 10.0f;
        matrix[8] = (float)tmp[8] / 4096.0f;
        matrix[9] = (float)tmp[9] / 4096.0f;
        matrix[10] = (float)tmp[10] / 4096.0f;
        matrix[11] = (float)tmp[11] / 10.0f;
        matrix[14] = 0.0f;
        matrix[13] = 0.0f;
        matrix[12] = 0.0f;
        matrix[15] = 1.0f;
        tmp = null;
    }

    public String toString() {
        float[] matrix = new float[16];
        this.get(matrix);
        return matrix[0] + " " + matrix[1] + " " + matrix[2] + " " + matrix[3] + "\n" + matrix[4] + " " + matrix[5] + " " + matrix[6] + " " + matrix[7] + "\n" + matrix[8] + " " + matrix[9] + " " + matrix[10] + " " + matrix[11] + "\n" + matrix[12] + " " + matrix[13] + " " + matrix[14] + " " + matrix[15];
    }

    public void translateToOrigin() {
        this.trans.m03 = 0;
        this.trans.m13 = 0;
        this.trans.m23 = 0;
    }
}

