/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.math;

import com.lemonquest.math.MathFP;

public class Vec2D {
    public int X;
    public int Y;

    public Vec2D() {
    }

    public Vec2D(int x, int y) {
        this.X = x;
        this.Y = y;
    }

    public Vec2D(Vec2D copy) {
        this.X = copy.X;
        this.Y = copy.Y;
    }

    public void set(int x, int y) {
        this.X = x;
        this.Y = y;
    }

    public void set(Vec2D copy) {
        this.X = copy.X;
        this.Y = copy.Y;
    }

    public boolean isZero() {
        return this.X == 0 && this.Y == 0;
    }

    public void add(Vec2D n) {
        this.X += n.X;
        this.Y += n.Y;
    }

    public void sub(Vec2D n) {
        this.X -= n.X;
        this.Y -= n.Y;
    }

    public void mul(int fpNumber) {
        this.X = MathFP.mul(this.X, fpNumber);
        this.Y = MathFP.mul(this.Y, fpNumber);
    }

    public void div(int fpNumber) {
        this.X = MathFP.div(this.X, fpNumber);
        this.Y = MathFP.div(this.Y, fpNumber);
    }

    public int crossProduct(Vec2D v) {
        return MathFP.mul(this.X, v.Y) - MathFP.mul(this.Y, v.X);
    }

    public int dotProduct(Vec2D n) {
        return MathFP.mul(this.X, n.X) + MathFP.mul(this.Y, n.Y);
    }

    public static int dotProduct(Vec2D n1, Vec2D n2) {
        return MathFP.mul(n1.X, n2.X) + MathFP.mul(n1.Y, n2.Y);
    }

    public int magnitude() {
        return MathFP.sqrt(MathFP.mul(this.X, this.X) + MathFP.mul(this.Y, this.Y));
    }

    public void getPerp2D_CCW() {
        int x = this.X;
        int y = this.Y;
        this.X = -y;
        this.Y = x;
    }

    public void getPerp2D_CW() {
        int y;
        int x = this.X;
        this.X = y = this.Y;
        this.Y = -x;
    }

    public void rotate2D(Vec2D v) {
        int x = this.X;
        int y = this.Y;
        this.X = MathFP.mul(x, v.X) + MathFP.mul(y, v.Y);
        this.Y = MathFP.mul(v.X, y) - MathFP.mul(x, v.Y);
    }

    public void rotate2D(int d) {
        int x = MathFP.cos(MathFP.mul(MathFP.degree2radian, d));
        int y = MathFP.sin(MathFP.mul(MathFP.degree2radian, d));
        this.rotate2D(new Vec2D(x, y));
    }

    public void rotate2Dfast(int degreeFP) {
        int x = MathFP.lookupCos(MathFP.toInt(degreeFP));
        int y = MathFP.lookupSin(MathFP.toInt(degreeFP));
        this.rotate2D(new Vec2D(x, y));
    }

    public void reverse() {
        this.X = -this.X;
        this.Y = -this.Y;
    }

    public int normalize() {
        int len = this.magnitude();
        if (len == 0) {
            return len;
        }
        this.X = MathFP.div(this.X, len);
        this.Y = MathFP.div(this.Y, len);
        return len;
    }

    public int[] get() {
        int[] ret = new int[3];
        ret[0] = this.X;
        ret[1] = this.Y;
        return ret;
    }

    public String toString() {
        return "[" + MathFP.toString(this.X) + ", " + MathFP.toString(this.Y) + "]";
    }
}

