/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.util;

import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class LQGfx {
    private Image bufImg;
    private final int frequency;

    public LQGfx(String imgFile) {
        this.frequency = 3;
        try {
            this.bufImg = Image.createImage((String)imgFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public LQGfx(Image img, int sx, int sy, int w, int h) {
        this.frequency = 3;
        try {
            this.bufImg = img;
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public LQGfx(int w, int h) {
        this.frequency = 3;
        this.bufImg = Image.createImage((int)w, (int)h);
    }

    public int getWidth() {
        return this.bufImg.getWidth();
    }

    public int getHeight() {
        return this.bufImg.getHeight();
    }

    private void getRGB(int[] rgb, Image img, int offset, int scanLen, int x, int y, int w, int h) {
    }

    public void draw(Graphics g, int x, int y, int sx, int sy, int w, int h, int align, int alpha) {
        LQGfx.drawImage(g, this.bufImg, x, y, sx, sy, w, h, align);
    }

    public void draw(Graphics g, int x, int y, int align) {
        LQGfx.drawImage(g, this.bufImg, x, y, 0, 0, this.bufImg.getWidth(), this.bufImg.getHeight(), align);
    }

    public void draw(Graphics g, int x, int y, int sx, int sy, int w, int h, int align) {
        LQGfx.drawImage(g, this.bufImg, x, y, sx, sy, w, h, align);
    }

    public void setAlpha(int alpha) {
    }

    private void blend(int[] raw, int alphaValue) {
    }

    private void blend(int[] raw, int alphaValue, int maskColor, int dontmaskColor) {
    }

    public void initFade(int time) {
    }

    public void initFade(int time, int alphaMin, int alphaMax) {
    }

    public boolean fadeIn() {
        return true;
    }

    public boolean fadeOut() {
        return true;
    }

    public boolean fadeInOut() {
        return true;
    }

    public static final void drawEdgeString(Graphics g, int edgecolor, int strcolor, int x, int y, String info, int align) {
        g.setColor(edgecolor);
        g.drawString(info, x + 1, y, align);
        g.drawString(info, x, y + 1, align);
        g.drawString(info, x, y - 1, align);
        g.drawString(info, x - 1, y, align);
        g.setColor(strcolor);
        g.drawString(info, x, y, align);
    }

    public static final void drawImage(Graphics g, Image img, int x, int y, int sx, int sy, int w, int h, int align) {
        if (align == 0) {
            g.setClip(x, y, w, h);
            g.drawImage(img, x - sx, y - sy, align);
        } else {
            int tmp;
            w = w > img.getWidth() ? img.getWidth() : w;
            h = h > img.getHeight() ? img.getHeight() : h;
            int cx = x;
            int cy = y;
            int cw = w;
            int ch = h;
            int dx = x - sx;
            int dy = y - sy;
            if (sx > 0) {
                tmp = img.getWidth() - sx;
                int n = cw = tmp > w ? w : tmp;
            }
            if (sy > 0) {
                tmp = img.getHeight() - sy;
                int n = ch = tmp > h ? h : tmp;
            }
            if ((align & 8) != 0) {
                cx -= cw;
                dx += img.getWidth() - cw;
            } else if ((align & 1) != 0) {
                cx -= cw >> 1;
                dx += (img.getWidth() >> 1) - (cw >> 1);
            }
            if ((align & 0x20) != 0) {
                cy -= ch;
                dy += img.getHeight() - ch;
            } else if ((align & 2) != 0) {
                cy -= ch >> 1;
                dy += (img.getHeight() >> 1) - (ch >> 1);
            }
            g.setClip(cx, cy, cw, ch);
            g.drawImage(img, dx, dy, align);
        }
        g.setClip(0, 0, 600, 600);
    }

    public static Image readPltImage(DataInputStream pngDis, DataInputStream cptDis) {
        try {
            byte[] actData = null;
            int actLength = 0;
            int actIndex = 0;
            int pngLength = 0;
            pngLength = cptDis.readInt();
            actIndex = cptDis.readInt();
            actLength = cptDis.readInt();
            actData = new byte[actLength];
            cptDis.read(actData);
            byte[] pngData = null;
            pngData = new byte[pngLength];
            pngDis.read(pngData);
            for (int i = actIndex; i < actIndex + actLength; ++i) {
                pngData[i] = actData[i - actIndex];
            }
            return Image.createImage((byte[])pngData, (int)0, (int)pngLength);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static final Image CreateAlphaImage(int Alphalike, Image src) {
        int w = src.getWidth();
        int h = src.getHeight();
        int len = w * h;
        int[] srcRgb = new int[len];
        int[] dscRgb = new int[len];
        try {
            src.getRGB(srcRgb, 0, w, 0, 0, w, h);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (int i = 0; i < len; ++i) {
            dscRgb[i] = srcRgb[i] + Alphalike;
        }
        Image result = Image.createRGBImage((int[])dscRgb, (int)w, (int)h, (boolean)true);
        return result;
    }

    private static float maximum(float[] val) {
        if (val[0] >= val[1] && val[0] >= val[2]) {
            return val[0];
        }
        if (val[1] >= val[0] && val[1] >= val[2]) {
            return val[1];
        }
        return val[2];
    }

    private static float minimum(float[] val) {
        if (val[0] <= val[1] && val[0] <= val[2]) {
            return val[0];
        }
        if (val[1] <= val[0] && val[1] <= val[2]) {
            return val[1];
        }
        return val[2];
    }

    public static float[] RGBtoHSV(float[] rgb) {
        float[] hsv = new float[3];
        float max = LQGfx.maximum(rgb);
        float min = LQGfx.minimum(rgb);
        hsv[2] = max;
        hsv[1] = max == 0.0f ? 0.0f : (max - min) / max;
        if (hsv[1] == 0.0f) {
            hsv[0] = -1.0f;
        } else {
            float delta = max - min;
            if (rgb[0] == max) {
                hsv[0] = (rgb[1] - rgb[2]) / delta;
            } else if (rgb[1] == max) {
                hsv[0] = (float)(2.0 + (double)((rgb[2] - rgb[0]) / delta));
            } else if (rgb[2] == max) {
                hsv[0] = (float)(4.0 + (double)((rgb[0] - rgb[1]) / delta));
            }
            hsv[0] = (float)((double)hsv[0] * 60.0);
            if (hsv[0] < 0.0f) {
                hsv[0] = (float)((double)hsv[0] + 360.0);
            }
        }
        return hsv;
    }

    public static float[] HSVtoRGB(float[] hsv) {
        float[] rgb = new float[3];
        if ((double)hsv[1] == 0.0) {
            if ((double)hsv[0] == -1.0) {
                rgb[0] = hsv[2];
                rgb[1] = hsv[2];
                rgb[2] = hsv[2];
            } else {
                System.out.println("invalid HSV values are: (" + hsv[0] + "," + hsv[1] + "," + hsv[2] + ")");
            }
        } else {
            if ((double)hsv[0] == 360.0) {
                hsv[0] = 0.0f;
            }
            hsv[0] = (float)((double)hsv[0] / 60.0);
            int i = (int)Math.floor(hsv[0]);
            float f = hsv[0] - (float)i;
            float p = (float)((double)hsv[2] * (1.0 - (double)hsv[1]));
            float q = (float)((double)hsv[2] * (1.0 - (double)(hsv[1] * f)));
            float t = (float)((double)hsv[2] * (1.0 - (double)hsv[1] * (1.0 - (double)f)));
            switch (i) {
                case 0: {
                    rgb[0] = hsv[2];
                    rgb[1] = t;
                    rgb[2] = p;
                    break;
                }
                case 1: {
                    rgb[0] = q;
                    rgb[1] = hsv[2];
                    rgb[2] = p;
                    break;
                }
                case 2: {
                    rgb[0] = p;
                    rgb[1] = hsv[2];
                    rgb[2] = t;
                    break;
                }
                case 3: {
                    rgb[0] = p;
                    rgb[1] = q;
                    rgb[2] = hsv[2];
                    break;
                }
                case 4: {
                    rgb[0] = t;
                    rgb[1] = p;
                    rgb[2] = hsv[2];
                    break;
                }
                case 5: {
                    rgb[0] = hsv[2];
                    rgb[1] = p;
                    rgb[2] = q;
                }
            }
        }
        return rgb;
    }

    private static int[] zoom(int[] srcBuf, int srcW, int srcH, int desW, int desH) {
        int i;
        short[] tabY = new short[desH];
        short[] tabX = new short[desW];
        int sb = 0;
        int db = 0;
        int tems = 0;
        int temd = 0;
        int distance = srcH > desH ? srcH : desH;
        for (i = 0; i <= distance; ++i) {
            tabY[db] = (short)sb;
            temd += desH;
            if ((tems += srcH) > distance) {
                tems -= distance;
                ++sb;
            }
            if (temd <= distance) continue;
            temd -= distance;
            ++db;
        }
        sb = 0;
        db = 0;
        tems = 0;
        temd = 0;
        distance = srcW > desW ? srcW : desW;
        for (i = 0; i <= distance; ++i) {
            tabX[db] = (short)sb;
            temd += desW;
            if ((tems += srcW) > distance) {
                tems -= distance;
                ++sb;
            }
            if (temd <= distance) continue;
            temd -= distance;
            ++db;
        }
        int[] desBuf = new int[desW * desH];
        int dx = 0;
        int dy = 0;
        boolean sx = false;
        int sy = 0;
        short oldy = -1;
        for (int i2 = 0; i2 < desH; ++i2) {
            if (oldy == tabY[i2]) {
                System.arraycopy(desBuf, dy - desW, desBuf, dy, desW);
            } else {
                dx = 0;
                for (int j = 0; j < desW; ++j) {
                    desBuf[dy + dx] = srcBuf[sy + tabX[j]];
                    ++dx;
                }
                sy += (tabY[i2] - oldy) * srcW;
            }
            oldy = tabY[i2];
            dy += desW;
        }
        srcBuf = null;
        tabY = null;
        tabX = null;
        return desBuf;
    }
}

