/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.lemonquest.lq3d.LQFactory;
import com.lemonquest.lq3d.LQTransform;
import com.lemonquest.math.MathFP;
import com.lemonquest.math.Vec2D;
import com.lemonquest.physics_v2.DynamicObj;
import com.lemonquest.physics_v2.RaceWorld;
import com.lemonquest.physics_v2.ShapeLine;
import com.lemonquest.physics_v2.StaticObj;
import com.lemonquest.util.LQConsole;
import com.lemonquest.util.LQKey;
import game.Design;
import game.GameMain;
import game.LevelMap;
import game.Res;
import game.RiderInfo;
import java.util.Random;
import javax.microedition.lcdui.Graphics;

public class Bike {
    private Res res = Res.instance();
    public static final byte ModePlayer = 0;
    public static final byte ModeReplay = 1;
    public static final byte ModeAI = 2;
    public static final byte ModeWinShow = 3;
    public static final byte ModeCrash = 4;
    public static final byte ModeSmallGame = 5;
    private DynamicObj physicsObj;
    private GameMain game;
    private RiderInfo riderInfo;
    private boolean isGearLocked = false;
    private int gear;
    private int groundID;
    private int lastGroundID;
    private int angle;
    private byte mode = (byte)2;
    private boolean isDisabled = false;
    private int finishedGround = -1;
    private int currentLap;
    private int[] usedFrameNum;
    private boolean isFinished = false;
    private int[] crashPerLap;
    private int passNum;
    private int rankBonus;
    private int speedBonus;
    private int highSpeedTime;
    private int highSpeedThreshold;
    private int draftBonus;
    private int draftTime;
    private int draftThreshold;
    private int drawTurnAngle;
    private int rank;
    private int offsetFromDrivingDir;
    private int offsetFromGroundDir;
    private Vec2D crashPos = new Vec2D();
    private byte crashLastMode;
    private int crashGroundID;
    private int crashLastGroundID;
    private boolean crashIsInSand;
    private int crashTick;
    public static final int CrashTime = 30;
    private BikeCustom bikeCustom;
    public LQTransform bikeCrashRotTrans = LQFactory.LQTransform();
    public LQTransform humanCrashTrans = LQFactory.LQTransform();
    public LQTransform humanCrashRotTrans = LQFactory.LQTransform();
    private final byte ControlAcc;
    private final byte ControlBrake = (byte)2;
    private final byte ControlSteerLeft = (byte)4;
    private final byte ControlSteerRight = (byte)8;
    private final byte ControlLockGear = (byte)16;
    private final byte ControlGearUp = (byte)32;
    private final byte ControlGearDown = (byte)64;
    private byte control = 0;
    private byte lastControl = 0;
    private int controlNum = 0;
    private ReplayNode replayListHead;
    private ReplayNode replayListTail;
    Random rand = new Random();
    public boolean isInSand_debug = false;
    public int timeSand = 0;
    public int MAX_TIME_SAND = 300;
    private static Vec2D tmpGroundDir = new Vec2D();
    private int winShowDist = 0;
    private static Vec2D tmpDrivingPoint = new Vec2D();
    private static Vec2D tmpTurnDir = new Vec2D();
    private static Vec2D tmpDestDir = new Vec2D();
    private static Vec2D tmpSelf2other = new Vec2D();

    public Bike(GameMain game, DynamicObj phyObj) {
        this.ControlAcc = 1;
        this.game = game;
        this.physicsObj = phyObj;
        this.physicsObj.setBike(this);
        this.crashPerLap = new int[game.getLevelCustom().lapNum];
        this.findGroundID();
        this.usedFrameNum = new int[game.getLevelCustom().lapNum];
        this.updateDrawData();
    }

    public void resetToPos(Vec2D pos, Vec2D dir) {
        this.physicsObj.resetToPosition(pos, dir);
        this.findGroundID();
        this.updateDrawData();
        this.gear = 0;
    }

    public void lockGear(boolean isLock) {
        this.isGearLocked = isLock;
    }

    public void setRiderInfo(RiderInfo info) {
        this.riderInfo = info;
    }

    public void setPerformance(int acc, int speed, int handling, int brake) {
        int[] gear_ratios = new int[this.physicsObj.gearRatios.length];
        for (int i = 0; i < gear_ratios.length; ++i) {
            gear_ratios[i] = this.performParamInterp(Design.GearRatioMinLevels[i], Design.GearRatioMaxLevels[i], acc, 20);
        }
        int[] gear_speeds = new int[this.physicsObj.gearSpeeds.length];
        for (int i = 0; i < gear_speeds.length; ++i) {
            gear_speeds[i] = this.performParamInterp(Design.GearSpeedsMinLevels[i], Design.GearSpeedsMaxLevels[i], acc, 20);
        }
        this.physicsObj.setGearRatios(gear_ratios);
        this.physicsObj.setGearSpeeds(gear_speeds);
        this.highSpeedThreshold = gear_speeds[gear_speeds.length - 1] * 3 / 4;
        int enginePower = this.performParamInterp(Design.EnginePowerMinLevel, Design.EnginePowerMaxLevel, speed, 20);
        this.physicsObj.setEnginePower(enginePower);
        int turnSpeed = this.performParamInterp(Design.TurnSpeedMinLevel, Design.TurnSpeedMaxLevel, handling, 20);
        this.physicsObj.setTurnSpeed(turnSpeed);
        int turnRestoreSpeed = this.performParamInterp(Design.TurnRestoreSpeedMinLevel, Design.TurnRestoreSpeedMaxLevel, handling, 20);
        this.physicsObj.setTurnRestoreSpeed(turnRestoreSpeed);
        this.draftThreshold = this.physicsObj.getMaxTurnAngleFP() * 1 / 2;
        int brakeFactor = this.performParamInterp(Design.BrakeMinLevel, Design.BrakeMaxLevel, brake, 20);
        this.physicsObj.setBrakeResistFactor(brakeFactor);
    }

    private int performParamInterp(int minFP, int maxFP, int time, int totalTime) {
        return minFP + (maxFP - minFP) * time / totalTime;
    }

    public void setCrashPos(Vec2D pos) {
        this.crashPos.set(pos);
    }

    public BikeCustom getBikeCustom() {
        return this.bikeCustom;
    }

    public void setBikeCustom(BikeCustom bikeCustom) {
        this.bikeCustom = bikeCustom;
        if (this.game.getLevelCustom().weather != 0 || this.bikeCustom.tireType == 1) {
            // empty if block
        }
        switch (this.bikeCustom.tireHardness) {
            case 0: {
                for (int i = 0; i < this.physicsObj.gearSpeeds.length; ++i) {
                    this.physicsObj.gearSpeeds[i] = this.physicsObj.gearSpeeds[i] * 7 / 8;
                }
                this.physicsObj.setBrakeResistFactor(this.physicsObj.getBrakeResistFactor() * 9 / 8);
                this.physicsObj.setTurnSpeed(this.physicsObj.getTurnSpeedFP() * 11 / 10);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                for (int i = 0; i < this.physicsObj.gearSpeeds.length; ++i) {
                    this.physicsObj.gearSpeeds[i] = this.physicsObj.gearSpeeds[i] * 9 / 8;
                }
                this.physicsObj.setBrakeResistFactor(this.physicsObj.getBrakeResistFactor() * 7 / 8);
                this.physicsObj.setTurnSpeed(this.physicsObj.getTurnSpeedFP() * 9 / 10);
            }
        }
    }

    public boolean canCollideOtherBike() {
        return this.getMode() != 3 && this.getMode() != 4 && !this.isDisabled();
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public void disable() {
        this.isDisabled = true;
    }

    public RiderInfo getRiderInfo() {
        return this.riderInfo;
    }

    public DynamicObj getPhysicsObj() {
        return this.physicsObj;
    }

    public int getDrawTurnAngle() {
        if (this.mode == 4) {
            if (this.drawTurnAngle > 0) {
                return 85;
            }
            return -65;
        }
        return this.drawTurnAngle;
    }

    public int getTurnAngle() {
        return this.physicsObj.getTurnAngle();
    }

    public int getAngle() {
        return this.angle;
    }

    public int getVelX() {
        return this.physicsObj.getVelocity().X;
    }

    public int getVelY() {
        return this.physicsObj.getVelocity().Y;
    }

    public float getXf() {
        return this.physicsObj.getXf();
    }

    public float getYf() {
        return this.physicsObj.getYf();
    }

    public Vec2D getSmokePos() {
        Vec2D pos = new Vec2D(this.physicsObj.getDir());
        pos.mul(RaceWorld.CONST_5);
        pos.add(this.physicsObj.getCenter());
        return pos;
    }

    public Vec2D getSandPos() {
        Vec2D pos = new Vec2D(this.physicsObj.getDir());
        pos.mul(RaceWorld.CONST_2);
        pos.add(this.physicsObj.getCenter());
        return pos;
    }

    public int getZf() {
        int normZ = 3;
        int result = 0;
        if (this.isInSand() && this.getSpeedFP() > RaceWorld.CONST_2 && !this.game.getLevel().isPause()) {
            int a = this.rand.nextInt();
            if (a % 4 > 2) {
                if (this == this.game.getLevel().getPlayerBike()) {
                    GameMain.vibrate(100);
                }
                result = 3 + a % 2;
            } else {
                result = 3;
            }
        } else {
            result = 3;
        }
        if (this.getMode() == 4) {
            result += 3;
        }
        return result;
    }

    public int getDirX_FP() {
        return this.physicsObj.getDir().X;
    }

    public int getDirY_FP() {
        return this.physicsObj.getDir().Y;
    }

    public int getTurnDirX_FP() {
        return this.physicsObj.getTurnDir().X;
    }

    public int getTurnDirY_FP() {
        return this.physicsObj.getTurnDir().Y;
    }

    public int getGroundID() {
        return this.groundID;
    }

    public int getGear() {
        return this.gear;
    }

    public int getMaxSpeedFP() {
        return this.physicsObj.gearSpeeds[this.physicsObj.gearSpeeds.length - 1];
    }

    public int getMaxSpeedFPGear() {
        return this.physicsObj.gearSpeeds[this.physicsObj.getGear()];
    }

    public int getSpeedFP() {
        return this.physicsObj.getSpeedFP();
    }

    public boolean isBraking() {
        return this.physicsObj.isBraking();
    }

    public boolean isInSand() {
        boolean isNow = this.physicsObj.isInSand();
        if (isNow && !this.isInSand_debug) {
            this.timeSand = this.MAX_TIME_SAND;
        } else if (!isNow) {
            this.timeSand = 0;
        } else if (this.timeSand > 0) {
            --this.timeSand;
        }
        this.isInSand_debug = isNow;
        return this.timeSand != 0;
    }

    public ReplayNode getReplayList() {
        return this.replayListHead;
    }

    public void setReplayList(ReplayNode listHead) {
        this.replayListHead = listHead;
    }

    public void clearReplayList() {
        this.replayListHead = null;
        this.replayListTail = null;
    }

    public void enterGhostMode() {
        this.physicsObj.setGhost(true);
        this.setMode((byte)1);
        this.lockGear(true);
    }

    public boolean isGhost() {
        return this.physicsObj.isGhost();
    }

    public void setMode(byte newMode) {
        this.mode = newMode;
    }

    public byte getMode() {
        return this.mode;
    }

    public int getFinishedLaps() {
        return this.currentLap;
    }

    public int getFinishedGround() {
        return this.finishedGround;
    }

    public boolean hasFinishedRace() {
        return this.isFinished;
    }

    public void setFinished(boolean finished) {
        this.isFinished = finished;
    }

    public int getUsedTime(int lapNum) {
        return this.usedFrameNum[lapNum];
    }

    public int getTotalUsedTime() {
        int total = 0;
        for (int i = 0; i < this.usedFrameNum.length; ++i) {
            total += this.usedFrameNum[i];
        }
        return total;
    }

    public void setTotalUseTime(int a) {
        int i = 0;
        while (i < this.usedFrameNum.length) {
            int n = i++;
            this.usedFrameNum[n] = this.usedFrameNum[n] + a;
        }
    }

    public boolean isDirWrong() {
        return this.offsetFromDrivingDir < 0 && this.offsetFromGroundDir < 0;
    }

    public int getCrashTick() {
        return this.crashTick;
    }

    public int[] getCrashParLap() {
        return this.crashPerLap;
    }

    public int getPassNum() {
        return this.passNum;
    }

    public int getRankBonus() {
        return this.rankBonus;
    }

    public int getSpeedBonus() {
        return this.speedBonus;
    }

    public int getDraftBonus() {
        return this.draftBonus;
    }

    public void update(int frame) {
        this.updateGroundID();
        if (this.isInSand()) {
            // empty if block
        }
        if (this.mode == 2) {
            this.updateAI(frame);
        } else if (this.mode == 0) {
            if (this.isGearLocked) {
                this.updateKey_AutoAcc(frame);
            } else {
                this.updateKey_ManualAcc(frame);
            }
        } else if (this.mode == 4) {
            this.updateCrash(frame);
        } else if (this.mode == 1) {
            this.updateReplay(frame);
        } else if (this.mode == 3) {
            this.updateWinShow(frame);
        } else if (this.mode == 5) {
            this.updateSmallGame(frame);
        }
        if (!this.hasFinishedRace() && this.mode != 4) {
            if (this.finishedGround >= GameMain.levelMap.getGrounds().length) {
                this.finishedGround = 0;
                ++this.currentLap;
                if (this.currentLap >= this.game.getLevelCustom().lapNum) {
                    this.isFinished = true;
                }
            }
        }
        if (!this.hasFinishedRace()) {
            int n = this.currentLap;
            this.usedFrameNum[n] = this.usedFrameNum[n] + 1;
        } else {
            this.setMode((byte)3);
        }
        this.updateSpeedBonus();
        this.updateDraftBonus();
        this.updateDrawData();
    }

    private void updateDraftBonus() {
        if (this != this.game.getLevel().getPlayerBike()) {
            return;
        }
        if (Math.abs(this.physicsObj.getTurnAngleFP()) > this.draftThreshold) {
            if (this.draftTime == 0) {
                ++this.draftTime;
            } else {
                ++this.draftTime;
                if (this.draftTime == 30) {
                    ++this.draftBonus;
                } else if (this.draftTime == 50) {
                    this.draftTime = 0;
                    ++this.draftBonus;
                }
            }
        } else {
            this.draftTime = 0;
        }
    }

    private void updateSpeedBonus() {
        if (this != this.game.getLevel().getPlayerBike()) {
            return;
        }
        if (this.getSpeedFP() > this.highSpeedThreshold) {
            if (this.highSpeedTime == 0) {
                ++this.highSpeedTime;
            } else {
                ++this.highSpeedTime;
                if (this.highSpeedTime == 30) {
                    ++this.speedBonus;
                } else if (this.highSpeedTime == 50) {
                    this.highSpeedTime = 0;
                    ++this.speedBonus;
                }
            }
        } else {
            this.highSpeedTime = 0;
        }
    }

    private void updateDrawData() {
        this.angle = this.physicsObj.getAngle();
        int maxDestTurn = 50;
        if (this.getSpeedFP() < RaceWorld.CONST_10) {
            maxDestTurn = 20;
        } else if (this.getSpeedFP() < RaceWorld.CONST_20) {
            maxDestTurn = 35;
        }
        int destBikeTurnAngle = this.getTurnAngle() * 2;
        if (destBikeTurnAngle < -maxDestTurn) {
            destBikeTurnAngle = -maxDestTurn;
        }
        if (destBikeTurnAngle > maxDestTurn) {
            destBikeTurnAngle = maxDestTurn;
        }
        this.drawTurnAngle += destBikeTurnAngle - this.drawTurnAngle >> 2;
    }

    private void findGroundID() {
        float x = this.getXf();
        float y = this.getYf();
        LevelMap.Ground[] grounds = GameMain.levelMap.getGrounds();
        for (int i = 0; i < grounds.length; ++i) {
            float left = grounds[i].x - 160;
            float right = grounds[i].x + 160;
            float top = grounds[i].y + 160;
            float bottom = grounds[i].y - 160;
            if (!(x >= left) || !(x <= right) || !(y <= top) || !(y >= bottom)) continue;
            this.groundID = i;
            break;
        }
    }

    public void setRank(int newRank) {
        if (newRank < this.rank) {
            ++this.passNum;
        }
        if (this.rank != 0 && newRank == 0) {
            this.rankBonus += 2;
        }
        if (this.rank != 1 && newRank == 1 || this.rank != 2 && newRank == 2) {
            ++this.rankBonus;
        }
        this.rank = newRank;
    }

    public int getRank() {
        return this.rank;
    }

    public void updateGroundID() {
        this.lastGroundID = this.groundID;
        int x = (int)this.getXf();
        int y = (int)this.getYf();
        LevelMap.Ground[] grounds = GameMain.levelMap.getGrounds();
        int left = grounds[this.groundID].x - 160;
        int right = grounds[this.groundID].x + 160;
        int top = grounds[this.groundID].y + 160;
        int bottom = grounds[this.groundID].y - 160;
        if (x < left || x > right || y > top || y < bottom) {
            for (int i = this.groundID - 1; i <= this.groundID + 1; ++i) {
                int id = i;
                if (i < 0) {
                    id = i + grounds.length;
                }
                if (i > grounds.length - 1) {
                    id = i - grounds.length;
                }
                left = grounds[id].x - 160;
                right = grounds[id].x + 160;
                top = grounds[id].y + 160;
                bottom = grounds[id].y - 160;
                if (x < left || x > right || y > top || y < bottom) continue;
                this.groundID = id;
                break;
            }
        }
        if (!this.isFinished && this.mode != 4) {
            int dist = this.groundID - this.lastGroundID;
            if (Math.abs(dist) > 1) {
                dist = dist > 0 ? -1 : 1;
            }
            this.finishedGround += dist;
        }
        this.offsetFromDrivingDir = Vec2D.dotProduct(this.physicsObj.getTurnDir(), grounds[this.groundID].drivingDir);
        if (this == this.game.getLevel().getPlayerBike()) {
            int nextID = GameMain.levelMap.getNextGroundID(this.groundID);
            tmpGroundDir.set(grounds[nextID].x, grounds[nextID].y);
            tmpGroundDir.sub(new Vec2D(grounds[this.groundID].x, grounds[this.groundID].y));
            this.offsetFromGroundDir = Vec2D.dotProduct(this.physicsObj.getTurnDir(), tmpGroundDir);
        }
    }

    private void updateWinShow(int frame) {
        StaticObj staticObj;
        if (this.physicsObj.getSpeedFP() <= 0) {
            return;
        }
        this.lastControl = this.control;
        this.control = 0;
        LevelMap.Ground[] grounds = GameMain.levelMap.getGrounds();
        int g_id = this.groundID;
        if (this.winShowDist < 0 && (g_id = this.lastGroundID - 1) < 0) {
            g_id += grounds.length;
        }
        Vec2D drivingPoint = new Vec2D(grounds[g_id].drivingPointFP);
        Vec2D turnDir = new Vec2D(this.physicsObj.getTurnDir());
        int escapeBikeSteer = 0;
        int escapeEdgeSteer = 0;
        int drivePointSteer = 0;
        boolean decisionPriority = false;
        boolean needToTurn = false;
        this.control = (byte)(this.control & 0xFFFFFFFD);
        Vec2D destDir = new Vec2D(drivingPoint);
        int nextID = this.groundID + 1;
        if (nextID > grounds.length - 1) {
            nextID = 0;
        } else if (nextID < 0) {
            nextID = grounds.length - 1;
        }
        Vec2D nextDrivingPoint = new Vec2D(grounds[nextID].drivingPointFP);
        destDir.add(nextDrivingPoint);
        destDir.div(RaceWorld.CONST_2);
        destDir.sub(this.physicsObj.getCenter());
        drivePointSteer = turnDir.crossProduct(destDir);
        if (this.physicsObj.getSpeedFP() > RaceWorld.CONST_10 && this.offsetFromDrivingDir <= RaceWorld.CONST_0_8) {
            LQConsole.println("\u51cf\u901f\u8fc7\u5f2f");
            this.control = (byte)(this.control | 2);
        }
        if ((staticObj = this.game.getLevel().getPhyWorld().willCollideBallStaticObj(this.physicsObj)) != null) {
            int time = RaceWorld.nearestContact.time;
            if (time < RaceWorld.CONST_0_5) {
                LQConsole.println("\u51cf\u901f\u8eb2\u907f\u8fb9\u754c");
                this.control = (byte)(this.control | 2);
            }
            if (!staticObj.isEventOnly() || !this.isInSand()) {
                Vec2D normal = new Vec2D(RaceWorld.nearestContact.normal);
                escapeEdgeSteer = turnDir.crossProduct(normal);
                LQConsole.println("need to turn " + (escapeEdgeSteer > 0 ? "left" : "right"));
                decisionPriority = true;
                needToTurn = true;
            }
        }
        if (decisionPriority) {
            if (escapeEdgeSteer > 0 && escapeBikeSteer < 0 || escapeEdgeSteer < 0 && escapeBikeSteer > 0) {
                LQConsole.println("\u51cf\u901f\uff0c\u8eb2\u907f\u8fb9\u7f18\u548c\u5176\u5b83\u8f66\u8f86");
                this.control = (byte)(this.control | 2);
            } else {
                int steer = escapeBikeSteer != 0 ? escapeBikeSteer : escapeEdgeSteer;
                this.aiSteer(steer, 0);
            }
        } else {
            this.aiSteer(drivePointSteer, RaceWorld.CONST_5);
        }
        if ((this.control & 2) <= 0 && this.physicsObj.getSpeedFP() < RaceWorld.CONST_10) {
            this.control = (byte)(this.control | 1);
        }
        this.control = (byte)(this.control | 2);
        this.doControl(this.control);
    }

    private void updateSmallGame(int frame) {
        this.lastControl = this.control;
        this.control = (byte)(this.control & 0xFFFFFFEF);
        switch (this.game.getLevelCustom().typeOfRace) {
            case 6: {
                if (frame == 0) {
                    this.control = (byte)(this.control | 0x20);
                } else {
                    this.control = (byte)(this.control & 0xFFFFFFEF);
                    this.control = (byte)(this.control & 0xFFFFFFDF);
                }
                if (LQKey.IsKeyHold(2) || LQKey.IsKeyPressed(1) || this.physicsObj.getSpeedFP() > this.physicsObj.gearSpeeds[this.gear]) {
                    this.control = (byte)(this.control | 2);
                } else if ((this.control & 2) > 0) {
                    this.control = (byte)(this.control & 0xFFFFFFFD);
                }
                if (frame <= 60) {
                    if (!(this.game.destWheelieAngle < 50.0f)) break;
                    this.game.destWheelieAngle += 0.8333333f;
                    this.game.wheelieX += 0.16666667f;
                    this.game.wheelieZ += 0.13333334f;
                    break;
                }
                float changeSpeed = 0.3f;
                if (this.game.wheelieAngle > 70.0f) {
                    this.game.destWheelieAngle += this.game.destWheelieAngle * 0.1f;
                    break;
                }
                if (LQKey.IsKeyHold(0x100000)) {
                    this.game.destWheelieAngle += this.game.destWheelieAngle * changeSpeed;
                    break;
                }
                if (this.game.destWheelieAngle > 5.0f) {
                    this.game.destWheelieAngle -= this.game.destWheelieAngle * changeSpeed;
                    break;
                }
                this.game.destWheelieAngle = 0.0f;
                break;
            }
            case 8: {
                int timeStep = 12;
                if (frame == 0 || frame == timeStep * 1 || frame == timeStep * 2 || frame == timeStep * 3 || frame == timeStep * 4 || frame == timeStep * 5) {
                    this.control = (byte)(this.control | 0x20);
                } else {
                    this.control = (byte)(this.control & 0xFFFFFFEF);
                    this.control = (byte)(this.control & 0xFFFFFFDF);
                }
                if ((LQKey.IsKeyHold(0x100000) || LQKey.IsKeyPressed(2)) && frame > 60 || this.physicsObj.getSpeedFP() > this.physicsObj.gearSpeeds[this.gear]) {
                    this.control = (byte)(this.control | 2);
                    break;
                }
                if ((this.control & 2) <= 0) break;
                this.control = (byte)(this.control & 0xFFFFFFFD);
                break;
            }
            case 7: {
                if (frame == 0 || frame == Design.AccChangeGearTime[1] || frame == Design.AccChangeGearTime[2] || frame == Design.AccChangeGearTime[3] || frame == Design.AccChangeGearTime[4] || frame == Design.AccChangeGearTime[5]) {
                    this.control = (byte)(this.control | 0x20);
                    this.game.brakeHasHit = false;
                } else {
                    this.control = (byte)(this.control & 0xFFFFFFEF);
                    this.control = (byte)(this.control & 0xFFFFFFDF);
                }
                if (this.physicsObj.getSpeedFP() > this.physicsObj.gearSpeeds[this.gear]) {
                    this.control = (byte)(this.control | 2);
                } else if ((this.control & 2) > 0) {
                    this.control = (byte)(this.control & 0xFFFFFFFD);
                }
                if (this.game.brakeHasHit || this.gear >= 6 || !LQKey.IsKeyPressed(0x100000) && !LQKey.IsKeyPressed(1)) break;
                int perfectHitTime = Design.AccChangeGearTime[this.gear] - Design.AccPerfectOffset[this.gear];
                if (frame >= perfectHitTime - 1 && frame <= perfectHitTime + 1) {
                    this.game.earnedPoints += 2;
                } else if (frame >= perfectHitTime - 1 - 2 && frame <= perfectHitTime + 1 + 2) {
                    ++this.game.earnedPoints;
                }
                this.game.brakeHasHit = true;
            }
        }
        this.doControl(this.control);
    }

    private void updateAI(int frame) {
        StaticObj staticObj;
        this.lastControl = this.control;
        this.control = 0;
        LevelMap.Ground[] grounds = GameMain.levelMap.getGrounds();
        tmpDrivingPoint.set(grounds[this.groundID].drivingPointFP);
        tmpTurnDir.set(this.physicsObj.getTurnDir());
        int escapeBikeSteer = 0;
        int escapeEdgeSteer = 0;
        int drivePointSteer = 0;
        boolean decisionPriority = false;
        boolean needToTurn = false;
        this.control = (byte)(this.control & 0xFFFFFFFD);
        tmpDestDir.set(tmpDrivingPoint);
        int nextID = this.groundID + 1;
        if (nextID > grounds.length - 1) {
            nextID = 0;
        } else if (nextID < 0) {
            nextID = grounds.length - 1;
        }
        tmpDestDir.add(grounds[nextID].drivingPointFP);
        tmpDestDir.div(RaceWorld.CONST_2);
        tmpDestDir.sub(this.physicsObj.getCenter());
        drivePointSteer = tmpTurnDir.crossProduct(tmpDestDir);
        DynamicObj otherBikeObj = this.game.getLevel().getPhyWorld().willCollideBallBall(this.physicsObj);
        if (otherBikeObj != null) {
            tmpSelf2other.set(otherBikeObj.getCenter());
            tmpSelf2other.sub(this.physicsObj.getCenter());
            escapeBikeSteer = tmpTurnDir.crossProduct(tmpSelf2other);
            decisionPriority = true;
            needToTurn = true;
        }
        if (this.physicsObj.getSpeedFP() > RaceWorld.CONST_10 && this.offsetFromDrivingDir <= RaceWorld.CONST_0_8) {
            LQConsole.println("\u51cf\u901f\u8fc7\u5f2f");
            this.control = (byte)(this.control | 2);
        }
        if ((staticObj = null) != null) {
            int time = RaceWorld.nearestContact.time;
            if (this.physicsObj.getSpeedFP() > RaceWorld.CONST_3 && time < RaceWorld.CONST_0_5) {
                LQConsole.println("\u51cf\u901f\u8eb2\u907f\u8fb9\u754c");
                this.control = (byte)(this.control | 2);
            }
            if (!staticObj.isEventOnly() || !this.isInSand()) {
                escapeEdgeSteer = tmpTurnDir.crossProduct(RaceWorld.nearestContact.normal);
                LQConsole.println("need to turn " + (escapeEdgeSteer > 0 ? "left" : "right"));
                decisionPriority = true;
                needToTurn = true;
            }
        }
        if (decisionPriority) {
            if (escapeEdgeSteer > 0 && escapeBikeSteer < 0 || escapeEdgeSteer < 0 && escapeBikeSteer > 0) {
                LQConsole.println("\u51cf\u901f\uff0c\u8eb2\u907f\u8fb9\u7f18\u548c\u5176\u5b83\u8f66\u8f86");
                this.control = (byte)(this.control | 2);
            } else {
                int steer = escapeBikeSteer != 0 ? escapeBikeSteer : escapeEdgeSteer;
                this.aiSteer(steer, 0);
            }
        } else {
            this.aiSteer(drivePointSteer, RaceWorld.CONST_5);
        }
        if ((this.control & 2) <= 0) {
            this.control = (byte)(this.control | 1);
        }
        if (this.control != this.lastControl) {
            this.addReplayNode(this.control, frame);
        }
        this.doControl(this.control);
    }

    private void aiSteer(int leftRight, int threshold) {
        if (leftRight > threshold) {
            this.control = (byte)(this.control | 4);
            this.control = (byte)(this.control & 0xFFFFFFF7);
        } else if (leftRight < -threshold) {
            this.control = (byte)(this.control | 8);
            this.control = (byte)(this.control & 0xFFFFFFFB);
        } else {
            this.control = (byte)(this.control & 0xFFFFFFFB);
            this.control = (byte)(this.control & 0xFFFFFFF7);
        }
    }

    private void updateKey_AutoAcc(int frame) {
        this.lastControl = this.control;
        this.control = (byte)(this.control & 0xFFFFFFEF);
        this.control = LQKey.IsKeyPressed(1) ? (byte)(this.control | 0x20) : (byte)(this.control & 0xFFFFFFDF);
        this.control = LQKey.IsKeyPressed(2) ? (byte)(this.control | 0x40) : (byte)(this.control & 0xFFFFFFBF);
        if (LQKey.IsKeyHold(2) || this.physicsObj.getSpeedFP() > this.physicsObj.gearSpeeds[this.gear]) {
            this.control = (byte)(this.control | 2);
        } else if ((this.control & 2) > 0) {
            this.control = (byte)(this.control & 0xFFFFFFFD);
        }
        if (LQKey.IsKeyHold(4)) {
            this.control = (byte)(this.control | 4);
        } else if ((this.control & 4) > 0) {
            this.control = (byte)(this.control & 0xFFFFFFFB);
        }
        if (LQKey.IsKeyHold(8)) {
            this.control = (byte)(this.control | 8);
        } else if ((this.control & 8) > 0) {
            this.control = (byte)(this.control & 0xFFFFFFF7);
        }
        if (this.control != this.lastControl) {
            this.addReplayNode(this.control, frame);
        }
        this.doControl(this.control);
    }

    private void updateKey_ManualAcc(int frame) {
        this.lastControl = this.control;
        if (LQKey.IsKeyHold(1)) {
            this.control = (byte)(this.control | 1);
        } else if ((this.control & 1) > 0) {
            this.control = (byte)(this.control & 0xFFFFFFFE);
        }
        if (LQKey.IsKeyHold(2)) {
            this.control = (byte)(this.control | 2);
        } else if ((this.control & 2) > 0) {
            this.control = (byte)(this.control & 0xFFFFFFFD);
        }
        if (LQKey.IsKeyHold(4)) {
            this.control = (byte)(this.control | 4);
        } else if ((this.control & 4) > 0) {
            this.control = (byte)(this.control & 0xFFFFFFFB);
        }
        if (LQKey.IsKeyHold(8)) {
            this.control = (byte)(this.control | 8);
        } else if ((this.control & 8) > 0) {
            this.control = (byte)(this.control & 0xFFFFFFF7);
        }
        if (LQKey.IsKeyDblPressed(1)) {
            this.control = (byte)(this.control & 0xFFFFFFFE);
            this.control = (byte)(this.control | 0x10);
        } else {
            this.control = (byte)(this.control & 0xFFFFFFEF);
        }
        if (this.control != this.lastControl) {
            this.addReplayNode(this.control, frame);
        }
        this.doControl(this.control);
    }

    private boolean updateCrash(int frame) {
        if (this.crashTick > 30) {
            this.groundID = this.crashGroundID;
            this.lastGroundID = this.crashLastGroundID;
            LevelMap.Ground[] grounds = GameMain.levelMap.getGrounds();
            Vec2D dir = new Vec2D(grounds[this.groundID].drivingPointFP);
            dir.sub(this.crashPos);
            dir.normalize();
            this.resetToPos(this.crashPos, dir);
            this.setMode(this.crashLastMode);
            if (this.crashIsInSand) {
                this.physicsObj.intoSand();
            } else {
                this.physicsObj.inToRoad();
            }
            this.crashTick = 0;
            return true;
        }
        ++this.crashTick;
        return false;
    }

    private boolean updateReplay(int frame) {
        if (this.replayListHead == null) {
            return true;
        }
        if (this.replayListHead.frame == frame) {
            this.control = this.replayListHead.control;
            this.replayListHead = this.replayListHead.nextNode;
            ++this.controlNum;
        }
        this.doControl(this.control);
        return false;
    }

    private void doControl(byte controlType) {
        if ((controlType & 1) > 0) {
            this.physicsObj.setGear(this.gear);
        } else {
            this.physicsObj.setGear(0);
        }
        if ((controlType & 4) > 0) {
            this.physicsObj.turnLeft();
        } else if ((controlType & 8) > 0) {
            this.physicsObj.turnRight();
        } else {
            this.physicsObj.restoreTurn();
        }
        if ((controlType & 2) > 0) {
            this.physicsObj.brake();
        } else {
            this.physicsObj.restoreBrake();
        }
        if ((controlType & 0x20) > 0) {
            this.isGearLocked = true;
            if (this.gear < this.physicsObj.gearRatios.length - 1) {
                ++this.gear;
            }
        }
        if ((controlType & 0x40) > 0) {
            this.isGearLocked = true;
            if (this.gear > 0) {
                --this.gear;
            }
        }
        if ((controlType & 0x10) > 0) {
            boolean bl = this.isGearLocked = !this.isGearLocked;
        }
        if (this.isGearLocked) {
            this.physicsObj.setGear(this.gear);
        } else if ((controlType & 1) > 0) {
            if (this.gear == 0) {
                ++this.gear;
            } else if (this.gear < this.physicsObj.gearRatios.length - 1 && this.getSpeedFP() > this.physicsObj.gearSpeeds[this.gear - 1]) {
                ++this.gear;
            }
        } else if (this.gear > 0 && this.getSpeedFP() < this.physicsObj.gearSpeeds[this.gear - 1]) {
            --this.gear;
        }
    }

    private void addReplayNode(byte control, int frame) {
        ++this.controlNum;
        ReplayNode node = new ReplayNode();
        node.frame = frame;
        node.control = control;
        if (this.replayListTail == null) {
            this.replayListHead = this.replayListTail = node;
        } else {
            this.replayListTail.nextNode = node;
            this.replayListTail = node;
        }
    }

    private String controlToString(byte control) {
        String str = "";
        if ((control & 1) > 0) {
            str = str + "acc, ";
        }
        if ((control & 2) > 0) {
            str = str + "braking, ";
        }
        if ((control & 8) > 0) {
            str = str + "steerRight, ";
        }
        if ((control & 4) > 0) {
            str = str + "steerLeft, ";
        }
        if ((control & 0x10) > 0) {
            str = str + "lockGear, ";
        }
        if ((control & 0x20) > 0) {
            str = str + "gearUp, ";
        }
        if ((control & 0x40) > 0) {
            str = str + "gearDown, ";
        }
        return str;
    }

    public int toDrawX(int num) {
        return (int)((float)MathFP.toInt(num) * 0.5f);
    }

    public int toDrawY(int num) {
        return -((int)((float)MathFP.toInt(num) * 0.5f));
    }

    public int toDrawLen(int num) {
        return (int)((float)MathFP.toInt(num) * 0.5f);
    }

    public void draw(Graphics g, int cam2DX, int cam2DY) {
        int x = this.toDrawX(this.physicsObj.getCenter().X) + cam2DX;
        int y = this.toDrawY(this.physicsObj.getCenter().Y) + cam2DY;
        int dirX = this.physicsObj.getDir().X;
        int dirY = this.physicsObj.getDir().Y;
        dirX = MathFP.mul(dirX, MathFP.toFP(20));
        dirY = MathFP.mul(dirY, MathFP.toFP(20));
        g.setColor(65280);
        g.drawLine(x, y, x + this.toDrawX(dirX), y + this.toDrawY(dirY));
        dirX = this.physicsObj.getTurnDir().X;
        dirY = this.physicsObj.getTurnDir().Y;
        dirX = MathFP.mul(dirX, MathFP.toFP(10));
        dirY = MathFP.mul(dirY, MathFP.toFP(10));
        g.setColor(0xFFFF00);
        g.drawLine(x, y, x + this.toDrawX(dirX), y + this.toDrawY(dirY));
    }

    public void collideOtherBike(Bike otherBike) {
        Vec2D relativeVel = new Vec2D(this.physicsObj.getVelocity());
        relativeVel.sub(otherBike.getPhysicsObj().getVelocity());
        int relativeSpeed = relativeVel.normalize();
        if (relativeSpeed > RaceWorld.CONST_20) {
            this.crash();
        }
    }

    public void collideWithWall(StaticObj staticObj) {
        int degree = Math.abs(Vec2D.dotProduct(this.physicsObj.getDir(), ((ShapeLine)staticObj.getShape()).getUnit()));
        if (degree < RaceWorld.CONST_0_7 && this.getSpeedFP() > RaceWorld.CONST_5) {
            this.crash();
        }
    }

    private void crash() {
        if (this.mode == 4) {
            return;
        }
        this.control = 0;
        this.physicsObj.setGear(0);
        this.bikeCrashRotTrans.identity();
        this.bikeCrashRotTrans.translateWorld(0.0f, 0.0f, -this.getZf());
        this.humanCrashRotTrans.identity();
        this.humanCrashRotTrans.translateWorld(0.0f, 0.0f, -this.getZf());
        this.crashLastMode = this.mode;
        this.crashGroundID = this.groundID;
        this.crashLastGroundID = this.lastGroundID;
        this.crashIsInSand = this.isInSand();
        this.setCrashPos(this.physicsObj.getLastCenter());
        this.setMode((byte)4);
        int n = this.currentLap;
        this.crashPerLap[n] = this.crashPerLap[n] + 1;
    }

    public static class BikeCustom {
        public static final byte TireTypeSlick = 0;
        public static final byte TireTypeWet = 1;
        public static final byte TireHardnessSoft = 0;
        public static final byte TireHardnessMedium = 1;
        public static final byte TireHardnessHard = 2;
        public byte tireType;
        public byte tireHardness;
    }

    public static class ReplayNode {
        public int frame;
        public byte control;
        public ReplayNode nextNode;
    }
}

