/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.lemonquest.lq3d.LQCamera;
import com.lemonquest.lq3d.LQConfig;
import com.lemonquest.lq3d.LQFactory;
import com.lemonquest.lq3d.LQTransform;
import com.lemonquest.lq3d.LQVector;
import com.lemonquest.math.LQMath;
import com.lemonquest.math.MathFP;
import com.lemonquest.math.Vec2D;
import com.lemonquest.physics_v2.DynamicObj;
import com.lemonquest.util.LQKey;
import game.Bike;
import game.Effects;
import game.GameMain;
import game.LevelMap;
import javax.microedition.lcdui.Graphics;

public class Camera {
    private GameMain game;
    private LQCamera camera = LQFactory.LQCamera();
    private float[] pos = new float[]{0.0f, 0.0f, 1000.0f};
    private float[] look = new float[]{0.0f, 0.0f, -1.0f};
    private float[] up = new float[]{0.0f, 1.0f, 0.0f};
    private float[] destPos = new float[]{0.0f, 0.0f, 0.0f};
    private float[] destLook = new float[]{0.0f, 0.0f, 0.0f};
    private int lookDownZ = 700;
    private float near = 10.0f;
    private float far = 1600.0f;
    private float deg = 60.0f;
    private byte type;
    public static final byte Type_StandbyLook = -5;
    public static final byte Type_OpeningShow = -4;
    public static final byte Type_SmallMap_Shanghai = -3;
    public static final byte Type_ViewBike2 = -2;
    public static final byte Type_ViewBike = -1;
    public static final byte Type_LookDown = 0;
    public static final byte Type_Free = 1;
    public static final byte Type_Follow = 2;
    public static final byte Type_SideFollow = 3;
    public static final byte ChangableTypeNum = 4;
    private boolean isOnAir = false;
    Bike targetBike;
    public ClippingData clippingData = new ClippingData();
    private int offsetFromGroundDir;
    private Vec2D tmpGroundDir = new Vec2D();

    public Camera(GameMain game) {
        this.game = game;
        this.camera = LQFactory.LQCamera();
        this.setType((byte)0);
    }

    public LQCamera getData() {
        return this.camera;
    }

    public void setPos(float x, float y, float z) {
        this.pos[0] = x;
        this.pos[1] = y;
        this.pos[2] = z;
    }

    public boolean isOpeningShow() {
        return this.type == -4;
    }

    public void setType(byte type) {
        this.type = type;
        this.camera.setPerspective(this.near, this.far, this.deg, LQConfig.ScreenWidth, LQConfig.ScreenHeight);
        switch (this.type) {
            case -4: {
                Vec2D tmp = new Vec2D(this.targetBike.getPhysicsObj().getTurnDir());
                Vec2D offset = new Vec2D(tmp);
                if ((this.game.getLevel().getBikes().length - 1) % 4 < 2) {
                    offset.getPerp2D_CW();
                } else {
                    offset.getPerp2D_CCW();
                }
                offset.mul(MathFP.toFP(50));
                tmp.mul(MathFP.toFP(400));
                tmp.add(offset);
                tmp.add(this.targetBike.getPhysicsObj().getCenter());
                this.pos[0] = MathFP.toInt(tmp.X);
                this.pos[1] = MathFP.toInt(tmp.Y);
                this.pos[2] = 10.0f;
                this.look[0] = this.targetBike.getXf();
                this.look[1] = this.targetBike.getYf();
                this.look[2] = this.targetBike.getZf();
                this.up[0] = 0.0f;
                this.up[1] = 0.0f;
                this.up[2] = 1.0f;
                this.camera.targetAt(this.pos, this.look, this.up);
                break;
            }
            case -3: {
                this.lookDownZ = 1400;
                this.pos[0] = 0.0f;
                this.pos[1] = 400.0f;
                this.pos[2] = this.lookDownZ;
                this.look[0] = 0.0f;
                this.look[1] = 0.0f;
                this.look[2] = -1.0f;
                this.up[0] = 0.0f;
                this.up[1] = 1.0f;
                this.up[2] = 0.0f;
                this.camera.lookAt(this.pos, this.look, this.up);
                break;
            }
            case -1: {
                this.pos[0] = 0.0f;
                this.pos[1] = -56.0f;
                this.pos[2] = 20.0f;
                this.look[0] = 0.0f;
                this.look[1] = 0.0f;
                this.look[2] = 0.0f;
                this.up[0] = 0.0f;
                this.up[1] = 0.0f;
                this.up[2] = 1.0f;
                this.camera.targetAt(this.pos, this.look, this.up);
                break;
            }
            case -2: {
                this.pos[0] = 0.0f;
                this.pos[1] = -66.0f;
                this.pos[2] = 20.0f;
                this.look[0] = 0.0f;
                this.look[1] = 0.0f;
                this.look[2] = -6.0f;
                this.up[0] = 0.0f;
                this.up[1] = 0.0f;
                this.up[2] = 1.0f;
                this.camera.targetAt(this.pos, this.look, this.up);
                break;
            }
            case 0: {
                this.lookDownZ = 700;
                this.pos[0] = 0.0f;
                this.pos[1] = 0.0f;
                this.pos[2] = this.lookDownZ;
                this.look[0] = 0.0f;
                this.look[1] = 0.0f;
                this.look[2] = -1.0f;
                this.up[0] = 0.0f;
                this.up[1] = 1.0f;
                this.up[2] = 0.0f;
                break;
            }
            case 1: {
                this.pos[0] = 0.0f;
                this.pos[1] = 0.0f;
                this.pos[2] = 70.0f;
                this.look[0] = 0.0f;
                this.look[1] = 1.0f;
                this.look[2] = -0.268f;
                this.up[0] = 0.0f;
                this.up[1] = 0.0f;
                this.up[2] = 1.0f;
                break;
            }
            case 2: {
                Bike bike = this.targetBike;
                this.pos[0] = bike.getXf() - (float)MathFP.toInt(bike.getDirX_FP() * 80);
                this.pos[1] = bike.getYf() - (float)MathFP.toInt(bike.getDirY_FP() * 80);
                this.pos[2] = bike.getZf() + 50;
                this.look[0] = bike.getXf();
                this.look[1] = bike.getYf();
                this.look[2] = bike.getZf() + 40;
                this.up[0] = 0.0f;
                this.up[1] = 0.0f;
                this.up[2] = 1.0f;
                this.camera.targetAt(this.pos, this.look, this.up);
                break;
            }
            case 3: {
                Bike bike = this.targetBike;
                Vec2D right = new Vec2D(bike.getDirX_FP(), bike.getDirY_FP());
                right.getPerp2D_CW();
                this.pos[0] = bike.getXf() + (float)MathFP.toInt(right.X * 40);
                this.pos[1] = bike.getYf() + (float)MathFP.toInt(right.Y * 40);
                this.pos[2] = bike.getZf() + 50;
                this.look[0] = bike.getXf();
                this.look[1] = bike.getYf();
                this.look[2] = bike.getZf() + 40;
                this.up[0] = 0.0f;
                this.up[1] = 0.0f;
                this.up[2] = 1.0f;
                this.camera.targetAt(this.pos, this.look, this.up);
            }
        }
    }

    public float getAngle2() {
        float[] normLook = new float[3];
        this.camera.getNormalLook(normLook);
        if (normLook[0] == 0.0f) {
            if (normLook[1] > 0.0f) {
                return 90.0f;
            }
            return 270.0f;
        }
        double angle = LQMath.atan(normLook[1] / normLook[0]);
        angle = angle * 180.0 / 3.141592502593994;
        if (normLook[0] < 0.0f) {
            angle = 180.0 + angle;
        } else if (normLook[0] > 0.0f && normLook[1] < 0.0f) {
            angle = 360.0 + angle;
        }
        return (float)angle;
    }

    public int getAngle() {
        float[] normLook = new float[3];
        this.camera.getNormalLook(normLook);
        int sin = (int)(normLook[1] * (float)MathFP.ONE);
        if (sin < 0) {
            sin = -sin;
        }
        int degree = MathFP.lookupArcsin(sin);
        if (normLook[0] < 0.0f) {
            if (normLook[1] < 0.0f) {
                return degree + 180;
            }
            return 180 - degree;
        }
        if (normLook[1] < 0.0f) {
            return 360 - degree;
        }
        return degree;
    }

    public void changeType() {
        this.type = (byte)(this.type + 1);
        if (this.type >= 4) {
            this.type = 0;
        }
        this.setType(this.type);
    }

    public void setTargetBike(Bike bike) {
        this.targetBike = bike;
    }

    private void walk(float units) {
        float[] unitLook = new float[3];
        this.camera.getNormalLook(unitLook);
        if (this.isOnAir) {
            this.pos[0] = this.pos[0] + unitLook[0] * units;
            this.pos[1] = this.pos[1] + unitLook[1] * units;
            this.pos[2] = this.pos[2] + unitLook[2] * units;
        } else {
            this.pos[0] = this.pos[0] + unitLook[0] * units;
            this.pos[1] = this.pos[1] + unitLook[1] * units;
        }
    }

    private void pitch(float angle) {
    }

    private void yaw(float angle) {
        LQTransform trans = LQFactory.LQTransform();
        if (!this.isOnAir) {
            trans.rotateWorldZ(angle);
        }
        LQVector vec = new LQVector(this.up[0], this.up[1], this.up[2]);
        vec.mul(trans);
        this.up[0] = vec.getX();
        this.up[1] = vec.getY();
        this.up[2] = vec.getZ();
        vec.set(this.look[0], this.look[1], this.look[2]);
        vec.mul(trans);
        this.look[0] = vec.getX();
        this.look[1] = vec.getY();
        this.look[2] = vec.getZ();
    }

    public void update() {
        switch (this.type) {
            case -5: {
                this.look[0] = this.targetBike.getXf();
                this.look[1] = this.targetBike.getYf();
                this.look[2] = this.targetBike.getZf() + 40;
                this.camera.targetAt(this.pos, this.look, this.up);
                break;
            }
            case -4: {
                Vec2D dest = new Vec2D(this.targetBike.getPhysicsObj().getTurnDir());
                Vec2D offset = new Vec2D(dest);
                if ((this.game.getLevel().getBikes().length - 1) % 4 < 2) {
                    offset.getPerp2D_CW();
                } else {
                    offset.getPerp2D_CCW();
                }
                offset.mul(MathFP.toFP(50));
                dest.mul(MathFP.toFP(-150));
                dest.add(offset);
                dest.add(this.targetBike.getPhysicsObj().getCenter());
                float rate = 0.025f;
                if (this.game.getLevel().getShowTick() == 70) {
                    Effects.FullScreenBlackOutEff.instance().begin(60);
                }
                this.destPos[0] = MathFP.toInt(dest.X);
                this.destPos[1] = MathFP.toInt(dest.Y);
                this.destPos[2] = this.targetBike.getZf() + 50;
                float movement = 0.0f;
                int i = 0;
                while (i < 3) {
                    movement = (float)Math.sqrt((this.destPos[i] - this.pos[i]) * (this.destPos[i] - this.pos[i])) * rate;
                    if (this.destPos[i] - this.pos[i] < 0.0f) {
                        movement = -movement;
                    }
                    int n = i++;
                    this.pos[n] = this.pos[n] + movement;
                }
                this.camera.targetAt(this.pos, this.look, this.up);
                break;
            }
            case 0: {
                float step = 100.0f;
                if (LQKey.IsKeyHold(0x100000)) {
                    if (LQKey.IsKeyHold(1)) {
                        this.pos[1] = this.pos[1] + 100.0f;
                    }
                    if (LQKey.IsKeyHold(2)) {
                        this.pos[1] = this.pos[1] - 100.0f;
                    }
                    if (LQKey.IsKeyHold(4)) {
                        this.pos[0] = this.pos[0] - 100.0f;
                    }
                    if (LQKey.IsKeyHold(8)) {
                        this.pos[0] = this.pos[0] + 100.0f;
                    }
                    if (LQKey.IsKeyHold(32)) {
                        this.pos[2] = this.pos[2] - 100.0f;
                        this.lookDownZ = (int)((float)this.lookDownZ - 100.0f);
                    }
                    if (LQKey.IsKeyHold(2048)) {
                        this.pos[2] = this.pos[2] + 100.0f;
                        this.lookDownZ = (int)((float)this.lookDownZ + 100.0f);
                    }
                } else {
                    Bike bike = this.targetBike;
                    this.destPos[0] = bike.getXf();
                    this.destPos[1] = bike.getYf();
                    this.destPos[2] = bike.getZf() + this.lookDownZ;
                    for (int i = 0; i < 3; ++i) {
                        int n = i;
                        this.pos[n] = this.pos[n] + (this.destPos[i] - this.pos[i]) * 0.25f;
                    }
                }
                this.camera.lookAt(this.pos, this.look, this.up);
                break;
            }
            case 1: {
                float step = 10.0f;
                if (LQKey.IsKeyHold(1)) {
                    this.walk(10.0f);
                }
                if (LQKey.IsKeyHold(2)) {
                    this.walk(-10.0f);
                }
                if (LQKey.IsKeyHold(4)) {
                    this.yaw(10.0f);
                }
                if (LQKey.IsKeyHold(8)) {
                    this.yaw(-10.0f);
                }
                if (LQKey.IsKeyHold(32)) {
                    this.pos[2] = this.pos[2] - 10.0f;
                }
                if (LQKey.IsKeyHold(2048)) {
                    this.pos[2] = this.pos[2] + 10.0f;
                }
                this.camera.lookAt(this.pos, this.look, this.up);
                break;
            }
            case 2: {
                Bike bike = this.targetBike;
                int x = (bike.getTurnDirX_FP() + bike.getDirX_FP()) / 2;
                int y = (bike.getTurnDirY_FP() + bike.getDirY_FP()) / 2;
                this.destPos[0] = bike.getXf() - (float)MathFP.toInt(x * 80);
                this.destPos[1] = bike.getYf() - (float)MathFP.toInt(y * 80);
                this.destPos[2] = bike.getZf() + 50;
                this.destLook[0] = bike.getXf();
                this.destLook[1] = bike.getYf();
                this.destLook[2] = bike.getZf() + 40;
                for (int i = 0; i < 3; ++i) {
                    int n = i;
                    this.pos[n] = this.pos[n] + (this.destPos[i] - this.pos[i]) * 0.5f;
                    int n2 = i;
                    this.look[n2] = this.look[n2] + (this.destLook[i] - this.look[i]) * 0.5f;
                }
                this.camera.targetAt(this.pos, this.look, this.up);
                break;
            }
            case 3: {
                Bike bike = this.targetBike;
                Vec2D right = new Vec2D(bike.getDirX_FP(), bike.getDirY_FP());
                right.getPerp2D_CW();
                int bikeSpeed = MathFP.toInt(bike.getSpeedFP());
                if (bikeSpeed > 36) {
                    bikeSpeed = 36;
                }
                int distant = 70 + bikeSpeed;
                this.destPos[0] = bike.getXf() + (float)MathFP.toInt(right.X * distant);
                this.destPos[1] = bike.getYf() + (float)MathFP.toInt(right.Y * distant);
                this.destPos[2] = bike.getZf() + 15;
                this.destLook[0] = bike.getXf() + (float)MathFP.toInt(bike.getDirX_FP() * bikeSpeed);
                this.destLook[1] = bike.getYf() + (float)MathFP.toInt(bike.getDirY_FP() * bikeSpeed);
                this.destLook[2] = bike.getZf() + 20;
                for (int i = 0; i < 3; ++i) {
                    int n = i;
                    this.pos[n] = this.pos[n] + (this.destPos[i] - this.pos[i]) * 0.5f;
                    int n3 = i;
                    this.look[n3] = this.look[n3] + (this.destLook[i] - this.look[i]) * 0.5f;
                }
                this.camera.targetAt(this.pos, this.look, this.up);
            }
        }
        if (this.targetBike != null) {
            LevelMap.Ground[] grounds = GameMain.levelMap.getGrounds();
            DynamicObj physicsObj = this.targetBike.getPhysicsObj();
            int groundID = this.targetBike.getGroundID();
            int nextID = GameMain.levelMap.getNextGroundID(groundID);
            this.tmpGroundDir.set(grounds[nextID].x, grounds[nextID].y);
            this.tmpGroundDir.sub(new Vec2D(grounds[groundID].x, grounds[groundID].y));
            this.offsetFromGroundDir = Vec2D.dotProduct(new Vec2D((int)(this.look[0] - this.pos[0]) * MathFP.ONE, (int)(this.look[1] - this.pos[1]) * MathFP.ONE), this.tmpGroundDir);
        }
    }

    public boolean isDirWrong() {
        return this.offsetFromGroundDir < 0;
    }

    public final float[] getPos() {
        return this.pos;
    }

    public void draw(Graphics g) {
        g.setColor(0xFFFFFF);
        g.drawString("pos:(" + this.pos[0] + ", " + this.pos[1] + ", " + this.pos[2] + ")", 0, 40, 20);
        g.drawString("look:(" + this.look[0] + ", " + this.look[1] + ", " + this.look[2] + ")", 0, 60, 20);
        g.drawString("up:(" + this.up[0] + ", " + this.up[1] + ", " + this.up[2] + ")", 0, 80, 20);
    }

    public static class ClippingData {
        public static final float Radius = (float)Math.sqrt(32611.46484375) * 2.0f;
        public static final float tanFov = (float)Math.tan(0.5235987755982988);
        public static final float invSinFov = (float)(1.0 / Math.sin(0.5235987755982988));
        public float[] pos = new float[2];
        public float[] look = new float[2];
        public float[] left = new float[2];
        public float[] right = new float[2];
        public float[] farPlaneCenter = new float[2];
        public float[][] trianleCCW = new float[3][];
        public float[][] points = new float[3][];

        public ClippingData() {
            for (int i = 0; i < this.trianleCCW.length; ++i) {
                this.trianleCCW[i] = new float[2];
                this.points[i] = new float[2];
            }
        }

        public void update(float[] camPos, float[] target, float farPlane) {
            this.pos[0] = camPos[0];
            this.pos[1] = camPos[1];
            this.look[0] = target[0] - camPos[0];
            this.look[1] = target[1] - camPos[1];
            double inv_look = 1.0 / Math.sqrt(this.look[0] * this.look[0] + this.look[1] * this.look[1]);
            this.look[0] = (float)((double)this.look[0] * inv_look);
            this.look[1] = (float)((double)this.look[1] * inv_look);
            float backward = Radius * invSinFov;
            this.pos[0] = this.pos[0] - this.look[0] * backward;
            this.pos[1] = this.pos[1] - this.look[1] * backward;
            this.farPlaneCenter[0] = this.pos[0] + this.look[0] * (farPlane + Radius + Radius * invSinFov);
            this.farPlaneCenter[1] = this.pos[1] + this.look[1] * (farPlane + Radius + Radius * invSinFov);
            float leftRightScale = farPlane * tanFov;
            this.left[0] = this.look[0];
            this.left[1] = this.look[1];
            LQMath.getPerp2D_CCW(this.left);
            this.left[0] = this.left[0] * leftRightScale + this.farPlaneCenter[0];
            this.left[1] = this.left[1] * leftRightScale + this.farPlaneCenter[1];
            this.right[0] = this.look[0];
            this.right[1] = this.look[1];
            LQMath.getPerp2D_CW(this.right);
            this.right[0] = this.right[0] * leftRightScale + this.farPlaneCenter[0];
            this.right[1] = this.right[1] * leftRightScale + this.farPlaneCenter[1];
            this.points[0][0] = this.pos[0];
            this.points[0][1] = this.pos[1];
            this.points[1][0] = this.right[0];
            this.points[1][1] = this.right[1];
            this.points[2][0] = this.left[0];
            this.points[2][1] = this.left[1];
            this.trianleCCW[0][0] = this.right[0] - this.pos[0];
            this.trianleCCW[0][1] = this.right[1] - this.pos[1];
            this.trianleCCW[1][0] = this.left[0] - this.right[0];
            this.trianleCCW[1][1] = this.left[1] - this.right[1];
            this.trianleCCW[2][0] = this.pos[0] - this.left[0];
            this.trianleCCW[2][1] = this.pos[1] - this.left[1];
        }
    }
}

