/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.lemonquest.lq3d.renderlist.LQObjClipper;
import com.lemonquest.lq3d.renderlist.LQRenderList;
import com.lemonquest.lq3d.renderlist.LQRenderNode;
import com.lemonquest.math.LQMath;
import game.GameMain;
import game.LevelMap;
import game.Res;

public class RaceMapClipper
implements LQObjClipper {
    private GameMain game;
    private Res res = Res.instance();
    public static int GroundStartIndex = 0;
    public static int GroundEndIndex = 0;

    public RaceMapClipper(GameMain game) {
        this.game = game;
    }

    public void update(LQRenderList renderList, LQRenderNode[] nodeList) {
        int i;
        int groundID = this.game.getLevel().getPlayerBike().getGroundID();
        if (this.game.getCamera().isDirWrong()) {
            GroundStartIndex = groundID - 6 + 1;
            GroundEndIndex = groundID + 1;
            this.res.groundApp[0].setCullingMode(2);
            if (!Res.isSBmemory()) {
                for (i = 0; i < this.res.treeApp.length; ++i) {
                    this.res.treeApp[i].setCullingMode(2);
                }
            }
        } else {
            GroundStartIndex = groundID - 1;
            GroundEndIndex = groundID - 1 + 6;
            this.res.groundApp[0].setCullingMode(0);
            if (!Res.isSBmemory()) {
                for (i = 0; i < this.res.treeApp.length; ++i) {
                    this.res.treeApp[i].setCullingMode(0);
                }
            }
        }
        for (i = GroundStartIndex; i <= GroundEndIndex; ++i) {
            LevelMap.Ground[] grounds = GameMain.levelMap.getGrounds();
            int id = i;
            if (i < 0) {
                id = i + grounds.length;
            }
            if (i > grounds.length - 1) {
                id = i - grounds.length;
            }
            nodeList[id].translate(grounds[id].x, grounds[id].y, grounds[id].z);
            renderList.pushBackRenderList(nodeList[id]);
        }
    }

    private void update2(LQRenderList renderList, LQRenderNode[] nodeList) {
        int groundID = this.game.getLevel().getPlayerBike().getGroundID();
        GroundStartIndex = groundID - 6;
        GroundEndIndex = groundID - 1 + 6;
        float[][] trangle = this.game.getCamera().clippingData.trianleCCW;
        float[][] points = this.game.getCamera().clippingData.points;
        float[] tmp = new float[2];
        boolean[] isIn = new boolean[12];
        int totalCount = 0;
        for (int i = GroundStartIndex; i <= GroundEndIndex; ++i) {
            int j;
            isIn[totalCount] = false;
            LevelMap.Ground[] grounds = GameMain.levelMap.getGrounds();
            int id = i;
            if (i < 0) {
                id = i + grounds.length;
            }
            if (i > grounds.length - 1) {
                id = i - grounds.length;
            }
            for (j = 0; j < trangle.length; ++j) {
                tmp[0] = (float)grounds[id].x - points[j][0];
                tmp[0] = (float)grounds[id].y - points[j][1];
                float side = LQMath.crossProduct2D(trangle[j], tmp);
                if (side > 0.0f) break;
            }
            if (j == trangle.length) {
                isIn[totalCount] = true;
            }
            ++totalCount;
        }
        int wrong = 0;
        int right = 0;
        for (int i = 0; i < isIn.length; ++i) {
            if (isIn[i]) {
                ++wrong;
                continue;
            }
            ++right;
        }
        boolean isWrong = wrong > right;
        System.out.println("wrong:" + !isWrong);
        int addedCount = 0;
        for (int i = GroundStartIndex; i <= GroundEndIndex; ++i) {
            if (addedCount >= 6) continue;
            LevelMap.Ground[] grounds = GameMain.levelMap.getGrounds();
            int id = i;
            if (i < 0) {
                id = i + grounds.length;
            }
            if (i > grounds.length - 1) {
                id = i - grounds.length;
            }
            if (!isIn[i - GroundStartIndex]) continue;
            ++addedCount;
            nodeList[id].translate(grounds[id].x, grounds[id].y, grounds[id].z);
            renderList.pushBackRenderList(nodeList[id]);
        }
        System.out.println("addedCount: " + addedCount);
    }
}

