/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.lemonquest.math.MathFP;
import com.lemonquest.math.Vec2D;
import com.lemonquest.physics_v2.DynamicObj;
import com.lemonquest.physics_v2.EventHandler;
import com.lemonquest.physics_v2.RaceWorld;
import com.lemonquest.physics_v2.ShapeLine;
import com.lemonquest.physics_v2.StaticObj;
import game.Effects;
import game.GameMain;

public class RoadEventHandler
implements EventHandler {
    public static final byte EventChangeRoadType = 0;
    public static final byte EventSpark = 1;
    public static final byte EventCollideBike = 2;
    private GameMain game;
    private Vec2D lineNorm = new Vec2D();

    public RoadEventHandler(GameMain game) {
        this.game = game;
    }

    public void fireEvent(byte eventType, DynamicObj dynObj, StaticObj staticObj) {
        switch (eventType) {
            case 1: {
                if (dynObj.getBike() == null) break;
                dynObj.getBike().collideWithWall(staticObj);
                if (dynObj.getSpeedFP() <= RaceWorld.CONST_30) break;
                Effects.instance().addBikeSpark(RaceWorld.collisionPoint);
            }
        }
    }

    public void fireInstantEvent(byte eventType, DynamicObj dynObj, StaticObj staticObj) {
        switch (eventType) {
            case 0: {
                boolean isSameSide = false;
                short groundID = staticObj.groundID;
                Vec2D groundCenter = new Vec2D(MathFP.toFP(GameMain.levelMap.getGrounds()[groundID].x), MathFP.toFP(GameMain.levelMap.getGrounds()[groundID].y));
                isSameSide = RaceWorld.isSameSide(dynObj, groundCenter, staticObj);
                if (isSameSide) {
                    dynObj.inToRoad();
                    break;
                }
                this.lineNorm.set(((ShapeLine)staticObj.getShape()).getUnit());
                this.lineNorm.getPerp2D_CW();
                int angle = Vec2D.dotProduct(dynObj.getVelocity(), this.lineNorm);
                if (angle >= 0) break;
                dynObj.intoSand();
            }
        }
    }

    public void fireWaypointEvent(byte eventType, int ballIndex, int wayPointIndex, int terminalIndex) {
    }
}

