/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.lemonquest.lq3d.LQBufferedTexture;
import com.lemonquest.lq3d.LQFactory;
import com.lemonquest.lq3d.LQGraphics3D;
import com.lemonquest.lq3d.LQTransform;
import com.lemonquest.text.LQFont;
import com.lemonquest.util.LQGfx;
import com.lemonquest.util.LQKey;
import game.Design;
import game.FontRollProperty;
import game.GameMain;
import game.ItemList;
import game.LQSound;
import game.MainMIDlet;
import game.Res;
import game.RiderInfo;
import game.Txt;
import java.util.Random;
import javax.microedition.lcdui.Graphics;

public class UI {
    private GameMain game;
    private Res res = Res.instance();
    private LQGraphics3D g3d;
    private MenuItem currMenu;
    private MenuItem lastMenu;
    private MenuItem mainMenu;
    private MenuItem quickRaceMenu;
    private MenuItem pauseMenu;
    private ItemList achievementMenu;
    private int confirmBoxTxt;
    public int confirmBoxLastGameState;
    private boolean isConfirmed;
    public final int TitleY;
    public final int TitleBarH;
    public final int PageContentMarginY;
    public final int PageContentMarginX;
    public final int smallLineHeight;
    public final int midLineHeight;
    public final int bigLineHeight;
    private int pauseBoxW;
    private int pauseBoxH;
    public static boolean SOUND_OPEN = true;
    public static boolean VIBRATION_OPEN = true;
    private int logoState = 0;
    private int logoTick = 0;
    private int isChangingColor;
    private int[] bikeColorHue = new int[2];
    private int bikeColorIndex;
    private int tireConfigChosenIndex;
    public int tmpBikePoints;
    private int[] tmpBikeProperties;
    public boolean fixLoading;
    private int coverTick;
    private FontRollProperty roll_play = null;
    private FontRollProperty roll_training = null;
    private int txtScrollPos;
    private int maxScrollPos;
    public LQTransform bikeRotateTrans = LQFactory.LQTransform();
    private boolean isChooseQuickRace2 = false;
    private static int strMoveTick = 0;

    public String getMI() {
        return this.res.txt[this.currMenu.getSelectedItem().getName()];
    }

    public UI(GameMain game, LQGraphics3D g3d) {
        this.TitleY = 20;
        this.TitleBarH = 36;
        this.PageContentMarginY = 6;
        this.PageContentMarginX = 10;
        this.smallLineHeight = 15;
        this.midLineHeight = 15;
        this.bigLineHeight = 20;
        this.game = game;
        this.g3d = g3d;
    }

    public void createMenuTree() {
        int[] main;
        int[] main_gmg;
        this.currMenu = this.mainMenu = new MenuItem(null, -1);
        if (!SOUND_OPEN && !VIBRATION_OPEN) {
            main_gmg = new int[]{2, 216, 147, 6, 5, 7, 8};
            main = new int[]{2, 216, 147, 5, 7, 8};
        } else {
            main_gmg = new int[]{2, 216, 147, 6, 4, 5, 7, 8};
            main = new int[]{2, 216, 147, 4, 5, 7, 8};
        }
        int[] achievement = Txt.Achievement;
        int[] play = new int[]{11, 10, 41};
        int[] miniGame = new int[]{60, 61, 62, 63, 64};
        int[] settings = SOUND_OPEN && VIBRATION_OPEN ? new int[]{16, 15} : (SOUND_OPEN && !VIBRATION_OPEN ? new int[]{16} : (!SOUND_OPEN && VIBRATION_OPEN ? new int[]{15} : null));
        int[] custom_bike = new int[]{51, 49, 50};
        int[] bike_color = new int[this.res.BikeColorNum];
        for (int i = 0; i < bike_color.length; ++i) {
            bike_color[i] = i;
        }
        int[] type_of_tire = new int[]{44, 45};
        int[] hardness_of_tire = new int[]{47, 46, 48};
        int[] HighScore = Txt.TrackNames;
        if (MainMIDlet.isSupportGMG) {
            this.mainMenu.setItems(main_gmg);
        } else {
            this.mainMenu.setItems(main);
        }
        this.achievementMenu = new ItemList(null, -1);
        this.achievementMenu.setItems(achievement);
        int loopShow = 7;
        if (Res.isW176()) {
            loopShow = 3;
        } else if (Res.is320x240()) {
            loopShow = 5;
        } else if (Res.isW128()) {
            loopShow = Res.isH160() ? 4 : 2;
        } else if (Res.isSB240_29X() || Res.isSB240()) {
            loopShow = 4;
        }
        this.achievementMenu.set_loopShow(loopShow);
        this.mainMenu.getItemByName(2).setItems(play);
        if (SOUND_OPEN || VIBRATION_OPEN) {
            this.mainMenu.getItemByName(4).setItems(settings);
        }
        this.mainMenu.getItemByName(147).setItems(HighScore);
        this.mainMenu.getItemByName(2).getItemByName(41).setItems(miniGame);
        this.mainMenu = this.mainMenu.getItemByName(2);
        this.createChampMenu(this.mainMenu.getItemByName(10));
        this.mainMenu.getItemByName(11).setItems(custom_bike);
        this.mainMenu = this.mainMenu.getItemByName(11);
        this.mainMenu.getItemByName(51).setItems(bike_color);
        this.mainMenu.getItemByName(49).setItems(type_of_tire);
        this.mainMenu.getItemByName(50).setItems(hardness_of_tire);
        this.mainMenu = this.currMenu;
        int[] custom_circuit = new int[]{30, 31, 32, 33, 34};
        int[] type_of_race = new int[]{37, 38, 39, 40};
        int[] circuit = Txt.TrackNames;
        int[] lap_num = new int[]{1, 2, 3};
        int[] opponent_num = new int[]{0, 1, 2};
        int[] weather = new int[]{35, 36};
        this.currMenu = this.quickRaceMenu = new MenuItem(null, -1);
        this.quickRaceMenu.setItems(custom_circuit);
        this.quickRaceMenu.getItemByName(30).setItems(type_of_race);
        this.quickRaceMenu.getItemByName(31).setItems(circuit);
        this.quickRaceMenu.getItemByName(32).setItems(lap_num);
        this.quickRaceMenu.getItemByName(33).setItems(opponent_num);
        this.quickRaceMenu.getItemByName(34).setItems(weather);
        this.quickRaceMenu.getItemByName(32).selNext(true);
        this.quickRaceMenu.getItemByName(32).selNext(true);
        this.quickRaceMenu.getItemByName(33).selPrev(true);
        this.quickRaceMenu = this.currMenu;
        int[] pause = !SOUND_OPEN && !VIBRATION_OPEN ? new int[]{18, 221, 5, 23, 24} : new int[]{18, 221, 4, 5, 23, 24};
        int[] pause_settins = SOUND_OPEN && VIBRATION_OPEN ? new int[]{16, 15} : (SOUND_OPEN && !VIBRATION_OPEN ? new int[]{16} : (!SOUND_OPEN && VIBRATION_OPEN ? new int[]{15} : null));
        this.currMenu = this.pauseMenu = new MenuItem(null, -1);
        this.pauseMenu.setItems(pause);
        if (SOUND_OPEN || VIBRATION_OPEN) {
            this.pauseMenu.getItemByName(4).setItems(pause_settins);
        }
        this.pauseMenu = this.currMenu;
        this.currMenu = this.mainMenu;
    }

    public void createChampMenu(MenuItem root) {
        MenuItem copyChamp = root;
        int[] championship = null;
        int[] race_day = new int[]{52, 41, 57};
        int[] moto_enhance = new int[]{103, 104, 105, 106};
        int[] custom_tire = new int[]{49, 50};
        int[] type_of_tire = new int[]{44, 45};
        int[] hardness_of_tire = new int[]{46, 47, 48};
        if (this.res.userProfile.hasChampionshipRecord()) {
            championship = new int[]{21, 19};
            root.setItems(championship);
            root.getItemByName(21).setItems(race_day);
            root.getItemByName(19).setItems(race_day);
            root = root.getItemByName(21);
            root.getItemByName(57).setItems(moto_enhance);
            root.getItemByName(52).setItems(custom_tire);
            root = root.getItemByName(52);
            root.getItemByName(49).setItems(type_of_tire);
            root.getItemByName(50).setItems(hardness_of_tire);
            root = copyChamp.getItemByName(19);
            root.getItemByName(57).setItems(moto_enhance);
            root.getItemByName(52).setItems(custom_tire);
            root = root.getItemByName(52);
            root.getItemByName(49).setItems(type_of_tire);
            root.getItemByName(50).setItems(hardness_of_tire);
        } else {
            championship = new int[]{19};
            root.setItems(championship);
            root.getItemByName(19).setItems(race_day);
            root = root.getItemByName(19);
            root.getItemByName(57).setItems(moto_enhance);
            root.getItemByName(52).setItems(custom_tire);
            root = root.getItemByName(52);
            root.getItemByName(49).setItems(type_of_tire);
            root.getItemByName(50).setItems(hardness_of_tire);
        }
        int[] training = this.res.userProfile.getChampTrainings();
        if (this.res.userProfile.hasChampionshipRecord()) {
            MenuItem trainingMenuContinue = copyChamp.getItemByName(21).getItemByName(41);
            trainingMenuContinue.setItems(training);
        }
        MenuItem trainingMenuNew = copyChamp.getItemByName(19).getItemByName(41);
        trainingMenuNew.setItems(training);
    }

    public static int[] select3From5(int[] srcMenus) {
        int[] training = new int[3];
        Random rand = new Random();
        for (int i = 0; i < 3; ++i) {
            int sel = Math.abs(rand.nextInt()) % srcMenus.length;
            training[i] = srcMenus[sel];
            int[] newAllTraining = new int[srcMenus.length - 1];
            int count = 0;
            for (int j = 0; j < srcMenus.length; ++j) {
                if (j == sel) continue;
                newAllTraining[count] = srcMenus[j];
                ++count;
            }
            srcMenus = newAllTraining;
        }
        return training;
    }

    public void update(int delta) {
        switch (this.game.gameState) {
            case 1: {
                this.res.initLogoRes();
                this.res.logoLqGfx.initFade(500);
                this.game.setGameState(2);
                break;
            }
            case 2: {
                this.updateLogo(delta);
                break;
            }
            case 3: {
                this.res.releaseLogoRes();
                if (SOUND_OPEN) {
                    this.game.setGameState(4);
                    break;
                }
                this.game.setGameState(101);
                break;
            }
            case 4: {
                this.game.setGameState(5);
                break;
            }
            case 5: {
                if (LQKey.IsKeyPressed(0x100000) || LQKey.IsKeyPressed(65536)) {
                    LQSound.SOUND_ON = true;
                    this.game.setGameState(101);
                    break;
                }
                if (!LQKey.IsKeyPressed(131072)) break;
                LQSound.SOUND_ON = false;
                this.game.setGameState(101);
                break;
            }
            case 11: {
                Res.audioManager.PlaySound(Res.SND_MENU, -1);
                this.game.setGameState(12);
                break;
            }
            case 12: {
                if (!this.res.menuCoverGfx.fadeIn() || !LQKey.IsKeyPressed(0x100000)) break;
                this.res.CopyRight = null;
                this.res.menuCoverGfx = null;
                this.game.setGameState(21);
                break;
            }
            case 411: {
                Res.menuWhiteBar.initFade(800, 50, 120);
                Res.menuBlackBar.setAlpha(140);
                this.txtScrollPos = 0;
                this.game.setGameState(412);
                break;
            }
            case 451: {
                this.updateAchievement();
                break;
            }
            case 452: {
                this.updateAchievementDisplay();
                break;
            }
            case 412: 
            case 422: {
                this.updateHelpAbout();
                break;
            }
            case 421: {
                Res.menuWhiteBar.setAlpha(140);
                Res.menuBlackBar.setAlpha(140);
                this.txtScrollPos = 0;
                this.game.setGameState(422);
                break;
            }
            case 21: {
                if (Res.menuWhiteBar == null) {
                    Res.menuWhiteBar = new LQGfx(Res.DIR + "menuSelectBar.png");
                }
                Res.menuWhiteBar.initFade(800, 50, 120);
                Res.audioManager.PlaySound(Res.SND_MENU, -1);
                this.game.setGameState(22);
                break;
            }
            case 117: {
                this.updataChooseQuickRaceGhost();
                break;
            }
            case 22: {
                this.updateMainMenu(delta);
                break;
            }
            case 404: {
                if (LQKey.IsKeyPressed(0x100000) || LQKey.IsKeyPressed(65536)) {
                    MainMIDlet.quitApp();
                }
                if (!LQKey.IsKeyPressed(131072)) break;
                this.game.setGameState(22);
                break;
            }
            case 111: {
                this.game.camera.setType((byte)-1);
                this.bikeRotateTrans.identity();
                this.bikeRotateTrans.rotateX(10.0f);
                Res.audioManager.PlaySound(Res.SND_OPTIONS, -1);
                this.game.setGameState(112);
                break;
            }
            case 112: {
                this.updateChooseBike();
                break;
            }
            case 113: {
                this.game.setGameState(114);
                break;
            }
            case 121: {
                this.res.userProfile.loadGhostHS();
                this.res.userProfile.load();
                this.game.setGameState(122);
                break;
            }
            case 122: {
                this.updateHighScore();
                break;
            }
            case 114: {
                Res.menuWhiteBar.initFade(800, 50, 120);
                this.currMenu = this.quickRaceMenu;
                this.game.setGameState(115);
                break;
            }
            case 115: {
                this.updateChooseQuickRace(delta);
                break;
            }
            case 131: {
                this.game.releaseLevelCustom();
                if (this.game.getLevelCustom() == null) {
                    int levelIndex = this.res.userProfile.getChampLevel();
                    Random rand = new Random();
                    int weatherType = this.res.userProfile.getChampWeather();
                    this.createChampMenu(this.mainMenu.getItemByName(2).getItemByName(10));
                    this.game.initLevelCustom(1, 0, levelIndex, Design.ChampionshipCircuitLaps[levelIndex], 6, weatherType);
                }
                this.currMenu = this.getRaceDayMenu();
                Res.audioManager.PlaySound(Res.SND_OPTIONS, -1);
                this.game.setGameState(132);
                break;
            }
            case 132: {
                this.updateRaceDay();
                break;
            }
            case 133: {
                break;
            }
            case 141: {
                this.game.camera.setType((byte)-2);
                this.bikeRotateTrans.identity();
                this.tmpBikePoints = this.res.userProfile.getBikeProper(4);
                this.tmpBikeProperties = new int[4];
                for (int i = 0; i < 4; ++i) {
                    this.tmpBikeProperties[i] = this.res.userProfile.getBikeProper(i + 0);
                }
                this.game.setGameState(142);
                break;
            }
            case 142: {
                this.updateBikeEnhance();
                break;
            }
            case 143: {
                break;
            }
            case 151: {
                this.game.setGameState(152);
                break;
            }
            case 152: {
                this.updateTraining();
                break;
            }
            case 153: {
                break;
            }
            case 161: {
                this.game.initBikeCustom((byte)0, (byte)1);
                Res.menuWhiteBar.initFade(800, 50, 120);
                this.game.setGameState(162);
                break;
            }
            case 162: {
                this.updateTireConfig();
                break;
            }
            case 163: {
                this.res.menuTireConfigBG = null;
                this.game.setGameState(104);
                break;
            }
            case 201: {
                this.res.initPauseMenuRes();
                this.currMenu = this.pauseMenu;
                this.currMenu.resetSelection();
                Res.menuWhiteBar.setAlpha(160);
                Res.menuBlackBar.setAlpha(170);
                this.pauseBoxH = this.currMenu.getItemCount() * 20;
                this.pauseBoxH += Res.ScreenH / 10;
                if (this.pauseBoxH > Res.ScreenH) {
                    this.pauseBoxH = Res.ScreenH;
                }
                this.pauseBoxW = 0;
                for (int i = 0; i < this.currMenu.getItemCount(); ++i) {
                    int lineWidth = this.res.fontWhiteBig.getLineWidth(this.res.txt[this.currMenu.getItem(i).getName()].toCharArray());
                    if (lineWidth <= this.pauseBoxW) continue;
                    this.pauseBoxW = lineWidth;
                }
                this.pauseBoxW += Res.ScreenW / 10;
                this.pauseBoxW += 16;
                if (this.pauseBoxW > Res.ScreenW) {
                    this.pauseBoxW = Res.ScreenW;
                }
                this.game.setGameState(202);
                break;
            }
            case 202: 
            case 203: {
                this.updatePause(delta);
                break;
            }
            case 204: {
                this.res.releasePauseMenuRes();
                this.currMenu = this.mainMenu;
                break;
            }
            case 301: {
                this.res.loadMenuNextState = 302;
                this.game.setGameState(107);
                break;
            }
            case 302: {
                this.game.setGameState(303);
                break;
            }
            case 303: {
                if (this.game.getLevelCustom().gameMode == 2) {
                    this.game.setGameState(114);
                } else if (this.game.getLevelCustom().gameMode == 1) {
                    this.game.setGameState(311);
                }
                this.game.releaseLevelCustom();
                break;
            }
            case 311: {
                this.game.setGameState(312);
                break;
            }
            case 321: {
                if (!LQKey.IsKeyPressed(65536) && !LQKey.IsKeyPressed(512) && !LQKey.IsKeyPressed(0x100000)) break;
                this.game.setGameState(131);
                break;
            }
            case 312: {
                this.game.setGameState(313);
                break;
            }
            case 313: {
                if (this.game.levelIndexRaceDay == 14) {
                    this.game.setGameState(321);
                    break;
                }
                this.game.setGameState(131);
                break;
            }
            case 401: {
                Res.menuBlackBar.setAlpha(20);
                this.game.setGameState(402);
                break;
            }
            case 402: {
                if (LQKey.IsKeyPressed(65536)) {
                    this.isConfirmed = true;
                    this.game.setGameState(403);
                    break;
                }
                if (!LQKey.IsKeyPressed(131072)) break;
                this.isConfirmed = false;
                this.game.setGameState(403);
                break;
            }
            case 403: {
                this.updateConfirmExit();
            }
        }
    }

    private void updateLogo(int delta) {
        if (this.logoState == 0 && this.res.logoLqGfx.fadeIn()) {
            ++this.logoState;
        }
        if (this.logoState == 1) {
            if (this.logoTick >= 2500) {
                this.res.logoLqGfx.initFade(500);
                ++this.logoState;
            }
            this.logoTick += delta;
        }
        if (this.logoState == 2 && this.res.logoLqGfx.fadeOut()) {
            this.game.setGameState(3);
        }
    }

    private void updateAchievement() {
        if (Res.menuWhiteBar.fadeInOut()) {
            Res.menuWhiteBar.initFade(800, 50, 120);
        }
        if (LQKey.IsKeyPressed(131072)) {
            this.game.setGameState(21);
        }
        if (LQKey.IsKeyPressed(1)) {
            this.achievementMenu.selPrev(false, false);
        }
        if (LQKey.IsKeyPressed(2)) {
            this.achievementMenu.selNext(false, false);
        }
        if (LQKey.IsKeyPressed(65536) || LQKey.IsKeyPressed(512) || LQKey.IsKeyPressed(0x100000)) {
            this.game.setGameState(452);
        }
    }

    private void updateAchievementDisplay() {
        if (LQKey.IsKeyPressed(131072)) {
            this.game.setGameState(451);
        }
    }

    private void updateHelpAbout() {
        if (Res.menuWhiteBar.fadeInOut()) {
            Res.menuWhiteBar.initFade(800, 50, 120);
        }
        this.updateHelpAboutScrollBar();
        if (LQKey.IsKeyPressed(131072)) {
            this.game.setGameState(21);
        }
    }

    private void updateHelpAboutScrollBar() {
        if (!Res.isW128() && this.game.gameState == 412) {
            return;
        }
        if (LQKey.IsKeyHold(1)) {
            this.txtScrollPos += 15;
            if (this.txtScrollPos > 0) {
                this.txtScrollPos = 0;
            }
        }
        if (LQKey.IsKeyHold(2) && (!Res.isW176() || this.game.gameState == 422) && this.txtScrollPos > -(this.maxScrollPos - Res.ScreenH / 2)) {
            this.txtScrollPos -= 15;
        }
    }

    private void updataChooseQuickRaceGhost() {
        if (Res.menuWhiteBar.fadeInOut()) {
            Res.menuWhiteBar.initFade(800, 50, 120);
        }
        if (LQKey.IsKeyPressed(1) || LQKey.IsKeyPressed(4)) {
            this.currMenu.selPrev(true);
        } else if (LQKey.IsKeyPressed(2) || LQKey.IsKeyPressed(8)) {
            this.currMenu.selNext(true);
        }
        if (LQKey.IsKeyPressed(131072)) {
            this.currMenu = this.quickRaceMenu;
            this.game.setGameState(115);
        }
        if (LQKey.IsKeyPressed(0x100000) || LQKey.IsKeyPressed(65536)) {
            switch (this.currMenu.getSelectedItem().getName()) {
                case 155: {
                    if (this.quickRaceMenu.getItemByName(30).getSelectedItem().getName() == 40 && !this.res.userProfile.hasGhostData(this.quickRaceMenu.getItem(1).getSelectedIndex())) {
                        this.game.msgt.addNewMessage(this.res.fontWhiteBig, this.res.txt[157], true, -1);
                        this.game.msgt.msg[0].set_y(136);
                        return;
                    }
                    this.currMenu = this.quickRaceMenu;
                    this.GoLoadLevelInit();
                    this.game.isGhostDataFromOnLine = false;
                }
            }
        }
    }

    public void GoLoadLevelInit() {
        this.game.initLevelCustom(2, this.quickRaceMenu.getItem(0).getSelectedIndex(), this.quickRaceMenu.getItem(1).getSelectedIndex(), this.quickRaceMenu.getItem(2).getSelectedItem().getName(), this.quickRaceMenu.getItem(3).getSelectedItem().getName(), this.quickRaceMenu.getItem(4).getSelectedIndex());
        this.game.setGameState(104);
    }

    public boolean isStateSetting() {
        if (this.currMenu == null) {
            return false;
        }
        return this.currMenu.getName() == 4;
    }

    private void updateMainMenu(int delta) {
        if (Res.menuWhiteBar.fadeInOut()) {
            Res.menuWhiteBar.initFade(800, 50, 120);
        }
        if (this.currMenu.getSelectedItem().getName() == 16 && (LQKey.IsKeyPressed(8) || LQKey.IsKeyPressed(4))) {
            return;
        }
        if (LQKey.IsKeyPressed(1) || LQKey.IsKeyPressed(4)) {
            this.currMenu.selPrev(true);
            if (this.roll_play != null) {
                this.roll_play.reset();
            }
            if (this.roll_training != null) {
                this.roll_training.reset();
            }
        } else if (LQKey.IsKeyPressed(2) || LQKey.IsKeyPressed(8)) {
            this.currMenu.selNext(true);
            if (this.roll_play != null) {
                this.roll_play.reset();
            }
            if (this.roll_training != null) {
                this.roll_training.reset();
            }
        }
        if (LQKey.IsKeyPressed(131072) && this.currMenu.getParent() != null) {
            if (this.currMenu.getName() == 4) {
                Res.audioManager.PlaySound(Res.SND_MENU, -1);
            }
            this.currMenu = this.currMenu.getParent();
        }
        if (LQKey.IsKeyPressed(0x100000) || LQKey.IsKeyPressed(65536)) {
            switch (this.currMenu.getSelectedItem().getName()) {
                case 2: 
                case 3: 
                case 41: {
                    this.currMenu = this.currMenu.getSelectedItem();
                    break;
                }
                case 4: {
                    if (SOUND_OPEN && Res.audioManager != null) {
                        Res.audioManager.StopCurrentSound();
                    }
                    this.currMenu = this.currMenu.getSelectedItem();
                    break;
                }
                case 10: {
                    this.game.isMiniGame = false;
                    if (this.game.getLevelCustom() != null) {
                        this.game.getLevelCustom().gameMode = 1;
                    }
                    this.createChampMenu(this.mainMenu.getItemByName(2).getItemByName(10));
                    this.currMenu = this.currMenu.getSelectedItem();
                    break;
                }
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: {
                    this.game.isMiniGame = true;
                    this.game.smallGameName = this.currMenu.getSelectedItem().getName();
                    this.currMenu = this.mainMenu;
                    this.game.setGameState(561);
                    break;
                }
                case 216: {
                    this.game.setGameState(451);
                    break;
                }
                case 5: {
                    this.game.setGameState(411);
                    break;
                }
                case 7: {
                    this.game.setGameState(421);
                    break;
                }
                case 19: {
                    if (this.res.userProfile.hasChampionshipRecord()) {
                        this.confirmBoxTxt = 22;
                        this.confirmBoxLastGameState = 22;
                        this.game.setGameState(401);
                        break;
                    }
                    this.res.userProfile.resetChampRecord();
                    this.game.releaseLevelCustom();
                    this.createChampMenu(this.mainMenu.getItemByName(2).getItemByName(10));
                    this.currMenu = this.currMenu.getSelectedItem();
                    this.game.setGameState(131);
                    break;
                }
                case 147: {
                    this.currMenu = this.currMenu.getSelectedItem();
                    this.game.setGameState(121);
                    break;
                }
                case 21: {
                    this.currMenu = this.currMenu.getSelectedItem();
                    this.game.setGameState(131);
                    break;
                }
                case 11: {
                    this.game.isMiniGame = false;
                    if (this.game.getLevelCustom() != null) {
                        this.game.getLevelCustom().gameMode = (byte)2;
                    }
                    this.currMenu = this.currMenu.getSelectedItem();
                    if (!Res.isCanChangeColor()) {
                        this.game.initBikeCustom((byte)this.currMenu.getItemByName(49).getSelectedIndex(), (byte)this.currMenu.getItemByName(50).getSelectedIndex());
                        this.lastMenu = this.currMenu;
                        this.currMenu = this.quickRaceMenu;
                        this.currMenu.select(0);
                        this.isChooseQuickRace2 = false;
                        this.game.setGameState(113);
                        break;
                    }
                    this.game.setGameState(111);
                    break;
                }
                case 15: {
                    this.game.vibrationSwitch();
                    break;
                }
                case 16: {
                    this.game.soundSwitch();
                    if (this.game.isSoundEnabled()) {
                        Res.audioManager.PlaySound(Res.SND_SOUND_ON, 1);
                        break;
                    }
                    if (!SOUND_OPEN || Res.audioManager == null) break;
                    Res.audioManager.StopCurrentSound();
                    break;
                }
                case 107: {
                    this.currMenu = this.currMenu.getParent();
                    break;
                }
                case 6: {
                    MainMIDlet.instance.WebRequest(MainMIDlet.UrlGmg);
                    break;
                }
                case 8: {
                    this.game.setGameState(404);
                    break;
                }
            }
        }
    }

    private void updatePause(int delta) {
        if (this.game.gameState == 203) {
            this.updateHelpAboutScrollBar();
            if (LQKey.IsKeyPressed(131072)) {
                this.game.setGameState(202);
            }
        } else {
            if (LQKey.IsKeyPressed(65536) || LQKey.IsKeyPressed(0x100000) || LQKey.IsKeyPressed(512)) {
                switch (this.currMenu.getSelectedItem().getName()) {
                    case 107: {
                        if (this.currMenu.getParent() == null) break;
                        this.currMenu = this.currMenu.getParent();
                        break;
                    }
                    case 18: {
                        this.res.releasePauseMenuRes();
                        this.game.getLevel().pause();
                        this.game.setGameState(501);
                        LQKey.ClearKey();
                        break;
                    }
                    case 221: {
                        this.confirmBoxTxt = 222;
                        this.confirmBoxLastGameState = 202;
                        this.game.setGameState(401);
                        break;
                    }
                    case 23: {
                        this.confirmBoxTxt = 28;
                        this.confirmBoxLastGameState = 202;
                        this.game.setGameState(401);
                        break;
                    }
                    case 24: {
                        this.confirmBoxTxt = 27;
                        this.confirmBoxLastGameState = 202;
                        this.game.setGameState(401);
                        break;
                    }
                    case 4: {
                        this.currMenu = this.currMenu.getSelectedItem();
                        break;
                    }
                    case 5: {
                        this.game.setGameState(203);
                        this.txtScrollPos = 0;
                        break;
                    }
                    case 15: {
                        this.game.vibrationSwitch();
                        break;
                    }
                    case 16: {
                        this.game.soundSwitch();
                    }
                }
            }
            if (LQKey.IsKeyPressed(1) || LQKey.IsKeyPressed(4)) {
                this.currMenu.selPrev(true);
                if (this.currMenu.getSelectedItem().getName() == 221 && !this.game.isCanRestart()) {
                    this.currMenu.selPrev(true);
                }
            } else if (LQKey.IsKeyPressed(2) || LQKey.IsKeyPressed(8)) {
                this.currMenu.selNext(true);
                if (this.currMenu.getSelectedItem().getName() == 221 && !this.game.isCanRestart()) {
                    this.currMenu.selNext(true);
                }
            }
            if (LQKey.IsKeyPressed(131072)) {
                if (this.currMenu.getParent() == null) {
                    this.res.releasePauseMenuRes();
                    this.game.getLevel().pause();
                    this.game.setGameState(501);
                } else {
                    this.currMenu = this.currMenu.getParent();
                }
            }
        }
    }

    private void updateChooseBike() {
        if (Res.menuWhiteBar.fadeInOut()) {
            Res.menuWhiteBar.initFade(800, 50, 120);
        }
        if (LQKey.IsKeyPressed(131072)) {
            this.currMenu = this.currMenu.getParent();
            this.game.setGameState(21);
        }
        if (LQKey.IsKeyPressed(0x100000) || LQKey.IsKeyPressed(65536)) {
            this.game.initBikeCustom((byte)this.currMenu.getItemByName(49).getSelectedIndex(), (byte)this.currMenu.getItemByName(50).getSelectedIndex());
            this.lastMenu = this.currMenu;
            this.currMenu = this.quickRaceMenu;
            this.currMenu.select(0);
            this.isChooseQuickRace2 = false;
            this.game.setGameState(113);
        }
        this.isChangingColor = 0;
        if (LQKey.IsKeyPressed(4)) {
            this.currMenu.getSelectedItem().selPrev(true);
            if (this.currMenu.getSelectedIndex() == 0) {
                this.isChangingColor = 1;
            }
        } else if (LQKey.IsKeyPressed(8)) {
            this.currMenu.getSelectedItem().selNext(true);
            if (this.currMenu.getSelectedIndex() == 0) {
                this.isChangingColor = 1;
            }
        }
        if (LQKey.IsKeyPressed(1)) {
            this.currMenu.selPrev(true);
        } else if (LQKey.IsKeyPressed(2)) {
            this.currMenu.selNext(true);
        }
        if (this.isChangingColor > 0) {
            this.bikeColorIndex = this.currMenu.getItemByName(51).getSelectedIndex();
            this.res.bufferedBikeTexture.updatePalette(this.res.bikePalettesFromFile[this.bikeColorIndex]);
            this.res.bufferedHumanTexture.updatePalette(this.res.humanPalettesFromFile[this.bikeColorIndex]);
            this.res.bikeMesh.getAppearance().getTexture().set(this.res.bufferedBikeTexture);
            for (int i = 0; i < this.res.humanMeshes.length; ++i) {
                this.res.humanMeshes[i].getAppearance().getTexture().set(this.res.bufferedHumanTexture);
            }
        }
    }

    private void updateHighScore() {
        if (LQKey.IsKeyPressed(4)) {
            this.currMenu.selPrev(true);
        } else if (LQKey.IsKeyPressed(8)) {
            this.currMenu.selNext(true);
        }
        if (LQKey.IsKeyPressed(131072)) {
            this.game.setGameState(22);
            this.currMenu = this.currMenu.getParent();
        }
    }

    private void updateChooseQuickRace(int delta) {
        if (Res.menuWhiteBar.fadeInOut()) {
            Res.menuWhiteBar.initFade(800, 50, 120);
        }
        if (LQKey.IsKeyPressed(131072)) {
            if ((Res.isW128() || Res.isW176()) && this.isChooseQuickRace2) {
                this.isChooseQuickRace2 = false;
                this.quickRaceMenu.select(0);
            } else if (!Res.isCanChangeColor()) {
                this.currMenu = this.mainMenu.getItemByName(2);
                this.game.setGameState(21);
            } else {
                this.game.setGameState(111);
                this.currMenu = this.lastMenu;
            }
        }
        if (LQKey.IsKeyPressed(0x100000) || LQKey.IsKeyPressed(65536)) {
            if ((Res.isW128() || Res.isW176()) && !this.isChooseQuickRace2) {
                this.isChooseQuickRace2 = true;
                this.quickRaceMenu.select(2);
                if (this.quickRaceMenu.getItemByName(30).getSelectedItem().getName() == 39) {
                    this.quickRaceMenu.select(3);
                } else if (this.quickRaceMenu.getItemByName(30).getSelectedItem().getName() == 40) {
                    this.quickRaceMenu.select(4);
                }
            } else {
                this.isChooseQuickRace2 = false;
                this.quickRaceMenu.select(0);
                this.startGame();
            }
        }
        if (LQKey.IsKeyPressed(4)) {
            this.quickRaceMenu.getSelectedItem().selPrev(true);
        } else if (LQKey.IsKeyPressed(8)) {
            this.quickRaceMenu.getSelectedItem().selNext(true);
        }
        if ((LQKey.IsKeyPressed(4) || LQKey.IsKeyPressed(8)) && this.quickRaceMenu.getSelectedItem().getName() == 30) {
            if (this.quickRaceMenu.getItemByName(30).getSelectedItem().getName() == 39) {
                if (this.quickRaceMenu.getItemByName(33).getSelectedIndex() == 0) {
                    this.quickRaceMenu.getItemByName(33).selNext(true);
                }
                this.quickRaceMenu.getItemByName(33).getItem(0).disable();
            } else {
                this.quickRaceMenu.getItemByName(33).getItem(0).enable();
            }
            if (this.quickRaceMenu.getItemByName(30).getSelectedItem().getName() == 39 || this.quickRaceMenu.getItemByName(30).getSelectedItem().getName() == 40) {
                this.quickRaceMenu.getItemByName(32).disable();
            } else {
                this.quickRaceMenu.getItemByName(32).enable();
            }
            if (this.quickRaceMenu.getItemByName(30).getSelectedItem().getName() == 40) {
                this.quickRaceMenu.getItemByName(32).select(0);
                this.quickRaceMenu.getItemByName(33).disable();
                this.quickRaceMenu.getItemByName(33).select(0);
            } else {
                this.quickRaceMenu.getItemByName(33).enable();
            }
        }
        if (this.quickRaceMenu.getItemByName(30).getSelectedItem().getName() == 39) {
            MenuItem lapMenu = this.quickRaceMenu.getItemByName(32);
            MenuItem opponentsMenu = this.quickRaceMenu.getItemByName(33);
            int offset = opponentsMenu.getSelectedIndex() - lapMenu.getSelectedIndex();
            if (offset > 0) {
                while (offset > 0) {
                    lapMenu.selNext(true);
                    --offset;
                }
            } else if (offset < 0) {
                while (offset < 0) {
                    lapMenu.selPrev(true);
                    ++offset;
                }
            }
        }
        int indexSelected = this.quickRaceMenu.getSelectedIndex();
        if (LQKey.IsKeyPressed(1)) {
            if (Res.isW128() || Res.isW176()) {
                if (this.isChooseQuickRace2) {
                    if (this.quickRaceMenu.getItemByName(30).getSelectedItem().getName() != 40 && (this.quickRaceMenu.getItemByName(30).getSelectedItem().getName() != 39 || indexSelected != 3) && indexSelected > 2) {
                        this.currMenu.selPrev(false);
                    }
                } else {
                    this.currMenu.selPrev(false);
                }
            } else {
                this.currMenu.selPrev(true);
            }
        } else if (LQKey.IsKeyPressed(2)) {
            if (Res.isW128() || Res.isW176()) {
                if (this.isChooseQuickRace2) {
                    this.currMenu.selNext(false);
                } else if (indexSelected < 1) {
                    this.currMenu.selNext(false);
                }
            } else {
                this.currMenu.selNext(true);
            }
        }
    }

    private void restart() {
        if (this.game.isTrainingMode()) {
            if (this.game.isMiniGame) {
                this.game.isMiniGame = true;
                this.currMenu = this.mainMenu;
                this.game.setGameState(561);
            } else if (!this.game.isMiniGame) {
                this.game.isMiniGame = false;
                this.game.setGameState(561);
            }
        } else if (this.game.isChampionshipMode()) {
            this.game.setGameState(163);
        } else if (this.game.isQuickRaceMode()) {
            this.startGame();
        }
    }

    private void startGame() {
        if (this.quickRaceMenu.getItemByName(30).getSelectedItem().getName() == 40) {
            if (this.quickRaceMenu.getItemByName(30).getSelectedItem().getName() == 40 && !this.res.userProfile.hasGhostData(this.quickRaceMenu.getItem(1).getSelectedIndex())) {
                this.game.msgt.addNewMessage(this.res.fontWhiteBig, this.res.txt[157], true, -1);
                this.game.msgt.msg[0].set_y(136);
                return;
            }
            this.currMenu = this.quickRaceMenu;
            this.GoLoadLevelInit();
            this.game.isGhostDataFromOnLine = false;
            return;
        }
        this.GoLoadLevelInit();
    }

    private void updateRaceDay() {
        if (Res.menuWhiteBar.fadeInOut()) {
            Res.menuWhiteBar.initFade(800, 50, 120);
        }
        if (LQKey.IsKeyPressed(131072)) {
            this.game.setGameState(21);
            this.currMenu = this.currMenu.getParent();
        }
        if (LQKey.IsKeyPressed(1)) {
            this.currMenu.selPrev(true);
            if (this.currMenu.getSelectedItem().getName() == 41) {
                this.currMenu.selPrev(true);
            }
        } else if (LQKey.IsKeyPressed(2)) {
            this.currMenu.selNext(true);
            if (this.currMenu.getSelectedItem().getName() == 41) {
                this.currMenu.selNext(true);
            }
        }
        if (LQKey.IsKeyPressed(0x100000) || LQKey.IsKeyPressed(65536)) {
            switch (this.currMenu.getSelectedItem().getName()) {
                case 57: {
                    this.currMenu = this.currMenu.getSelectedItem();
                    this.game.setGameState(141);
                    break;
                }
                case 41: {
                    this.currMenu = this.currMenu.getSelectedItem();
                    this.game.setGameState(151);
                    break;
                }
                case 52: {
                    this.game.levelIndexRaceDay = this.res.userProfile.getChampLevel();
                    this.game.setGameState(161);
                }
            }
        }
    }

    private void updateTireConfig() {
        if (Res.menuWhiteBar.fadeInOut()) {
            Res.menuWhiteBar.initFade(800, 50, 120);
        }
        if (LQKey.IsKeyPressed(4)) {
            --this.tireConfigChosenIndex;
            if (this.tireConfigChosenIndex < 0) {
                this.tireConfigChosenIndex = 1;
            }
        }
        if (LQKey.IsKeyPressed(8)) {
            ++this.tireConfigChosenIndex;
            if (this.tireConfigChosenIndex > 1) {
                this.tireConfigChosenIndex = 0;
            }
        }
        if (LQKey.IsKeyPressed(1)) {
            if (this.tireConfigChosenIndex == 0) {
                this.game.getPlayerBikeCustom().tireType = (byte)(this.game.getPlayerBikeCustom().tireType - 1);
                if (this.game.getPlayerBikeCustom().tireType < 0) {
                    this.game.getPlayerBikeCustom().tireType = 1;
                }
            } else if (this.tireConfigChosenIndex == 1) {
                this.game.getPlayerBikeCustom().tireHardness = (byte)(this.game.getPlayerBikeCustom().tireHardness - 1);
                if (this.game.getPlayerBikeCustom().tireHardness < 0) {
                    this.game.getPlayerBikeCustom().tireHardness = (byte)2;
                }
            }
        }
        if (LQKey.IsKeyPressed(2)) {
            if (this.tireConfigChosenIndex == 0) {
                this.game.getPlayerBikeCustom().tireType = (byte)(this.game.getPlayerBikeCustom().tireType + 1);
                if (this.game.getPlayerBikeCustom().tireType > 1) {
                    this.game.getPlayerBikeCustom().tireType = 0;
                }
            } else if (this.tireConfigChosenIndex == 1) {
                this.game.getPlayerBikeCustom().tireHardness = (byte)(this.game.getPlayerBikeCustom().tireHardness + 1);
                if (this.game.getPlayerBikeCustom().tireHardness > 2) {
                    this.game.getPlayerBikeCustom().tireHardness = 0;
                }
            }
        }
        if (LQKey.IsKeyPressed(0x100000) || LQKey.IsKeyPressed(65536)) {
            this.game.setGameState(163);
        }
        if (LQKey.IsKeyPressed(131072)) {
            this.game.setGameState(131);
        }
    }

    private void updateBikeEnhance() {
        if (Res.menuWhiteBar.fadeInOut()) {
            Res.menuWhiteBar.initFade(800, 50, 120);
        }
        if (LQKey.IsKeyPressed(131072)) {
            this.currMenu = this.currMenu.getParent();
            this.game.setGameState(131);
        }
        if (LQKey.IsKeyPressed(1)) {
            this.currMenu.selPrev(true);
        }
        if (LQKey.IsKeyPressed(2)) {
            this.currMenu.selNext(true);
        }
        if (LQKey.IsKeyPressed(0x100000)) {
            int propertyIndex = this.currMenu.getSelectedIndex() + 0;
            int neededPoints = this.res.userProfile.getNeededPoints(propertyIndex, this.tmpBikeProperties[this.currMenu.getSelectedIndex()]);
            if (this.tmpBikeProperties[this.currMenu.getSelectedIndex()] < 20 && neededPoints <= this.tmpBikePoints) {
                this.tmpBikePoints -= neededPoints;
                int n = this.currMenu.getSelectedIndex();
                this.tmpBikeProperties[n] = this.tmpBikeProperties[n] + 1;
            }
        }
        if (LQKey.IsKeyPressed(65536)) {
            this.res.userProfile.setBikeProperty(4, this.tmpBikePoints);
            this.res.userProfile.setBikeProperty(0, this.tmpBikeProperties[0]);
            this.res.userProfile.setBikeProperty(1, this.tmpBikeProperties[1]);
            this.res.userProfile.setBikeProperty(2, this.tmpBikeProperties[2]);
            this.res.userProfile.setBikeProperty(3, this.tmpBikeProperties[3]);
            this.res.userProfile.saveBikeProperty();
            this.currMenu = this.currMenu.getParent();
            this.game.setGameState(131);
        }
    }

    private void updateTraining() {
        if (Res.menuWhiteBar.fadeInOut()) {
            Res.menuWhiteBar.initFade(800, 50, 120);
        }
        if (LQKey.IsKeyPressed(131072)) {
            this.currMenu = this.currMenu.getParent();
            this.game.setGameState(131);
        }
        if (LQKey.IsKeyPressed(1) || LQKey.IsKeyPressed(4)) {
            this.currMenu.selPrev(true);
            if (this.roll_play != null) {
                this.roll_play.reset();
            }
            if (this.roll_training != null) {
                this.roll_training.reset();
            }
        } else if (LQKey.IsKeyPressed(2) || LQKey.IsKeyPressed(8)) {
            this.currMenu.selNext(true);
            if (this.roll_play != null) {
                this.roll_play.reset();
            }
            if (this.roll_training != null) {
                this.roll_training.reset();
            }
        }
        if (LQKey.IsKeyPressed(0x100000) || LQKey.IsKeyPressed(65536)) {
            this.game.isMiniGame = false;
            this.game.smallGameName = this.currMenu.getSelectedItem().getName();
            this.currMenu = this.currMenu.getParent();
            this.game.setGameState(561);
            return;
        }
    }

    private MenuItem getRaceDayMenu() {
        return this.mainMenu.getItemByName(2).getItemByName(10).getSelectedItem();
    }

    public void setBackMiniGame() {
        this.currMenu = this.mainMenu.getItemByName(2).getItemByName(41);
    }

    private void updateConfirmExit() {
        if (this.isConfirmed) {
            switch (this.confirmBoxLastGameState) {
                case 202: {
                    this.res.releasePauseMenuRes();
                }
            }
            switch (this.confirmBoxTxt) {
                case 28: {
                    this.currMenu = this.mainMenu.getItemByName(2);
                    this.res.loadMenuNextState = 21;
                    this.confirmBoxTxt = 28;
                    this.confirmBoxLastGameState = 202;
                    this.res.releasePauseMenuRes();
                    this.res.releaseLevel();
                    this.game.releaseLevelCustom();
                    this.currMenu = this.mainMenu.getItemByName(2);
                    this.currMenu.select(0);
                    this.game.setGameState(107);
                    break;
                }
                case 27: {
                    MainMIDlet.quitApp();
                    break;
                }
                case 222: {
                    this.restart();
                    break;
                }
                case 22: {
                    this.res.userProfile.resetChampRecord();
                    this.createChampMenu(this.mainMenu.getItemByName(2).getItemByName(10));
                    this.game.releaseLevelCustom();
                    this.currMenu = this.currMenu.getItemByName(21);
                    this.game.setGameState(131);
                }
            }
        } else {
            switch (this.confirmBoxLastGameState) {
                case 22: 
                case 202: {
                    this.game.setGameState(this.confirmBoxLastGameState);
                }
            }
        }
    }

    public void champYet() {
        this.res.userProfile.champYet();
        this.createChampMenu(this.mainMenu.getItemByName(2).getItemByName(10));
    }

    public void draw(Graphics g) {
        this.fixLoading = false;
        switch (this.game.gameState) {
            case 2: {
                this.drawLogo(g);
                break;
            }
            case 5: {
                this.drawEnableSound(g);
                break;
            }
            case 102: 
            case 105: 
            case 108: {
                this.drawLoading(g);
                break;
            }
            case 12: {
                this.drawCover(g);
                break;
            }
            case 451: {
                this.drawAchievement(g);
                break;
            }
            case 452: {
                this.drawAchievementDisplay(g);
                break;
            }
            case 412: 
            case 422: {
                this.drawHelpAbout(g);
                break;
            }
            case 22: {
                this.drawMainMenu(g);
                break;
            }
            case 404: {
                this.drawConfirmExitAll(g);
                break;
            }
            case 132: {
                this.drawRaceDay(g);
                break;
            }
            case 142: {
                this.drawBikeEnhance(g);
                break;
            }
            case 152: {
                this.drawTraining(g);
                break;
            }
            case 162: {
                this.drawTireConfig(g);
                break;
            }
            case 112: {
                this.drawChooseBike(g);
                break;
            }
            case 122: {
                this.drawHighScore(g);
                break;
            }
            case 117: {
                this.drawQuickRaceGhost(g);
                break;
            }
            case 115: {
                if (this.isChooseQuickRace2) {
                    this.drawChooseQuickRace2(g);
                    break;
                }
                this.drawChooseQuickRace(g);
                break;
            }
            case 202: 
            case 203: {
                this.drawPause(g);
                break;
            }
            case 321: {
                this.drawCongratulations(g);
                break;
            }
            case 302: {
                this.game.setGameState(303);
                break;
            }
            case 312: {
                this.game.setGameState(313);
                break;
            }
            case 402: {
                this.drawConfirm(g);
            }
        }
    }

    private void drawLogo(Graphics g) {
        g.setColor(7342641);
        g.fillRect(Res.ScreenX, Res.ScreenY, Res.ScreenW, Res.ScreenH);
        this.res.logoLqGfx.draw(g, Res.ScreenW / 2, Res.ScreenH / 2, 3);
    }

    private void drawEnableSound(Graphics g) {
        g.setColor(1056330);
        g.fillRect(Res.ScreenX, Res.ScreenY, Res.ScreenW, Res.ScreenH);
        this.res.fontWhiteBig.drawString(g, this.res.txt[136], 10, Res.ScreenH / 3, Res.ScreenW - 20, Res.ScreenH, 17, true);
        this.drawButtons(g, 111, 112);
    }

    private void drawLoading(Graphics g) {
        this.fixLoading = true;
        for (int i = 0; i < 4; ++i) {
            if (this.res.loadingTick < 100) {
                ++this.res.loadingTick;
            }
            if (this.res.loadingTick <= 100) continue;
            this.res.loadingTick = 100;
        }
        if (Res.isSBmemory() || Res.isHI()) {
            this.res.menuBgGfx = null;
            g.setColor(0);
            g.fillRect(0, 0, 600, 600);
        } else {
            this.res.menuBgGfx.draw(g, 0, 0, 20);
        }
        int x = Res.ScreenW / 5;
        int y = Res.ScreenH / 6 * 5;
        int w = Res.ScreenW / 5 * 3;
        int h = 6;
        UI.drawMessageBox(g, Res.menuWhiteBar, x - 9, y - 8, w + 17, 23, 0, 0, 0);
        Res.resetClip(g);
        g.setColor(0xFFFFFF);
        g.fillRect(x, y, this.res.loadingTick * w / 100, 6);
        g.drawRect(x - 2, y - 2, w + 3, 9);
        this.res.fontWhiteMid.drawString(g, this.res.txt[109], Res.ScreenW / 2, y - 6, 33);
        if (this.game.gameState == 105) {
            int levelIndex = this.game.getLevelIndex();
            int Y = 72;
            if (Res.is352x416()) {
                Y = 140;
            }
            if (this.game.getLevelCustom().typeOfRace == 7 || this.game.getLevelCustom().typeOfRace == 8 || this.game.getLevelCustom().typeOfRace == 5 || this.game.getLevelCustom().typeOfRace == 6 || this.game.getLevelCustom().typeOfRace == 4) {
                Y = Res.isW128() ? (Y -= 40) : (Y += 40);
                this.res.fontWhiteMid.drawString(g, this.res.txt[41], Res.ScreenW / 2, Y, 17);
            } else {
                this.res.load_menuCurcuitThumb();
                if (Res.isW128()) {
                    Y = 8;
                } else if (Res.isW176()) {
                    Y = 48;
                }
                int gridWidth = this.res.menuCurcuitThumb.getWidth() / 15;
                this.res.load_menuAlphaCircuitBG();
                this.res.menuAlphaCircuitBG.draw(g, Res.ScreenW / 2, Y + this.res.menuCurcuitThumb.getHeight() / 2, 3);
                this.res.menuCurcuitThumb.draw(g, Res.ScreenW / 2, Y, this.game.getLevelIndex() * gridWidth, 0, gridWidth, this.res.menuCurcuitThumb.getHeight(), 17);
                Y += this.res.menuAlphaCircuitBG.getHeight();
                Y += this.res.fontWhiteMid.getFontHeight() + this.res.fontWhiteMid.getLineSpacing();
                if (Res.isW128()) {
                    Y -= 16;
                }
                this.res.fontWhiteMid.drawString(g, this.res.txt[Txt.TrackCountries[levelIndex]], Res.ScreenW / 2, Y, 17);
                this.res.fontWhiteMid.drawString(g, this.res.txt[Txt.TrackNames[levelIndex]], Res.ScreenW / 2, Y += 15, 17);
            }
        }
    }

    private void drawCover(Graphics g) {
        this.res.menuCoverGfx.draw(g, 0, 0, 20);
        ++this.coverTick;
        this.coverTick %= 14;
        if (this.coverTick < 10) {
            this.res.fontWhiteBig.drawString(g, this.res.txt[1], Res.ScreenW / 2, 301, 33, true);
        }
        this.res.load_CopyRight();
        this.res.CopyRight.draw(g, 120, 314, 33);
    }

    private void drawConfirmExitAll(Graphics g) {
        this.res.menuBgGfx.draw(g, 0, 0, 20);
        this.res.fontWhiteBig.drawString(g, this.res.txt[27], 0, 160, 240, 320, 17, true);
        this.drawButtons(g, 111, 112);
    }

    private void drawMainMenu(Graphics g) {
        if (this.res.menuBgGfx == null) {
            this.res.menuBgGfx = new LQGfx(Res.DIR + "menu_bg.png");
        }
        this.res.menuBgGfx.draw(g, 0, 0, 20);
        int lineHeight = Res.isW128() ? this.res.fontWhiteSmall.getFontHeight() + 2 : this.res.fontWhiteBig.getFontHeight() + 10;
        int lineWidth = Res.ScreenW - 20;
        int itemY = (Res.ScreenH - lineHeight * this.currMenu.count()) / 2;
        if (this.currMenu.getName() == 41) {
            if (Res.isSB240_29X()) {
                itemY = 68;
            } else if (Res.is352x416()) {
                itemY = 110;
            } else {
                itemY = 80;
                if (Res.isSB240()) {
                    itemY = 32;
                } else if (Res.isW176()) {
                    itemY = 16;
                } else if (Res.isW128()) {
                    itemY = 4;
                }
            }
        }
        boolean isPlayMenu = false;
        if (this.currMenu.getItem(0).getName() == 11) {
            isPlayMenu = true;
            if (Res.isSB240_29X()) {
                itemY = 68;
            } else if (Res.is352x416()) {
                itemY = 120;
            } else {
                itemY -= Res.getScaleHeight(60);
                if (Res.isSB240()) {
                    itemY = 32;
                } else if (Res.isH160()) {
                    itemY = 24;
                }
            }
        }
        int infoY = itemY + lineHeight * this.currMenu.count();
        int h_hot = 20;
        int y_hot = itemY - 6 + this.currMenu.getSelectedIndex() * lineHeight;
        if (Res.isW128()) {
            h_hot -= 6;
            y_hot = itemY - 1 + this.currMenu.getSelectedIndex() * lineHeight;
        }
        UI.drawMessageBox(g, Res.menuWhiteBar, (Res.ScreenW - lineWidth) / 2, y_hot, lineWidth, h_hot, 0, 0, 0);
        String str = "";
        for (int i = 0; i < this.currMenu.count(); ++i) {
            boolean isHot = this.currMenu.getSelectedIndex() == i;
            str = this.res.txt[this.currMenu.getItem(i).getName()];
            if (this.currMenu.getItem(i).getName() == 15) {
                UI uI = this;
                str = str + ": " + (uI.game.isVibrateEnabled() ? this.res.txt[113] : this.res.txt[114]);
            }
            if (this.currMenu.getItem(i).getName() == 16) {
                str = str + ": " + (this.game.isSoundEnabled() ? this.res.txt[113] : this.res.txt[114]);
                if (this.game.gameState == 22) {
                    this.res.fontWhiteBig.drawString(g, str, 120, itemY + lineHeight * i, 17, true);
                    continue;
                }
                this.res.fontWhiteBig.drawString(g, str, 0, itemY + lineHeight * i, Res.ScreenW, lineHeight, 17, true);
                continue;
            }
            this.res.fontWhiteBig.drawString(g, str, 0, itemY + lineHeight * i, Res.ScreenW, lineHeight, 17, true);
        }
        if (isPlayMenu) {
            int indexTxt = 12;
            switch (this.currMenu.getItem(this.currMenu.getSelectedIndex()).getName()) {
                case 11: {
                    indexTxt = 12;
                    break;
                }
                case 10: {
                    indexTxt = 20;
                    break;
                }
                default: {
                    indexTxt = 125;
                }
            }
            infoY = Res.isSB240_29X() ? Res.ScreenH - 20 : Res.ScreenH - 40;
            if (!Res.is352x416()) {
                this.res.menuAlphaSplitLine.draw(g, Res.ScreenW / 2, infoY, 17);
            }
            infoY = Res.isSB240() ? (infoY -= 109) : (Res.isSB240_29X() ? (infoY -= 135) : (Res.is352x416() ? (infoY -= 183) : (infoY -= 135)));
            this.res.menuAlphaSplitLine.draw(g, Res.ScreenW / 2, infoY, 17);
            this.res.fontWhiteSmall.drawString(g, this.res.txt[indexTxt], 10, infoY, 220, 135, 3);
        }
        if (this.currMenu.getName() == 41) {
            if (Res.isW128()) {
                itemY += 32;
            }
            this.drawTrainingHelp(g, itemY + lineHeight * 10);
        }
        this.drawButtons(g, 108, -1);
        if (this.currMenu != this.mainMenu) {
            this.drawButtons(g, -1, 107);
        }
    }

    public void drawTrainingHelp(Graphics g, int Y) {
        if (!Res.is320x240()) {
            this.res.menuAlphaSplitLine.draw(g, Res.ScreenW / 2, Y, 17);
        }
        this.res.menuAlphaSplitLine.draw(g, Res.ScreenW / 2, Y -= 90, 17);
        Y += 15;
        int tip = 0;
        switch (this.currMenu.getSelectedItem().getName()) {
            case 60: {
                tip = 130;
                break;
            }
            case 61: {
                tip = 131;
                break;
            }
            case 64: {
                tip = 134;
                break;
            }
            case 62: {
                tip = 133;
                break;
            }
            case 63: {
                tip = 132;
            }
        }
        this.res.fontWhiteSmall.drawString(g, this.res.txt[tip], Res.ScreenX + 16, Y, 208, 320, 17);
    }

    public void drawAchievement(Graphics g) {
        int space;
        this.res.menuBgGfx.draw(g, 0, 0, 20);
        int X = space = 4;
        int W = 240 - space * 2;
        int Y = space;
        int H = 320 - this.res.fontWhiteBig.getFontHeight() - space * 2 - 4;
        this.res.fontWhiteBig.drawString(g, this.res.txt[216], 120, Y += 4, 17, true);
        Y += this.res.fontWhiteBig.getFontHeight() + 4;
        X += 4;
        W = 230;
        H = this.res.fontWhiteMid.getFontHeight() * 2 + this.res.fontWhiteSmall.getFontHeight() + 2;
        if (Res.isW128()) {
            H = 18;
        }
        boolean isHot = false;
        for (int i = 0; i < this.achievementMenu.get_loopShow(); ++i) {
            isHot = false;
            if (this.achievementMenu.get_indexShow() + i >= this.achievementMenu.getSubItemsCount()) break;
            if (this.achievementMenu.getSelectedIndex() == this.achievementMenu.get_indexShow() + i) {
                isHot = true;
            }
            if (isHot) {
                UI.drawMessageBox(g, Res.menuWhiteBar, X - 3, Y, W - 10, H - 2, 0, 0, 0);
            }
            this.drawListCellAchievement(g, this.achievementMenu.get_indexShow() + i, X, Y, i == this.achievementMenu.get_loopShow() - 1);
            Y += H;
        }
        this.res.menuAlphaSplitLine.draw(g, Res.ScreenW / 2, Y += 8, 17);
        Y += 16;
        X += 10;
        int X2 = 218;
        if (Res.isW128()) {
            X = 2;
            X2 = 238;
            if (Res.isH160()) {
                Y -= 12;
            }
        }
        this.res.fontWhiteSmall.drawString(g, this.res.txt[219], X, Y, 20);
        String strEARNED = this.res.userProfile.getNums_achievementEarned() + "/" + 18;
        this.res.fontWhiteSmall.drawString(g, strEARNED, X2, Y, 24);
        this.res.fontWhiteSmall.drawString(g, this.res.txt[220], X, Y += this.res.fontWhiteSmall.getFontHeight() + 8, 20);
        String strPOINTS = this.res.userProfile.get_lemonMoney() + "/" + 5000;
        this.res.fontWhiteSmall.drawString(g, strPOINTS, X2, Y, 24);
        Y += 32;
        if (!(Res.isW128() || Res.isSB240() || Res.isSB240_29X() || Res.isW176())) {
            this.res.menuAlphaSplitLine.draw(g, Res.ScreenW / 2, Y, 17);
        }
        this.achievementMenu.drawBar(g);
        this.drawButtons(g, 108, 107);
    }

    private void drawListCellAchievement(Graphics g, int index, int x, int y, boolean is1) {
        int i;
        String lineCut = Res.isW240() ? "---------------------------" : (Res.isW128() ? "-----------------" : "------------------------");
        ++y;
        if (Res.isW128()) {
            int i2 = this.res.txt[Txt.Achievement[index]].indexOf(" ");
            if (i2 == -1) {
                i2 = this.res.txt[Txt.Achievement[index]].length();
            }
            this.res.fontWhiteMid.drawString(g, this.res.txt[Txt.Achievement[index]].substring(0, i2) + "...", x, y, 20);
        } else {
            String str1 = this.res.txt[Txt.Achievement[index]];
            if (!Res.isW240() && this.res.fontWhiteSmall.getLineWidth(str1.toCharArray()) > 120) {
                i = str1.indexOf(" ");
                if (i == -1) {
                    i = str1.length();
                }
                str1 = str1.substring(0, i) + "...";
            }
            this.res.fontWhiteMid.drawString(g, str1, x, y, 20);
        }
        if (!Res.isW128()) {
            this.res.fontWhiteMid.drawString(g, "" + GameMain.POINT_Achievement[index], 224, y + 4, 24);
        }
        if (this.res.userProfile.achievementEarned[index] != 0) {
            int y1 = 48;
            if (Res.isW128()) {
                y1 = 24;
            }
            if (this.res.coin == null) {
                this.res.coin = new LQGfx(Res.DIR + "coin.png");
            }
            this.res.coin.draw(g, 240 - y1, y + 2, 24);
        }
        if (!Res.isW128()) {
            y += this.res.fontWhiteMid.getFontHeight() + 3;
            String str = this.res.txt[Txt.B[index]];
            if (!Res.isW240() && this.res.fontWhiteSmall.getLineWidth(str.toCharArray()) > 120) {
                i = str.indexOf(" ");
                if (i == -1) {
                    i = str.length();
                }
                str = str.substring(0, i) + "...";
            }
            this.res.fontWhiteSmall.drawString(g, str, x, y, 20);
            y += this.res.fontWhiteSmall.getFontHeight() + 1;
        }
        if (!is1 && !Res.isW128()) {
            this.res.fontWhiteMid.drawString(g, lineCut, x, y, 20);
        }
    }

    public void drawAchievementDisplay(Graphics g) {
        int space;
        String lineCut = "-------------------------";
        this.res.menuBgGfx.draw(g, 0, 0, 20);
        this.drawButtons(g, -1, 107);
        int X = space = 4;
        int W = 240 - space * 2;
        int Y = space;
        int H = 320 - this.res.fontWhiteBig.getFontHeight() - space * 2 - 4;
        if (!Res.isW128()) {
            this.res.fontWhiteBig.drawString(g, this.res.txt[218], 120, Y += 4, 17, true);
            Y += this.res.fontWhiteBig.getFontHeight() + 12;
        }
        this.res.fontWhiteBig.drawString(g, this.res.txt[Txt.Achievement[this.achievementMenu.getSelectedIndex()]], 120, Y, 17, true);
        this.res.fontWhiteMid.drawString(g, lineCut, 120, Y += this.res.fontWhiteBig.getFontHeight() + 1, 17);
        Y += this.res.fontWhiteMid.getFontHeight() + 1;
        if (Res.isW128()) {
            this.res.fontWhiteSmall.drawString(g, this.res.txt[Txt.B[this.achievementMenu.getSelectedIndex()]], 0, Y, 232, 200, 17);
            Y += 48;
        } else {
            this.res.fontWhiteSmall.drawString(g, this.res.txt[Txt.B[this.achievementMenu.getSelectedIndex()]], 120, Y, 17);
            this.res.fontWhiteMid.drawString(g, lineCut, 120, Y += (this.res.fontWhiteSmall.getFontHeight() + 1) * 2 + 4, 17);
        }
        if (Res.isW176()) {
            Y += 24;
        }
        Y += Res.getScaleHeight((this.res.fontWhiteSmall.getFontHeight() + 1) * 2 + 4);
        if (this.res.userProfile.achievementEarned[this.achievementMenu.getSelectedIndex()] != 0) {
            if (this.res.coin == null) {
                this.res.coin = new LQGfx(Res.DIR + "coin.png");
            }
            this.res.coin.draw(g, 120, Y, 17);
            Y += this.res.coin.getHeight() + 8;
        }
        this.res.fontWhiteBig.drawString(g, GameMain.POINT_Achievement[this.achievementMenu.getSelectedIndex()] + " " + this.res.txt[59], 120, Y, 17, true);
        Y += Res.getScaleHeight(this.res.fontWhiteBig.getFontHeight() + 1 + 4);
        if (Res.isW128()) {
            Y += 4;
        }
        int indexEarned = 215;
        if (this.res.userProfile.achievementEarned[this.achievementMenu.getSelectedIndex()] != 0) {
            indexEarned = 219;
        }
        this.res.fontWhiteBig.drawString(g, this.res.txt[indexEarned], 120, Y, 17, true);
        if (Res.isW128()) {
            return;
        }
        Y += this.res.fontWhiteBig.getFontHeight();
        this.res.menuAlphaSplitLine.draw(g, Res.ScreenW / 2, Y += Res.getScaleHeight(Res.getScaleHeight(20)), 17);
        if (Res.isW176()) {
            return;
        }
        this.res.fontWhiteBig.drawString(g, this.res.txt[138], 120, Y += Res.getScaleHeight(Res.getScaleHeight(40)), 17, true);
        this.res.menuAlphaSplitLine.draw(g, Res.ScreenW / 2, Y += this.res.fontWhiteBig.getFontHeight() + 6, 17);
        int w_score = 22;
        int X2 = 240 - w_score;
        this.res.fontWhiteSmall.drawString(g, this.res.txt[219], X += 10, Y += 6, 20);
        String strEARNED = this.res.userProfile.getNums_achievementEarned() + "/" + 18;
        this.res.fontWhiteSmall.drawString(g, strEARNED, X2, Y, 24);
        this.res.fontWhiteSmall.drawString(g, this.res.txt[220], X, Y += this.res.fontWhiteSmall.getFontHeight() + 8, 20);
        String strPOINTS = this.res.userProfile.get_lemonMoney() + "/" + 5000;
        this.res.fontWhiteSmall.drawString(g, strPOINTS, X2, Y, 24);
        Y += this.res.fontWhiteSmall.getFontHeight() + 4;
        if (!Res.isW176()) {
            this.res.menuAlphaSplitLine.draw(g, Res.ScreenW / 2, Y, 17);
        }
    }

    public void drawHelpAbout(Graphics g) {
        this.res.menuBgGfx.draw(g, 0, 0, 20);
        this.drawHelpAboutContent(g);
        this.drawButtons(g, -1, 107);
    }

    private void drawHelpAboutContent(Graphics g) {
        int scrollButtonY;
        String titleTxt = null;
        String contentTxt = null;
        int align = 0;
        if (this.game.gameState == 422) {
            titleTxt = this.res.txt[7];
            contentTxt = this.res.txt[26];
            align = 17;
        } else {
            titleTxt = this.res.txt[5];
            contentTxt = this.res.txt[25];
            align = 17;
        }
        int h_title = 36;
        if (Res.isW128()) {
            h_title = 20;
        }
        this.res.fontWhiteBig.drawString(g, titleTxt, Res.ScreenX, Res.ScreenY, Res.ScreenW, h_title, 3, true);
        int txtX = 10;
        int txtY = 42;
        int scrollBarW = 10;
        int txtW = Res.ScreenW - 20 - scrollBarW;
        int txtH = Res.ScreenH - 84;
        short[][] lineData = this.res.fontWhiteSmall.getLineData(contentTxt, txtW);
        this.maxScrollPos = lineData.length * 15;
        int scrollBarH = Res.ScreenH / 2;
        int scrollBarX = Res.ScreenX + Res.ScreenW - 10 - 2;
        int scrollBarY = (Res.ScreenH - scrollBarH) / 2;
        int scrollButtonSize = scrollBarH / 10;
        if (!Res.isW128() && this.game.gameState != 422) {
            scrollButtonSize = scrollBarH;
        }
        if ((scrollButtonY = scrollBarY + (scrollBarH - scrollButtonSize) * this.txtScrollPos / -(this.maxScrollPos - Res.ScreenH / 2)) > scrollBarY + (scrollBarH - scrollButtonSize)) {
            scrollButtonY = scrollBarY + (scrollBarH - scrollButtonSize);
        }
        if (scrollButtonSize < scrollBarY) {
            Res.resetClip(g);
            g.setColor(7468031);
            g.fillRoundRect(scrollBarX, scrollBarY - 1, scrollBarW, scrollBarH + 2, 0, 0);
            for (int i = 0; i < 2; ++i) {
                Res.resetClip(g);
                g.setColor(0xFFFC00);
                g.fillRoundRect(scrollBarX + 1, scrollButtonY, scrollBarW - 2, scrollButtonSize, 0, 0);
            }
        } else {
            txtY += (320 - this.txtScrollPos - txtH) / 2;
        }
        if (this.game.gameState == 412 || this.game.gameState == 203) {
            if (Res.isW128()) {
                txtH = 288;
                txtY = 20;
                txtX = 4;
            } else if (Res.is352x416()) {
                txtH = 320;
                txtW = 160;
                txtY = 120;
                txtX = 32;
            } else if (Res.is320x240()) {
                txtH = 320;
                txtW = 160;
                txtY = 56;
                txtX = 32;
            } else {
                txtH = 320;
                txtY = 32;
            }
        } else if (Res.isW128()) {
            txtY -= 20;
            txtH += 48;
        } else if (Res.isW176()) {
            txtY = 32;
            txtH = 272;
        }
        g.setClip(0, 0, Res.ScreenW, Res.ScreenH);
        this.res.fontWhiteSmall.setArea(true, txtX, txtY, txtW, txtH);
        if (this.game.gameState != 422) {
            this.res.fontWhiteSmall.drawString(g, contentTxt, txtX, txtY + this.txtScrollPos, txtW, txtH - this.txtScrollPos, 20);
        } else {
            this.res.fontWhiteSmall.drawString(g, contentTxt, txtX, txtY + this.txtScrollPos, txtW, txtH - this.txtScrollPos, align);
        }
        this.res.fontWhiteSmall.setArea(false, 0, 0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawChooseBike(Graphics g) {
        this.res.menuBgGfx.draw(g, 0, 0, 20);
        int y1 = 20;
        int y2 = 18;
        if (Res.isW128()) {
            this.res.fontWhiteSmall.drawString(g, this.res.txt[29], Res.ScreenW / 2, 8, 3, true);
        } else {
            this.res.fontWhiteBig.drawString(g, this.res.txt[11], Res.ScreenW / 2, y1, 33);
            this.res.fontWhiteSmall.drawString(g, this.res.txt[29], 0, y2, Res.ScreenW, 18, 3, true);
        }
        this.drawButtons(g, 108, 107);
        if (!(Res.isW128() || Res.isHI() && !Res.isW240())) {
            try {
                this.g3d.bindTarget(g);
                this.g3d.clear();
                if (this.isChangingColor == 0) {
                    this.bikeRotateTrans.rotateWorldZ(5.0f);
                }
                int humanMeshIndex = 5;
                this.res.bikeMesh.setAppearance(this.res.bikeAddApp);
                this.res.humanMeshes[5].setAppearance(this.res.humanAddApp);
                LQTransform trans2 = LQFactory.LQTransform(this.bikeRotateTrans);
                LQTransform transLow = LQFactory.LQTransform(this.bikeRotateTrans);
                trans2.rotateX(180.0f);
                LQTransform trans = this.bikeRotateTrans;
                if (Res.isSB240_29X() || Res.isSB240() || Res.is320x240()) {
                    trans2.scale(0.7f, 0.7f, 0.7f);
                    trans2.translate(0.0f, -4.0f, 0.0f);
                    transLow.scale(0.8f, 0.8f, 0.8f);
                    transLow.translate(0.0f, 4.0f, 0.0f);
                    trans = transLow;
                }
                this.g3d.render(this.res.bikeMesh, trans2);
                this.g3d.render(this.res.humanMeshes[5], trans2);
                this.res.bikeMesh.setAppearance(this.res.bikeReplaceApp);
                this.res.humanMeshes[5].setAppearance(this.res.humanReplaceApp);
                this.g3d.render(this.res.bikeMesh, trans);
                this.g3d.render(this.res.humanMeshes[5], trans);
                this.g3d.flush();
            }
            finally {
                this.g3d.releaseTarget();
            }
        }
        int Y = 42;
        int lineWidth = Res.ScreenW - 20;
        int menuIndex = 0;
        if (Res.isW128()) {
            Y = 26;
        } else if (Res.isSB240_29X()) {
            Y += 116;
        } else if (Res.is352x416()) {
            Y += 230;
        } else {
            Y = Res.isW176() ? (Y += 52) : (Y += 150);
            if (Res.isSB240()) {
                Y -= 56;
            }
            if (Res.is320x240()) {
                Y = 119;
            }
        }
        int colorGridSize = Res.ScreenW / 10;
        int colorMargin = colorGridSize / 8;
        int colorGridNum = 8;
        if (this.currMenu.getSelectedIndex() == menuIndex) {
            UI.drawMessageBox(g, Res.menuWhiteBar, (Res.ScreenW - lineWidth) / 2, Y - 1, lineWidth, 15 + colorGridSize + 15, 0, 0, 0);
        }
        this.res.fontWhiteMid.drawString(g, this.res.txt[51], Res.ScreenW / 2, Y, 17);
        this.drawArrow(g, 2, colorGridSize, (Y += 15) + colorGridSize / 2, 10);
        this.drawArrow(g, 3, Res.ScreenW - colorGridSize, Y + colorGridSize / 2, 6);
        Res.resetClip(g);
        int xGrid = 0;
        if (Res.isW128()) {
            xGrid = 6;
        }
        for (int i = 0; i < 8; ++i) {
            int index = i;
            int itemCount = this.currMenu.getItemByName(51).getItemCount();
            if (index < 0) {
                index += itemCount;
            }
            if (index >= itemCount) {
                index -= itemCount;
            }
            g.setColor(this.res.BikeColors[index]);
            g.fillRect(xGrid + colorGridSize + i * colorGridSize + colorMargin, Y + colorMargin, colorGridSize - colorMargin * 2, colorGridSize - colorMargin * 2);
        }
        g.setColor(0xEEFFEE);
        g.drawRect(xGrid + colorGridSize + this.currMenu.getItemByName(51).getSelectedIndex() * colorGridSize, Y, colorGridSize - 1, colorGridSize - 1);
        ++menuIndex;
        Y += colorGridSize;
        this.res.fontWhiteMid.drawString(g, this.res.txt[43], Res.ScreenW / 2, Y += 15, 17);
        Y += 15;
        if (this.currMenu.getSelectedIndex() == menuIndex) {
            UI.drawMessageBox(g, Res.menuWhiteBar, (Res.ScreenW - lineWidth) / 2, Y - 1, lineWidth, 15, 0, 0, 0);
        }
        String typeOfTireStr = this.res.txt[this.currMenu.getItem(menuIndex).getSelectedItem().getName()];
        this.res.fontWhiteSmall.drawString(g, typeOfTireStr, 0, Y, Res.ScreenW, 15, 17);
        int strWidth = this.res.fontWhiteSmall.getLineWidth(typeOfTireStr.toCharArray()) + 10;
        this.drawArrow(g, 2, (Res.ScreenW - strWidth) / 2, Y + 7, 10);
        this.drawArrow(g, 3, (Res.ScreenW + strWidth) / 2, Y + 7, 6);
        Y += 15;
        if (this.currMenu.getSelectedIndex() == ++menuIndex) {
            UI.drawMessageBox(g, Res.menuWhiteBar, (Res.ScreenW - lineWidth) / 2, Y, lineWidth, 15, 0, 0, 0);
        }
        String hardnessOfTireStr = this.res.txt[this.currMenu.getItem(menuIndex).getSelectedItem().getName()];
        this.res.fontWhiteSmall.drawString(g, hardnessOfTireStr, 0, Y, Res.ScreenW, 15, 17);
        strWidth = this.res.fontWhiteSmall.getLineWidth(hardnessOfTireStr.toCharArray()) + 10;
        this.drawArrow(g, 2, (Res.ScreenW - strWidth) / 2, Y + 7, 10);
        this.drawArrow(g, 3, (Res.ScreenW + strWidth) / 2, Y + 7, 6);
        Y += 15;
    }

    public void drawQuickRaceGhost(Graphics g) {
        this.drawMainMenu(g);
    }

    private void drawChooseQuickRace2(Graphics g) {
        int Y = 48;
        int lineWidth = Res.ScreenW - 20;
        int menuIndex = 0;
        String str = this.res.txt[this.currMenu.getItem(menuIndex).getSelectedItem().getName()];
        int strWidth = this.res.fontWhiteSmall.getLineWidth(str.toCharArray()) + 10;
        this.res.menuBgGfx.draw(g, 0, 0, 20);
        if (Res.isW128()) {
            Y = Res.isH160() ? 24 : 4;
        } else {
            this.res.fontWhiteBig.drawString(g, this.res.txt[42], Res.ScreenW / 2, 20, 33, true);
        }
        menuIndex = 2;
        if (this.currMenu.getSelectedIndex() == menuIndex) {
            UI.drawMessageBox(g, Res.menuWhiteBar, (Res.ScreenW - lineWidth) / 2, Y - 3, lineWidth, 30, 0, 0, 0);
        }
        if (this.currMenu.getSelectedIndex() == menuIndex + 1 && this.quickRaceMenu.getItemByName(30).getSelectedItem().getName() == 39) {
            int y1 = Y + 30;
            UI.drawMessageBox(g, Res.menuWhiteBar, (Res.ScreenW - lineWidth) / 2, y1 - 3 - 30, lineWidth, 60, 0, 0, 0);
        }
        this.res.fontWhiteMid.drawString(g, this.res.txt[this.currMenu.getItem(menuIndex).getName()], 0, Y, Res.ScreenW, 15, 17);
        str = "" + this.currMenu.getItem(menuIndex).getSelectedItem().getName();
        this.res.fontWhiteSmall.drawString(g, str, 0, Y += 15, Res.ScreenW, 15, 17);
        strWidth = this.res.fontWhiteSmall.getLineWidth(str.toCharArray()) + 10;
        this.drawArrow(g, 2, (Res.ScreenW - strWidth) / 2, Y + 7, 10);
        this.drawArrow(g, 3, (Res.ScreenW + strWidth) / 2, Y + 7, 6);
        Y += 15;
        if (this.currMenu.getSelectedIndex() == ++menuIndex && this.quickRaceMenu.getItemByName(30).getSelectedItem().getName() != 39) {
            UI.drawMessageBox(g, Res.menuWhiteBar, (Res.ScreenW - lineWidth) / 2, Y - 3, lineWidth, 30, 0, 0, 0);
        }
        this.res.fontWhiteMid.drawString(g, this.res.txt[this.currMenu.getItem(menuIndex).getName()], 0, Y, Res.ScreenW, 15, 17);
        str = "" + this.currMenu.getItem(menuIndex).getSelectedItem().getName();
        this.res.fontWhiteSmall.drawString(g, str, 0, Y += 15, Res.ScreenW, 15, 17);
        strWidth = this.res.fontWhiteSmall.getLineWidth(str.toCharArray()) + 10;
        this.drawArrow(g, 2, (Res.ScreenW - strWidth) / 2, Y + 7, 10);
        this.drawArrow(g, 3, (Res.ScreenW + strWidth) / 2, Y + 7, 6);
        this.res.menuAlphaSplitLine.draw(g, Res.ScreenW / 2, (Y += 15) + 7, 17);
        Y += 15;
        if (this.currMenu.getSelectedIndex() == ++menuIndex) {
            UI.drawMessageBox(g, Res.menuWhiteBar, (Res.ScreenW - lineWidth) / 2, Y - 3, lineWidth, 30, 0, 0, 0);
        }
        this.res.fontWhiteMid.drawString(g, this.res.txt[this.currMenu.getItem(menuIndex).getName()], 0, Y, Res.ScreenW, 15, 17);
        str = this.res.txt[this.currMenu.getItem(menuIndex).getSelectedItem().getName()];
        this.res.fontWhiteSmall.drawString(g, str, 0, Y += 15, Res.ScreenW, 15, 17);
        strWidth = this.res.fontWhiteSmall.getLineWidth(str.toCharArray()) + 10;
        this.drawArrow(g, 2, (Res.ScreenW - strWidth) / 2, Y + 7, 10);
        this.drawArrow(g, 3, (Res.ScreenW + strWidth) / 2, Y + 7, 6);
        Y += 15;
        if (!this.game.msgt.isHaveMessage()) {
            this.drawButtons(g, 108, 107);
        }
    }

    private void drawChooseQuickRace(Graphics g) {
        int Y;
        if (Res.isSB240_29X()) {
            Y = 24;
        } else if (Res.is352x416()) {
            Y = 80;
        } else {
            Y = 42;
            if (Res.isSB240()) {
                Y = 32;
            }
        }
        int lineWidth = Res.ScreenW - 20;
        if (this.res.menuBgGfx == null) {
            System.out.println("err:drawLevelResult(menuBgGfx==null)");
            this.res.menuBgGfx = new LQGfx(Res.DIR + "menu_bg.png");
        }
        this.res.menuBgGfx.draw(g, 0, 0, 20);
        if (Res.isW128()) {
            Y = Res.isH160() ? 12 : 4;
        } else {
            this.res.fontWhiteBig.drawString(g, this.res.txt[42], Res.ScreenW / 2, 20, 33, true);
        }
        int menuIndex = 0;
        if (this.currMenu.getSelectedIndex() == menuIndex && !this.game.msgt.isHaveMessage()) {
            UI.drawMessageBox(g, Res.menuWhiteBar, (Res.ScreenW - lineWidth) / 2, Y - 3, lineWidth, 30, 0, 0, 0);
        }
        this.res.fontWhiteMid.drawString(g, this.res.txt[this.currMenu.getItem(menuIndex).getName()], 0, Y, Res.ScreenW, 15, 17);
        String str = this.res.txt[this.currMenu.getItem(menuIndex).getSelectedItem().getName()];
        this.res.fontWhiteSmall.drawString(g, str, 0, Y += 15, Res.ScreenW, 15, 17);
        int strWidth = this.res.fontWhiteSmall.getLineWidth(str.toCharArray()) + 10;
        this.drawArrow(g, 2, (Res.ScreenW - strWidth) / 2, Y + 7, 10);
        this.drawArrow(g, 3, (Res.ScreenW + strWidth) / 2, Y + 7, 6);
        Y += 15;
        if (this.currMenu.getSelectedIndex() == ++menuIndex && !this.game.msgt.isHaveMessage()) {
            int h_track = 75 + this.res.menuCurcuitThumb.getHeight();
            if (Res.isSB240_29X() || Res.isSB240()) {
                h_track -= 30;
            }
            UI.drawMessageBox(g, Res.menuWhiteBar, (Res.ScreenW - lineWidth) / 2, Y - 3, lineWidth, h_track, 0, 0, 0);
        }
        this.res.fontWhiteMid.drawString(g, this.res.txt[this.currMenu.getItem(menuIndex).getName()], 0, Y, Res.ScreenW, 15, 17);
        int gridWidth = this.res.menuCurcuitThumb.getWidth() / 15;
        this.res.menuCurcuitThumb.draw(g, Res.ScreenW / 2, Y += 15, this.currMenu.getItemByName(31).getSelectedIndex() * gridWidth, 0, gridWidth, this.res.menuCurcuitThumb.getHeight(), 17);
        this.drawArrow(g, 2, (Res.ScreenW - gridWidth * 3 / 2) / 2, Y + this.res.menuCurcuitThumb.getHeight() / 2, 10);
        this.drawArrow(g, 3, (Res.ScreenW + gridWidth * 3 / 2) / 2, Y + this.res.menuCurcuitThumb.getHeight() / 2, 6);
        strWidth = this.res.menuCurcuitThumb.getWidth() + 10;
        this.drawArrow(g, 2, (Res.ScreenW - strWidth) / 2, Y + this.res.menuCurcuitThumb.getHeight() / 2, 10);
        this.drawArrow(g, 3, (Res.ScreenW + strWidth) / 2, Y + this.res.menuCurcuitThumb.getHeight() / 2, 6);
        Res.resetClip(g);
        g.setColor(0x779977);
        g.drawRect((Res.ScreenW - gridWidth) / 2 - 1, Y - 1, gridWidth + 2, this.res.menuCurcuitThumb.getHeight() + 2);
        if (this.quickRaceMenu.getItemByName(30).getSelectedItem().getName() == 40 && !this.res.userProfile.hasGhostData(this.quickRaceMenu.getItem(1).getSelectedIndex())) {
            UI.drawMessageBox(g, Res.menuBlackBar, (Res.ScreenW - gridWidth) / 2, Y, gridWidth + 2 - 1, this.res.menuCurcuitThumb.getHeight() + 2 - 1, 0, 0, 0);
            this.res.menuLockGfx.draw(g, Res.ScreenW / 2, Y + this.res.menuCurcuitThumb.getHeight() / 2, 3);
        }
        Y += this.res.menuCurcuitThumb.getHeight();
        if (!Res.isSB240_29X() && !Res.isSB240()) {
            Y += 15;
        }
        this.res.fontWhiteSmall.drawString(g, this.res.txt[this.currMenu.getItem(menuIndex).getSelectedItem().getName()], 0, Y, Res.ScreenW, 15, 17);
        this.res.fontWhiteSmall.drawString(g, this.res.txt[Txt.TrackCountries[this.currMenu.getItem(menuIndex).getSelectedIndex()]], 0, Y += 15, Res.ScreenW, 15, 17);
        if (!this.game.msgt.isHaveMessage()) {
            this.drawButtons(g, 108, 107);
        }
        if (Res.isW128() || Res.isW176()) {
            return;
        }
        Y += 15;
        if (!Res.isSB240() && !Res.isSB240_29X()) {
            this.res.menuAlphaSplitLine.draw(g, Res.ScreenW / 2, (Y += 15) + 7, 17);
        }
        if (!Res.is320x240()) {
            Y += 15;
        }
        if (this.currMenu.getSelectedIndex() == ++menuIndex) {
            UI.drawMessageBox(g, Res.menuWhiteBar, (Res.ScreenW - lineWidth) / 2, Y - 3, lineWidth, 30, 0, 0, 0);
        }
        if (this.quickRaceMenu.getItemByName(30).getSelectedItem().getName() == 39 && this.currMenu.getSelectedIndex() == menuIndex + 1) {
            int Y1 = Y + 15 + 15;
            UI.drawMessageBox(g, Res.menuWhiteBar, (Res.ScreenW - lineWidth) / 2, Y1 - 3 - 30, lineWidth, 60, 0, 0, 0);
        }
        this.res.fontWhiteMid.drawString(g, this.res.txt[this.currMenu.getItem(menuIndex).getName()], 0, Y, Res.ScreenW, 15, 17);
        str = "" + this.currMenu.getItem(menuIndex).getSelectedItem().getName();
        this.res.fontWhiteSmall.drawString(g, str, 0, Y += 15, Res.ScreenW, 15, 17);
        strWidth = this.res.fontWhiteSmall.getLineWidth(str.toCharArray()) + 10;
        this.drawArrow(g, 2, (Res.ScreenW - strWidth) / 2, Y + 7, 10);
        this.drawArrow(g, 3, (Res.ScreenW + strWidth) / 2, Y + 7, 6);
        Y += 15;
        if (this.currMenu.getSelectedIndex() == ++menuIndex && this.quickRaceMenu.getItemByName(30).getSelectedItem().getName() != 39) {
            UI.drawMessageBox(g, Res.menuWhiteBar, (Res.ScreenW - lineWidth) / 2, Y - 3, lineWidth, 30, 0, 0, 0);
        }
        this.res.fontWhiteMid.drawString(g, this.res.txt[this.currMenu.getItem(menuIndex).getName()], 0, Y, Res.ScreenW, 15, 17);
        str = "" + this.currMenu.getItem(menuIndex).getSelectedItem().getName();
        this.res.fontWhiteSmall.drawString(g, str, 0, Y += 15, Res.ScreenW, 15, 17);
        strWidth = this.res.fontWhiteSmall.getLineWidth(str.toCharArray()) + 10;
        this.drawArrow(g, 2, (Res.ScreenW - strWidth) / 2, Y + 7, 10);
        this.drawArrow(g, 3, (Res.ScreenW + strWidth) / 2, Y + 7, 6);
        if (!Res.isSB240()) {
            this.res.menuAlphaSplitLine.draw(g, Res.ScreenW / 2, (Y += 15) + 7, 17);
        }
        Y += 15;
        if (this.currMenu.getSelectedIndex() == ++menuIndex) {
            UI.drawMessageBox(g, Res.menuWhiteBar, (Res.ScreenW - lineWidth) / 2, Y - 3, lineWidth, 30, 0, 0, 0);
        }
        this.res.fontWhiteMid.drawString(g, this.res.txt[this.currMenu.getItem(menuIndex).getName()], 0, Y, Res.ScreenW, 15, 17);
        str = this.res.txt[this.currMenu.getItem(menuIndex).getSelectedItem().getName()];
        this.res.fontWhiteSmall.drawString(g, str, 0, Y += 15, Res.ScreenW, 15, 17);
        strWidth = this.res.fontWhiteSmall.getLineWidth(str.toCharArray()) + 10;
        this.drawArrow(g, 2, (Res.ScreenW - strWidth) / 2, Y + 7, 10);
        this.drawArrow(g, 3, (Res.ScreenW + strWidth) / 2, Y + 7, 6);
        Y += 15;
    }

    private void drawHighScore(Graphics g) {
        this.res.menuBgGfx.draw(g, 0, 0, 20);
        int Y = 80;
        Y = Res.getScaleHeight(Y);
        Y = Res.getScaleHeight(Y);
        this.res.fontWhiteBig.drawString(g, this.res.txt[148], Res.ScreenW / 2, Y, 17, true);
        this.res.fontWhiteMid.drawString(g, this.res.txt[Txt.TrackNames[this.currMenu.getSelectedIndex()]], Res.ScreenW / 2, Y += Res.getScaleHeight(48), 17);
        int gridWidth = this.res.menuCurcuitThumb.getWidth() / 15;
        this.res.menuCurcuitThumb.draw(g, Res.ScreenW / 2, Y += 24, this.currMenu.getSelectedIndex() * gridWidth, 0, gridWidth, this.res.menuCurcuitThumb.getHeight(), 17);
        int strWidth = 80;
        int Y_lock = Y + this.res.menuCurcuitThumb.getHeight() / 2;
        this.drawArrow(g, 2, (Res.ScreenW - strWidth) / 2, Y_lock, 10);
        this.drawArrow(g, 3, (Res.ScreenW + strWidth) / 2, Y_lock, 6);
        Res.resetClip(g);
        g.setColor(0x779977);
        g.drawRect((Res.ScreenW - gridWidth) / 2 - 1, Y - 1, gridWidth + 2, this.res.menuCurcuitThumb.getHeight() + 2);
        Y += this.res.menuCurcuitThumb.getHeight() + 32;
        int time = this.res.userProfile.getBestTime(this.currMenu.getSelectedIndex());
        if (this.res.userProfile.ghostHS[this.currMenu.getSelectedIndex()].isOK && time != Integer.MAX_VALUE) {
            if (time > Design.MAX_TIME) {
                time = Design.MAX_TIME;
            }
            String timeStr = this.res.txt[118] + ":" + GameMain.getTimeString(time);
            this.res.fontWhiteMid.drawString(g, timeStr, Res.ScreenW / 2, Y, 3);
        } else {
            this.res.menuLockGfx.draw(g, Res.ScreenW / 2, Y_lock, 3);
        }
        this.drawButtons(g, -1, 107);
    }

    private void drawRaceDay(Graphics g) {
        if (this.res.menuBgGfx == null) {
            this.res.menuBgGfx = new LQGfx(Res.DIR + "menu_bg.png");
        }
        this.res.menuBgGfx.draw(g, 0, 0, 20);
        if (!Res.isW128()) {
            this.res.fontWhiteBig.drawString(g, this.res.txt[10], Res.ScreenW / 2, 18, 3, true);
        }
        this.drawButtons(g, 108, 107);
        int Y = 42;
        int X = 10;
        int lineWidth = Res.ScreenW - 20;
        int itemY = (Res.ScreenH - 20 * this.currMenu.count()) / 2;
        if (Res.isW128() || Res.isW176()) {
            itemY = Res.ScreenH - 20 * this.currMenu.count() - 16;
            if (Res.isH160()) {
                itemY -= 24;
            }
        }
        if (Res.isSB240() || Res.isSB240_29X()) {
            itemY += 8;
        } else if (Res.is320x240()) {
            itemY = 40;
        }
        for (int i = 0; i < this.currMenu.count(); ++i) {
            int y_raceDay = itemY + 20 * i;
            if (i == 1) continue;
            if (i == 0) {
                y_raceDay += 24;
            }
            if (i == this.currMenu.getSelectedIndex()) {
                UI.drawMessageBox(g, Res.menuWhiteBar, (Res.ScreenW - lineWidth) / 2, y_raceDay - 3, lineWidth, 20, 0, 0, 0);
            }
            this.res.fontWhiteBig.drawString(g, this.res.txt[this.currMenu.getItem(i).getName()], 0, y_raceDay, Res.ScreenW, 20, 17, true);
        }
        int levelIndex = this.res.userProfile.getChampLevel();
        Y += 15;
        int gridWidth = this.res.menuCurcuitThumb.getWidth() / 15;
        int X_map = Res.ScreenW / 2 + gridWidth / 2;
        int a_x_map = 4;
        if (!Res.isW128()) {
            if (Res.isW176()) {
                X_map = Res.ScreenW / 2;
                a_x_map = 1;
                Y = 36;
                this.res.menuAlphaCircuitBG.draw(g, X_map, Y + this.res.menuCurcuitThumb.getHeight() / 2, a_x_map | 2);
                this.res.menuCurcuitThumb.draw(g, X_map, Y, gridWidth * levelIndex, 0, gridWidth, this.res.menuCurcuitThumb.getHeight(), a_x_map | 0x10);
            } else {
                this.res.menuAlphaCircuitBG.draw(g, X_map, Y + this.res.menuCurcuitThumb.getHeight() / 2, a_x_map | 2);
                this.res.menuCurcuitThumb.draw(g, X_map += 4, Y, gridWidth * levelIndex, 0, gridWidth, this.res.menuCurcuitThumb.getHeight(), a_x_map | 0x10);
            }
        }
        int a_info = 4;
        int w_info = Res.ScreenW / 2;
        if (Res.isW128()) {
            Y = 12;
            a_info = 1;
            X = 0;
            w_info = Res.ScreenW;
        } else if (Res.isW176()) {
            Y = 36 + this.res.menuCurcuitThumb.getHeight() + 16;
            a_info = 1;
            X = 0;
            w_info = Res.ScreenW;
        } else if (Res.is352x416()) {
            X += 40;
        } else if (Res.is320x240()) {
            X += 32;
            Y = 42;
        }
        this.res.fontWhiteMid.drawString(g, this.res.txt[54] + " " + (this.res.userProfile.getChampRaceDay() + 1), X, Y, w_info, 15, a_info | 0x10);
        String trackTitle = this.res.txt[Txt.TrackCountries[levelIndex]];
        trackTitle = trackTitle + " - " + this.res.txt[Txt.TrackNames[levelIndex]];
        this.res.fontWhiteSmall.drawString(g, trackTitle, X, Y += 15, Res.ScreenW - 12, 75, a_info | 0x10);
        Y += 15;
        if (!Res.isW128()) {
            String weatherStr = this.res.txt[34] + ": ";
            weatherStr = this.game.getLevelCustom().weather == 0 ? weatherStr + this.res.txt[35] : weatherStr + this.res.txt[36];
            this.res.fontWhiteSmall.drawString(g, weatherStr, X, Y, w_info, 15, a_info | 0x10);
        }
        if (Res.isW128() || Res.isW176()) {
            return;
        }
        Y = Res.ScreenH - 40;
        this.res.menuAlphaSplitLine.draw(g, Res.ScreenW / 2, Y, 17);
        int Y1 = Y -= 75;
        if (Res.isSB240() || Res.isSB240_29X()) {
            Y += 15;
            Y1 += 30;
        }
        this.res.menuAlphaSplitLine.draw(g, Res.ScreenW / 2, Y1, 17);
        this.res.fontWhiteSmall.drawString(g, this.res.txt[126], X, Y += 15, Res.ScreenW - X * 2, 45, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawBikeEnhance(Graphics g) {
        int y_infoPoints;
        this.res.menuBgGfx.draw(g, 0, 0, 20);
        this.res.fontWhiteBig.drawString(g, this.res.txt[57], Res.ScreenW / 2, 20, 33, true);
        this.drawButtons(g, 108, 107);
        if (Res.isW240()) {
            try {
                this.g3d.bindTarget(g);
                this.g3d.clear();
                if (this.isChangingColor == 0) {
                    this.bikeRotateTrans.rotateWorldZ(5.0f);
                }
                this.res.bikeMesh.setAppearance(this.res.bikeAddApp);
                LQTransform trans2 = LQFactory.LQTransform(this.bikeRotateTrans);
                trans2.rotateX(180.0f);
                this.g3d.render(this.res.bikeMesh, trans2);
                this.res.bikeMesh.setAppearance(this.res.bikeReplaceApp);
                this.g3d.render(this.res.bikeMesh, this.bikeRotateTrans);
                this.g3d.flush();
            }
            finally {
                this.g3d.releaseTarget();
            }
        }
        int Y = Res.ScreenH / 2;
        if (Res.isW128() || Res.isW176()) {
            Y = this.res.fontWhiteMid.getFontHeight() + 24 + 32;
        } else if (Res.is352x416()) {
            Y += 8;
        }
        int lineWidth = Res.ScreenW - 20;
        String[] propertyNames = new String[]{this.res.txt[103], this.res.txt[104], this.res.txt[105], this.res.txt[106]};
        int[] strWidths = new int[propertyNames.length];
        for (int i = 0; i < propertyNames.length; ++i) {
            strWidths[i] = this.res.fontWhiteMid.getLineWidth(propertyNames[i].toCharArray());
        }
        int maxStrWidth = 0;
        for (int i = 0; i < propertyNames.length; ++i) {
            if (strWidths[i] <= maxStrWidth) continue;
            maxStrWidth = strWidths[i];
        }
        int X = 18 + maxStrWidth;
        if (Res.isW128()) {
            X = 152;
        }
        int barWidth = (Res.ScreenW - 20 - maxStrWidth - 16) / 2;
        int barHeight = 10;
        for (int i = 0; i < propertyNames.length; ++i) {
            if (i == this.currMenu.getSelectedIndex()) {
                UI.drawMessageBox(g, Res.menuWhiteBar, (Res.ScreenW - lineWidth) / 2, Y - (15 - barHeight) / 2, lineWidth, 15, 0, 0, 0);
            }
            this.res.fontWhiteMid.drawString(g, propertyNames[i], X - lineWidth, Y, lineWidth, barHeight, 10);
            Res.resetClip(g);
            int tmpY = Y;
            int greenRectWidth = barWidth * this.tmpBikeProperties[i] / Design.BikeEnhancePoints[i].length;
            g.setColor(0xFF0000);
            g.fillRect(X + 6, tmpY + 2, greenRectWidth, barHeight - 3);
            if (i == this.currMenu.getSelectedIndex()) {
                g.setColor(0xFFFF00);
                g.fillRect(X + 6 + greenRectWidth, tmpY + 2, barWidth / Design.BikeEnhancePoints[i].length, barHeight - 3);
            }
            if (i == this.currMenu.getSelectedIndex()) {
                int neededPoints = this.res.userProfile.getNeededPoints(i + 0, this.tmpBikeProperties[i]);
                if (neededPoints <= this.tmpBikePoints) {
                    g.setColor(65280);
                } else {
                    g.setColor(0x880000);
                }
            } else {
                g.setColor(0x333333);
            }
            g.drawRect(X + 4, tmpY, barWidth + 3, barHeight);
            if (Res.isW128()) {
                Y += 13;
                continue;
            }
            Y += 15;
        }
        if (Res.isW128()) {
            y_infoPoints = 18;
        } else if (Res.isSB240_29X()) {
            y_infoPoints = 24;
        } else {
            y_infoPoints = Res.ScreenY + 36;
            if (Res.isSB240()) {
                y_infoPoints = 18;
            }
        }
        if (Res.isW128() || Res.isW176()) {
            y_infoPoints = 24;
        }
        if (!Res.isW128()) {
            UI.drawMessageBox(g, Res.menuWhiteBar, 10, y_infoPoints, lineWidth, 30, 0, 0, 0);
        }
        int strW = this.res.fontWhiteMid.getLineWidth((this.res.txt[122] + ":").toCharArray());
        int x_info = 14;
        if (Res.isW128()) {
            x_info = 2;
        }
        this.res.fontWhiteMid.drawString(g, this.res.txt[122] + ":", x_info, y_infoPoints, lineWidth, 30, 6);
        int pointsX = x_info + strW + 10;
        int totalPoints = this.tmpBikePoints;
        this.res.fontNumWhiteBig.drawString(g, "" + totalPoints, pointsX, y_infoPoints, Res.ScreenW, 30, 6);
        int neededPoints = this.res.userProfile.getNeededPoints(this.currMenu.getSelectedIndex() + 0, this.tmpBikeProperties[this.currMenu.getSelectedIndex()]);
        this.res.fontWhiteMid.drawString(g, " - " + neededPoints, pointsX + this.res.fontNumWhiteBig.getLineWidth("00000".toCharArray()), y_infoPoints, Res.ScreenW, 30, 6);
        if (Res.isW128()) {
            return;
        }
        Y = Res.ScreenH - 20;
        if (Res.is352x416()) {
            Y -= 16;
        } else if (Res.is320x240()) {
            Y += 16;
        }
        if (!(!Res.isW240() || Res.isSB240() || Res.isSB240_29X() || Res.is352x416() || Res.is320x240())) {
            this.res.menuAlphaSplitLine.draw(g, Res.ScreenW / 2, Y, 17);
        }
        Y -= 75;
        if (Res.isW240() && !Res.isSB240() && !Res.isSB240_29X() && !Res.is320x240()) {
            this.res.menuAlphaSplitLine.draw(g, Res.ScreenW / 2, Y, 17);
        }
        this.res.fontWhiteSmall.drawString(g, this.res.txt[127], 10, Y += 15, Res.ScreenW - 20, 45, 3);
    }

    private void drawTraining(Graphics g) {
        this.res.menuBgGfx.draw(g, 0, 0, 20);
        this.res.fontWhiteBig.drawString(g, this.res.txt[41], Res.ScreenW / 2, 20, 33, true);
        int Y = 42;
        int X = 10;
        int lineWidth = Res.ScreenW - 20;
        int itemY = Res.isSB240() ? Y - 8 : (Res.isSB240_29X() ? Y + 10 : Y + 32);
        if (Res.isW128() || Res.isW176()) {
            itemY = 32;
        } else if (Res.is352x416()) {
            itemY += 32;
        } else if (Res.is320x240()) {
            itemY = 38;
        }
        UI.drawMessageBox(g, Res.menuWhiteBar, (Res.ScreenW - lineWidth) / 2, itemY - 3 + this.currMenu.getSelectedIndex() * 20, lineWidth, 20, 0, 0, 0);
        for (int i = 0; i < this.currMenu.count(); ++i) {
            this.res.fontWhiteBig.drawString(g, this.res.txt[this.currMenu.getItem(i).getName()], 0, itemY + 20 * i, Res.ScreenW, 20, 17, true);
        }
        if (Res.is352x416()) {
            Y -= 32;
        }
        if (Res.isW240()) {
            Y = Res.ScreenH - 40;
            if (!Res.is320x240()) {
                this.res.menuAlphaSplitLine.draw(g, Res.ScreenW / 2, Y, 17);
            }
            Y -= 120;
            if (Res.is320x240()) {
                Y += 48;
            }
            this.res.menuAlphaSplitLine.draw(g, Res.ScreenW / 2, Y, 17);
            Y += 15;
        }
        int tip = 0;
        switch (this.currMenu.getSelectedItem().getName()) {
            case 60: {
                tip = 130;
                break;
            }
            case 61: {
                tip = 131;
                break;
            }
            case 64: {
                tip = 134;
                break;
            }
            case 62: {
                tip = 133;
                break;
            }
            case 63: {
                tip = 132;
            }
        }
        if (!Res.isW128()) {
            if (Res.isW176()) {
                Y = 304;
                this.drawTrainingHelp(g, Y);
            } else {
                this.res.fontWhiteSmall.drawString(g, this.res.txt[tip], 10, Y, 220, 120, 17);
            }
        }
        this.drawButtons(g, 108, 107);
    }

    private void drawTireConfig(Graphics g) {
        this.res.menuBgGfx.draw(g, 0, 0, 20);
        this.drawButtons(g, 108, 107);
        this.res.fontWhiteBig.drawString(g, this.res.txt[43], Res.ScreenW / 2, 18, 3, true);
        int Y = 42;
        if (Res.isW128() || Res.isW176()) {
            Y = 10;
        } else if (Res.is352x416()) {
            Y += 40;
        } else if (Res.is320x240()) {
            Y = 40;
        }
        int lineWidth = Res.ScreenW / 2 - 20;
        if (this.res.menuTireConfigBG == null) {
            this.res.menuTireConfigBG = Res.createFixedMsgBox(lineWidth, 15, 10, 9734);
            this.res.menuTireConfigBG.setAlpha(50);
        }
        this.res.fontWhiteMid.drawString(g, this.res.txt[49], 0, Y += 20, Res.ScreenW / 2, Res.ScreenH, 17);
        this.res.fontWhiteMid.drawString(g, this.res.txt[50], Res.ScreenW / 2, Y, Res.ScreenW / 2, Res.ScreenH, 17);
        Y += 15;
        String tireTypeStr = this.res.txt[44] + '\n' + this.res.txt[45];
        String tireHardnessStr = this.res.txt[46] + '\n' + this.res.txt[47] + '\n' + this.res.txt[48];
        int[] nArray = new int[2];
        nArray[0] = (Res.ScreenW / 2 - lineWidth) / 2;
        nArray[1] = Res.ScreenW / 2 + (Res.ScreenW / 2 - lineWidth) / 2;
        int[] bar_x = nArray;
        int[] bar_y = new int[]{Y + this.game.getPlayerBikeCustom().tireType * 15, Y + this.game.getPlayerBikeCustom().tireHardness * 15};
        for (int i = 0; i < 2; ++i) {
            if (this.tireConfigChosenIndex == i) {
                UI.drawMessageBox(g, Res.menuWhiteBar, bar_x[i], bar_y[i], lineWidth, 15, 0, 0, 0);
                continue;
            }
            this.res.menuTireConfigBG.draw(g, bar_x[i], bar_y[i], 20);
        }
        this.res.fontWhiteSmall.drawString(g, tireTypeStr, 0, Y, Res.ScreenW / 2, Res.ScreenH, 17);
        this.res.fontWhiteSmall.drawString(g, tireHardnessStr, Res.ScreenW / 2, Y, Res.ScreenW / 2, Res.ScreenH, 17);
        if (Res.isW128()) {
            return;
        }
        if (!Res.is320x240()) {
            Y += 30;
        }
        Y += 20;
        if (Res.isW240()) {
            Y += 15;
        }
        if (!Res.is320x240()) {
            this.res.menuAlphaSplitLine.draw(g, Res.ScreenW / 2, Y, 17);
        }
        if (Res.isW240()) {
            Y += 15;
        }
        this.res.fontWhiteSmall.drawString(g, this.res.txt[128], 10, Y, Res.ScreenW / 2 - 20, 90, 3);
        this.res.fontWhiteSmall.drawString(g, this.res.txt[129], Res.ScreenW / 2 + 10, Y, Res.ScreenW / 2 - 20, 90, 3);
        Y += 90;
        Y += 15;
        if (Res.isW240() && !Res.isSB240()) {
            this.res.menuAlphaSplitLine.draw(g, Res.ScreenW / 2, Y, 17);
        }
        Y += 15;
    }

    private void drawLevelResult(Graphics g) {
        if (this.res.menuBgGfx == null) {
            System.out.println("err:drawLevelResult(menuBgGfx==null)");
            this.res.menuBgGfx = new LQGfx(Res.DIR + "menu_bg.png");
        }
        this.res.menuBgGfx.draw(g, 0, 0, 20);
        String title = "";
        switch (this.game.getLevelCustom().gameMode) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                title = this.res.txt[11];
            }
        }
        if (!Res.isW128()) {
            this.res.fontWhiteBig.drawString(g, title, Res.ScreenW / 2, 20, 33);
            this.res.fontWhiteBig.drawString(g, this.res.txt[115], 0, 36, Res.ScreenW, this.res.fontWhiteBig.getFontHeight() * 2, 3, true);
        }
        int drawX = Res.ScreenW / 4;
        int drawY = 36 + this.res.fontWhiteBig.getFontHeight() * 6;
        if (Res.isW128()) {
            drawX = 4;
            drawY = 4;
        } else if (Res.isW176()) {
            drawY = this.res.fontWhiteBig.getFontHeight() * 2 + this.res.fontWhiteBig.getFontHeight() + 32;
        }
        this.game.drawRaceResultRanks(g, drawX, drawY);
        this.drawButtons(g, 110, 173);
    }

    private void drawCongratulations(Graphics g) {
        if (this.res.menuBgGfx == null) {
            this.res.menuBgGfx = new LQGfx(Res.DIR + "menu_bg.png");
        }
        this.res.menuBgGfx.draw(g, 0, 0, 20);
        this.res.fontWhiteBig.drawString(g, this.res.txt[135], (Res.ScreenW - Res.ScreenW * 3 / 4) / 2, Res.ScreenH / 2 - 32, Res.ScreenW * 3 / 4, Res.ScreenH, 17, true);
        this.drawButtons(g, 110, -1);
    }

    private void drawChampResult(Graphics g) {
        this.res.load_menuBgGfx();
        this.res.menuBgGfx.draw(g, 0, 0, 20);
        int drawX = 0;
        int drawY = 0;
        if (!Res.isW128()) {
            String title = this.res.txt[10];
            this.res.fontWhiteBig.drawString(g, title, Res.ScreenW / 2, 20, 33);
            int Y = 36;
            if (Res.isW128() || Res.isW176()) {
                Y = 28;
            }
            this.res.fontWhiteBig.drawString(g, this.res.txt[53], 0, Y, Res.ScreenW, this.res.fontWhiteBig.getFontHeight() * 2, 3, true);
            drawX = Res.ScreenW / 4;
            drawY = Y + this.res.fontWhiteBig.getFontHeight() * 3;
            if (Res.isW128() || Res.isW176()) {
                drawY = Y + this.res.fontWhiteBig.getFontHeight() + 8;
            }
            String raceNum = this.res.txt[54] + " " + this.res.userProfile.getChampInfoLevel() + "/" + Design.ChampionshipCircuitLaps.length;
            this.res.fontWhiteMid.drawString(g, raceNum, Res.ScreenW / 2, drawY, 17);
            drawY += this.res.fontWhiteBig.getFontHeight() + 8;
        }
        this.drawChampRank(g, drawX, drawY);
        this.drawButtons(g, 110, -1);
    }

    private int drawChampRank(Graphics g, int drawX, int drawY) {
        int drawX1;
        int i;
        if (Res.isW240() && !Res.isSB240() && !Res.is320x240()) {
            this.res.menuAlphaSplitLine.draw(g, Res.ScreenW / 2, drawY += 15, 17);
            drawY += 15;
        }
        int x1 = drawX;
        int x2 = drawX + 36;
        int x3 = 3 * drawX;
        if (Res.isW128()) {
            x2 = x1 = 24;
            x3 = 100;
            drawY = 1;
        } else if (Res.isW176()) {
            x2 = x1 = 24;
            x3 += 12;
        }
        this.res.fontWhiteMid.drawString(g, this.res.txt[59].toLowerCase(), 120, drawY, 17, true);
        drawY += 15;
        if (Res.isW240() && !Res.is320x240()) {
            this.res.menuAlphaSplitLine.draw(g, Res.ScreenW / 2, drawY += 15, 17);
            drawY += 15;
        }
        int[] tR = this.res.userProfile.getChampTotalRanks();
        int[] totalRanks = new int[tR.length];
        for (int i2 = 0; i2 < totalRanks.length; ++i2) {
            totalRanks[i2] = tR[i2];
        }
        int[] riderIndices = new int[totalRanks.length];
        for (i = 0; i < riderIndices.length; ++i) {
            riderIndices[i] = i;
        }
        for (i = 0; i < totalRanks.length; ++i) {
            for (int j = i + 1; j < totalRanks.length; ++j) {
                if (totalRanks[j] <= totalRanks[i]) continue;
                int tmp = totalRanks[j];
                totalRanks[j] = totalRanks[i];
                totalRanks[i] = tmp;
                tmp = riderIndices[j];
                riderIndices[j] = riderIndices[i];
                riderIndices[i] = tmp;
            }
        }
        String posStr = "";
        String namesStr = "";
        String pointsStr = "";
        for (int i3 = 0; i3 < riderIndices.length; ++i3) {
            posStr = posStr + "" + (i3 + 1) + '\n';
            if (Res.isW128()) {
                if (RiderInfo.infos[riderIndices[i3]].name.length() < 12) {
                    namesStr = namesStr + RiderInfo.infos[riderIndices[i3]].name + '\n';
                } else {
                    int index1 = RiderInfo.infos[riderIndices[i3]].name.indexOf(" ");
                    if (index1 == -1) {
                        index1 = RiderInfo.infos[riderIndices[i3]].name.length();
                    }
                    namesStr = namesStr + RiderInfo.infos[riderIndices[i3]].name.substring(0, index1) + "..." + '\n';
                }
            } else {
                namesStr = namesStr + RiderInfo.infos[riderIndices[i3]].name + '\n';
            }
            pointsStr = pointsStr + "" + totalRanks[i3] + '\n';
        }
        int xP1 = drawX1 = 32;
        int xP2 = drawX1 + 20;
        int xP3 = 3 * drawX;
        if (Res.isW128()) {
            xP1 = 4;
            xP2 = 18;
            xP3 = 98;
            drawY = Res.isH160() ? 24 : 12;
        } else if (Res.isW176()) {
            xP1 = 8;
            xP2 = 20;
            xP3 += 12;
        }
        this.res.fontWhiteSmall.drawString(g, posStr, xP1, drawY, Res.ScreenW, Res.ScreenH, 20);
        this.res.fontWhiteSmall.drawString(g, namesStr, xP2, drawY, Res.ScreenW, Res.ScreenH, 20);
        this.res.fontWhiteSmall.drawString(g, pointsStr, xP3, drawY, Res.ScreenW, Res.ScreenH, 20);
        return (this.res.fontWhiteSmall.getFontHeight() + this.res.fontWhiteSmall.getLineSpacing()) * 8 + this.res.fontWhiteMid.getFontHeight() + this.res.fontWhiteMid.getLineSpacing();
    }

    private void drawPause(Graphics g) {
        UI.drawMessageBox(g, Res.menuBlackBar, (Res.ScreenW - this.pauseBoxW) / 2, Res.ScreenY + (Res.ScreenH - this.pauseBoxH) / 2, this.pauseBoxW, this.pauseBoxH, 0, 0, 0);
        int lineHeight = this.res.fontWhiteBig.getFontHeight() + 10;
        int lineWidth = Res.ScreenW - 20;
        int itemY = (Res.ScreenH - lineHeight * this.currMenu.count()) / 2;
        String str = "";
        int iDraw = 0;
        int yOffset = !this.game.isCanRestart() ? this.res.fontWhiteBig.getFontHeight() : 0;
        for (int i = 0; i < this.currMenu.count(); ++i) {
            if (this.currMenu.getItem(i).getName() == 221 && !this.game.isCanRestart()) continue;
            if (this.game.gameState != 203 && this.currMenu.getItem(i) == this.currMenu.getSelectedItem()) {
                UI.drawMessageBox(g, Res.menuWhiteBar, (Res.ScreenW - this.pauseBoxW) / 2, yOffset + itemY + lineHeight * iDraw - 3, this.pauseBoxW, 20, 0, 0, 0);
            }
            str = this.res.txt[this.currMenu.getItem(i).getName()];
            if (this.currMenu.getItem(i).getName() == 15) {
                UI uI = this;
                str = str + ": " + (uI.game.isVibrateEnabled() ? this.res.txt[113] : this.res.txt[114]);
            }
            if (this.currMenu.getItem(i).getName() == 16) {
                str = str + ": " + (this.game.isSoundEnabled() ? this.res.txt[113] : this.res.txt[114]);
            }
            this.res.fontWhiteBig.drawString(g, str, 0, yOffset + itemY + lineHeight * iDraw, Res.ScreenW, lineHeight, 17, true);
            ++iDraw;
        }
        if (this.game.gameState == 203) {
            g.setClip(0, 0, 240, 320);
            g.setColor(0);
            g.fillRect(0, 0, 240, 320);
            if (!Res.isW128()) {
                UI.drawMessageBox(g, Res.menuWhiteBar, Res.ScreenX, Res.ScreenY + 8, Res.ScreenW, 20, 0, 0, 0);
            }
            this.drawHelpAboutContent(g);
            this.drawButtons(g, -1, 107);
        } else {
            this.drawButtons(g, 108, 107);
        }
    }

    private void drawConfirm(Graphics g) {
        int boxW = Res.ScreenW - 20;
        int boxX = (Res.ScreenW - boxW) / 2;
        short[][] lineData = this.res.fontWhiteBig.getLineData(this.res.txt[this.confirmBoxTxt], boxW);
        int boxH = (lineData.length + 5) * (this.res.fontWhiteBig.getFontHeight() + this.res.fontWhiteBig.getLineSpacing());
        if (boxH > Res.ScreenH) {
            boxH = Res.ScreenH;
        }
        int boxY = Res.ScreenH - boxH >> 1;
        UI.drawMessageBox(g, Res.menuBlackBar, Res.ScreenX, Res.ScreenY, Res.ScreenW, Res.ScreenH, 0, 0, 0);
        this.res.fontWhiteBig.drawString(g, this.res.txt[this.confirmBoxTxt], boxX, boxY, boxW, boxH, 3, true);
        this.drawButtons(g, 111, 112);
    }

    public void drawArrow(Graphics g, int dir, int x, int y, int align) {
        this.res.menuArrowGfx.draw(g, x, y, dir * this.res.menuArrowGfx.getWidth() / 4, 0, this.res.menuArrowGfx.getWidth() / 4, this.res.menuArrowGfx.getHeight(), align);
    }

    public void drawButtons(Graphics g, int leftStr, int rightStr) {
        int spaceY = 2;
        if (Res.isW128()) {
            spaceY = 0;
        }
        if (leftStr >= 0 && leftStr < this.res.txt.length) {
            this.res.fontWhiteBig.drawString(g, this.res.txt[leftStr], 2, Res.ScreenH - spaceY, 36, true);
        }
        if (rightStr >= 0 && rightStr < this.res.txt.length) {
            this.res.fontWhiteBig.drawString(g, this.res.txt[rightStr], Res.ScreenW - 2, Res.ScreenH - spaceY, 40, true);
        }
    }

    public static boolean drawMessageBox(Graphics g, LQGfx img, int x, int y, int w, int h, int state, int time1, int totalTime) {
        boolean ret = false;
        int color = 7468031;
        if (img == Res.menuBlackBar) {
            color = 0;
        }
        g.setClip(0, 0, 600, 600);
        g.setColor(color);
        g.fillRoundRect(x, y, w, h, 10, 10);
        return ret;
    }

    public static boolean drawSingleLineString(boolean isScroll, Graphics g, LQFont font, String str, int maxLineWidth, int x, int y, int anchor) {
        int lineWidth = font.getLineWidth(str.toCharArray());
        if (lineWidth > maxLineWidth) {
            if ((anchor & 1) != 0) {
                x -= maxLineWidth / 2;
            }
            font.setArea(true, x, 0, maxLineWidth, Res.ScreenH);
            int dis = font.getFontHeight() * 2;
            if (isScroll && --strMoveTick < -lineWidth) {
                strMoveTick = dis;
            }
            font.drawString(g, str, x + strMoveTick, y, 20);
            font.drawString(g, str, x + strMoveTick + lineWidth + dis, y, 20);
            font.setArea(false, 0, 0, 0, 0);
            return true;
        }
        font.drawString(g, str, x, y, anchor);
        return false;
    }

    private void changeTexture(LQBufferedTexture texture, int[] texPalBuf, int hueOffset, byte[] hueScale, int hueScaleMin, int hueScaleMax) {
        float[] rgb = new float[3];
        int[] pal = texture.getPalette();
        for (int i = 0; i < pal.length; ++i) {
            rgb[0] = pal[i] >> 16 & 0xFF;
            rgb[1] = pal[i] >> 8 & 0xFF;
            rgb[2] = pal[i] & 0xFF;
            float[] hsv = LQGfx.RGBtoHSV(rgb);
            if (hueScale[i] < hueScaleMin || hueScale[i] > hueScaleMax) continue;
            hsv[0] = hsv[0] + (float)hueOffset;
            if (hsv[0] > 360.0f) {
                hsv[0] = hsv[0] - 360.0f;
            }
            rgb = LQGfx.HSVtoRGB(hsv);
            texPalBuf[i] = ((int)rgb[0] & 0xFF) << 16 | ((int)rgb[1] & 0xFF) << 8 | (int)rgb[2] & 0xFF;
        }
        texture.updatePalette(texPalBuf);
    }

    public static void setClipFullScreen(Graphics g) {
        g.setClip(0, 0, 240, 320);
    }

    public boolean isGMG() {
        return this.currMenu.getSelectedItem().getName() == 6;
    }

    private static class MenuItem {
        private MenuItem parent;
        private MenuItem[] subItems;
        private short name;
        private short title;
        private byte selIndex;
        private boolean disabled;

        public MenuItem(MenuItem parent, int name) {
            this.parent = parent;
            this.name = (short)name;
            this.title = (short)name;
            this.disabled = false;
        }

        public void setItems(int[] itemNames) {
            this.subItems = null;
            this.selIndex = 0;
            if (itemNames != null) {
                this.subItems = new MenuItem[itemNames.length];
                for (int i = 0; i < this.subItems.length; ++i) {
                    this.subItems[i] = new MenuItem(this, itemNames[i]);
                }
            }
        }

        public void resetSelection() {
            this.selIndex = 0;
        }

        public void disable() {
            this.disabled = true;
        }

        public void enable() {
            this.disabled = false;
        }

        public boolean isDisabled() {
            return this.disabled;
        }

        public int count() {
            return this.subItems.length;
        }

        public MenuItem getItemByName(int name) {
            for (int i = 0; i < this.subItems.length; ++i) {
                if (this.subItems[i].getName() != name) continue;
                return this.subItems[i];
            }
            return null;
        }

        public int getItemCount() {
            return this.subItems.length;
        }

        public MenuItem getItem(int index) {
            return this.subItems[index];
        }

        public int getName() {
            return this.name;
        }

        public int getTitle() {
            return this.title;
        }

        public MenuItem getParent() {
            return this.parent;
        }

        public int getSelectedIndex() {
            return this.selIndex;
        }

        public MenuItem getSelectedItem() {
            return this.subItems[this.selIndex];
        }

        public boolean select(int index) {
            if (index < 0 || index > this.subItems.length - 1 || this.subItems[index].isDisabled()) {
                return false;
            }
            this.selIndex = (byte)index;
            return true;
        }

        public void selNext(boolean isLoop) {
            this.selIndex = (byte)(this.selIndex + 1);
            if (this.selIndex >= this.count()) {
                this.selIndex = isLoop ? (byte)0 : (byte)(this.count() - 1);
            }
            if (this.subItems[this.selIndex].isDisabled()) {
                this.selNext(isLoop);
            }
        }

        public void selPrev(boolean isLoop) {
            this.selIndex = (byte)(this.selIndex - 1);
            if (this.selIndex < 0) {
                this.selIndex = isLoop ? (byte)(this.count() - 1) : (byte)0;
            }
            if (this.subItems[this.selIndex].isDisabled()) {
                this.selPrev(isLoop);
            }
        }
    }
}

