/*
 * Decompiled with CFR 0.152.
 */
package MyGame;

import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.TiledLayer;

public class Buildings
extends TiledLayer {
    static final int TILE_WIDTH = 60;
    static final int TILE_HEIGHT = 140;
    static final byte[] LOADING_FRAME_SEQUENCE = new byte[]{25, 26, 27, 28, 29, 30};
    static final byte[] GAS_STATION_FRAME_SEQUENCE = new byte[]{37, 38, 39, 40, 41, 42};
    static final byte[] REPAIR_STATION_FRAME_SEQUENCE = new byte[]{31, 32, 33, 34, 35, 36};
    static final byte[] DRIVE_THRU_FRAME_SEQUENCE = new byte[]{43, 44, 45, 46};
    private byte myLoadingSequenceIndex = 0;
    private byte myGasStationSequenceIndex = 0;
    private byte myRepairStationSequenceIndex = 0;
    private byte myDriveThruSequenceIndex = 0;
    public int myAnimatedLoadingIndex;
    public int myAnimatedGasStationIndex;
    public int myAnimatedRepairStationIndex;
    public int myAnimatedDriveThruIndex;
    private int dispWidth = 0;

    public Buildings(int dWidth) throws Exception {
        super(4, 20, Image.createImage((String)"/images/new_buildings.png"), 60, 140);
        this.dispWidth = dWidth;
        if (this.dispWidth >= 320) {
            this.setPosition(90, 0);
        } else {
            this.setPosition(30, 0);
        }
        this.myAnimatedLoadingIndex = this.createAnimatedTile(1);
        this.myAnimatedGasStationIndex = this.createAnimatedTile(1);
        this.myAnimatedRepairStationIndex = this.createAnimatedTile(1);
        this.myAnimatedDriveThruIndex = this.createAnimatedTile(1);
        int[][] tiles = new int[][]{{0, 0, 0, 16}, {21, 0, 0, 4}, {7, 0, 0, this.myAnimatedRepairStationIndex}, {0, 0, 0, 0}, {15, 0, 0, 14}, {0, 0, 0, 17}, {3, 0, 0, this.myAnimatedLoadingIndex}, {9, 0, 0, 0}, {10, 0, 0, 22}, {11, 0, 0, this.myAnimatedDriveThruIndex}, {13, 0, 0, 2}, {0, 0, 0, 8}, {20, 0, 0, this.myAnimatedGasStationIndex}, {0, 0, 0, 0}, {0, 0, 0, 15}, {13, 0, 0, this.myAnimatedLoadingIndex}, {19, 0, 0, 0}, {0, 0, 0, 16}, {21, 0, 0, 4}, {0, 0, 0, 0}};
        for (int row = 0; row < 20; ++row) {
            for (int col = 0; col < 4; ++col) {
                this.setCell(col, row, tiles[row][col]);
            }
        }
    }

    void reset() {
        if (this.dispWidth == 320) {
            this.setPosition(90, 0);
        } else {
            this.setPosition(30, 0);
        }
        this.myLoadingSequenceIndex = 0;
        this.myGasStationSequenceIndex = 0;
        this.myRepairStationSequenceIndex = 0;
        this.myDriveThruSequenceIndex = 0;
        this.setAnimatedTile(this.myAnimatedLoadingIndex, LOADING_FRAME_SEQUENCE[this.myLoadingSequenceIndex]);
        this.setAnimatedTile(this.myAnimatedGasStationIndex, GAS_STATION_FRAME_SEQUENCE[this.myGasStationSequenceIndex]);
        this.setAnimatedTile(this.myAnimatedRepairStationIndex, REPAIR_STATION_FRAME_SEQUENCE[this.myRepairStationSequenceIndex]);
        this.setAnimatedTile(this.myAnimatedDriveThruIndex, DRIVE_THRU_FRAME_SEQUENCE[this.myDriveThruSequenceIndex]);
    }

    void advance(int tickCount) {
        if (tickCount % 5 == 0) {
            this.myLoadingSequenceIndex = (byte)(this.myLoadingSequenceIndex + 1);
            this.myLoadingSequenceIndex = (byte)(this.myLoadingSequenceIndex % 5);
            this.setAnimatedTile(this.myAnimatedLoadingIndex, LOADING_FRAME_SEQUENCE[this.myLoadingSequenceIndex]);
            this.myGasStationSequenceIndex = (byte)(this.myGasStationSequenceIndex + 1);
            this.myGasStationSequenceIndex = (byte)(this.myGasStationSequenceIndex % 5);
            this.setAnimatedTile(this.myAnimatedGasStationIndex, GAS_STATION_FRAME_SEQUENCE[this.myGasStationSequenceIndex]);
            this.myRepairStationSequenceIndex = (byte)(this.myRepairStationSequenceIndex + 1);
            this.myRepairStationSequenceIndex = (byte)(this.myRepairStationSequenceIndex % 5);
            this.setAnimatedTile(this.myAnimatedRepairStationIndex, REPAIR_STATION_FRAME_SEQUENCE[this.myRepairStationSequenceIndex]);
            this.myDriveThruSequenceIndex = (byte)(this.myDriveThruSequenceIndex + 1);
            this.myDriveThruSequenceIndex = (byte)(this.myDriveThruSequenceIndex % 4);
            this.setAnimatedTile(this.myAnimatedDriveThruIndex, DRIVE_THRU_FRAME_SEQUENCE[this.myDriveThruSequenceIndex]);
        }
    }
}

