/*
 * Decompiled with CFR 0.152.
 */
package spl.gamestore.moregames;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.TextBox;
import spl.gamestore.common.GameStore;
import spl.gamestore.common.Module;
import spl.gamestore.common.Params;
import spl.gamestore.common.Resources;
import spl.gamestore.moregames.HelperThread;

public class MoreGamesModule
extends Module
implements Params,
Resources {
    private int smsSentStatus = -1;
    private boolean enabled;
    private int buttonGap;
    public String errorMessage;
    public static final byte INDEX_BLACK = 0;
    public static final byte INDEX_WHITE = 1;
    private byte fontBig = 0;
    private byte fontSmall = 0;
    private int smsTimer;
    private final Object lock = new Object();
    private int navigationIndexX = -1;
    private int navigationIndexY = 0;
    private boolean navigateNext = true;
    private boolean navigatePrev = false;
    public Hashtable games;
    private String currentLink;
    private Command commandOk;
    private Command commandBack;
    public boolean networkEnabled = false;
    private String serverLink = null;
    private String catalogueVersion = null;
    private HelperThread helperThread;
    private boolean screenshotLoaded;
    private int loadingSteps;
    private int currentStep;
    private String[][] navigationMatrix;
    private final byte MAX_NUMBER_LENGTH = (byte)12;
    public TextBox editBox;
    private boolean tafEnabled = true;
    private int smsStep;
    private int pointWidth;
    private int strSendingOffset;
    private int strSendingWidth;
    private String strSending;
    private int tafY;
    private int tafW;
    private int tafH;
    private int[] tafX;
    private String[] tafMessage;
    private boolean dialogIsShown = false;
    private String mainCategory;
    private boolean drawGmgMenuItem;
    private boolean drawLinkMenuItem;
    private String[] press5Message;
    private int press5Y;
    private int press5W;
    private int press5H;
    private int[] press5X;
    private boolean drawPress5Message;
    private boolean rectangleFlag = false;
    private int rectangleCycleCount = 0;
    private String[][] menuItems;
    private Image[] menuIcons;
    private int[] menuItemsX;
    private int[] menuItemsH;
    private int currentItem;
    private int firstVisibleItemIndex;
    private int menuYEnd;
    private int menuYBegin;
    private int menuY;
    private int[] titleTextX;
    private String[] text;
    private int textWidth;
    private int boxWidth;
    private int textYBegin;
    private int textYEnd;
    private int textXBegin;
    private int currentLine;
    private int visibleLines;
    private int textY;
    private int itemGap;
    private int lineGap;
    private int menuTitleY;
    private int menuTitleH;
    private int lineHeightBig;
    private int lineHeightSmall;
    private int menuX;
    private int iconsX;
    private int iconsW;
    private int iconsH;
    private boolean drawScrollUp;
    private boolean drawScrollDown;
    private boolean menuScrollingActive;
    public byte prevState;
    public byte nextState = (byte)-1;
    public byte lastHelperOperation = (byte)-1;
    public byte lastHelperResult = (byte)-1;
    private Image imgArrowsH;
    private Image imgSoftkeyOk;
    private Image imgSoftkeyBack;
    private Image imgArrowsV;
    private boolean arrowsFlag = false;
    private int arrowsCycleCount = 0;
    private int H_ARROW_WIDTH;
    private int H_ARROW_HEIGHT;
    private int TEXT_ARROW_HEIGHT;
    private int V_ARROW_WIDTH;
    private int V_ARROW_HEIGHT;
    public Image imgTextCorners;
    public Image imgProgressBar;
    public Image imgBroken;
    public Image imgLightCorners;
    public Image imgDarkCorners;
    private int textCornerSize;
    private int buttonCornerSize;
    private int progressBarTildeW;
    private int PROGRESSBAR_H;
    private Image currentScreenshot;
    private int imageX;
    private int imageY;
    private int SCREENSHOT_X;
    private int SCREENSHOT_Y;
    private int SCREENSHOT_W;
    private int SCREENSHOT_H;
    private boolean currentScreenshotIsLoading;
    private boolean addedToQueue;
    private int softkeyOkX;
    private int softkeyBackX;
    private int softkeysY;
    private int softkeysWidth;
    private int hArrowsY;
    private int textArrowsX;
    private String mgImplementation;
    private static final char CHAR_DELIMITER = ',';
    public static final byte STATE_INIT_MODULE = 0;
    public static final byte STATE_SELECT_LANGUAGE = 1;
    public static final byte STATE_CATEGORY_SCREEN = 2;
    public static final byte STATE_GAME_SCREEN = 3;
    public static final byte STATE_CONFIRM_EXIT = 4;
    public static final byte STATE_SHOW_GOTO_MESSAGE = 5;
    public static final byte STATE_SHOW_FLIP_MESSAGE = 6;
    public static final byte STATE_REQUEST_ALL_DATA = 7;
    public static final byte STATE_REQUEST_GAME_DATA = 8;
    public static final byte STATE_CONFIRM_NETWORK = 9;
    public static final byte STATE_ENTER_PHONENUMBER = 10;
    public static final byte STATE_SENDING_SMS = 11;
    public static final byte STATE_SMS_SENT = 12;
    public static final byte STATE_SHOW_SMS_MESSAGE = 13;
    public static final byte STATE_SHOW_SETTINGS_MESSAGE = 14;
    public static final byte STATE_EXIT = 15;
    public static final byte INDEX_CODE = 0;
    public static final byte INDEX_TITLE = 1;
    public static final byte INDEX_DESCRIPTION = 2;
    public static final byte INDEX_LINK = 3;
    public static final byte INDEX_ICON = 4;
    public static final byte INDEX_SCREENSHOT = 5;
    public static final byte INDEX_GAME = 6;
    public static final byte INDEX_PRELOADED = 7;
    private static final int shadowColor1 = 0xADADAD;
    private static final int shadowColor2 = 0xC2C2C2;
    private static final int shadowColor3 = 0xE0E0E0;
    private static final int shadowColor4 = 0xE2E2E2;
    private static final int butLightColor1 = 11150353;
    private static final int butLightColor2 = 16474624;
    private static final int butLightColor3 = 13581568;
    private static final int butLightColor4 = 14432768;
    private static final int butLightColor5 = 12527104;
    private static final int butLightColor6 = 0x560606;
    private static final int butDarkColor1 = 7997960;
    private static final int butDarkColor2 = 11408136;
    private static final int butDarkColor3 = 11947842;
    private static final int butDarkColor4 = 10957850;
    private static final int butDarkColor5 = 12527104;
    private static final int butDarkColor6 = 7081229;
    private String gotoLink = null;
    private int pointerDownY;
    private int lineWhenPressed;
    int ix;
    int iy;

    public void loadCommonData() {
        String navigation;
        if (this.networkEnabled && this.mainCategory == null) {
            this.mainCategory = GameStore.instance.getFromJad(GameStore.getResource(48, true));
            if (this.mainCategory != null) {
                this.mainCategory = this.mainCategory.trim();
            }
        }
        if (this.games == null) {
            this.games = new Hashtable();
            Object[] gamesArr = (Object[])GameStore.getResource(1, "/gs_moregames.bin", "common");
            for (int i = 0; i < gamesArr.length; ++i) {
                Object[] game = (Object[])gamesArr[i];
                if ("".equals(game[2])) {
                    game[2] = null;
                }
                game[3] = GameStore.instance.getFromJad(game[3]);
                if (!this.networkEnabled && !"1".equals(game[7])) continue;
                this.games.put(game[0], game);
            }
            Object[] categoriesArr = (Object[])GameStore.getResource(2, "/gs_moregames.bin", "common");
            for (int i = 0; i < categoriesArr.length; ++i) {
                Object[] category = (Object[])categoriesArr[i];
                if ("".equals(category[2])) {
                    category[2] = null;
                }
                category[3] = GameStore.instance.getFromJad(category[3]);
                String categoryJadKey = (String)GameStore.getResource(31, true);
                String categoryContent = GameStore.instance.getFromJad(categoryJadKey + category[0]);
                Vector categoryGames = new Vector();
                if (categoryContent != null) {
                    Vector codes = GameStore.splitByString(categoryContent, ',');
                    for (int j = 0; j < codes.size(); ++j) {
                        if (!this.games.containsKey(codes.elementAt(j))) continue;
                        categoryGames.addElement(codes.elementAt(j));
                    }
                }
                if (!GameStore.isKey(this.mainCategory, (String)category[0]) && categoryGames.size() <= 0) continue;
                this.games.put(category[0], category);
            }
        }
        if (this.navigationMatrix == null && (navigation = GameStore.instance.getFromJad(GameStore.getResource(47, true))) != null) {
            int i;
            Vector navigationChunk = GameStore.splitByString(navigation, ',');
            int index = 0;
            while (index < navigationChunk.size()) {
                if (!this.games.containsKey(navigationChunk.elementAt(index))) {
                    navigationChunk.removeElementAt(index);
                    continue;
                }
                ++index;
            }
            for (i = 0; i < navigationChunk.size(); ++i) {
                if (this.games.containsKey(navigationChunk.elementAt(i))) continue;
                navigationChunk.removeElementAt(i);
            }
            this.navigationMatrix = new String[navigationChunk.size()][];
            for (i = 0; i < navigationChunk.size(); ++i) {
                String code = (String)navigationChunk.elementAt(i);
                Object[] cat = (Object[])this.games.get(code);
                if ("1".equals(cat[6])) {
                    this.navigationMatrix[i] = new String[1];
                    this.navigationMatrix[i][0] = code;
                    continue;
                }
                String categoryJadKey = (String)GameStore.getResource(31, true);
                String categoryContent = GameStore.instance.getFromJad(categoryJadKey + code);
                Vector categoryGames = new Vector();
                if (categoryContent != null) {
                    Vector codes = GameStore.splitByString(categoryContent, ',');
                    for (int j = 0; j < codes.size(); ++j) {
                        if (!this.games.containsKey(codes.elementAt(j))) continue;
                        categoryGames.addElement(codes.elementAt(j));
                    }
                }
                this.navigationMatrix[i] = new String[categoryGames.size() + 1];
                this.navigationMatrix[i][0] = code;
                for (int j = 0; j < categoryGames.size(); ++j) {
                    this.navigationMatrix[i][j + 1] = (String)categoryGames.elementAt(j);
                }
            }
        }
    }

    public MoreGamesModule() {
        String mgImplKey = (String)GameStore.getResource(34, true);
        this.mgImplementation = GameStore.instance.parent.getJadAttribute(mgImplKey);
        this.mgImplementation = this.mgImplementation == null || this.mgImplementation.length() == 0 ? "off" : ("wap".toLowerCase().equals(this.mgImplementation.toLowerCase()) ? "wap" : ("static".toLowerCase().equals(this.mgImplementation.toLowerCase()) ? "static" : "off"));
        String serverLinkJadKey = (String)GameStore.getResource(28, true);
        if (serverLinkJadKey != null) {
            this.serverLink = GameStore.instance.parent.getJadAttribute(serverLinkJadKey);
        }
        this.catalogueVersion = GameStore.instance.parent.getJadAttribute((String)GameStore.getResource(37, true));
        if (this.serverLink == null || this.serverLink.trim().length() == 0 || this.serverLink.toLowerCase().equals("off".toLowerCase()) || this.catalogueVersion == null || this.catalogueVersion.length() == 0) {
            this.serverLink = null;
            this.networkEnabled = false;
        } else {
            this.networkEnabled = true;
        }
        this.loadCommonData();
        this.enabled = !"off".equals(this.mgImplementation) && this.navigationMatrix != null && this.navigationMatrix.length > 0;
        String taf = (String)GameStore.getResource(29, true);
        String tafEn = GameStore.instance.parent.getJadAttribute(taf);
        this.tafEnabled = tafEn != null && "Y".toLowerCase().equals(tafEn.toLowerCase());
        this.gotoLink = GameStore.instance.getFromJad(GameStore.getResource(49, true));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void loadResources() {
        this.loadCommonData();
        ++this.currentStep;
        try {
            String screenshotSize = (String)GameStore.getResource(35, true);
            try {
                this.SCREENSHOT_W = Integer.parseInt(screenshotSize.substring(0, screenshotSize.indexOf(120)));
                this.SCREENSHOT_H = Integer.parseInt(screenshotSize.substring(screenshotSize.indexOf(120) + 1, screenshotSize.length()));
            }
            catch (Exception e) {
                // empty catch block
            }
            ++this.currentStep;
            if (this.imgArrowsH == null) {
                this.imgArrowsH = (Image)GameStore.getResource(39, true);
            }
            this.H_ARROW_WIDTH = this.imgArrowsH.getWidth() / 2;
            this.H_ARROW_HEIGHT = this.imgArrowsH.getHeight();
            ++this.currentStep;
            if (this.imgArrowsV == null) {
                this.imgArrowsV = (Image)GameStore.getResource(38, true);
            }
            this.V_ARROW_WIDTH = this.imgArrowsV.getWidth();
            this.V_ARROW_HEIGHT = this.imgArrowsV.getHeight() / 2;
            ++this.currentStep;
            if (this.imgSoftkeyOk == null) {
                this.imgSoftkeyOk = (Image)GameStore.getResource(36, true);
            }
            ++this.currentStep;
            if (this.imgSoftkeyBack == null) {
                this.imgSoftkeyBack = (Image)GameStore.getResource(41, true);
            }
            ++this.currentStep;
            if (this.imgLightCorners == null) {
                this.imgLightCorners = (Image)GameStore.getResource(33, true);
                this.buttonCornerSize = this.imgLightCorners.getWidth() / 2;
            }
            ++this.currentStep;
            if (this.imgDarkCorners == null) {
                this.imgDarkCorners = (Image)GameStore.getResource(42, true);
            }
            ++this.currentStep;
            if (this.imgTextCorners == null) {
                this.imgTextCorners = (Image)GameStore.getResource(26, true);
                this.textCornerSize = this.imgTextCorners.getWidth() / 2;
            }
            ++this.currentStep;
            int softkeysH = this.imgSoftkeyOk.getHeight() > this.imgSoftkeyBack.getHeight() ? this.imgSoftkeyOk.getHeight() : this.imgSoftkeyBack.getHeight();
            this.softkeysWidth = this.imgSoftkeyOk.getWidth() > this.imgSoftkeyBack.getWidth() ? this.imgSoftkeyOk.getWidth() : this.imgSoftkeyBack.getWidth();
            this.softkeysY = 320 - softkeysH;
            this.softkeyOkX = 0;
            this.softkeyBackX = 240 - this.imgSoftkeyBack.getWidth();
            ++this.currentStep;
            if (this.fontSmall == 0) {
                this.fontSmall = GameStore.instance.loadFont(new int[]{13, 5}, 7);
            }
            ++this.currentStep;
            if (this.fontBig == 0) {
                this.fontBig = GameStore.instance.loadFont(new int[]{23, 16}, 11);
            }
            ++this.currentStep;
            this.lineHeightSmall = GameStore.instance.fontsHeights[this.fontSmall];
            this.lineHeightBig = GameStore.instance.fontsHeights[this.fontBig];
            this.buttonGap = this.lineHeightBig > 10 ? this.lineHeightBig / 4 : this.lineHeightBig / 2;
            this.TEXT_ARROW_HEIGHT = this.lineHeightSmall / 2 - 1;
            this.pointWidth = GameStore.instance.getStringWidth(".", this.fontBig);
            if (this.networkEnabled) {
                this.helperThread.setCatalogueVersion(this.catalogueVersion);
            }
            String contentSize = (String)GameStore.getResource(45, true);
            this.helperThread.setServerLink(this.serverLink);
            this.helperThread.setContentSize(contentSize);
            if (this.commandOk == null) {
                this.commandOk = new Command("Ok", 4, 1);
            }
            if (this.commandBack == null) {
                this.commandBack = new Command("Back", 2, 1);
            }
            ++this.currentStep;
            String currentLanguage = GameStore.lang;
            String gameLanguage = GameStore.instance.parent.getLanguage();
            if (gameLanguage == null) {
                if (currentLanguage != null) {
                    this.loadLocaleData();
                    this.navigateNext();
                } else {
                    this.prevState = 1;
                    this.initState((byte)1);
                }
            } else if (!gameLanguage.equals(currentLanguage)) {
                String[] locales = GameStore.vectorToArray(GameStore.splitByString("en,de,fr,es,it,pt,ru ", ','));
                int index = -1;
                for (int i = 0; i < locales.length; ++i) {
                    if (!locales[i].equals(gameLanguage)) continue;
                    index = i;
                    i = locales.length;
                }
                if (index == -1) {
                    this.prevState = 1;
                    this.initState((byte)1);
                } else {
                    GameStore.lang = locales[index];
                    this.loadLocaleData();
                    this.navigateNext();
                }
            } else {
                this.loadLocaleData();
                this.navigateNext();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean initActive(Object[] params) {
        if (!this.isEnabled()) {
            return false;
        }
        System.gc();
        if (this.imgProgressBar == null) {
            this.imgProgressBar = (Image)GameStore.getResource(46, true);
            this.progressBarTildeW = this.imgProgressBar.getWidth() / 7;
            this.PROGRESSBAR_H = this.imgProgressBar.getHeight();
        }
        this.helperThread = new HelperThread(this);
        this.helperThread.start();
        this.loadingSteps = 13;
        this.currentStep = 0;
        this.helperThread.addNewTask((byte)4, null);
        this.state = 0;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.lock;
        synchronized (object) {
            this.helperThread.tasksQueue = null;
            this.helperThread.isRunning = false;
            this.lock.notify();
        }
        this.dialogIsShown = false;
        this.helperThread.abortAllTasks();
        this.helperThread = null;
        if (this.games != null) {
            this.games.clear();
            this.games = null;
        }
        if (this.navigationMatrix != null) {
            for (int i = 0; i < this.navigationMatrix.length; ++i) {
                for (int j = 0; j < this.navigationMatrix[i].length; ++j) {
                    this.navigationMatrix[i][j] = null;
                }
            }
            this.navigationMatrix = null;
        }
        if (this.menuIcons != null) {
            for (int i = 0; i < this.menuIcons.length; ++i) {
                this.menuIcons[i] = null;
            }
            this.menuIcons = null;
        }
        this.menuItemsH = null;
        if (this.text != null) {
            for (int i = 0; i < this.text.length; ++i) {
                this.text[i] = null;
            }
            this.text = null;
        }
        this.imgArrowsV = null;
        this.imgArrowsH = null;
        this.imgDarkCorners = null;
        this.imgLightCorners = null;
        this.imgTextCorners = null;
        this.imgSoftkeyBack = null;
        this.imgSoftkeyOk = null;
        this.imgProgressBar = null;
        this.imgBroken = null;
        this.currentScreenshot = null;
        if (this.tafMessage != null) {
            for (int i = 0; i < this.tafMessage.length; ++i) {
                this.tafMessage[i] = null;
            }
            this.tafMessage = null;
        }
        if (this.press5Message != null) {
            for (int i = 0; i < this.press5Message.length; ++i) {
                this.press5Message[i] = null;
            }
            this.press5Message = null;
        }
        this.press5X = null;
        GameStore.instance.cleanFonts();
        this.fontSmall = 0;
        this.fontBig = 0;
        this.navigationIndexX = -1;
        System.gc();
        this.state = (byte)15;
    }

    public void cycle() {
        if (80 * (GameStore.instance.realScreenH - GameStore.instance.realScreenW) < 0) {
            if (this.state != 6) {
                this.prevState = this.state;
                this.initState((byte)6);
            }
        } else if (this.state == 6) {
            this.initState(this.prevState);
        }
        if (HelperThread.currentOperation >= 0) {
            this.helperThread.timer -= 100;
            if (this.helperThread.timer < 0) {
                this.helperThread.currentOperationAborted = true;
            }
        }
        if (HelperThread.currentOperation >= 0 && this.helperThread.timer < 0 && (this.state == 7 || this.state == 8)) {
            this.initState(this.prevState);
        }
        if (this.state == 7 && this.lastHelperOperation == 0 && this.lastHelperResult >= 0) {
            if (this.lastHelperResult == 1) {
                this.initState((byte)14);
            } else {
                this.initState(this.prevState);
            }
            this.lastHelperResult = (byte)-1;
            this.lastHelperOperation = (byte)-1;
        } else if (this.state == 8 && this.lastHelperOperation == 1 && this.lastHelperResult >= 0) {
            if (this.lastHelperResult == 1) {
                this.initState((byte)14);
            } else if (this.lastHelperResult == 2) {
                this.initState(this.prevState);
            } else {
                this.initState((byte)3);
            }
            this.lastHelperResult = (byte)-1;
            this.lastHelperOperation = (byte)-1;
        } else if (this.state == 3 && this.lastHelperOperation == 2 && this.lastHelperResult >= 0) {
            if (this.currentScreenshotIsLoading) {
                if (this.lastHelperResult == 1) {
                    Object[] currentGame = null;
                    try {
                        currentGame = (Object[])this.games.get(this.navigationMatrix[this.navigationIndexX][this.navigationIndexY]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (currentGame != null) {
                        currentGame[5] = null;
                    }
                }
                this.initState((byte)3);
            }
            this.lastHelperResult = (byte)-1;
            this.lastHelperOperation = (byte)-1;
        }
        if (this.screenshotLoaded) {
            this.screenshotLoaded = false;
            if (this.state == 3 && this.currentScreenshotIsLoading) {
                this.initState((byte)3);
            }
        }
        if (this.tafEnabled && this.state == 11) {
            if (this.smsSentStatus > 0) {
                this.setState((byte)12);
                this.smsSentStatus = -1;
            }
            this.smsTimer += 100;
            if (this.smsTimer % 500 == 0) {
                ++this.smsStep;
                if (this.smsStep == 4) {
                    this.smsStep = 0;
                }
                this.smsTimer = 0;
            }
            this.strSendingOffset = this.smsStep * this.pointWidth;
        }
        ++this.arrowsCycleCount;
        if (this.arrowsCycleCount > 4) {
            this.arrowsFlag = !this.arrowsFlag;
            this.arrowsCycleCount = 0;
        }
        ++this.rectangleCycleCount;
        if (this.rectangleCycleCount > 8) {
            this.rectangleFlag = !this.rectangleFlag;
            this.rectangleCycleCount = 0;
        }
    }

    public void keyPressed(int key) {
        block45: {
            block1 : switch (key) {
                case 1: {
                    switch (this.state) {
                        case 1: {
                            String[] locales = GameStore.vectorToArray(GameStore.splitByString("en,de,fr,es,it,pt,ru ", ','));
                            GameStore.lang = locales[this.currentItem];
                            this.loadLocaleData();
                            this.navigateNext();
                            break;
                        }
                        case 2: {
                            this.prevState = this.state;
                            this.navigatePrev = false;
                            this.navigateNext = false;
                            if (this.drawGmgMenuItem && this.drawLinkMenuItem && this.currentItem == this.menuItems.length - 2 || this.drawGmgMenuItem && !this.drawLinkMenuItem && this.currentItem == this.menuItems.length - 1) {
                                if (!this.dialogIsShown) {
                                    this.nextState = (byte)7;
                                    this.initState((byte)9);
                                    break;
                                }
                                this.initState((byte)7);
                                break;
                            }
                            if (this.drawLinkMenuItem && this.currentItem == this.menuItems.length - 1) {
                                Object[] currentCategory = (Object[])this.games.get(this.navigationMatrix[this.navigationIndexX][0]);
                                this.currentLink = (String)currentCategory[3];
                                if (this.mgImplementation != null && "static".toLowerCase().equals(this.mgImplementation.toLowerCase())) {
                                    this.initState((byte)5);
                                    break;
                                }
                                this.initState((byte)4);
                                break;
                            }
                            this.navigationIndexY = this.currentItem + 1;
                            this.navigatePrev = false;
                            this.navigateNext = false;
                            this.initState((byte)3);
                            break;
                        }
                        case 3: {
                            if (this.drawPress5Message) {
                                this.prevState = this.state;
                                Object[] currentGame = (Object[])this.games.get(this.navigationMatrix[this.navigationIndexX][this.navigationIndexY]);
                                this.currentLink = (String)currentGame[3];
                                if (this.mgImplementation != null && "static".toLowerCase().equals(this.mgImplementation.toLowerCase())) {
                                    this.initState((byte)5);
                                    break;
                                }
                                this.initState((byte)4);
                                break;
                            }
                            break block45;
                        }
                        case 4: {
                            try {
                                GameStore.instance.goToUrl(this.currentLink);
                            }
                            catch (Throwable e) {
                                this.initState((byte)5);
                            }
                            break;
                        }
                        case 9: {
                            this.dialogIsShown = true;
                            this.initState(this.nextState);
                            break;
                        }
                        case 10: {
                            String smsNumber = this.editBox.getString();
                            if (this.editBox.getString().length() > 12) {
                                smsNumber = smsNumber.substring(0, 12);
                            }
                            this.editBox.setString(smsNumber);
                            if (this.editBox.getString().length() <= 0) break block1;
                            this.setState((byte)11);
                            GameStore.instance.setCurrentDisplayable((Displayable)GameStore.instance);
                            break;
                        }
                        case 13: {
                            this.initState(this.nextState);
                        }
                    }
                    break;
                }
                case 2: {
                    if (this.state == 1 || this.state == 2 || this.state == 3 && (this.navigateNext || this.navigatePrev)) {
                        GameStore.instance.destroyModule(0, false);
                        break;
                    }
                    if (this.state == 3) {
                        this.currentItem = this.navigationIndexY - 1;
                        this.initState((byte)2);
                        break;
                    }
                    if (this.state == 9) {
                        if (this.navigateNext) {
                            this.navigateNext();
                            break;
                        }
                        if (this.navigatePrev) {
                            this.navigatePrev();
                            break;
                        }
                        this.initState(this.prevState);
                        break;
                    }
                    if (this.state == 7 || this.state == 8) {
                        if (this.state == 7) {
                            if (HelperThread.currentOperation == 0) {
                                this.helperThread.currentOperationAborted = true;
                                this.navigationIndexY = this.currentItem + 1;
                                this.initState((byte)2);
                                break;
                            }
                        }
                        if (this.state != 8) break;
                        if (HelperThread.currentOperation != 1) break;
                        this.helperThread.currentOperationAborted = true;
                        if (this.navigationIndexY == 0) {
                            this.navigateNext();
                            break;
                        }
                        this.navigationIndexY = this.currentItem + 1;
                        this.initState((byte)2);
                        break;
                    }
                    if (this.state == 14) {
                        if (this.navigateNext) {
                            this.navigateNext();
                            break;
                        }
                        if (this.navigatePrev) {
                            this.navigatePrev();
                            break;
                        }
                        this.initState(this.prevState);
                        break;
                    }
                    if (this.state == 10) {
                        this.initState(this.prevState);
                        GameStore.instance.setCurrentDisplayable((Displayable)GameStore.instance);
                        break;
                    }
                    if (this.state == 6) break;
                    this.initState(this.prevState);
                    break;
                }
                case 5: {
                    if (this.state == 1 || this.state == 2) {
                        if (this.currentItem <= 0) break;
                        if (this.currentItem == this.firstVisibleItemIndex) {
                            --this.firstVisibleItemIndex;
                        }
                        --this.currentItem;
                        this.drawScrollUp = this.menuScrollingActive && this.currentItem > 0;
                        this.drawScrollDown = this.menuScrollingActive && this.currentItem < this.menuItemsH.length;
                        break;
                    }
                    if (!this.drawScrollUp) break;
                    --this.currentLine;
                    this.drawScrollUp = this.currentLine > 0;
                    this.drawScrollDown = this.currentLine < this.text.length - this.visibleLines;
                    break;
                }
                case 6: {
                    if (this.state == 1 || this.state == 2) {
                        this.scrollDown();
                        break;
                    }
                    if (!this.drawScrollDown) break;
                    ++this.currentLine;
                    this.drawScrollDown = this.currentLine < this.text.length - this.visibleLines;
                    this.drawScrollUp = this.currentLine > 0;
                    break;
                }
                case 3: {
                    if (this.state == 2 || this.state == 3 && (this.navigateNext || this.navigatePrev)) {
                        this.navigateNext();
                        break;
                    }
                    if (this.state != 3) break;
                    this.navigationIndexY = this.navigationIndexY < this.navigationMatrix[this.navigationIndexX].length - 1 ? ++this.navigationIndexY : 1;
                    this.currentItem = this.navigationIndexY - 1;
                    this.initState((byte)3);
                    break;
                }
                case 4: {
                    if (this.state == 2 || this.state == 3 && (this.navigateNext || this.navigatePrev)) {
                        this.navigatePrev();
                        break;
                    }
                    if (this.state != 3) break;
                    this.navigationIndexY = this.navigationIndexY > 1 ? --this.navigationIndexY : this.navigationMatrix[this.navigationIndexX].length - 1;
                    this.currentItem = this.navigationIndexY - 1;
                    this.initState((byte)3);
                    break;
                }
                case 48: {
                    if (!this.tafEnabled || this.state != 3) break;
                    this.prevState = this.state;
                    this.nextState = (byte)10;
                    this.initState((byte)13);
                }
            }
        }
    }

    private void drawButton(Graphics g, int x, int y, int width, int height, int color1, int color2, int color3, int color4, int color5, int color6, Image buttonCorners) {
        int x1;
        int x2;
        g.setClip(x, ++y, this.buttonCornerSize, this.buttonCornerSize);
        g.drawImage(buttonCorners, x, y, 0);
        g.setClip(x, y + height - this.buttonCornerSize, this.buttonCornerSize, this.buttonCornerSize);
        g.drawImage(buttonCorners, x, y + height - 2 * this.buttonCornerSize, 0);
        g.setClip(x + width - this.buttonCornerSize, y, this.buttonCornerSize, this.buttonCornerSize);
        g.drawImage(buttonCorners, x + width - 2 * this.buttonCornerSize, y, 0);
        g.setClip(x + width - this.buttonCornerSize, y + height - this.buttonCornerSize, this.buttonCornerSize, this.buttonCornerSize);
        g.drawImage(buttonCorners, x + width - 2 * this.buttonCornerSize, y + height - 2 * this.buttonCornerSize, 0);
        g.setClip(x, y, width, height);
        int y1 = y + this.buttonCornerSize;
        int y2 = y + height - this.buttonCornerSize;
        int yMiddle = y + height / 2;
        if (y1 < y2) {
            g.setColor(0xE2E2E2);
            g.drawLine(x, y1, x, y2);
            g.setColor(color1);
            g.drawLine(x + 1, y1, x + 1, yMiddle);
            g.drawLine(x + width - 1, y1, x + width - 1, yMiddle);
            g.setColor(color6);
            g.drawLine(x + 1, y2, x + 1, yMiddle);
            g.drawLine(x + width - 1, y2, x + width - 1, yMiddle);
            g.setColor(color2);
            g.fillRect(x + 2, y1, width - 3, yMiddle - y1);
            g.setColor(color3);
            g.fillRect(x + 2, yMiddle, width - 3, 2);
            g.setColor(color4);
            g.fillRect(x + 2, yMiddle + 2, width - 3, y2 - yMiddle - 2);
        }
        if ((x2 = x + width - this.buttonCornerSize) > (x1 = x + this.buttonCornerSize)) {
            g.setColor(color1);
            g.drawLine(x1, y, x2, y);
            g.setColor(color2);
            g.fillRect(x1, y + 1, x2 - x1, yMiddle - y - 1);
            g.setColor(color3);
            g.fillRect(x1, yMiddle, x2 - x1, 2);
            g.setColor(color4);
            g.fillRect(x1, yMiddle + 2, x2 - x1, y + height - yMiddle - 6);
            g.setColor(color5);
            g.drawLine(x1, y + height - 5, x2, y + height - 5);
            g.setColor(color6);
            g.drawLine(x1, y + height - 4, x2, y + height - 4);
            g.setColor(0xADADAD);
            g.drawLine(x1, y + height - 3, x2, y + height - 3);
            g.setColor(0xC2C2C2);
            g.drawLine(x1, y + height - 2, x2, y + height - 2);
            g.setColor(0xE0E0E0);
            g.drawLine(x1, y + height - 1, x2, y + height - 1);
        }
        g.setClip(0, 0, 240, 320);
    }

    private void drawMenu(Graphics g) {
        g.setClip(0, 0, 240, 320);
        int moveY = this.V_ARROW_HEIGHT / 8;
        if (!this.arrowsFlag) {
            moveY = 0;
        }
        if (this.menuScrollingActive && this.currentItem < this.menuItems.length - 1) {
            g.setClip(120 - this.V_ARROW_WIDTH / 2, 320 - 9 * this.V_ARROW_HEIGHT / 8 - moveY, this.V_ARROW_WIDTH, this.V_ARROW_HEIGHT);
            g.drawImage(this.imgArrowsV, 120 - this.V_ARROW_WIDTH / 2, 320 - 9 * this.V_ARROW_HEIGHT / 8 - moveY - this.V_ARROW_HEIGHT, 0);
        }
        if (this.menuScrollingActive && this.currentItem > 0) {
            g.setClip(120 - this.V_ARROW_WIDTH / 2, this.menuYBegin - 9 * this.V_ARROW_HEIGHT / 8 - this.lineHeightBig / 2 + moveY, this.V_ARROW_WIDTH, this.V_ARROW_HEIGHT);
            g.drawImage(this.imgArrowsV, 120 - this.V_ARROW_WIDTH / 2, this.menuYBegin - 9 * this.V_ARROW_HEIGHT / 8 - this.lineHeightBig / 2 + moveY, 0);
        }
        g.setClip(0, 0, 240, 320);
        this.drawButton(g, this.menuX - 2 * this.buttonGap, this.menuTitleY - this.buttonGap, 240 - 2 * this.menuX + 2 * this.buttonGap, this.menuTitleH + 2 * this.buttonGap, 11150353, 16474624, 13581568, 14432768, 12527104, 0x560606, this.imgLightCorners);
        g.setColor(0xFCFCFC);
        int iY = this.menuTitleY;
        for (int i = 0; i < this.text.length; ++i) {
            GameStore.instance.drawString(g, this.fontBig, (byte)1, this.text[i], this.titleTextX[i], iY, 16, 0, 0, 240, 320);
            iY += this.lineHeightBig + this.lineGap;
        }
        iY = this.menuYBegin;
        for (int i = this.firstVisibleItemIndex; i < this.menuItemsH.length && iY + this.menuItemsH[i] <= this.menuYEnd; ++i) {
            byte imageIndex;
            this.menuY = iY + this.menuItemsH[i] / 2 - (this.menuItems[i].length * (this.lineHeightBig + this.lineGap) - this.lineGap) / 2;
            g.setClip(0, 0, 240, 320);
            if (i == this.currentItem) {
                this.drawButton(g, this.menuX - 2 * this.buttonGap, iY - this.buttonGap, 240 - 2 * this.menuX + 4 * this.buttonGap, this.menuItemsH[i] + 2 * this.buttonGap, 7997960, 11408136, 11947842, 10957850, 12527104, 7081229, this.imgDarkCorners);
                g.setColor(0xFCFCFC);
                imageIndex = 1;
            } else {
                g.setColor(0);
                imageIndex = 0;
            }
            for (int j = 0; j < this.menuItems[i].length; ++j) {
                GameStore.instance.drawString(g, this.fontBig, imageIndex, this.menuItems[i][j], this.menuItemsX[i], this.menuY, 0, 0, this.menuYBegin, 240, this.menuYEnd - this.menuYBegin);
                this.menuY += this.lineHeightBig + this.lineGap;
            }
            if (this.menuIcons != null && this.menuIcons[i] != null) {
                g.setClip(this.iconsX, iY, this.iconsW, this.menuItemsH[i]);
                g.drawImage(this.menuIcons[i], this.iconsX + this.iconsH / 2, iY + this.menuItemsH[i] / 2, 3);
            }
            iY += this.menuItemsH[i] + this.itemGap;
        }
    }

    private void drawProgressBar(Graphics g, int x, int y, int w, boolean fill, int all, int done) {
        int iX;
        g.setClip(x, y, this.progressBarTildeW, this.PROGRESSBAR_H);
        g.drawImage(this.imgProgressBar, x, y, 0);
        for (iX = x + this.progressBarTildeW; iX < x + w - 2 * this.progressBarTildeW; iX += this.progressBarTildeW) {
            g.setClip(iX, y, this.progressBarTildeW, this.PROGRESSBAR_H);
            g.drawImage(this.imgProgressBar, iX - this.progressBarTildeW, y, 0);
        }
        iX = x + w - 2 * this.progressBarTildeW;
        g.setClip(iX, y, this.progressBarTildeW, this.PROGRESSBAR_H);
        g.drawImage(this.imgProgressBar, iX - this.progressBarTildeW, y, 0);
        g.setClip(iX += this.progressBarTildeW, y, this.progressBarTildeW, this.PROGRESSBAR_H);
        g.drawImage(this.imgProgressBar, iX - 2 * this.progressBarTildeW, y, 0);
        if (fill && all > 0 && done > 0) {
            int w1 = w * done / all;
            if (w - w1 < this.progressBarTildeW) {
                w1 = w;
            } else if (w1 < 2 * this.progressBarTildeW) {
                return;
            }
            g.setClip(x, y, this.progressBarTildeW, this.PROGRESSBAR_H);
            g.drawImage(this.imgProgressBar, x - 3 * this.progressBarTildeW, y, 0);
            for (iX = x + this.progressBarTildeW; iX < x + w1 - this.progressBarTildeW; iX += this.progressBarTildeW) {
                g.setClip(iX, y, this.progressBarTildeW, this.PROGRESSBAR_H);
                g.drawImage(this.imgProgressBar, iX - 4 * this.progressBarTildeW, y, 0);
            }
            iX = x + w1 - this.progressBarTildeW;
            g.setClip(iX, y, this.progressBarTildeW, this.PROGRESSBAR_H);
            if (w == w1) {
                g.drawImage(this.imgProgressBar, iX - 6 * this.progressBarTildeW, y, 0);
            } else {
                g.drawImage(this.imgProgressBar, iX - 5 * this.progressBarTildeW, y, 0);
            }
        }
    }

    public void paint(Graphics g) {
        if (this.tafEnabled && this.state == 10) {
            return;
        }
        g.setColor(0xFFFFFF);
        if (this.state == 6) {
            g.setClip(0, 0, GameStore.instance.realScreenW, GameStore.instance.realScreenH);
            g.fillRect(0, 0, GameStore.instance.realScreenW, GameStore.instance.realScreenH);
        } else {
            g.setClip(0, 0, 240, 320);
            g.fillRect(0, 0, 240, 320);
        }
        if (this.state == 15) {
            return;
        }
        if (this.state == 1 || this.state == 2) {
            this.drawMenu(g);
        } else if (this.state == 3) {
            int i;
            int y;
            int i2;
            int iY;
            int borderSize = this.lineHeightSmall / 2;
            if (this.currentScreenshot == null) {
                g.setClip(0, 0, 240, 320);
                g.setColor(0xFFFFFF);
                g.fillRect(this.SCREENSHOT_X + 2, this.SCREENSHOT_Y + 2, this.SCREENSHOT_W - 4, this.SCREENSHOT_H - 4);
                g.setColor(0xEDEDED);
                g.drawRect(this.SCREENSHOT_X + 1, this.SCREENSHOT_Y + 1, this.SCREENSHOT_W - 1, this.SCREENSHOT_H - 1);
                g.setColor(0xDDDDDD);
                g.drawLine(this.SCREENSHOT_X, this.SCREENSHOT_Y, this.SCREENSHOT_X, this.SCREENSHOT_Y + this.SCREENSHOT_H);
                g.drawLine(this.SCREENSHOT_X, this.SCREENSHOT_Y, this.SCREENSHOT_X + this.SCREENSHOT_W, this.SCREENSHOT_Y);
            }
            if (this.currentScreenshot != null) {
                g.drawImage(this.currentScreenshot, this.imageX, this.imageY, 0);
            } else if (this.addedToQueue) {
                int PROGRESSBAR_LENGTH = 4 * this.SCREENSHOT_W / 5;
                this.drawProgressBar(g, 120 - PROGRESSBAR_LENGTH / 2, this.SCREENSHOT_Y + this.SCREENSHOT_H / 2 - this.PROGRESSBAR_H, PROGRESSBAR_LENGTH, this.currentScreenshotIsLoading, this.helperThread.bytesNeedToDownload, this.helperThread.bytesLoaded);
            } else {
                g.drawImage(this.imgBroken, this.imageX, this.imageY, 0);
            }
            g.setClip(0, 0, 240, 320);
            if (this.drawPress5Message && this.rectangleFlag) {
                g.setColor(0xFF0000);
                g.fillRect(120 - this.press5W / 2 - borderSize / 2, this.press5Y - borderSize / 2, this.press5W + borderSize, this.press5H + borderSize);
                iY = this.press5Y;
                g.setColor(0xFCFCFC);
                for (i2 = 0; i2 < this.press5Message.length; ++i2) {
                    GameStore.instance.drawString(g, this.fontSmall, (byte)1, this.press5Message[i2], this.press5X[i2], iY, 0, 0, this.press5Y, 240, this.press5H);
                    iY += this.lineHeightSmall + this.lineGap;
                }
            }
            if (this.tafEnabled) {
                g.setClip(0, 0, 240, 320);
                this.drawButton(g, 120 - this.tafW / 2 - this.lineHeightSmall / 2, this.tafY - this.lineHeightSmall / 2, this.tafW + this.lineHeightSmall, this.tafH + this.lineHeightSmall, 11150353, 16474624, 13581568, 14432768, 12527104, 0x560606, this.imgLightCorners);
                g.setColor(0xFCFCFC);
                iY = this.tafY;
                for (i2 = 0; i2 < this.tafMessage.length; ++i2) {
                    GameStore.instance.drawString(g, this.fontSmall, (byte)1, this.tafMessage[i2], this.tafX[i2], iY, 0, 0, 0, 240, 320);
                    iY += this.lineHeightSmall + this.lineGap;
                }
            }
            g.setClip(this.textXBegin - borderSize, this.textYBegin - borderSize, this.textCornerSize, this.textCornerSize);
            g.drawImage(this.imgTextCorners, this.textXBegin - borderSize, this.textYBegin - borderSize, 0);
            g.setClip(this.textXBegin - borderSize, this.textYEnd + borderSize - this.textCornerSize, this.textCornerSize, this.textCornerSize);
            g.drawImage(this.imgTextCorners, this.textXBegin - borderSize, this.textYEnd + borderSize - 2 * this.textCornerSize, 0);
            g.setClip(this.textXBegin - borderSize + this.boxWidth - this.textCornerSize, this.textYBegin - borderSize, this.textCornerSize, this.textCornerSize);
            g.drawImage(this.imgTextCorners, this.textXBegin - borderSize + this.boxWidth - 2 * this.textCornerSize, this.textYBegin - borderSize, 0);
            g.setClip(this.textXBegin - borderSize + this.boxWidth - this.textCornerSize, this.textYEnd + borderSize - this.textCornerSize, this.textCornerSize, this.textCornerSize);
            g.drawImage(this.imgTextCorners, this.textXBegin - borderSize + this.boxWidth - 2 * this.textCornerSize, this.textYEnd + borderSize - 2 * this.textCornerSize, 0);
            g.setClip(0, 0, 240, 320);
            g.setColor(0xE4E4E4);
            g.fillRect(this.textXBegin - borderSize + this.textCornerSize, this.textYBegin - borderSize, this.boxWidth - 2 * this.textCornerSize, this.textYEnd - this.textYBegin + 2 * borderSize);
            g.fillRect(this.textXBegin - borderSize, this.textYBegin - borderSize + this.textCornerSize, this.boxWidth, this.textYEnd - this.textYBegin + 2 * borderSize - 2 * this.textCornerSize);
            g.setColor(0);
            iY = this.textY;
            int endLine = this.currentLine + this.visibleLines - 1;
            for (int i3 = this.currentLine; i3 < this.text.length && i3 <= endLine; ++i3) {
                if (i3 < this.titleTextX.length) {
                    GameStore.instance.drawString(g, this.fontSmall, (byte)0, this.text[i3], this.titleTextX[i3], iY, 16, this.textXBegin, this.textYBegin, this.textWidth, this.textYEnd - this.textYBegin);
                } else {
                    GameStore.instance.drawString(g, this.fontSmall, (byte)0, this.text[i3], this.textXBegin, iY, 0, 0, 0, 240, 320);
                }
                iY += this.lineHeightSmall + this.lineGap;
            }
            g.setClip(0, 0, 240, 320);
            g.setColor(0);
            int moveY = this.TEXT_ARROW_HEIGHT / 3;
            if (!this.arrowsFlag) {
                moveY = 0;
            }
            if (this.drawScrollDown) {
                y = this.textYEnd - this.TEXT_ARROW_HEIGHT - moveY;
                if (this.textYEnd - this.textYBegin <= 3 * this.TEXT_ARROW_HEIGHT) {
                    y += this.TEXT_ARROW_HEIGHT / 2;
                }
                for (i = 0; i <= this.TEXT_ARROW_HEIGHT; ++i) {
                    g.drawLine(this.textArrowsX - i, y - i - moveY, this.textArrowsX + i, y - i - moveY);
                }
                g.drawLine(this.textArrowsX, y - moveY, this.textArrowsX - this.TEXT_ARROW_HEIGHT / 2 - 1, y - this.TEXT_ARROW_HEIGHT - moveY);
                g.drawLine(this.textArrowsX, y - moveY, this.textArrowsX + this.TEXT_ARROW_HEIGHT / 2 + 1, y - this.TEXT_ARROW_HEIGHT - moveY);
            }
            if (this.drawScrollUp) {
                y = this.textYBegin + this.TEXT_ARROW_HEIGHT / 2 + moveY;
                for (i = 0; i <= this.TEXT_ARROW_HEIGHT; ++i) {
                    g.drawLine(this.textArrowsX - i, y + i + moveY, this.textArrowsX + i, y + i + moveY);
                }
                g.drawLine(this.textArrowsX, y + moveY, this.textArrowsX - this.TEXT_ARROW_HEIGHT / 2 - 1, y + this.TEXT_ARROW_HEIGHT + moveY);
                g.drawLine(this.textArrowsX, y + moveY, this.textArrowsX + this.TEXT_ARROW_HEIGHT / 2 + 1, y + this.TEXT_ARROW_HEIGHT + moveY);
            }
        } else if (this.state == 4 || this.state == 5 || this.state == 6 || this.state == 9 || this.state == 14 || this.tafEnabled && this.state == 12 || this.tafEnabled && this.state == 13 || this.tafEnabled && this.state == 11) {
            g.setClip(0, 0, GameStore.instance.realScreenW, GameStore.instance.realScreenH);
            g.setColor(0);
            int iY = this.textY;
            for (int i = this.currentLine; i < this.text.length && i < this.currentLine + this.visibleLines; ++i) {
                if (this.state == 11 && i == this.text.length - 1) {
                    GameStore.instance.drawString(g, this.fontBig, (byte)0, this.text[i], this.titleTextX[i] + 2 * this.pointWidth - this.strSendingOffset, iY, 16, 0, this.textYBegin, 240, this.textYEnd - this.textYBegin);
                } else {
                    GameStore.instance.drawString(g, this.fontBig, (byte)0, this.text[i], this.titleTextX[i], iY, 16, 0, this.textYBegin, 240, this.textYEnd - this.textYBegin);
                }
                iY += this.lineHeightBig + this.lineGap;
            }
            g.setClip(0, 0, GameStore.instance.realScreenW, GameStore.instance.realScreenH);
            int moveY = this.V_ARROW_HEIGHT / 8;
            if (!this.arrowsFlag) {
                moveY = 0;
            }
            if (this.drawScrollUp) {
                g.setClip(120 - this.V_ARROW_WIDTH / 2, this.textYBegin - 5 * this.V_ARROW_HEIGHT / 4 - this.lineHeightBig / 2 + moveY, this.V_ARROW_WIDTH, this.V_ARROW_HEIGHT);
                g.drawImage(this.imgArrowsV, 120 - this.V_ARROW_WIDTH / 2, this.textYBegin - 5 * this.V_ARROW_HEIGHT / 4 - this.lineHeightBig / 2 + moveY, 0);
            }
            if (this.drawScrollDown) {
                g.setClip(120 - this.V_ARROW_WIDTH / 2, 320 - 5 * this.V_ARROW_HEIGHT / 4 - moveY, this.V_ARROW_WIDTH, this.V_ARROW_HEIGHT);
                g.drawImage(this.imgArrowsV, 120 - this.V_ARROW_WIDTH / 2, 320 - 5 * this.V_ARROW_HEIGHT / 4 - moveY - this.V_ARROW_HEIGHT, 0);
            }
        } else if (this.state == 7 || this.state == 8) {
            this.drawProgressBar(g, 30, this.softkeysY / 2 - this.PROGRESSBAR_H / 2, 180, true, this.helperThread.bytesNeedToDownload, this.helperThread.bytesLoaded);
        } else if (this.state == 0) {
            this.drawProgressBar(g, 30, 160 - this.PROGRESSBAR_H / 2, 180, true, this.loadingSteps, this.currentStep);
        } else if (this.tafEnabled && this.state == 11) {
            g.setColor(0);
            GameStore.instance.drawString(g, this.fontBig, (byte)0, this.strSending, 120 + 3 * this.pointWidth - this.strSendingOffset, this.softkeysY / 2 - this.lineHeightBig / 2, 17, 120 - this.strSendingWidth / 2, this.softkeysY / 2 - this.lineHeightBig / 2, this.strSendingWidth, this.lineHeightBig);
        }
        if (this.state != 6) {
            g.setClip(0, 0, 240, 320);
            if (this.state != 7 && this.state != 8 && this.state != 5 && this.state != 11 && this.state != 12 && this.state != 14 && this.state != 0) {
                g.drawImage(this.imgSoftkeyOk, this.softkeyOkX, 320, 36);
            }
            if (this.state != 0) {
                g.drawImage(this.imgSoftkeyBack, this.softkeyBackX, 320, 36);
            }
        }
        if (this.state == 2 && this.navigationMatrix.length > 1 || this.state == 3 && this.navigationIndexY == 0 && this.navigationMatrix.length > 1 || this.state == 3 && this.navigationIndexY > 0 && this.navigationMatrix[this.navigationIndexX].length > 2) {
            int leftArrowXPos = this.H_ARROW_WIDTH / 8;
            int rightArrowXPos = 240 - 9 * this.H_ARROW_WIDTH / 8;
            int moveX = this.H_ARROW_WIDTH / 8;
            if (!this.arrowsFlag) {
                moveX = 0;
            }
            g.setClip(leftArrowXPos + moveX, this.hArrowsY, this.H_ARROW_WIDTH, this.H_ARROW_HEIGHT);
            g.drawImage(this.imgArrowsH, leftArrowXPos + moveX, this.hArrowsY, 0);
            g.setClip(rightArrowXPos - moveX, this.hArrowsY, this.H_ARROW_WIDTH, this.H_ARROW_HEIGHT);
            g.drawImage(this.imgArrowsH, rightArrowXPos - moveX - this.H_ARROW_WIDTH, this.hArrowsY, 0);
        }
    }

    public void keyRepeated(int key) {
        if (key != 1 && key != 2) {
            this.keyPressed(key);
        }
    }

    private void scrollDown() {
        if (this.currentItem == this.menuItemsH.length - 1) {
            return;
        }
        ++this.currentItem;
        int currentItemY = this.menuYBegin;
        for (int i = this.firstVisibleItemIndex; i < this.currentItem; ++i) {
            currentItemY += this.menuItemsH[i] + this.itemGap;
        }
        if (currentItemY + this.menuItemsH[this.currentItem] > this.menuYEnd && this.firstVisibleItemIndex >= 0) {
            int h = 0;
            while (h < this.menuItemsH[this.currentItem]) {
                h += this.menuItemsH[this.firstVisibleItemIndex];
                ++this.firstVisibleItemIndex;
            }
        }
        this.drawScrollUp = this.menuScrollingActive && this.currentItem > 0;
        this.drawScrollDown = this.menuScrollingActive && this.currentItem < this.menuItemsH.length - 1;
    }

    void navigateNext() {
        this.navigateNext = true;
        this.navigatePrev = false;
        if (this.navigationMatrix.length == 1 && (this.state == 2 || this.state == 3)) {
            return;
        }
        this.currentItem = 0;
        this.navigationIndexX = this.navigationIndexX < this.navigationMatrix.length - 1 ? ++this.navigationIndexX : 0;
        Object[] data = (Object[])this.games.get(this.navigationMatrix[this.navigationIndexX][0]);
        boolean isGame = "1".equals(data[6]);
        if (isGame) {
            this.navigationIndexY = 0;
            this.initState((byte)3);
        } else {
            this.navigationIndexY = 1;
            this.initState((byte)2);
        }
    }

    void navigatePrev() {
        this.navigatePrev = true;
        this.navigateNext = false;
        if (this.navigationMatrix.length == 1 && (this.state == 2 || this.state == 3)) {
            return;
        }
        this.currentItem = 0;
        this.navigationIndexX = this.navigationIndexX > 0 ? --this.navigationIndexX : this.navigationMatrix.length - 1;
        Object[] data = (Object[])this.games.get(this.navigationMatrix[this.navigationIndexX][0]);
        boolean isGame = "1".equals(data[6]);
        if (isGame) {
            this.navigationIndexY = 0;
            this.initState((byte)3);
        } else {
            this.navigationIndexY = 1;
            this.initState((byte)2);
        }
    }

    private void loadLocaleData() {
        GameStore.instance.loadFont(new int[]{13, 5}, 7, this.fontSmall);
        GameStore.instance.loadFont(new int[]{23, 16}, 11, this.fontBig);
        Object[] gamesLocal = (Object[])GameStore.getResource(1, "/gs_moregames.bin", GameStore.lang);
        for (int i = 0; i < gamesLocal.length; ++i) {
            Object[] gameLocalData = (Object[])gamesLocal[i];
            Object[] game = (Object[])this.games.get(gameLocalData[0]);
            if (game == null) continue;
            game[1] = gameLocalData[1];
            game[2] = gameLocalData[2];
        }
        Object[] categoriesArr = (Object[])GameStore.getResource(2, "/gs_moregames.bin", GameStore.lang);
        for (int i = 0; i < categoriesArr.length; ++i) {
            Object[] category = (Object[])categoriesArr[i];
            Object[] commonCategory = (Object[])this.games.get(category[0]);
            if (commonCategory == null) continue;
            String categoryLinkJadKey = (String)category[3];
            String categoryLinkTitle = (String)category[2];
            if (categoryLinkJadKey != null && categoryLinkJadKey.length() > 0 && categoryLinkTitle != null && categoryLinkTitle.length() > 0) {
                category[3] = GameStore.instance.parent.getJadAttribute(categoryLinkJadKey);
                if ("".equals(category[3])) {
                    category[3] = null;
                }
            } else {
                category[3] = null;
            }
            commonCategory[1] = category[1];
            commonCategory[2] = category[2];
            commonCategory[3] = category[3];
        }
    }

    public void mergeData(Object[] gamesArr, Object[] categoriesArr, String navigationString, Object[] categoriesContent) {
        Object[] oldGame;
        Object[] gameData;
        String currentCategoryCode = null;
        if (this.navigationIndexX >= 0) {
            try {
                currentCategoryCode = this.navigationMatrix[this.navigationIndexX][0];
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (gamesArr != null) {
            for (int i = 0; i < gamesArr.length; ++i) {
                gameData = (Object[])gamesArr[i];
                oldGame = (Object[])this.games.get(gameData[0]);
                if ("1".equals(gameData[7]) || oldGame != null && "1".equals(oldGame[7])) continue;
                if (oldGame != null && ((String)gameData[3]).length() == 0) {
                    gameData[3] = oldGame[3];
                }
                if (oldGame != null && oldGame[5] instanceof byte[] && "".equals(gameData[5])) {
                    gameData[5] = oldGame[5];
                }
                if ("".equals(gameData[3])) {
                    gameData[3] = null;
                }
                this.games.put(gameData[0], gameData);
            }
        }
        if (categoriesArr != null) {
            for (int i = 0; i < categoriesArr.length; ++i) {
                gameData = (Object[])categoriesArr[i];
                oldGame = (Object[])this.games.get(gameData[0]);
                if (oldGame != null && "1".equals(oldGame[7])) continue;
                if (oldGame != null && ((String)gameData[3]).length() == 0) {
                    gameData[3] = oldGame[3];
                }
                this.games.put(gameData[0], gameData);
            }
        }
        Vector navigationChunk = GameStore.splitByString(navigationString, ',');
        int index = 0;
        while (index < navigationChunk.size()) {
            if (!this.games.containsKey(navigationChunk.elementAt(index))) {
                navigationChunk.removeElementAt(index);
                continue;
            }
            ++index;
        }
        String[][] navigationMatrixNew = new String[navigationChunk.size()][];
        for (int i = 0; i < navigationChunk.size(); ++i) {
            int j;
            String code = (String)navigationChunk.elementAt(i);
            Object[] cat = (Object[])this.games.get(code);
            if ("1".equals(cat[6])) {
                navigationMatrixNew[i] = new String[1];
                navigationMatrixNew[i][0] = code;
                continue;
            }
            Vector categoryGames = new Vector();
            for (j = 0; j < categoriesContent.length; ++j) {
                String catContent = (String)categoriesContent[j];
                if (!code.equals(catContent.substring(0, catContent.indexOf(44)))) continue;
                String categoryContent = catContent.substring(catContent.indexOf(44) + 1, catContent.length());
                Vector codes = GameStore.splitByString(categoryContent, ',');
                for (int l = 0; l < codes.size(); ++l) {
                    if (!this.games.containsKey(codes.elementAt(l))) continue;
                    categoryGames.addElement(codes.elementAt(l));
                }
            }
            for (int k = 0; k < this.navigationMatrix.length; ++k) {
                if (!code.equals(this.navigationMatrix[k][0])) continue;
                for (int j2 = 1; j2 < this.navigationMatrix[k].length; ++j2) {
                    Object[] game;
                    if (categoryGames.contains(this.navigationMatrix[k][j2]) || (game = (Object[])this.games.get(this.navigationMatrix[k][j2])) == null || !"1".equals(game[7])) continue;
                    categoryGames.addElement(this.navigationMatrix[k][j2]);
                }
            }
            navigationMatrixNew[i] = new String[categoryGames.size() + 1];
            navigationMatrixNew[i][0] = code;
            for (j = 0; j < categoryGames.size(); ++j) {
                navigationMatrixNew[i][j + 1] = (String)categoryGames.elementAt(j);
            }
        }
        if (currentCategoryCode != null) {
            for (index = 0; index < navigationMatrixNew.length; ++index) {
                if (!currentCategoryCode.equals(navigationMatrixNew[index][0])) continue;
                this.navigationMatrix = navigationMatrixNew;
                this.navigationIndexX = index;
                this.prevState = (byte)2;
                return;
            }
            this.navigationIndexX = 0;
            Object[] data = (Object[])this.games.get(this.navigationMatrix[this.navigationIndexX][0]);
            this.prevState = "1".equals(data[6]) ? (byte)3 : (byte)2;
        }
    }

    public void helperTaskStarted(byte httpOperation, Object[] game) {
        if (httpOperation == 1 || httpOperation == 2) {
            this.currentScreenshotIsLoading = game.equals(this.games.get(this.navigationMatrix[this.navigationIndexX][this.navigationIndexY]));
        }
    }

    public void helperTaskCompleted(byte httpOperation, byte result) {
        if (httpOperation == 2) {
            this.screenshotLoaded = true;
        }
    }

    public void freeOldImages() {
        Object currentGame = this.games.get(this.navigationMatrix[this.navigationIndexX][this.navigationIndexY]);
        Enumeration elements = this.games.elements();
        while (elements.hasMoreElements()) {
            Object[] game1 = (Object[])elements.nextElement();
            if (game1.equals(currentGame) || game1[5] instanceof String) continue;
            game1[5] = null;
        }
        System.gc();
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initState(byte by) {
        try {
            this.drawScrollDown = false;
            this.drawScrollUp = false;
            if (by == 1 || by == 2) {
                int n;
                int n2;
                int n3;
                String[] stringArray;
                Object[] objectArray;
                int n4;
                String string;
                this.hArrowsY = this.softkeysY - this.H_ARROW_HEIGHT;
                this.rectangleFlag = true;
                this.rectangleCycleCount = 0;
                this.menuTitleY = 10 + this.lineHeightBig / 2;
                this.lineGap = this.lineHeightBig / 4;
                this.itemGap = 3 * this.lineHeightBig / 4;
                int n5 = this.lineHeightBig;
                if (by == 1) {
                    this.menuX = 3 * this.H_ARROW_WIDTH / 4 + this.itemGap;
                    string = (String)GameStore.getResource(30, true);
                } else {
                    this.menuX = this.H_ARROW_WIDTH;
                    Object[] objectArray2 = (Object[])this.games.get(this.navigationMatrix[this.navigationIndexX][0]);
                    string = (String)objectArray2[1];
                }
                if (this.text != null) {
                    for (int i = 0; i < this.text.length; ++i) {
                        this.text[i] = null;
                    }
                    this.text = null;
                }
                this.text = GameStore.instance.divideBreaker(string, 240 - 2 * this.menuX, this.fontBig);
                this.titleTextX = new int[this.text.length];
                for (n4 = 0; n4 < this.text.length; ++n4) {
                    this.titleTextX[n4] = 120 - GameStore.instance.getStringWidth(this.text[n4], this.fontBig) / 2;
                }
                this.menuTitleH = this.text.length * (this.lineHeightBig + this.lineGap) - this.lineGap;
                if (this.menuItems != null) {
                    for (n4 = 0; n4 < this.menuItems.length; ++n4) {
                        this.menuItems[n4] = null;
                    }
                    this.menuItems = null;
                }
                this.menuItemsX = null;
                this.menuItemsH = null;
                this.menuIcons = null;
                int n6 = 0;
                if (by == 1) {
                    objectArray = (Object[])GameStore.getResource(44, true);
                    String[] stringArray2 = GameStore.vectorToArray(GameStore.splitByString("en,de,fr,es,it,pt,ru ", ','));
                    n4 = stringArray2.length;
                    stringArray = new String[n4];
                    for (n3 = 0; n3 < n4; ++n3) {
                        int n7 = -1;
                        for (int i = 0; i < objectArray.length; ++i) {
                            if (!((String)objectArray[i]).trim().equals(stringArray2[n3].trim())) continue;
                            n7 = i;
                            i = objectArray.length;
                        }
                        stringArray[n3] = n7 == -1 || n7 == objectArray.length - 1 ? stringArray2[n3] : (String)objectArray[n7 + 1];
                    }
                    objectArray = null;
                } else {
                    n4 = this.navigationMatrix[this.navigationIndexX].length - 1;
                    objectArray = (Object[])this.games.get(this.navigationMatrix[this.navigationIndexX][0]);
                    if (GameStore.isKey(this.mainCategory, (String)objectArray[0])) {
                        this.drawGmgMenuItem = true;
                        ++n4;
                    } else {
                        this.drawGmgMenuItem = false;
                    }
                    if (objectArray[3] != null) {
                        ++n4;
                        this.drawLinkMenuItem = true;
                    } else {
                        this.drawLinkMenuItem = false;
                    }
                    stringArray = new String[n4];
                    int n8 = 0;
                    for (n3 = 0; n3 < this.navigationMatrix[this.navigationIndexX].length - 1; ++n3) {
                        Object[] objectArray3 = (Object[])this.games.get(this.navigationMatrix[this.navigationIndexX][n3 + 1]);
                        stringArray[n3] = (String)objectArray3[1];
                        ++n8;
                    }
                    if (this.drawGmgMenuItem) {
                        stringArray[n8] = (String)GameStore.getResource(6, false);
                        ++n8;
                    }
                    if (this.drawLinkMenuItem) {
                        stringArray[n8] = (String)objectArray[2];
                    }
                }
                this.menuItemsH = new int[n4];
                this.menuItemsX = new int[n4];
                this.menuItems = new String[n4][];
                this.menuIcons = new Image[n4];
                this.iconsH = 0;
                this.iconsW = 0;
                boolean bl = false;
                int n9 = 240 - 2 * this.menuX;
                if (by == 2) {
                    n3 = 0;
                    for (int i = 0; i < this.navigationMatrix[this.navigationIndexX].length - 1; ++i) {
                        Object[] objectArray4 = (Object[])this.games.get(this.navigationMatrix[this.navigationIndexX][i + 1]);
                        if (objectArray4[4] instanceof String) {
                            try {
                                objectArray4[4] = Image.createImage((String)("/" + objectArray4[4]));
                            }
                            catch (Exception exception) {
                                objectArray4[4] = null;
                            }
                        }
                        if (objectArray4[4] != null) {
                            this.menuIcons[i] = (Image)objectArray4[4];
                            this.iconsW = this.menuIcons[i].getWidth() > this.iconsW ? this.menuIcons[i].getWidth() : this.iconsW;
                            this.iconsH = this.menuIcons[i].getHeight() > this.iconsH ? this.menuIcons[i].getWidth() : this.iconsH;
                            bl = true;
                        } else {
                            this.menuIcons[i] = null;
                        }
                        ++n3;
                    }
                    if (this.drawGmgMenuItem) {
                        this.menuIcons[n3] = null;
                        ++n3;
                    }
                    Object[] objectArray5 = (Object[])this.games.get(this.navigationMatrix[this.navigationIndexX][0]);
                    if (this.drawLinkMenuItem && objectArray5[4] != null && objectArray5[4] instanceof String) {
                        try {
                            objectArray5[4] = Image.createImage((String)("/" + objectArray5[4]));
                        }
                        catch (Exception exception) {
                            objectArray5[4] = null;
                        }
                    }
                    if (this.drawLinkMenuItem && objectArray5[4] != null) {
                        this.menuIcons[n3] = (Image)objectArray5[4];
                        this.iconsW = this.menuIcons[n3].getWidth() > this.iconsW ? this.menuIcons[n3].getWidth() : this.iconsW;
                        this.iconsH = this.menuIcons[n3].getHeight() > this.iconsH ? this.menuIcons[n3].getWidth() : this.iconsH;
                        bl = true;
                    }
                }
                if (bl) {
                    n9 -= n5 + this.iconsW;
                }
                n3 = 0;
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    this.menuItems[n2] = GameStore.instance.divideBreaker(stringArray[n2], n9, this.fontBig);
                    int n10 = this.menuItems[n2].length * (this.lineHeightBig + this.lineGap) - this.lineGap;
                    this.menuItemsH[n2] = n10 > this.iconsH ? n10 : this.iconsH;
                    n3 += this.menuItemsH[n2] + this.itemGap;
                    if (by != 1) continue;
                    for (int i = 0; i < this.menuItems[n2].length; ++i) {
                        int n11 = GameStore.instance.getStringWidth(this.menuItems[n2][i], this.fontBig);
                        n6 = n11 > n6 ? n11 : n6;
                    }
                }
                n3 -= this.itemGap;
                n2 = this.iconsX = this.menuX;
                if (bl) {
                    n2 += this.iconsW + n5;
                }
                for (n = 0; n < this.menuItemsX.length; ++n) {
                    this.menuItemsX[n] = by == 1 ? 120 - n6 / 2 : n2;
                }
                this.menuYBegin = this.menuTitleY + this.menuTitleH + this.lineHeightBig;
                this.menuYEnd = by == 2 && this.navigationMatrix.length > 1 ? this.hArrowsY - this.lineHeightBig / 2 : this.softkeysY - this.lineHeightBig / 2;
                this.drawScrollUp = false;
                this.menuScrollingActive = n3 > this.menuYEnd - this.menuYBegin;
                this.drawScrollDown = this.menuScrollingActive;
                if (this.menuScrollingActive) {
                    this.menuYBegin += 3 * this.V_ARROW_HEIGHT / 2 - this.lineHeightBig / 2;
                    this.menuYEnd = by == 2 && this.navigationMatrix.length > 1 ? (this.hArrowsY < 320 - 3 * this.V_ARROW_HEIGHT / 2 ? this.hArrowsY - this.lineHeightBig / 2 : 320 - 3 * this.V_ARROW_HEIGHT / 2 - this.lineHeightBig / 2) : (320 - this.softkeysY > 3 * this.V_ARROW_HEIGHT / 2 ? this.softkeysY - this.lineHeightBig / 2 : 320 - 3 * this.V_ARROW_HEIGHT / 2 - this.lineHeightBig);
                } else {
                    this.menuYBegin += (this.menuYEnd - this.menuYBegin - n3) / 2;
                    this.menuYEnd = this.menuYBegin + n3;
                }
                if (this.navigationIndexY > 1) {
                    n = this.navigationIndexY - 1;
                    this.currentItem = 0;
                    this.firstVisibleItemIndex = 0;
                    this.navigationIndexY = 1;
                    for (int i = 0; i < n; ++i) {
                        this.scrollDown();
                    }
                } else {
                    this.currentItem = 0;
                    this.firstVisibleItemIndex = 0;
                    this.navigationIndexY = 0;
                }
            } else if (by == 7) {
                this.state = by;
                GameStore.instance.repaint();
                GameStore.instance.serviceRepaints();
                this.helperThread.addNewTask((byte)0, null);
            } else if (by == 8) {
                Object[] objectArray = (Object[])this.games.get(this.navigationMatrix[this.navigationIndexX][this.navigationIndexY]);
                this.state = by;
                GameStore.instance.repaint();
                GameStore.instance.serviceRepaints();
                this.helperThread.addNewTask((byte)1, objectArray);
            } else if (by == 3) {
                int n;
                int n12;
                int n13;
                String string;
                boolean bl;
                Object[] objectArray;
                block127: {
                    this.lineGap = 2;
                    this.addedToQueue = false;
                    this.currentScreenshotIsLoading = false;
                    this.currentScreenshot = null;
                    System.gc();
                    this.imageY = 10;
                    this.SCREENSHOT_Y = 10;
                    this.SCREENSHOT_X = this.imageX = 120 - this.SCREENSHOT_W / 2;
                    objectArray = (Object[])this.games.get(this.navigationMatrix[this.navigationIndexX][this.navigationIndexY]);
                    bl = "1".equals(objectArray[7]);
                    this.drawPress5Message = objectArray[3] != null && (!this.mgImplementation.toLowerCase().equals("static") || this.gotoLink != null && this.gotoLink.length() != 0);
                    this.currentScreenshot = null;
                    if (objectArray[5] != null) {
                        Object object;
                        if (objectArray[5] instanceof String) {
                            object = (String)objectArray[5];
                            if (((String)object).length() > 0) {
                                try {
                                    this.currentScreenshot = Image.createImage((String)("/" + objectArray[5]));
                                }
                                catch (Exception exception) {
                                    if (bl || !this.networkEnabled) {
                                        objectArray[5] = null;
                                        break block127;
                                    }
                                    objectArray[5] = "";
                                }
                            } else if (bl || !this.networkEnabled) {
                                objectArray[5] = null;
                            }
                        } else if (objectArray[5] instanceof byte[]) {
                            object = (byte[])objectArray[5];
                            try {
                                this.currentScreenshot = Image.createImage((byte[])object, (int)0, (int)((Object)object).length);
                            }
                            catch (Exception exception) {
                                objectArray[5] = null;
                            }
                        }
                    }
                }
                if ("".equals(objectArray[2]) && (bl || !this.networkEnabled)) {
                    objectArray[2] = null;
                }
                boolean bl2 = false;
                if (objectArray[2] == null && this.currentScreenshot == null) {
                    if (objectArray[3] != null) {
                        if (this.navigateNext || this.navigatePrev) {
                            bl2 = true;
                        } else {
                            this.initState((byte)4);
                        }
                    } else if (this.navigateNext) {
                        this.navigateNext();
                    } else if (this.navigatePrev) {
                        this.navigatePrev();
                    } else {
                        this.initState((byte)2);
                    }
                } else if (!bl && "".equals(objectArray[2])) {
                    if (!this.dialogIsShown) {
                        this.nextState = (byte)8;
                        this.initState((byte)9);
                    } else {
                        this.initState((byte)8);
                    }
                } else {
                    bl2 = true;
                }
                if (!bl2) {
                    return;
                }
                if (this.imgBroken == null) {
                    this.imgBroken = (Image)GameStore.getResource(32, true);
                }
                if (this.currentScreenshot == null) {
                    if (objectArray[5] == null) {
                        this.currentScreenshot = this.imgBroken;
                    } else if ("".equals(objectArray[5])) {
                        this.helperThread.addNewTask((byte)2, objectArray);
                        this.addedToQueue = true;
                    } else {
                        this.currentScreenshot = (Image)objectArray[5];
                    }
                }
                if (this.currentScreenshot != null) {
                    this.imageX = 120 - this.currentScreenshot.getWidth() / 2;
                    this.imageY = this.SCREENSHOT_Y + this.SCREENSHOT_H / 2 - this.currentScreenshot.getHeight() / 2;
                } else {
                    this.imageX = 120 - this.imgBroken.getWidth() / 2;
                    this.imageY = this.SCREENSHOT_Y + this.SCREENSHOT_H / 2 - this.imgBroken.getHeight() / 2;
                }
                int n14 = 3 * this.H_ARROW_WIDTH / 2;
                int n15 = this.lineHeightSmall / 2;
                this.textWidth = 240 - 2 * n14 - 2 * n15;
                this.boxWidth = this.textWidth + 2 * n15;
                if (this.drawPress5Message && this.press5Message == null) {
                    string = (String)GameStore.getResource(19, false);
                    this.press5Message = GameStore.instance.divideBreaker(string, this.textWidth, this.fontBig);
                    this.press5X = new int[this.press5Message.length];
                    n13 = 0;
                    for (n12 = 0; n12 < this.press5Message.length; ++n12) {
                        n = GameStore.instance.getStringWidth(this.press5Message[n12], this.fontSmall);
                        this.press5X[n12] = 120 - n / 2;
                        n13 = n13 > n ? n13 : n;
                    }
                    this.press5W = n13;
                }
                this.press5H = this.drawPress5Message ? this.press5Message.length * (this.lineHeightSmall + this.lineGap) - this.lineGap : 0;
                if (this.tafEnabled) {
                    if (this.tafMessage == null) {
                        string = (String)GameStore.getResource(9, false);
                        this.tafMessage = GameStore.instance.divideBreaker(string, 240 - 2 * this.lineHeightSmall, this.fontSmall);
                        this.tafX = new int[this.tafMessage.length];
                        n13 = 0;
                        for (n12 = 0; n12 < this.tafMessage.length; ++n12) {
                            n = GameStore.instance.getStringWidth(this.tafMessage[n12], this.fontSmall);
                            this.tafX[n12] = 120 - n / 2;
                            n13 = n13 > n ? n13 : n;
                        }
                        this.tafW = n13 < this.textWidth ? this.textWidth : n13;
                    }
                    this.tafH = this.tafMessage.length * (this.lineHeightSmall + this.lineGap) - this.lineGap;
                }
                this.press5Y = this.SCREENSHOT_Y + this.SCREENSHOT_H - 3 * this.press5H / 2;
                if (this.press5Y < this.SCREENSHOT_Y) {
                    this.press5Y = this.SCREENSHOT_Y;
                }
                this.textYBegin = this.SCREENSHOT_Y + this.SCREENSHOT_H + 3 * n15;
                this.hArrowsY = this.softkeysY - this.H_ARROW_HEIGHT;
                if (this.tafEnabled) {
                    this.tafY = this.SCREENSHOT_Y + this.SCREENSHOT_H + 2 * n15;
                    this.textYBegin += this.tafH + 2 * n15;
                    if (this.hArrowsY <= this.tafY + this.tafH + this.lineHeightSmall / 2 && 240 - (this.tafW + this.lineHeightSmall) < 5 * this.H_ARROW_WIDTH / 2) {
                        this.hArrowsY = this.tafY - this.H_ARROW_HEIGHT - this.lineHeightSmall / 2;
                    }
                }
                this.textYEnd = 10 < n15 ? 320 - n15 : 310;
                string = (String)objectArray[1];
                if (objectArray[2] != null) {
                    string = string + "\n" + objectArray[2];
                }
                this.textXBegin = n14 + n15;
                this.text = GameStore.instance.divideBreaker(string, this.textWidth, this.fontSmall);
                this.visibleLines = (this.textYEnd - this.textYBegin + this.lineGap) / (this.lineHeightSmall + this.lineGap);
                this.drawScrollUp = false;
                if (this.visibleLines < this.text.length) {
                    this.drawScrollDown = true;
                    this.textWidth -= 2 * this.TEXT_ARROW_HEIGHT + 1;
                    this.text = GameStore.instance.divideBreaker(string, this.textWidth, this.fontSmall);
                    this.textArrowsX = this.textXBegin + this.textWidth + this.TEXT_ARROW_HEIGHT + 1;
                } else {
                    this.drawScrollDown = false;
                }
                String[] stringArray = GameStore.instance.divideBreaker((String)objectArray[1], this.textWidth, this.fontSmall);
                this.titleTextX = new int[stringArray.length];
                for (n12 = 0; n12 < stringArray.length; ++n12) {
                    this.titleTextX[n12] = this.textXBegin + this.textWidth / 2 - GameStore.instance.getStringWidth(stringArray[n12], this.fontSmall) / 2;
                }
                this.textY = this.textYBegin + (this.textYEnd - this.textYBegin - this.lineHeightSmall * this.visibleLines - this.lineGap * (this.visibleLines - 1)) / 2;
                this.currentLine = 0;
                this.drawScrollUp = false;
                this.rectangleCycleCount = 0;
                this.rectangleFlag = true;
                this.state = (byte)3;
            } else if (by == 5) {
                int n = this.gotoLink.indexOf("http://");
                if (n != -1) {
                    this.gotoLink = this.gotoLink.substring(n + 7, this.gotoLink.length());
                }
                String string = GameStore.getResource(3, false) + this.gotoLink + GameStore.getResource(15, false);
                this.initMessage(string, this.lineHeightBig / 3, 220);
            } else if (by == 6) {
                String string = (String)GameStore.getResource(21, false);
                this.initMessage(string, this.lineHeightBig / 3, GameStore.instance.realScreenW - 20);
            } else if (by == 4) {
                String string = (String)GameStore.getResource(4, false);
                this.initMessage(string, this.lineHeightBig / 3, 220);
            } else if (by == 13) {
                Object[] objectArray = (Object[])this.games.get(this.navigationMatrix[this.navigationIndexX][this.navigationIndexY]);
                String string = (String)GameStore.getResource(8, false);
                String string2 = (String)GameStore.getResource(2, false);
                String string3 = (String)GameStore.getResource(20, false);
                String string4 = (String)objectArray[3];
                this.initMessage(string + string3 + string4 + string2, this.lineHeightBig / 3, 220);
            } else if (by == 14) {
                String string = (String)GameStore.getResource(12, false);
                this.initMessage(string, this.lineHeightBig / 3, 220);
            } else if (by == 9) {
                String string = (String)GameStore.getResource(25, false);
                this.initMessage(string, this.lineHeightBig / 3, 220);
            } else if (this.tafEnabled && by == 10) {
                if (this.editBox == null) {
                    this.editBox = new TextBox("Enter number", "", 13, 3);
                    this.editBox.addCommand(this.commandOk);
                    this.editBox.addCommand(this.commandBack);
                    this.editBox.setCommandListener((CommandListener)GameStore.instance);
                }
                GameStore.instance.setCurrentDisplayable((Displayable)this.editBox);
            } else if (this.tafEnabled && by == 11) {
                if (this.strSending == null) {
                    this.strSending = (String)GameStore.getResource(18, false);
                    this.strSendingWidth = GameStore.instance.getStringWidth(this.strSending, this.fontBig);
                }
                this.initMessage(this.strSending, this.lineHeightBig / 3, 220);
                Object[] objectArray = (Object[])this.games.get(this.navigationMatrix[this.navigationIndexX][this.navigationIndexY]);
                String string = (String)objectArray[3];
                String string5 = (String)GameStore.getResource(20, false);
                string5 = string5 + " " + string;
                String string6 = this.editBox.getString();
                String string7 = (String)GameStore.getResource(43, true);
                if (string7 != null && !"".equals(string7)) {
                    string6 = string6 + ":" + string7;
                }
                this.smsSentStatus = 0;
                boolean bl = GameStore.instance.setCurrentModule(2, new Object[]{new Integer(GameStore.instance.currentModuleIndex), string6, string5}, false);
                if (!bl) {
                    this.initState(this.prevState);
                }
            } else if (this.tafEnabled && by == 12) {
                String string = null;
                switch (this.smsSentStatus) {
                    case 1: {
                        string = (String)GameStore.getResource(22, false);
                        break;
                    }
                    case 2: {
                        string = (String)GameStore.getResource(24, false);
                    }
                }
                if (string != null) {
                    this.initMessage(string, this.lineHeightBig / 3, 220);
                } else {
                    this.setState(this.prevState);
                }
            }
            if (by != 3) {
                this.state = by;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initMessage(String message, int lineGap, int currentScreenW) {
        int i;
        this.textYBegin = 10;
        this.textYEnd = this.softkeysY;
        this.lineGap = lineGap;
        if (this.text != null) {
            for (i = 0; i < this.text.length; ++i) {
                this.text[i] = null;
            }
            this.text = null;
        }
        this.text = GameStore.instance.divideBreaker(message, currentScreenW - 20, this.fontBig);
        this.titleTextX = new int[this.text.length];
        this.textWidth = 0;
        for (i = 0; i < this.titleTextX.length; ++i) {
            this.titleTextX[i] = currentScreenW / 2 - GameStore.instance.getStringWidth(this.text[i], this.fontBig) / 2;
        }
        this.drawScrollUp = false;
        this.visibleLines = (this.textYEnd - this.textYBegin + lineGap) / (this.lineHeightBig + lineGap);
        if (this.visibleLines > this.text.length) {
            this.visibleLines = this.text.length;
        }
        boolean bl = this.drawScrollDown = this.visibleLines < this.text.length;
        if (this.drawScrollDown) {
            this.textYBegin += 3 * this.V_ARROW_HEIGHT / 2;
            this.textYEnd = 320 - this.softkeysY > 3 * this.V_ARROW_HEIGHT / 2 ? this.softkeysY : 320 - 3 * this.V_ARROW_HEIGHT / 2;
            this.visibleLines = (this.textYEnd - this.textYBegin + lineGap) / (this.lineHeightBig + lineGap);
            if (this.visibleLines > this.text.length) {
                this.visibleLines = this.text.length;
            }
            this.textY = this.textYBegin;
        } else {
            this.textY = this.textYBegin + (this.textYEnd - this.textYBegin - this.lineHeightBig * this.visibleLines - lineGap * (this.visibleLines - 1)) / 2;
        }
        this.currentLine = 0;
        this.drawScrollUp = false;
    }

    public void commandAction(Command command) {
        if (!this.tafEnabled) {
            return;
        }
        if (command == this.commandOk) {
            this.keyPressed(1);
        } else if (command == this.commandBack) {
            this.keyPressed(2);
        }
    }

    protected void pointerDragged(int x, int y) {
    }

    protected void pointerPressed(int x, int y) {
        this.ix = x;
        this.iy = y;
    }

    public boolean needPaint() {
        return true;
    }

    public void smsSenderCallback(int sentStatus) {
        this.smsSentStatus = sentStatus;
    }
}

