/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BMFont {
    static final int ALIGN_LEFT = 0;
    static final int ALIGN_CENTER = 1;
    static final int ALIGN_RIGHT = 2;
    static final int ALIGN_V_UPPER = 0;
    static final int ALIGN_V_CENTER = 1;
    static final int ALIGN_V_LOWER = 2;
    static final char BREAK_LINE_CHAR = '%';
    static final char NEXT_PAGE_CHAR = '#';
    private int[] positionOfSpace = new int[1100];
    private byte[] fileId;
    private byte fileVersion;
    private int numberOfPages;
    private int numberOfChars;
    private int numberOfKernings;
    private tBlock1 info;
    private tBlock2 common;
    private String[] pageNames;
    private tBlock4[] chars;
    private tBlock5[] kerning;
    private Image[] imgPageTexture;
    private char[] charNr;
    boolean ofail = false;
    private int vDelta = 0;
    private int clipX;
    private int clipY;
    private int clipW;
    private int clipH;
    private String hsString;
    private int hsMaxPos;
    private int hsCurrPos;
    private int hsWidth;
    private int hsHeight;
    private int hsVdelta;
    private int hsX;
    private int hsY;
    private int Ia;
    private int Id;
    private int[] sCurrPos = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private int[] sCurrDir = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private int sMaxPos;
    private int pS;
    private long hsZero;
    private long sZero;
    private long sTime;
    private boolean hsHasZero;

    public BMFont() {
        this.reset();
    }

    public BMFont(String fileName) {
        if (this.setFont(fileName) != 1) {
            this.reset();
        }
    }

    public static BMFont createBMFont(String fileName) {
        BMFont bmf = new BMFont();
        if (bmf.setFont(fileName) != 1) {
            return null;
        }
        return bmf;
    }

    private void reset() {
        this.numberOfPages = 0;
        while (this.numberOfPages < this.positionOfSpace.length) {
            this.positionOfSpace[this.numberOfPages] = 0;
            ++this.numberOfPages;
        }
        this.fileId = null;
        this.fileVersion = 0;
        this.numberOfPages = 0;
        this.numberOfChars = 0;
        this.numberOfKernings = 0;
        this.info = null;
        this.common = null;
        this.pageNames = null;
        this.chars = null;
        this.kerning = null;
        this.imgPageTexture = null;
        this.charNr = null;
    }

    public int setFont(String fileName) {
        this.ofail = fileName.equals("/Sprites/Font/menu_small.fnt");
        this.reset();
        InputStream is = this.getClass().getResourceAsStream(fileName);
        if (is == null) {
            System.out.println("ERROR: Unable to open font file: " + fileName);
            return 0;
        }
        try {
            int i;
            this.fileId = new byte[3];
            is.read(this.fileId, 0, 3);
            this.fileVersion = (byte)is.read();
            String tmpStr = new String(this.fileId);
            if (tmpStr.compareTo("BMF") != 0 || this.fileVersion != 3) {
                System.out.println("ERROR: Wrong BMFont file format at: %" + fileName);
                System.out.println("fileId: " + tmpStr);
                System.out.println("fileVersion: " + this.fileVersion);
                is.close();
                return 0;
            }
            byte blockType = this.readByte(is);
            int blockSize = this.readInt(is);
            this.info = new tBlock1();
            this.info.fontSize = (short)Math.abs(this.readShort(is));
            this.info.bitField = this.readByte(is);
            this.info.charSet = this.readByte(is);
            this.info.stretchH = this.readShort(is);
            this.info.aa = this.readByte(is);
            this.info.paddingUp = this.readByte(is);
            this.info.paddingRight = this.readByte(is);
            this.info.paddingDown = this.readByte(is);
            this.info.paddingLeft = this.readByte(is);
            this.info.spacingHoriz = this.readByte(is);
            this.info.spacingVert = this.readByte(is);
            this.info.outline = this.readByte(is);
            byte[] tmpBytes = new byte[blockSize - 14];
            is.read(tmpBytes, 0, blockSize - 14);
            this.info.fontName = new String(tmpBytes).trim();
            blockType = this.readByte(is);
            blockSize = this.readInt(is);
            this.common = new tBlock2();
            this.common.lineHeight = this.readShort(is);
            this.common.base = this.readShort(is);
            this.common.scaleW = this.readShort(is);
            this.common.scaleH = this.readShort(is);
            this.common.pages = this.readShort(is);
            this.common.bitField = this.readByte(is);
            this.common.alphaChnl = this.readByte(is);
            this.common.redChnl = this.readByte(is);
            this.common.greenChnl = this.readByte(is);
            this.common.blueChnl = this.readByte(is);
            this.numberOfPages = this.common.pages;
            blockType = this.readByte(is);
            blockSize = this.readInt(is);
            char[] tmpName = new char[100];
            this.pageNames = new String[this.numberOfPages];
            for (int i2 = 0; i2 < this.numberOfPages; ++i2) {
                int count = 0;
                do {
                    tmpName[count] = (char)this.readByte(is);
                } while (tmpName[++count - 1] != '\u0000');
                this.pageNames[i2] = new String(tmpName, 0, count - 1);
            }
            tmpName = null;
            blockType = this.readByte(is);
            blockSize = this.readInt(is);
            this.numberOfChars = blockSize / 20;
            this.chars = new tBlock4[this.numberOfChars];
            int maxId = 0;
            for (i = 0; i < this.numberOfChars; ++i) {
                this.chars[i] = new tBlock4();
                this.chars[i].cId = this.readInt(is);
                this.chars[i].x = this.readShort(is);
                this.chars[i].y = this.readShort(is);
                this.chars[i].width = this.readShort(is);
                this.chars[i].height = this.readShort(is);
                this.chars[i].xoffset = this.readShort(is);
                this.chars[i].yoffset = this.readShort(is);
                this.chars[i].xadvance = this.readShort(is);
                this.chars[i].page = this.readByte(is);
                this.chars[i].chnl = this.readByte(is);
                if (this.chars[i].cId <= maxId) continue;
                maxId = this.chars[i].cId;
            }
            this.charNr = new char[maxId + 1];
            for (i = 0; i < maxId + 1; ++i) {
                this.charNr[i] = '\u0000';
            }
            for (i = 0; i < this.numberOfChars; ++i) {
                int cId = this.chars[i].cId;
                this.charNr[cId] = (char)i;
            }
            is.close();
        }
        catch (Exception e) {
            System.out.println("ERROR: Unable to read font file: " + fileName);
            return 0;
        }
        String strDir = "";
        if (fileName.indexOf(47) != -1) {
            int firstIndex = fileName.indexOf(47);
            int lastIndex = 0;
            for (int i = 0; i < fileName.length(); ++i) {
                if (fileName.charAt(i) != '/') continue;
                lastIndex = i;
            }
            strDir = strDir + fileName.substring(firstIndex, lastIndex + 1);
        }
        this.imgPageTexture = new Image[this.numberOfPages];
        for (int i = 0; i < this.numberOfPages; ++i) {
            String pName = strDir;
            pName = pName + this.pageNames[i];
            try {
                this.imgPageTexture[i] = Image.createImage((String)pName);
                continue;
            }
            catch (Exception e) {
                System.out.println("ERROR: Unable to load font texture: " + pName);
                return 0;
            }
        }
        return 1;
    }

    private byte readByte(InputStream is) throws Exception {
        return (byte)is.read();
    }

    private short readShort(InputStream is) throws Exception {
        byte[] bytes = new byte[2];
        is.read(bytes, 0, 2);
        return (short)((bytes[1] & 0xFF) << 8 | bytes[0] & 0xFF);
    }

    private int readInt(InputStream is) throws Exception {
        byte[] bytes = new byte[4];
        is.read(bytes, 0, 4);
        return (bytes[3] & 0xFF) << 24 | (bytes[2] & 0xFF) << 16 | (bytes[1] & 0xFF) << 8 | bytes[0] & 0xFF;
    }

    public void showCharsInfo() {
        int i;
        System.out.println("NumberOfChars: " + this.numberOfChars);
        for (i = 0; i < this.numberOfChars; ++i) {
            System.out.println("charId: " + this.chars[i].cId);
            System.out.println("x: " + this.chars[i].x);
            System.out.println("y: " + this.chars[i].y);
            System.out.println("width: " + this.chars[i].width);
            System.out.println("height: " + this.chars[i].height);
            System.out.println("xoffset: " + this.chars[i].xoffset);
            System.out.println("yoffset: " + this.chars[i].yoffset);
            System.out.println("xadvance: " + this.chars[i].xadvance);
            System.out.println("page: " + this.chars[i].page);
            System.out.println("chnl: " + this.chars[i].chnl);
        }
        System.out.println("NumberOfKernings: " + this.numberOfKernings);
        for (i = 0; i < this.numberOfKernings; ++i) {
            System.out.println("first: " + this.kerning[i].first);
            System.out.println("second: " + this.kerning[i].second);
            System.out.println("amount: " + this.kerning[i].amount);
        }
    }

    public int charWidth(char ch) {
        return this.chars[this.charNr[ch]].width;
    }

    public int charHeight(char ch) {
        return this.chars[this.charNr[ch]].height;
    }

    public int charsWidth(char[] ch, int offset, int length) {
        int xpos = 0;
        for (int i = 0; i < length; ++i) {
            xpos += this.chars[this.charNr[ch[offset + i]]].xadvance;
        }
        return xpos;
    }

    public int stringWidth(String str) {
        int xpos = 0;
        for (int i = 0; i < str.length(); ++i) {
            xpos += this.chars[this.charNr[str.charAt((int)i)]].xadvance + (this.info.outline << 1);
        }
        return xpos;
    }

    public int substringWidth(String str, int offset, int len) {
        return this.stringWidth(str.substring(offset, offset + len));
    }

    public int getHeight() {
        return this.common.lineHeight;
    }

    public int getBaseLinePosition() {
        return this.common.base;
    }

    public void drawChar(Graphics g, char character, int x, int y, int anchor) {
        if (this.ofail) {
            if (character == '\u00f5') {
                character = (char)244;
            } else if (character == '\u00f4') {
                character = (char)245;
            }
        }
        if (anchor != 0) {
            int anchorX = 0;
            int anchorY = 0;
            if ((anchor & 8) == 8) {
                anchorX = this.charWidth(character);
            }
            if ((anchor & 1) == 1) {
                anchorX = this.charWidth(character) >> 1;
            }
            if ((anchor & 0x20) == 32) {
                anchorY = this.getHeight();
            }
            if ((anchor & 2) == 2) {
                anchorY = this.getHeight() >> 1;
            }
            if ((anchor & 0x40) == 64) {
                anchorY = this.getBaseLinePosition();
            }
            x -= anchorX;
            y -= anchorY;
        }
        character = this.charNr[character];
        this.pushClip(g);
        g.clipRect(x += this.chars[character].xoffset, y += this.chars[character].yoffset, (int)this.chars[character].width, (int)this.chars[character].height);
        g.drawImage(this.imgPageTexture[this.chars[character].page], x - this.chars[character].x, y - this.chars[character].y, 0);
        this.popClip(g);
    }

    public void drawString(Graphics g, String str, int x, int y, int anchor) {
        int sx = 0;
        if (anchor != 0) {
            int anchorX = 0;
            int anchorY = 0;
            if ((anchor & 8) == 8) {
                anchorX = this.stringWidth(str);
            }
            if ((anchor & 1) == 1) {
                anchorX = this.stringWidth(str) >> 1;
            }
            if ((anchor & 0x20) == 32) {
                anchorY = this.getHeight();
            }
            if ((anchor & 2) == 2) {
                anchorY = this.getHeight() >> 1;
            }
            if ((anchor & 0x40) == 64) {
                anchorY = this.getBaseLinePosition();
            }
            x -= anchorX;
            y -= anchorY;
        }
        this.pushClip(g);
        for (int i = 0; i < str.length(); ++i) {
            int c = this.ofail ? (str.charAt(i) == '\u00f5' ? 244 : (str.charAt(i) == '\u00f4' ? 245 : (int)str.charAt(i))) : str.charAt(i);
            char cId = this.charNr[c];
            this.popClip(g);
            g.clipRect(x + sx + this.chars[cId].xoffset, y + this.chars[cId].yoffset, (int)this.chars[cId].width, (int)this.chars[cId].height);
            g.drawImage(this.imgPageTexture[this.chars[cId].page], x + sx - this.chars[cId].x + this.chars[cId].xoffset, y - this.chars[cId].y + this.chars[cId].yoffset, 0);
            sx += this.chars[cId].xadvance + (this.info.outline << 1);
        }
        this.popClip(g);
    }

    public void drawTextInRect(Graphics g, String str, int x, int y, int width, int height, int align, int valign, int anchor) {
        if (anchor != 0) {
            int anchorX = 0;
            int anchorY = 0;
            if ((anchor & 8) == 8) {
                anchorX = this.stringWidth(str);
            }
            if ((anchor & 1) == 1) {
                anchorX = this.stringWidth(str) >> 1;
            }
            if ((anchor & 0x20) == 32) {
                anchorY = this.getHeight();
            }
            if ((anchor & 2) == 2) {
                anchorY = this.getHeight() >> 1;
            }
            x -= anchorX;
            y -= anchorY;
        }
        Vector textLines = this.splitTextIntoLines(str, width);
        switch (valign) {
            case 0: {
                this.vDelta = 0;
                break;
            }
            case 1: {
                this.vDelta = height - this.getHeight() * textLines.size() >> 1;
                break;
            }
            case 2: {
                this.vDelta = height - this.getHeight() * textLines.size();
            }
        }
        for (int i = 0; i < textLines.size(); ++i) {
            if ((i + 1) * this.getHeight() <= height) {
                switch (align) {
                    case 0: {
                        this.drawString(g, (String)textLines.elementAt(i), x, y + this.vDelta + i * this.getHeight(), 0);
                        break;
                    }
                    case 1: {
                        this.drawString(g, (String)textLines.elementAt(i), x + (width - this.stringWidth((String)textLines.elementAt(i)) >> 1), y + this.vDelta + i * this.getHeight(), 0);
                        break;
                    }
                    case 2: {
                        this.drawString(g, (String)textLines.elementAt(i), x + (width - this.stringWidth((String)textLines.elementAt(i))), y + this.vDelta + i * this.getHeight(), 0);
                    }
                }
                continue;
            }
            return;
        }
    }

    public Vector splitTextIntoLines(String str, int width) {
        int i;
        Vector<String> textLines = new Vector<String>();
        int numOfSpace = 0;
        int pointer = 0;
        for (i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != ' ' && str.charAt(i) != '%' && str.charAt(i) != '#') continue;
            this.positionOfSpace[pointer] = i;
            ++pointer;
            ++numOfSpace;
        }
        pointer = 0;
        for (i = 0; i < numOfSpace; ++i) {
            if (this.stringWidth(str.substring(pointer, this.positionOfSpace[i])) <= width && str.charAt(this.positionOfSpace[i]) != '%' && str.charAt(this.positionOfSpace[i]) != '#') continue;
            if (i - 1 < 0) {
                ++i;
            }
            textLines.addElement(str.substring(pointer, this.positionOfSpace[i - 1]).trim());
            pointer = this.positionOfSpace[i - 1] + 1;
            if (str.charAt(this.positionOfSpace[i]) != '%') continue;
            ++pointer;
        }
        if (this.stringWidth(str.substring(pointer)) > width && numOfSpace > 0) {
            if (pointer < this.positionOfSpace[numOfSpace - 1]) {
                textLines.addElement(str.substring(pointer, this.positionOfSpace[numOfSpace - 1]).trim());
            }
            pointer = this.positionOfSpace[numOfSpace - 1] + 1;
        }
        textLines.addElement(str.substring(pointer).trim());
        return textLines;
    }

    private void pushClip(Graphics g) {
        this.clipX = g.getClipX();
        this.clipY = g.getClipY();
        this.clipW = g.getClipWidth();
        this.clipH = g.getClipHeight();
    }

    private void popClip(Graphics g) {
        g.setClip(this.clipX, this.clipY, this.clipW, this.clipH);
    }

    public void drawScrollInRect(Graphics g, String str, int x, int y, int width, int height, int anchor) {
        this.sMaxPos = -(this.stringWidth(str) - width) - 5;
        if (this.sCurrPos[this.pS] > width) {
            this.sCurrPos[this.pS] = width;
        }
        if (this.sCurrPos[this.pS] < this.sMaxPos) {
            this.sCurrPos[this.pS] = this.sMaxPos;
            int n = this.pS;
            this.sCurrDir[n] = this.sCurrDir[n] * -1;
        } else if (this.sCurrPos[this.pS] > 5) {
            this.sCurrPos[this.pS] = 5;
            int n = this.pS;
            this.sCurrDir[n] = this.sCurrDir[n] * -1;
        }
        if (anchor != 0) {
            int anchorX = 0;
            int anchorY = 0;
            if ((anchor & 8) == 8) {
                anchorX = this.stringWidth(str);
            }
            if ((anchor & 1) == 1) {
                anchorX = this.stringWidth(str) >> 1;
            }
            if ((anchor & 0x20) == 32) {
                anchorY = this.getHeight();
            }
            if ((anchor & 2) == 2) {
                anchorY = this.getHeight() >> 1;
            }
            x -= anchorX;
            y -= anchorY;
        }
        g.setClip(x, y, width, height);
        this.drawString(g, str, x + this.sCurrPos[this.pS], y + (height - this.getHeight() >> 1), 0);
        if (this.pS < 15) {
            ++this.pS;
        }
        g.setClip(0, 0, 240, 320);
    }

    public void moveScrolls(long value) {
        if (this.pS == 0) {
            return;
        }
        this.sTime = value;
        if (this.sTime >= this.sZero + 35L) {
            this.Id = (int)(this.sTime - this.sZero) / 35;
            this.Ia = 0;
            while (this.Ia < this.pS) {
                int n = this.Ia;
                this.sCurrPos[n] = this.sCurrPos[n] + this.Id * this.sCurrDir[this.Ia];
                ++this.Ia;
            }
            this.sZero = this.sTime;
        }
        this.pS = 0;
    }

    public void setHorizontalScroller(String str, int width, int height) {
        this.hsString = str;
        this.hsMaxPos = this.stringWidth(str) * -1;
        this.hsWidth = width;
        this.hsHeight = height;
        this.hsHasZero = false;
        this.hsCurrPos = this.hsWidth;
        this.hsVdelta = this.hsHeight - this.common.lineHeight >> 1;
    }

    public void moveHorizontalScroller(long value) {
        if (!this.hsHasZero) {
            this.hsZero = value;
            this.hsHasZero = true;
            return;
        }
        this.hsCurrPos = (int)((float)(value - this.hsZero) * -0.04f) + this.hsWidth;
        if (this.hsCurrPos < this.hsMaxPos) {
            this.hsCurrPos = this.hsWidth;
            this.hsZero = value;
        }
    }

    public void putHorizontalScroller(int x, int y) {
        this.hsX = x;
        this.hsY = y;
    }

    public void drawHorizontalScroller(Graphics g) {
        g.setClip(this.hsX, this.hsY, this.hsWidth, this.hsHeight);
        this.drawString(g, this.hsString, this.hsX + this.hsCurrPos, this.hsY + this.hsVdelta, 0);
    }

    private class tBlock5 {
        long first;
        long second;
        short amount;

        private tBlock5() {
        }
    }

    private class tBlock4 {
        int cId;
        short x;
        short y;
        short width;
        short height;
        short xoffset;
        short yoffset;
        short xadvance;
        byte page;
        byte chnl;

        private tBlock4() {
        }
    }

    private class tBlock2 {
        short lineHeight;
        short base;
        short scaleW;
        short scaleH;
        short pages;
        byte bitField;
        byte alphaChnl;
        byte redChnl;
        byte greenChnl;
        byte blueChnl;

        private tBlock2() {
        }
    }

    private class tBlock1 {
        short fontSize;
        byte bitField;
        byte charSet;
        short stretchH;
        byte aa;
        byte paddingUp;
        byte paddingRight;
        byte paddingDown;
        byte paddingLeft;
        byte spacingHoriz;
        byte spacingVert;
        byte outline;
        String fontName;

        private tBlock1() {
        }
    }
}

