/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class MissionManager
extends GameLogic {
    public static int[] itemProbability;
    private Mission currentMission;
    private int missionId;
    public static boolean firstMissionPassed;
    private static int prevMission;
    private static boolean restart;
    private static boolean autoFail;

    public static void resetPrev() {
        prevMission = -1;
    }

    public MissionManager() {
        autoFail = false;
        this.setMission(GameLogic.gameWorld * 3 + GameLogic.gameTrack);
    }

    private void setMission(int m) {
        restart = prevMission == m;
        prevMission = m;
        this.missionId = m;
        this.currentMission = Stats.missionData[m];
        itemProbability = new int[6];
        MissionManager.itemProbability[0] = this.currentMission.bigGums;
        MissionManager.itemProbability[1] = itemProbability[0] + this.currentMission.katamaris;
        MissionManager.itemProbability[2] = itemProbability[1] + this.currentMission.drillers;
        MissionManager.itemProbability[3] = itemProbability[2] + this.currentMission.fatalities;
        MissionManager.itemProbability[4] = itemProbability[3] + this.currentMission.invincibilities;
        MissionManager.itemProbability[5] = itemProbability[4] + this.currentMission.autopilots;
    }

    public void release() {
        super.release();
        itemProbability = null;
    }

    public int getMissionId() {
        return this.missionId;
    }

    public void init() {
        int[] tab = new int[500000];
        tab[499999] = 1;
        this.firstFinish = false;
        gameItems = true;
        this.save = false;
        gameLaps = this.currentMission.missionLaps;
        gameState = 1;
        gameDifficulty = 1;
        this.race = new int[2][];
        if (this.currentMission.gums) {
            Kart.MAX_COLLECTIBLES = 100;
            Kart.BEGIN_COLLECTIBLES = 0;
        } else {
            Kart.MAX_COLLECTIBLES = 10;
            Kart.BEGIN_COLLECTIBLES = 5;
        }
        if (this.currentMission.boss) {
            this.race[0] = new int[2];
            this.race[1] = new int[2];
        } else {
            this.race[0] = new int[1];
            this.race[1] = new int[1];
        }
        this.race[1][0] = gameKart;
        this.race[0][0] = gameChar;
        if (this.currentMission.boss) {
            this.race[1][1] = this.currentMission.bossKart;
            this.race[0][1] = this.currentMission.bossChar;
        }
        this.nrActiveKarts = this.race[1].length;
        this.nrFinishedKarts = 0;
        this.kartsFinished = new boolean[this.nrActiveKarts];
        this.kartsOrder = new int[this.nrActiveKarts];
        this.kartsTimes = new String[this.nrActiveKarts];
        this.initHUD();
        this.m_RaceManager = new RaceManager();
        this.m_RaceManager.aiMissionParameters[0] = this.currentMission.bossAccuracy;
        this.m_RaceManager.aiMissionParameters[1] = this.currentMission.bossAggressivity;
        this.m_RaceManager.aiMissionParameters[2] = this.currentMission.bossItemity;
        this.m_RaceManager.aiMissionParameters[3] = this.currentMission.bossInsurance;
        this.m_RaceManager.aiMissionParameters[4] = this.currentMission.bossDrifting;
        this.m_RaceManager.race = this.race;
        this.timer = 0L;
        this.raceTime = 0L;
        this.timeDisp = this.timeStr = GameFrame.timeToStr(this.raceTime);
        this.playerLaps = 1;
        tab = null;
    }

    private void checkUnlocks() {
        if (!this.pass) {
            return;
        }
        int mis_id = this.getMissionId();
        if (!MissionManager.m_GameFrame.m_Menu.menuMiss_s[mis_id + 1]) {
            if (mis_id == 11) {
                this.firstFinish = true;
            }
            MissionManager.m_GameFrame.m_Menu.menuMiss_s[mis_id + 1] = true;
            this.save = true;
        }
    }

    public boolean update(float frame) {
        boolean finish = false;
        switch (gameState) {
            case 1: {
                gameState = 2;
                this.m_RaceManager.camAnim = true;
                this.timer = MainCanvas.m_CurrTime;
                break;
            }
            case 2: {
                SoundManager.playSfx(4);
                this.timeDisp = this.timeStr = GameFrame.timeToStr(this.currentMission.missionTime);
                if (m_GameFrame.isKeyDown(8)) {
                    this.m_RaceManager.camAnim = false;
                }
                if (this.m_RaceManager.camAnim) break;
                Kart.endIntro();
                this.timer = MainCanvas.m_CurrTime;
                if (!firstMissionPassed) {
                    gameState = 3;
                    break;
                }
                if (!restart) {
                    gameState = 4;
                    break;
                }
                this.timer = MainCanvas.m_CurrTime;
                gameState = 5;
                break;
            }
            case 5: {
                if (MainCanvas.m_CurrTime - this.timer <= 3000L) break;
                gameState = 6;
                this.m_RaceManager.m_Karts[0].acceleratePush();
                this.raceTimer = MainCanvas.m_CurrTime;
                break;
            }
            case 3: {
                m_GameFrame.showMessage(Text.getText(218) + " % %" + Text.getText(283), Text.getText(282) + " " + (this.missionId + 1) + ": " + " % %" + Text.getText(Text.Mission_summary[this.missionId]) + " % %" + Text.getText(283));
                gameState = 5;
                this.raceTimer = MainCanvas.m_CurrTime;
                this.timeDisp = this.timeStr = GameFrame.timeToStr(this.currentMission.missionTime);
                break;
            }
            case 4: {
                m_GameFrame.showMessage(Text.getText(282) + " " + (this.missionId + 1) + ": " + " % %" + Text.getText(Text.Mission_summary[this.missionId]) + " % %" + Text.getText(283));
                this.timer = MainCanvas.m_CurrTime;
                gameState = 5;
                this.raceTimer = MainCanvas.m_CurrTime;
                this.timeStr = GameFrame.timeToStr(this.currentMission.missionTime);
                break;
            }
            case 6: {
                this.raceTime = MainCanvas.m_CurrTime - this.raceTimer;
                this.timeDisp = this.timeStr = GameFrame.timeToStr((long)this.currentMission.missionTime - this.raceTime);
                if (this.m_RaceManager.m_Karts[0].bestPos / this.m_RaceManager.m_Track.iPoints.length > this.playerLaps) {
                    this.playerLaps = Math.min(this.currentMission.missionLaps, this.m_RaceManager.m_Karts[0].bestPos / this.m_RaceManager.m_Track.iPoints.length);
                }
                if (this.checkEndCondition()) {
                    if (this.pass) {
                        SoundManager.playSfx(23);
                    } else {
                        SoundManager.playSfx(2);
                    }
                    this.m_RaceManager.m_AI[0].setAwake();
                    MissionManager.m_GameFrame.m_Menu.menuAfter_s[0] = this.pass;
                    this.checkUnlocks();
                    gameState = 7;
                    this.timer = MainCanvas.m_CurrTime;
                    m_GameFrame.saveSettings();
                }
                this.updateControll();
                break;
            }
            case 7: {
                this.raceTime = MainCanvas.m_CurrTime - this.raceTimer;
                this.timeStr = GameFrame.timeToStr(this.raceTime);
                this.updateControll();
                if (!m_GameFrame.isKeyDown(999) || MainCanvas.m_CurrTime - this.timer <= 2000L) break;
                this.timer = MainCanvas.m_CurrTime;
                if (this.save) {
                    m_GameFrame.saveSettings();
                }
                if (this.firstFinish) {
                    gameState = 12;
                    break;
                }
                gameState = 0;
                finish = true;
                break;
            }
            case 12: {
                m_GameFrame.showMessage(Text.getText(200));
                gameState = 0;
                break;
            }
            case 0: {
                finish = true;
            }
        }
        this.blink = !this.blink;
        this.m_RaceManager.update(Stats.frame[gameDifficulty] * frame);
        return finish;
    }

    protected boolean checkEndCondition() {
        if (autoFail) {
            this.pass = false;
            firstMissionPassed = true;
            return true;
        }
        boolean end = false;
        this.pass = true;
        if (this.currentMission.timer && (long)this.currentMission.missionTime - this.raceTime <= 0L) {
            end = true;
        }
        if (this.currentMission.laps && this.m_RaceManager.m_Karts[0].lap > this.currentMission.missionLaps) {
            end = true;
        }
        if (this.currentMission.gums && this.m_RaceManager.m_Karts[0].getCollectibleCount() > this.currentMission.maxGums) {
            end = true;
        }
        if (this.currentMission.boss && this.m_RaceManager.m_Karts[1].lap > this.currentMission.missionLaps) {
            end = true;
        }
        if (this.currentMission.doors && this.m_RaceManager.m_Karts[0].getCurrentDoor() >= this.m_RaceManager.getDoorNumber() - 1) {
            end = true;
        }
        if (this.currentMission.drifts && this.m_RaceManager.m_Karts[0].getDrfitBoostCounter() >= this.currentMission.minDrifts) {
            end = true;
        }
        if (end && this.currentMission.gums && (this.m_RaceManager.m_Karts[0].getCollectibleCount() < this.currentMission.minGums || this.m_RaceManager.m_Karts[0].getCollectibleCount() >= this.currentMission.maxGums)) {
            this.pass = false;
        }
        if (end && this.currentMission.boss && this.m_RaceManager.m_Karts[1].actPos > this.m_RaceManager.m_Karts[0].actPos) {
            this.pass = false;
        }
        if (end && this.currentMission.drifts && this.m_RaceManager.m_Karts[0].getDrfitBoostCounter() < this.currentMission.minDrifts) {
            this.pass = false;
        }
        if (end && this.currentMission.doors && this.m_RaceManager.m_Karts[0].getCurrentDoor() < this.m_RaceManager.getDoorNumber() - 1) {
            this.pass = false;
        }
        if (this.currentMission.lapWin && this.m_RaceManager.m_Karts[0].lap <= this.currentMission.missionLaps) {
            this.pass = false;
        }
        if (!end) {
            this.pass = false;
        }
        if (this.currentMission.borders && this.m_RaceManager.m_Karts[0].getTrackSection() != 0) {
            this.pass = false;
            end = true;
        }
        if (this.currentMission.gumAutoWin && this.m_RaceManager.m_Karts[0].getCollectibleCount() >= this.currentMission.minGums && this.m_RaceManager.m_Karts[0].getCollectibleCount() < this.currentMission.maxGums) {
            end = true;
            this.pass = true;
        }
        if (this.currentMission.driftAutoWin && this.m_RaceManager.m_Karts[0].getDrfitBoostCounter() >= this.currentMission.minDrifts) {
            end = true;
            this.pass = true;
        }
        if (end) {
            this.playerFinalPos = this.checkPosition();
            firstMissionPassed = true;
        }
        return end;
    }

    protected void paintHUD(Graphics g) {
        this.paintHUDboost(g);
        this.paintHUDautopilot(g);
        if (gameState == 5 || gameState == 6) {
            this.paintHUDstartLights(g);
        }
        this.paintHUDstripes(g);
        this.paintHUDminimap(g);
        this.paintHUDavatar(g);
        this.paintHUDcollectedItem(g);
        if (gameState == 6 && this.currentMission.boss && !this.paintHUDwrongWay(g)) {
            this.paintHUDlapFinished(g);
        }
        if (gameState < 7 && gameState > 0) {
            if (this.currentMission.drifts) {
                this.paintHUDPerformedDrifts(g);
            }
            if (this.currentMission.doors) {
                this.paintHUDcollectedDoors(g);
            }
        }
        if (this.currentMission.laps && gameState < 7 && gameState > 0) {
            this.paintHUDlap(g);
        }
        if (this.currentMission.boss && gameState != 0) {
            this.paintHUDplayerPosition(g);
        }
        this.paintHUDgumNumber(g);
        if (this.currentMission.timer && (gameState == 5 || gameState == 3 || gameState == 4 || gameState == 6)) {
            this.paintHUDraceTime(g);
        }
        if (gameState == 7) {
            this.paintHUDafterRaceInfo(g);
            if (MainCanvas.m_CurrTime - this.timer > 2000L) {
                this.paintHUDpressInfo(g);
            }
        }
        if (gameState < 7 && gameState > 0) {
            this.paintHUDpauseArrow(g);
        }
        if (gameState == 0) {
            this.paintHUDshade(g);
        }
    }

    public static void setFail() {
        autoFail = true;
        System.out.println("MISSION AUTO FAIL!");
    }

    static {
        firstMissionPassed = false;
        prevMission = -1;
        restart = false;
        autoFail = false;
    }
}

