/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class TextBox {
    static final int TYPE_NORMAL = 0;
    static final int TYPE_PAGE = 1;
    static final int TYPE_SCROLL = 2;
    private BMFont mFont;
    private String mText;
    private int mWidth;
    private int mHeight;
    private int mType;
    private int mAlign;
    private Vector mTextLines;
    private int mScrollGap;
    private int mScrollTextPos;
    private int sGap;
    private int sBoxHeight;
    private int sHeight;
    private int mPagesCount;
    private int clipX;
    private int clipY;
    private int clipW;
    private int clipH;

    public TextBox() {
        this.reset();
    }

    public TextBox(BMFont f, String text, int width, int height, int type) {
        this.mFont = f;
        this.mText = text;
        this.mWidth = width;
        this.mHeight = height;
        this.mType = type;
        this.init();
    }

    public static TextBox createTextBox(BMFont f, String text, int width, int height, int type) {
        TextBox tmpBox = new TextBox(f, text, width, height, type);
        return tmpBox;
    }

    private void reset() {
        this.mFont = null;
        this.mText = null;
        this.mWidth = 0;
        this.mHeight = 0;
        this.mType = 0;
        this.mAlign = 0;
        this.mTextLines = null;
    }

    private void init() {
        this.mTextLines = this.mFont.splitTextIntoLines(this.mText, this.mWidth);
        switch (this.mType) {
            case 0: {
                break;
            }
            case 1: {
                this.sGap = this.mFont.getHeight();
                int pMaxLines = this.mHeight / this.sGap;
                this.mScrollGap = this.sBoxHeight = pMaxLines * this.sGap;
                this.mScrollTextPos = 0;
                int lineNr = 0;
                for (int i = 0; i < this.mTextLines.size(); ++i) {
                    String lineStr = (String)this.mTextLines.elementAt(i);
                    if (lineStr.charAt(0) == '#') {
                        this.mTextLines.setElementAt(lineStr.substring(1), i);
                        for (int j = 0; j < pMaxLines - lineNr; ++j) {
                            this.mTextLines.insertElementAt(" ", i);
                        }
                    }
                    if (++lineNr < pMaxLines) continue;
                    lineNr = 0;
                }
                this.mPagesCount = this.mTextLines.size() / pMaxLines;
                int restLines = this.mTextLines.size() - this.mPagesCount * pMaxLines;
                int addLines = 0;
                if (restLines > 0) {
                    addLines = pMaxLines - restLines;
                }
                if (addLines > 0) {
                    for (int i = 0; i < addLines; ++i) {
                        this.mTextLines.addElement(" ");
                    }
                }
                this.sHeight = this.sGap * this.mTextLines.size();
                break;
            }
            case 2: {
                this.mScrollGap = this.mFont.getHeight();
                this.sGap = this.mFont.getHeight();
                int sMaxLines = this.mHeight / this.sGap;
                this.sBoxHeight = sMaxLines * this.sGap;
                this.sHeight = this.sGap * this.mTextLines.size();
                this.mScrollTextPos = 0;
            }
        }
    }

    public void setFont(BMFont f) {
        this.mFont = f;
        this.init();
    }

    public BMFont getFont() {
        return this.mFont;
    }

    public void setAlign(int align) {
        this.mAlign = align;
    }

    public int getAlign() {
        return this.mAlign;
    }

    public void setWidth(int width) {
        this.mWidth = width;
        this.init();
    }

    public int getWidth() {
        return this.mWidth;
    }

    public void setHeight(int height) {
        this.mHeight = height;
        this.init();
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getLinesCount() {
        return this.mTextLines != null ? this.mTextLines.size() : -1;
    }

    public int getPagesCount() {
        return this.mType == 1 && this.mTextLines != null ? this.mPagesCount : -1;
    }

    public void setScrollLevel(int level) {
        if (this.mType != 2) {
            return;
        }
        this.mScrollTextPos = level;
    }

    public int getScrollLevel() {
        return this.mType == 2 ? this.mScrollTextPos : -1;
    }

    public int getScrollSize() {
        return this.mType == 2 ? this.mScrollTextPos : -1;
    }

    public void setScrollGap(int gap) {
        if (this.mType != 2) {
            return;
        }
        if (gap < 0) {
            gap = 0;
        }
        this.mScrollGap = gap;
    }

    public int getScrollGap() {
        return this.mType == 2 ? this.sHeight - this.sBoxHeight : -1;
    }

    public void drawBox(Graphics g, int x, int y, int anchor) {
        this.pushClip(g);
        if (anchor != 0) {
            int anchorX = 0;
            int anchorY = 0;
            if ((anchor & 8) == 8) {
                anchorX = this.mWidth;
            }
            if ((anchor & 1) == 1) {
                anchorX = this.mWidth >> 1;
            }
            if ((anchor & 0x20) == 32) {
                anchorY = this.mHeight;
            }
            if ((anchor & 2) == 2) {
                anchorY = this.mHeight >> 1;
            }
            x -= anchorX;
            y -= anchorY;
        }
        switch (this.mType) {
            case 0: {
                block14: for (int i = 0; i < this.mTextLines.size() && (i + 1) * this.mFont.getHeight() <= this.mHeight; ++i) {
                    switch (this.mAlign) {
                        case 0: {
                            this.mFont.drawString(g, (String)this.mTextLines.elementAt(i), x, y + i * this.mFont.getHeight(), 0);
                            continue block14;
                        }
                        case 1: {
                            this.mFont.drawString(g, (String)this.mTextLines.elementAt(i), x + (this.mWidth - this.mFont.stringWidth((String)this.mTextLines.elementAt(i))) >> 1, y + i * this.mFont.getHeight(), 0);
                            continue block14;
                        }
                        case 2: {
                            this.mFont.drawString(g, (String)this.mTextLines.elementAt(i), x + (this.mWidth - this.mFont.stringWidth((String)this.mTextLines.elementAt(i))), y + i * this.mFont.getHeight(), 0);
                        }
                    }
                }
                break;
            }
            case 1: 
            case 2: {
                int sBoxY = y + (this.mHeight - this.sBoxHeight >> 1);
                if (this.mScrollTextPos < 0) {
                    this.mScrollTextPos = 0;
                }
                if (this.mScrollTextPos > this.sHeight - this.sBoxHeight) {
                    this.mScrollTextPos = this.mTextLines.size() * this.sGap < this.mHeight ? 0 : this.sHeight - this.sBoxHeight;
                }
                g.setClip(x, y, this.mWidth, this.mHeight);
                block15: for (int i = 0; i < this.mTextLines.size(); ++i) {
                    if (-this.mScrollTextPos + i * this.sGap <= -this.sGap || -this.mScrollTextPos + i * this.sGap >= this.mHeight) continue;
                    switch (this.mAlign) {
                        case 0: {
                            this.mFont.drawString(g, (String)this.mTextLines.elementAt(i), x, sBoxY - this.mScrollTextPos + i * this.sGap, 0);
                            continue block15;
                        }
                        case 1: {
                            this.mFont.drawString(g, (String)this.mTextLines.elementAt(i), x + (this.mWidth - this.mFont.stringWidth((String)this.mTextLines.elementAt(i)) >> 1), sBoxY - this.mScrollTextPos + i * this.sGap, 0);
                            continue block15;
                        }
                        case 2: {
                            this.mFont.drawString(g, (String)this.mTextLines.elementAt(i), x + (this.mWidth - this.mFont.stringWidth((String)this.mTextLines.elementAt(i))), sBoxY - this.mScrollTextPos + i * this.sGap, 0);
                        }
                    }
                }
                break;
            }
        }
        this.popClip(g);
    }

    public void scrollUp() {
        this.mScrollTextPos -= this.mScrollGap;
    }

    public void scrollDown() {
        this.mScrollTextPos += this.mScrollGap;
    }

    private void pushClip(Graphics g) {
        this.clipX = g.getClipX();
        this.clipY = g.getClipY();
        this.clipW = g.getClipWidth();
        this.clipH = g.getClipHeight();
    }

    private void popClip(Graphics g) {
        g.setClip(this.clipX, this.clipY, this.clipW, this.clipH);
    }
}

