/*
 * Decompiled with CFR 0.152.
 */
package com.spl.gamestore.common;

import com.spl.gamestore.common.IGamesStore;
import com.spl.gamestore.common.Module;
import com.spl.gamestore.common.Params;
import com.spl.gamestore.common.Resources;
import com.spl.gamestore.hiscores.HiScoresModule;
import com.spl.gamestore.moregames.MoreGamesModule;
import com.spl.gamestore.smssender.SMSSenderModule;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameStore
extends Canvas
implements Runnable,
Resources,
Params,
CommandListener {
    public static final String common = "common";
    public static String lang;
    public static String resourcesFileName;
    public static String resourcesFileExt;
    private boolean destroingModule = false;
    private Displayable gameCanvas;
    private Displayable currentDisplayable;
    private boolean keyPressedFlag = false;
    private boolean keyRepeatedFlag = false;
    private boolean keyReleasedFlag = false;
    private boolean pointerPressedFlag;
    private boolean pointerDraggedFlag;
    private int keyPressed;
    private int pointerX;
    private int pointerY;
    private long keyPressedTime = 0L;
    public static final int SK_OK = 1;
    public static final int SK_CANCEL = 2;
    public static final int KEY_RIGHT = 3;
    public static final int KEY_LEFT = 4;
    public static final int KEY_UP = 5;
    public static final int KEY_DOWN = 6;
    public static final int KEY_SELECT = 7;
    public static final int KEY_BACK = 8;
    public IGamesStore parent;
    public static final GameStore instance;
    private Image backBufferImg;
    private final Hashtable modules = new Hashtable();
    private Module currentModule;
    public int currentModuleIndex = -1;
    public int realScreenW;
    public int realScreenH;
    public static final byte SYSTEM_FONT = 0;
    private Font systemFontFont;
    public int[] fontsHeights;
    public int[] fontsBaselines;
    private Image[][] fontsImages;
    private Image[][] fontsImagesLocale;
    private long[][] fontsLetters;
    private long[][] fontsLettersLocale;
    private long[][] fontsLettersCurrent;
    private byte lastFontIndex = 1;
    private final int ADDITIONAL_LETTER_SPACING;
    private final int MAX_FONTS;
    public static String debugOut;
    public boolean isRunning = true;
    public boolean dontRepaint = false;
    public Command[] commands;
    public final int MAX_COMMANDS;

    private GameStore() {
        this.ADDITIONAL_LETTER_SPACING = 0;
        this.MAX_FONTS = 10;
        this.MAX_COMMANDS = 10;
        int dotIndex = "/gs_resources.bin".lastIndexOf(46);
        resourcesFileName = "/gs_resources.bin".substring(0, dotIndex);
        resourcesFileExt = "/gs_resources.bin".substring(dotIndex + 1, "/gs_resources.bin".length());
        this.setFullScreenMode(true);
        this.fontsImages = new Image[10][];
        this.fontsImagesLocale = new Image[10][];
        this.fontsLetters = new long[10][];
        this.fontsLettersLocale = new long[10][];
        this.systemFontFont = Font.getDefaultFont();
        this.fontsHeights = new int[10];
        this.fontsHeights[0] = this.systemFontFont.getHeight();
        this.fontsBaselines = new int[10];
        this.fontsBaselines[0] = this.systemFontFont.getBaselinePosition();
        this.setCommandListener(this);
        new Thread(this).start();
    }

    public void setParent(IGamesStore parent) {
        this.parent = parent;
    }

    public void run() {
        while (this.isRunning) {
            try {
                long start = System.currentTimeMillis();
                this.realScreenW = this.getWidth();
                this.realScreenH = this.getHeight();
                if (this.currentModule != null) {
                    this.currentModule.cycle();
                }
                if (this.keyPressedFlag) {
                    this.keyPressedFlag = false;
                    if (this.currentModule != null) {
                        this.currentModule.keyPressed(this.keyPressed);
                    }
                }
                if (this.keyRepeatedFlag) {
                    this.keyRepeatedFlag = false;
                    if (this.currentModule != null) {
                        this.currentModule.keyRepeated(this.keyPressed);
                    }
                }
                if (this.pointerPressedFlag) {
                    this.pointerPressedFlag = false;
                    if (this.currentModule != null) {
                        this.currentModule.pointerPressed(this.pointerX, this.pointerY);
                    }
                }
                if (this.pointerDraggedFlag) {
                    this.pointerDraggedFlag = false;
                    if (this.currentModule != null) {
                        this.currentModule.pointerDragged(this.pointerX, this.pointerY);
                    }
                }
                if (!this.isRunning) {
                    return;
                }
                if (this.isShown()) {
                    this.repaint();
                }
                long end = System.currentTimeMillis();
                try {
                    if (end - start < 100L) {
                        Thread.sleep(100L - (end - start));
                        continue;
                    }
                    Thread.yield();
                }
                catch (InterruptedException e) {
                }
            }
            catch (Exception e) {}
        }
    }

    public static boolean isKey(String keyCodes, String key) {
        if (keyCodes == null || keyCodes.trim().equals("")) {
            return false;
        }
        return keyCodes.equals(key) || keyCodes.indexOf(key + ",") == 0 || keyCodes.indexOf("," + key + ",") != -1 || keyCodes.length() > key.length() && keyCodes.indexOf("," + key) == keyCodes.length() - key.length() - 1;
    }

    public void keyRepeated(int key) {
        if (System.currentTimeMillis() - this.keyPressedTime > 200L) {
            this.keyPressed = this.defineKey(key);
            this.keyRepeatedFlag = true;
        }
    }

    public int defineKey(int key) {
        String strKey = "" + key;
        if (GameStore.isKey("-7", strKey)) {
            key = 2;
        } else if (GameStore.isKey("-6", strKey)) {
            key = 1;
        } else if (GameStore.isKey("-4,54", strKey)) {
            key = 3;
        } else if (GameStore.isKey("-3,52", strKey)) {
            key = 4;
        } else if (GameStore.isKey("-1,50", strKey)) {
            key = 5;
        } else if (GameStore.isKey("-2,56", strKey)) {
            key = 6;
        } else if (GameStore.isKey("-5,53", strKey)) {
            key = 1;
        } else if (GameStore.isKey("", strKey)) {
            key = 2;
        } else if (GameStore.isKey("48", strKey)) {
            key = 48;
        }
        switch (key) {
            case 53: {
                key = 1;
                break;
            }
            case 50: {
                key = 5;
                break;
            }
            case 56: {
                key = 6;
                break;
            }
            case 52: {
                key = 4;
                break;
            }
            case 54: {
                key = 3;
            }
        }
        return key;
    }

    public void keyPressed(int key) {
        this.keyPressedTime = System.currentTimeMillis();
        this.keyPressed = this.defineKey(key);
        this.keyPressedFlag = true;
        this.keyReleasedFlag = false;
    }

    public void keyReleased(int key) {
        if (this.keyReleasedFlag) {
            this.keyPressed = this.defineKey(key);
            this.keyPressedFlag = true;
            this.keyReleasedFlag = true;
        }
    }

    public boolean setCurrentModule(int newModuleIndex, Object[] params, boolean removeOldModule) {
        Module newModule = this.getModule(newModuleIndex);
        if (newModule == null) {
            return false;
        }
        if (this.currentModule != null && removeOldModule) {
            this.modules.remove("" + this.currentModuleIndex);
            this.currentModule.destroy();
        }
        if (removeOldModule) {
            this.currentModule = newModule;
            this.currentModuleIndex = newModuleIndex;
        }
        this.modules.put("" + newModuleIndex, newModule);
        boolean success = newModule.initActive(params);
        if (success) {
            if (newModule.needPaint()) {
                this.currentDisplayable = this;
                this.gameCanvas = this.parent.getDisplay().getCurrent();
                this.parent.getDisplay().setCurrent((Displayable)this);
            } else {
                this.currentDisplayable = this.gameCanvas;
            }
        }
        return success;
    }

    public boolean startModule(int moduleType, Object[] params) {
        return this.setCurrentModule(moduleType, params, true);
    }

    public Module getModuleForName(String moduleName) {
        try {
            Object moduleObject = this.modules.get(moduleName);
            if (moduleObject != null) {
                return (Module)moduleObject;
            }
            Class<?> moduleClass = Class.forName(moduleName);
            moduleObject = moduleClass.newInstance();
            if (moduleObject instanceof Module) {
                Module module = (Module)moduleObject;
                this.modules.put(moduleName, module);
                return module;
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void paint(Graphics g) {
        try {
            if (this.dontRepaint) {
                return;
            }
            this.paint1(g);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void paint1(Graphics g) {
        this.realScreenW = this.getWidth();
        this.realScreenH = this.getHeight();
        try {
            if (this.currentModule != null) {
                this.currentModule.paint(g);
            } else if (this.destroingModule) {
                g.setColor(0);
                g.setClip(0, 0, 240, 320);
                g.fillRect(0, 0, 240, 320);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFont(Image[] images, byte[] data, byte fontIndex, boolean common) {
        FilterInputStream descdis = null;
        try {
            descdis = new DataInputStream(new ByteArrayInputStream(data));
            if (common) {
                this.fontsImages[fontIndex] = images;
                this.fontsHeights[fontIndex] = ((DataInputStream)descdis).readByte();
                this.fontsBaselines[fontIndex] = ((DataInputStream)descdis).readByte();
                int quantity = ((DataInputStream)descdis).readUnsignedByte();
                this.fontsLetters[fontIndex] = new long[quantity];
                for (int i = 0; i < quantity; ++i) {
                    this.fontsLetters[fontIndex][i] = ((DataInputStream)descdis).readLong();
                }
            } else {
                this.fontsImagesLocale[fontIndex] = images;
                ((DataInputStream)descdis).readByte();
                ((DataInputStream)descdis).readByte();
                int quantity = ((DataInputStream)descdis).readUnsignedByte();
                this.fontsLettersLocale[fontIndex] = new long[quantity];
                for (int i = 0; i < quantity; ++i) {
                    this.fontsLettersLocale[fontIndex][i] = ((DataInputStream)descdis).readLong();
                }
            }
        }
        catch (IOException ex) {
        }
        finally {
            try {
                if (descdis != null) {
                    descdis.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public void loadFont(int[] imagesIndexes, int rawIndex, byte font) {
        Image[] images = new Image[imagesIndexes.length];
        for (int i = 0; i < imagesIndexes.length; ++i) {
            images[i] = (Image)GameStore.getResource(imagesIndexes[i], false);
        }
        byte[] fontDescriptor = (byte[])GameStore.getResource(rawIndex, false);
        if (fontDescriptor == null) {
            return;
        }
        this.loadFont(images, fontDescriptor, font, false);
    }

    public byte loadFont(int[] imagesIndexes, int rawIndex) {
        byte resultIndex = this.lastFontIndex;
        Image[] images = new Image[imagesIndexes.length];
        for (int i = 0; i < imagesIndexes.length; ++i) {
            images[i] = (Image)GameStore.getResource(imagesIndexes[i], true);
        }
        byte[] fontDescriptor = (byte[])GameStore.getResource(rawIndex, true);
        this.loadFont(images, fontDescriptor, resultIndex, true);
        this.lastFontIndex = (byte)(this.lastFontIndex + 1);
        return resultIndex;
    }

    private int getIndex(char c, byte fontIndex, long[][] letters) {
        if (letters[fontIndex] == null) {
            return -1;
        }
        int low = 0;
        int hi = letters[fontIndex].length - 1;
        char lowChar = (char)(letters[fontIndex][low] >> 48);
        char hiChar = (char)(letters[fontIndex][hi] >> 48);
        if (c < lowChar || c > hiChar) {
            return -1;
        }
        if (hiChar == c) {
            return hi;
        }
        int current = hi / 2;
        while ((char)(letters[fontIndex][current] >> 48) != c) {
            if ((char)(letters[fontIndex][current] >> 48) > c) {
                hi = current;
            } else {
                low = current;
            }
            if (hi - low <= 1 && (char)(letters[fontIndex][hi] >> 48) != c && (char)(letters[fontIndex][low] >> 48) != c) {
                return -1;
            }
            current = (low + hi) / 2;
        }
        return current;
    }

    public void drawString(Graphics g, byte fontIndex, byte imageId, String strInp, int iX, int iY, int pos, int clipX, int clipY, int clipW, int clipH) {
        if ((pos & 0x20) != 0) {
            iY -= this.fontsHeights[fontIndex];
        } else if ((pos & 0x40) != 0) {
            iY -= this.fontsBaselines[fontIndex];
        } else if ((pos & 2) != 0) {
            iY -= this.fontsHeights[fontIndex] / 2;
        }
        if ((pos & 8) != 0) {
            iX -= this.getStringWidth(strInp, fontIndex);
        } else if ((pos & 1) != 0) {
            iX -= this.getStringWidth(strInp, fontIndex) / 2;
        }
        if (fontIndex == 0) {
            g.setClip(clipX, clipY, clipW, clipH);
            g.drawString(strInp, iX, iY, 20);
            return;
        }
        int iStrLngth = strInp.length();
        int iCharSpace = 0;
        for (int i = 0; i < iStrLngth; ++i) {
            int x = iX + iCharSpace;
            char c = strInp.charAt(i);
            int index = this.getIndexOfChar(c, fontIndex);
            if (index == -1) continue;
            long letter = this.fontsLettersCurrent[fontIndex][index];
            int charW = (int)(letter >> 24 & 0xFFL);
            int charH = (int)(letter >> 16 & 0xFFL);
            byte charDy = (byte)(letter & 0xFFL);
            int charY = iY - charH + charDy + this.fontsBaselines[fontIndex] - (this.fontsHeights[fontIndex] - this.fontsBaselines[fontIndex]);
            g.setClip(x, charY, charW, charH);
            if (this.fontsLettersCurrent == this.fontsLetters) {
                g.drawImage(this.fontsImages[fontIndex][imageId], x - (int)(letter >> 40 & 0xFFL), charY - (int)(letter >> 32 & 0xFFL), 20);
            } else {
                g.drawImage(this.fontsImagesLocale[fontIndex][imageId], x - (int)(letter >> 40 & 0xFFL), charY - (int)(letter >> 32 & 0xFFL), 20);
            }
            iCharSpace += charW + (byte)(letter >> 8 & 0xFFL) + 0;
        }
        g.setClip(clipX, clipY, clipW, clipH);
    }

    public int getStringWidth(String strInp, byte fontIndex) {
        if (fontIndex == 0) {
            return this.systemFontFont.stringWidth(strInp);
        }
        int iStrLngth = strInp.length();
        int strWidth = 0;
        for (int i = 0; i < iStrLngth; ++i) {
            strWidth += this.charWidth(strInp.charAt(i), fontIndex);
        }
        return strWidth;
    }

    private int getIndexOfChar(char c, byte fontIndex) {
        this.fontsLettersCurrent = this.fontsLetters;
        int index = this.getIndex(c, fontIndex, this.fontsLettersLocale);
        if (index == -1) {
            index = this.getIndex(c, fontIndex, this.fontsLetters);
            if (index == -1) {
                index = this.getIndex(c = (char)(c - 32), fontIndex, this.fontsLettersLocale);
                if (index == -1) {
                    index = this.getIndex(c, fontIndex, this.fontsLetters);
                } else {
                    this.fontsLettersCurrent = this.fontsLettersLocale;
                }
            }
        } else {
            this.fontsLettersCurrent = this.fontsLettersLocale;
        }
        return index;
    }

    private int charWidth(char c, byte fontIndex) {
        if (fontIndex == 0) {
            return this.systemFontFont.charWidth(c);
        }
        int index = this.getIndexOfChar(c, fontIndex);
        if (index == -1) {
            return 0;
        }
        long letter = this.fontsLettersCurrent[fontIndex][index];
        return (int)(letter >> 24 & 0xFFL) + (byte)(letter >> 8 & 0xFFL) + 0;
    }

    public String[] divideBreaker(String readedString, int viewportWidth, byte fontIndex) {
        Vector strings = GameStore.splitByString(readedString, '\n');
        int WHITESPACE = 32;
        int whitespaceWidth = this.charWidth(' ', fontIndex);
        int stringIndex = 0;
        while (stringIndex < strings.size()) {
            String s = (String)strings.elementAt(stringIndex);
            if (this.getStringWidth(s, fontIndex) <= viewportWidth) {
                ++stringIndex;
                continue;
            }
            strings.removeElementAt(stringIndex);
            int substringStart = 0;
            int substringEnd = 0;
            int substringWidth = 0;
            int stringLength = s.length();
            int currentStart = 0;
            while (currentStart < stringLength) {
                int currentWidth;
                int currentEnd = s.indexOf(32, currentStart);
                if (currentEnd == -1) {
                    currentEnd = s.length();
                }
                if (substringWidth + whitespaceWidth + (currentWidth = this.getStringWidth(s.substring(currentStart, currentEnd), fontIndex)) > viewportWidth) {
                    if (substringEnd > substringStart) {
                        strings.insertElementAt(s.substring(substringStart, substringEnd), stringIndex);
                        ++stringIndex;
                    }
                    substringWidth = currentWidth;
                    substringStart = substringEnd + 1;
                    substringEnd = currentEnd;
                    if (currentWidth > viewportWidth) {
                        for (currentEnd = currentStart + 1; currentEnd < substringEnd - 1 && this.getStringWidth(s.substring(currentStart, currentEnd), fontIndex) <= viewportWidth; ++currentEnd) {
                        }
                        strings.insertElementAt(s.substring(currentStart, --currentEnd), stringIndex);
                        ++stringIndex;
                        substringStart = currentEnd;
                        substringWidth = this.getStringWidth(s.substring(substringStart, substringEnd), fontIndex);
                    }
                } else {
                    substringEnd = currentEnd;
                    substringWidth += currentWidth + whitespaceWidth;
                }
                currentStart = currentEnd + 1;
            }
            if (substringStart >= stringLength) continue;
            strings.insertElementAt(s.substring(substringStart, substringEnd), stringIndex);
            ++stringIndex;
        }
        return GameStore.vectorToArray(strings);
    }

    public void goToUrl(String url) throws Throwable {
        String prUrl = url;
        System.gc();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            this.parent.connectBuyURI(prUrl);
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            this.parent.terminateApp();
        }
    }

    protected void pointerPressed(int x, int y) {
        this.pointerX = x;
        this.pointerY = y;
        this.pointerPressedFlag = true;
    }

    protected void pointerDragged(int x, int y) {
        this.pointerX = x;
        this.pointerY = y;
        this.pointerDraggedFlag = true;
    }

    public void addCommand(Command cmd) {
        super.addCommand(cmd);
    }

    public void removeCommand(Command cmd) {
        if (this.currentDisplayable != null) {
            super.removeCommand(cmd);
        }
    }

    public void destroyModule(int moduleIndex, boolean removeModule) {
        Module module = removeModule ? (Module)this.modules.remove("" + moduleIndex) : (Module)this.modules.get("" + moduleIndex);
        if (module != null) {
            if (this.currentModule == module) {
                this.currentModule = null;
            }
            module.destroy();
            if (module.needPaint()) {
                this.destroingModule = true;
                this.repaint();
                this.serviceRepaints();
                this.destroingModule = false;
            }
        }
        if (this.gameCanvas != null) {
            this.parent.getDisplay().setCurrent(this.gameCanvas);
        } else {
            this.parent.terminateApp();
        }
    }

    public void setCurrentDisplayable(Displayable d) {
        if (d == this) {
            this.setFullScreenMode(true);
        }
        this.parent.getDisplay().setCurrent(d);
    }

    public void commandAction(Command cmd, Displayable d) {
        if (this.currentModule != null) {
            this.currentModule.commandAction(cmd);
        }
    }

    public Module getModule(int moduleType) {
        Module module = (Module)this.modules.get("" + moduleType);
        if (module != null) {
            return module;
        }
        Module o = null;
        switch (moduleType) {
            case 0: {
                o = new MoreGamesModule();
                break;
            }
            case 1: {
                o = new HiScoresModule();
                break;
            }
            case 2: {
                o = new SMSSenderModule();
            }
        }
        if (o != null && o instanceof Module) {
            this.modules.put("" + moduleType, o);
            return o;
        }
        return null;
    }

    public boolean isModuleEnabled(int moduleType) {
        Module module = this.getModule(moduleType);
        if (module == null) {
            return false;
        }
        return module.isEnabled();
    }

    public int getOperationResult(int moduleType) {
        Module module = this.getModule(moduleType);
        if (module == null) {
            return -100;
        }
        return module.getOperationResult();
    }

    public String getString(int moduleType, int index) {
        Module module = this.getModule(moduleType);
        if (module == null) {
            return null;
        }
        return module.getString(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getResource(int resID, String resourceFileName, String lang) {
        InputStream is = "".getClass().getResourceAsStream(resourceFileName);
        DataInputStream dis = new DataInputStream(is);
        try {
            String language = (String)GameStore.readObject(dis);
            while (!language.equals(lang)) {
                int length = dis.readInt();
                dis.skip(length);
                language = (String)GameStore.readObject(dis);
            }
            dis.readInt();
            int key = dis.readInt();
            while (key != resID) {
                dis.skipBytes(1);
                int length = dis.readInt();
                dis.skip(length);
                key = dis.readInt();
            }
            Object object = GameStore.readObject(dis);
            return object;
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                is = null;
            }
            catch (IOException e) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getResource(int resID, boolean common) {
        String resourceFileName = common ? resourcesFileName + "." + resourcesFileExt : resourcesFileName + "_" + (lang == null ? "en" : lang) + "." + resourcesFileExt;
        InputStream is = "".getClass().getResourceAsStream(resourceFileName);
        if (is == null) {
            return null;
        }
        DataInputStream dis = new DataInputStream(is);
        try {
            int key = dis.readInt();
            while (key != resID) {
                dis.skipBytes(1);
                int length = dis.readInt();
                dis.skip(length);
                key = dis.readInt();
            }
            Object object = GameStore.readObject(dis);
            return object;
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                is = null;
            }
            catch (IOException e) {}
        }
        return null;
    }

    private static Object readObject(DataInputStream dis) throws IOException {
        block12: {
            try {
                byte type = dis.readByte();
                if (type == 0) {
                    dis.readUnsignedShort();
                    return dis.readUTF();
                }
                int length = dis.readInt();
                if (type == 0 || type == 1 || type == 2) {
                    byte[] data = new byte[length];
                    dis.read(data);
                    if (type == 0) {
                        return new String(data, 0, length, "UTF-8");
                    }
                    if (type == 1) {
                        Image image;
                        block11: {
                            image = null;
                            try {
                                image = Image.createImage((byte[])data, (int)0, (int)length);
                            }
                            catch (Exception e) {
                                if (data.length <= 1) break block11;
                                e.printStackTrace();
                            }
                        }
                        return image;
                    }
                    if (type == 2) {
                        return data;
                    }
                    break block12;
                }
                if (type == 3) {
                    int arraySize = dis.readInt();
                    Object[] array = new Object[arraySize];
                    for (int i = 0; i < arraySize; ++i) {
                        array[i] = GameStore.readObject(dis);
                    }
                    return array;
                }
            }
            catch (Error e) {
                e.printStackTrace();
            }
        }
        System.out.println("readObject(), return null");
        return null;
    }

    public static Vector splitByString(String text, char delimiter) {
        int currentIndex;
        Vector<String> vector = new Vector<String>();
        if (text == null) {
            return vector;
        }
        int startIndex = 0;
        while ((currentIndex = text.indexOf(delimiter, startIndex)) >= 0) {
            vector.addElement(text.substring(startIndex, currentIndex));
            startIndex = currentIndex + 1;
        }
        if (startIndex < text.length()) {
            vector.addElement(text.substring(startIndex).trim());
        }
        return vector;
    }

    public static String[] vectorToArray(Vector vector) {
        Object[] resultArray = new String[vector.size()];
        vector.copyInto(resultArray);
        vector.removeAllElements();
        vector = null;
        return resultArray;
    }

    public boolean isModuleRunning(int moduleIndex) {
        return this.currentModule != null && this.currentModuleIndex == moduleIndex;
    }

    public void cleanFonts() {
        int i;
        if (this.fontsImages != null) {
            for (i = 0; i < this.fontsImages.length; ++i) {
                this.fontsImages[i] = null;
            }
        }
        if (this.fontsImagesLocale != null) {
            for (i = 0; i < this.fontsImagesLocale.length; ++i) {
                this.fontsImagesLocale[i] = null;
            }
        }
        if (this.fontsLetters != null) {
            for (i = 0; i < this.fontsLetters.length; ++i) {
                this.fontsLetters[i] = null;
            }
        }
        if (this.fontsLettersLocale != null) {
            for (i = 0; i < this.fontsLettersLocale.length; ++i) {
                this.fontsLettersLocale[i] = null;
            }
        }
        this.lastFontIndex = 1;
    }

    public boolean isPainted() {
        return this.currentModule != null && this.currentModule.needPaint() || this.dontRepaint;
    }

    public String getFromJad(Object jadKey) {
        String key = (String)jadKey;
        if (key != null && key.length() > 0) {
            String result = this.parent.getJadAttribute(key);
            if (result != null && result.length() > 0) {
                return result;
            }
            return null;
        }
        return null;
    }

    static {
        instance = new GameStore();
        debugOut = null;
    }
}

