/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class GameManager
extends GameLogic {
    public static int cupCounter;

    public void init() {
        Kart.MAX_COLLECTIBLES = 10;
        Kart.BEGIN_COLLECTIBLES = 5;
        gameState = 1;
        gameRace = GameLogic.gameWorld * 3 + GameLogic.gameTrack;
        gameLaps = gameLapsSet;
        gameItems = gameItemsSet;
        if (gameMode == 3) {
            gameRace = 13;
        }
        if (gameMode == 2) {
            gameRace = 12;
            gameLaps = 3;
        }
        if (gameMode != 0) {
            gameDifficulty = 1;
        }
        this.race = new int[2][Stats.races[gameRace][0].length];
        this.nrActiveKarts = this.race[0].length;
        if (gameMode == 4) {
            gameLaps = this.nrActiveKarts - 1;
        }
        this.race[0][0] = gameChar;
        this.race[1][0] = gameKart;
        int i = 1;
        int j = 0;
        while (i < this.nrActiveKarts) {
            if (Stats.races[gameRace][0][j] == gameChar) {
                ++j;
            }
            this.race[0][i] = Stats.races[gameRace][0][j];
            this.race[1][i] = Stats.races[gameRace][1][j];
            ++i;
            ++j;
        }
        for (i = 1; i < this.nrActiveKarts; ++i) {
            if (this.race[0][i] == 10) {
                boolean repeated;
                do {
                    repeated = false;
                    this.race[0][i] = this.mRandom.nextInt(10);
                    for (int j2 = 0; j2 < this.nrActiveKarts; ++j2) {
                        if (this.race[0][i] != this.race[0][j2] || i == j2) continue;
                        repeated = true;
                    }
                } while (repeated);
            }
            if (this.race[1][i] != 3) continue;
            this.race[1][i] = this.mRandom.nextInt(3);
        }
        this.nrFinishedKarts = 0;
        this.kartsFinished = new boolean[this.nrActiveKarts];
        this.kartsOrder = new int[this.nrActiveKarts];
        this.kartsTimes = new String[this.nrActiveKarts];
        this.initHUD();
        this.m_RaceManager = new RaceManager();
        this.m_RaceManager.race = this.race;
        this.timer = 0L;
        this.raceTime = 0L;
        this.playerActLapTime = 0L;
        this.playerLapTimes = new long[gameLaps];
        this.timeDisp = this.timeStr = GameFrame.timeToStr(this.raceTime);
        this.playerLaps = 1;
        this.timeout = false;
        this.firstFinish = false;
        this.save = false;
    }

    public boolean update(float frame) {
        boolean finish = false;
        if (gameState == 0) {
            finish = true;
        }
        if (gameState == 1) {
            gameState = 2;
            this.m_RaceManager.camAnim = true;
            this.timer = MainCanvas.m_CurrTime;
        }
        if (gameState == 7) {
            this.raceTime = MainCanvas.m_CurrTime - this.raceTimer;
            this.timeStr = GameFrame.timeToStr(this.raceTime);
            this.updateControll();
            this.checkInfos();
            if (m_GameFrame.isKeyDown(999) && MainCanvas.m_CurrTime - this.timer > 2000L) {
                if (this.save) {
                    m_GameFrame.saveSettings();
                }
                if (this.pass || !this.timeout && gameMode != 4 && gameMode != 3) {
                    this.timer = MainCanvas.m_CurrTime;
                    gameState = 8;
                } else {
                    gameState = 0;
                    finish = true;
                }
            }
        }
        if (gameState == 8) {
            this.raceTime = MainCanvas.m_CurrTime - this.raceTimer;
            this.timeStr = GameFrame.timeToStr(this.raceTime);
            this.updateControll();
            this.checkInfos();
            if (m_GameFrame.isKeyDown(999) && MainCanvas.m_CurrTime - this.timer > 2000L) {
                if (this.unlock == 0) {
                    if (this.firstFinish) {
                        gameState = 12;
                    } else {
                        if (this.pass && gameMode == 0) {
                            ++cupCounter;
                        }
                        if (cupCounter == 3) {
                            gameState = 11;
                            cupCounter = 0;
                        } else if (gameMode != 2) {
                            gameState = 0;
                            finish = true;
                        } else if (this.highscore) {
                            gameState = 10;
                        } else {
                            gameState = 0;
                            finish = true;
                        }
                    }
                } else {
                    this.timer = MainCanvas.m_CurrTime;
                    gameState = 9;
                }
            }
        }
        if (gameState == 9) {
            this.raceTime = MainCanvas.m_CurrTime - this.raceTimer;
            this.timeStr = GameFrame.timeToStr(this.raceTime);
            this.updateControll();
            this.checkInfos();
            if (m_GameFrame.isKeyDown(999) && MainCanvas.m_CurrTime - this.timer > 2000L) {
                if (this.firstFinish) {
                    gameState = 12;
                } else {
                    gameState = 0;
                    finish = true;
                }
            }
        }
        if (gameState == 10) {
            m_GameFrame.enterName();
            gameState = 0;
        }
        if (gameState == 11) {
            m_GameFrame.showMessage(Text.getText(Text.End[gameWorld]));
            gameState = 0;
        }
        if (gameState == 12) {
            m_GameFrame.showMessage(Text.getText(199));
            gameState = 0;
        }
        if (gameState == 2) {
            SoundManager.playSfx(4);
            if (m_GameFrame.isKeyDown(999)) {
                this.m_RaceManager.camAnim = false;
            }
            if (!this.m_RaceManager.camAnim) {
                Kart.endIntro();
                this.timer = MainCanvas.m_CurrTime;
                gameState = 5;
            }
        }
        if (gameState == 5) {
            long toStart = 3000L + this.timer - MainCanvas.m_CurrTime;
            if (toStart < 1000L && m_GameFrame.isKeyUp(1)) {
                this.m_RaceManager.m_Karts[0].startSlowdown(60.0f, true);
            }
            if (toStart < 0L) {
                if (this.m_RaceManager.m_Karts[0].isSlowed) {
                    this.m_RaceManager.m_Karts[0].startSlowdown(20.0f, true);
                }
                gameState = 6;
                this.m_RaceManager.m_Karts[0].acceleratePush();
                this.raceTimer = MainCanvas.m_CurrTime;
                if (GameLogic.gameMode == 3) {
                    for (int i = 1; i < this.m_RaceManager.m_Karts.length; ++i) {
                        this.m_RaceManager.m_Karts[i].eatGhost();
                    }
                } else {
                    for (int i = 1; i < this.m_RaceManager.m_AI.length; ++i) {
                        this.m_RaceManager.m_AI[i].checkStartBoost();
                    }
                }
            }
        }
        if (gameState == 6) {
            this.raceTime = MainCanvas.m_CurrTime - this.raceTimer;
            this.timeDisp = this.timeStr = GameFrame.timeToStr(this.raceTime);
            if (m_GameFrame.isKeyUp(1) && this.raceTime < 333L && !this.m_RaceManager.m_Karts[0].isSlowed) {
                this.m_RaceManager.m_Karts[0].startBoost((float)(1L - this.raceTime / 1000L) * 60.0f);
            }
            if (this.m_RaceManager.m_Karts[0].bestPos / this.m_RaceManager.m_Track.iPoints.length > this.playerLaps) {
                this.playerLapTimes[this.playerLaps - 1] = this.raceTime - this.playerActLapTime;
                if (this.playerLapTimes[this.playerLaps - 1] < this.playerBestLapTime || this.playerLaps == 1) {
                    this.playerBestLapTime = this.playerLapTimes[this.playerLaps - 1];
                    this.playerBestLap = this.playerLaps;
                }
                this.playerActLapTime = this.raceTime;
                this.playerLaps = this.m_RaceManager.m_Karts[0].bestPos / this.m_RaceManager.m_Track.iPoints.length;
            }
            if (this.checkEndCondition()) {
                this.m_RaceManager.m_AI[0].setAwake();
                this.timer = MainCanvas.m_CurrTime;
                this.playerTime = MainCanvas.m_CurrTime - this.raceTimer;
                GameManager.m_GameFrame.m_Menu.menuAfter_s[0] = this.pass = this.winCondition();
                this.checkUnlocks();
                gameState = 7;
                if (gameMode == 2 && !this.timeout) {
                    this.highscore = GameManager.m_GameFrame.m_Menu.checkHighScore(this.playerTime);
                }
            }
            this.updateControll();
            this.checkInfos();
        }
        this.blink = !this.blink;
        this.m_RaceManager.update(Stats.frame[gameDifficulty] * frame);
        return finish;
    }

    protected boolean winCondition() {
        this.playerFinalPos = this.checkPosition();
        this.win = this.playerFinalPos == 1;
        if (this.timeout) {
            this.timeDisp = GameFrame.timeToStr(599999L);
            return false;
        }
        if ((gameMode == 0 || gameMode == 5) && this.playerFinalPos <= this.m_RaceManager.m_Karts.length + 1 >> 1) {
            SoundManager.playSfx(23);
            return true;
        }
        if (gameMode == 4 && this.playerFinalPos == 1) {
            SoundManager.playSfx(23);
            return true;
        }
        if (gameMode == 3 && this.m_RaceManager.m_Karts[0].lap > gameLaps) {
            SoundManager.playSfx(23);
            return true;
        }
        if (gameMode == 2) {
            SoundManager.playSfx(23);
            return true;
        }
        SoundManager.playSfx(2);
        return false;
    }

    protected boolean checkEndCondition() {
        if (this.raceTime > 599999L) {
            this.timeout = true;
            return true;
        }
        if (gameMode == 4) {
            int i;
            int lessLap = 0;
            int sameLap = 0;
            int lastOne = 0;
            int playerLap = this.m_RaceManager.m_Karts[0].lap;
            if (playerLap < 1) {
                playerLap = 1;
            }
            for (i = 1; i < this.m_RaceManager.m_Karts.length; ++i) {
                if (this.m_RaceManager.m_Karts[i].isSleeping()) continue;
                if (this.m_RaceManager.m_Karts[i].lap < playerLap) {
                    ++lessLap;
                    lastOne = i;
                }
                if (this.m_RaceManager.m_Karts[i].lap != playerLap) continue;
                ++sameLap;
            }
            if (lessLap == 0 && sameLap == 0) {
                this.kartsOrder[this.nrFinishedKarts] = 0;
                this.kartsTimes[this.nrFinishedKarts] = this.timeStr;
                ++this.nrFinishedKarts;
                if (this.nrActiveKarts == 2) {
                    for (i = 1; i < this.m_RaceManager.m_Karts.length; ++i) {
                        if (this.kartsFinished[i]) continue;
                        this.kartsOrder[this.nrFinishedKarts] = i;
                        this.kartsTimes[this.nrFinishedKarts] = this.timeStr;
                        ++this.nrFinishedKarts;
                    }
                }
                return true;
            }
            if (lessLap == 1) {
                this.m_RaceManager.m_Karts[lastOne].setSleep();
                this.m_RaceManager.m_AI[lastOne].setSleep();
                this.kartsFinished[lastOne] = true;
                this.kartsOrder[this.nrFinishedKarts] = lastOne;
                this.kartsTimes[this.nrFinishedKarts] = this.timeStr;
                ++this.nrFinishedKarts;
                --this.nrActiveKarts;
                if (this.nrActiveKarts == 1) {
                    this.kartsOrder[this.nrFinishedKarts] = 0;
                    this.kartsTimes[this.nrFinishedKarts] = this.timeStr;
                    ++this.nrFinishedKarts;
                }
            }
        }
        if (gameMode == 3 && this.m_RaceManager.m_Karts[0].eaten) {
            return true;
        }
        return this.m_RaceManager.m_Karts[0].lap > gameLaps;
    }

    private void checkInfos() {
        if (gameMode == 0 || gameMode == 5) {
            for (int i = 0; i < this.m_RaceManager.m_Karts.length; ++i) {
                if (this.kartsFinished[i] || this.m_RaceManager.m_Karts[i].lap <= gameLaps) continue;
                this.kartsFinished[i] = true;
                this.kartsOrder[this.nrFinishedKarts] = i;
                this.kartsTimes[this.nrFinishedKarts] = this.timeStr;
                ++this.nrFinishedKarts;
            }
        }
    }

    private void checkUnlocks() {
        int i;
        boolean ch;
        this.unlock = 0;
        if (!this.pass) {
            return;
        }
        if (gameMode != 0) {
            return;
        }
        this.unlockStr[0] = Text.getText(238);
        if (gameTrack == 2) {
            if (gameWorld != 3 && !GameManager.m_GameFrame.m_Menu.menuRace_s[gameWorld + 1][0]) {
                GameManager.m_GameFrame.m_Menu.menuRace_s[GameManager.gameWorld + 1][0] = true;
                ++this.unlock;
                this.unlockStr[this.unlock] = Text.getText(Text.CUPS[gameWorld + 1]);
            }
        } else if (!GameManager.m_GameFrame.m_Menu.menuRace_s[gameWorld][gameTrack + 1]) {
            GameManager.m_GameFrame.m_Menu.menuRace_s[GameManager.gameWorld][GameManager.gameTrack + 1] = true;
            this.save = true;
        }
        if (gameWorld == 0) {
            if (gameTrack == 2 && !GameManager.m_GameFrame.m_Menu.menuMode_s[2]) {
                GameManager.m_GameFrame.m_Menu.menuMode_s[2] = true;
                ++this.unlock;
                this.unlockStr[this.unlock] = Text.getText(28);
            }
            if (gameChar == 0 && !GameManager.m_GameFrame.m_Menu.menuChars_s[5] && this.win && !CharUnlocks[0][gameTrack]) {
                GameManager.CharUnlocks[0][GameManager.gameTrack] = true;
                this.save = true;
                ch = true;
                for (i = 0; i < CharUnlocks[0].length; ++i) {
                    if (CharUnlocks[0][i]) continue;
                    ch = false;
                }
                if (ch) {
                    GameManager.m_GameFrame.m_Menu.menuChars_s[5] = true;
                    ++this.unlock;
                    this.unlockStr[this.unlock] = Text.getText(41);
                }
            }
        }
        if (gameWorld == 1) {
            if (gameTrack == 2 && !GameManager.m_GameFrame.m_Menu.menuMode_s[3]) {
                GameManager.m_GameFrame.m_Menu.menuMode_s[3] = true;
                ++this.unlock;
                this.unlockStr[this.unlock] = Text.getText(30);
            }
            if (gameChar == 6 && !GameManager.m_GameFrame.m_Menu.menuChars_s[8] && this.win && !CharUnlocks[1][gameTrack]) {
                GameManager.CharUnlocks[1][GameManager.gameTrack] = true;
                this.save = true;
                ch = true;
                for (i = 0; i < CharUnlocks[1].length; ++i) {
                    if (CharUnlocks[1][i]) continue;
                    ch = false;
                }
                if (ch) {
                    GameManager.m_GameFrame.m_Menu.menuChars_s[8] = true;
                    GameManager.m_GameFrame.m_Menu.menuChars_s[7] = true;
                    GameManager.m_GameFrame.m_Menu.menuChars_s[9] = true;
                    ++this.unlock;
                    this.unlockStr[this.unlock] = Text.getText(44) + ", " + Text.getText(43) + ", " + Text.getText(45);
                }
            }
        }
        if (gameWorld == 2) {
            if (gameTrack == 2 && !GameManager.m_GameFrame.m_Menu.menuMode_s[4]) {
                GameManager.m_GameFrame.m_Menu.menuMode_s[4] = true;
                ++this.unlock;
                this.unlockStr[this.unlock] = Text.getText(31);
            }
            if (gameChar == 2 && !GameManager.m_GameFrame.m_Menu.menuChars_s[3] && this.win && !CharUnlocks[2][gameTrack]) {
                GameManager.CharUnlocks[2][GameManager.gameTrack] = true;
                this.save = true;
                ch = true;
                for (i = 0; i < CharUnlocks[2].length; ++i) {
                    if (CharUnlocks[2][i]) continue;
                    ch = false;
                }
                if (ch) {
                    GameManager.m_GameFrame.m_Menu.menuChars_s[3] = true;
                    ++this.unlock;
                    this.unlockStr[this.unlock] = Text.getText(39);
                }
            }
        }
        if (gameWorld == 3) {
            if (gameTrack == 2 && !GameManager.m_GameFrame.m_Menu.menuMode_s[5]) {
                GameManager.m_GameFrame.m_Menu.menuMode_s[5] = true;
                ++this.unlock;
                this.unlockStr[this.unlock] = Text.getText(32);
                this.firstFinish = true;
            }
            if (gameChar == 1 && !GameManager.m_GameFrame.m_Menu.menuChars_s[4] && this.win && !CharUnlocks[3][gameTrack]) {
                GameManager.CharUnlocks[3][GameManager.gameTrack] = true;
                this.save = true;
                ch = true;
                for (i = 0; i < CharUnlocks[3].length; ++i) {
                    if (CharUnlocks[3][i]) continue;
                    ch = false;
                }
                if (ch) {
                    GameManager.m_GameFrame.m_Menu.menuChars_s[4] = true;
                    ++this.unlock;
                    this.unlockStr[this.unlock] = Text.getText(40);
                }
            }
        }
        if (gameKart != 2) {
            int ku = gameChar;
            if (ku > 6) {
                ku = 6;
            }
            if (!GameManager.m_GameFrame.m_Menu.menuKarts_hs[ku][gameKart] && !KartUnlocks[ku][gameWorld * 3 + gameTrack]) {
                int i2;
                GameManager.KartUnlocks[ku][GameManager.gameWorld * 3 + GameManager.gameTrack] = true;
                this.save = true;
                boolean u = true;
                for (i2 = 0; i2 < KartUnlocks[ku].length; ++i2) {
                    if (KartUnlocks[ku][i2]) continue;
                    u = false;
                }
                if (u) {
                    for (i2 = 0; i2 < KartUnlocks[ku].length; ++i2) {
                        GameManager.KartUnlocks[ku][i2] = false;
                    }
                    GameManager.m_GameFrame.m_Menu.menuKarts_hs[ku][GameManager.gameKart] = true;
                    ++this.unlock;
                    this.unlockStr[this.unlock] = Text.getText(Text.kartNames[gameChar][gameKart + 1]);
                }
            }
        }
        if (this.unlock > 1) {
            this.unlockStr[0] = this.unlockStr[0] + ":";
        }
        if (this.unlock > 0) {
            this.save = true;
        }
    }

    protected void paintHUD(Graphics g) {
        this.paintHUDboost(g);
        this.paintHUDautopilot(g);
        if (gameState == 5 || gameState == 6) {
            this.paintHUDstartLights(g);
        }
        this.paintHUDstripes(g);
        this.paintHUDminimap(g);
        if (gameState < 7 && gameState > 0) {
            this.paintHUDlap(g);
        }
        this.paintHUDgumNumber(g);
        this.paintHUDcollectedItem(g);
        this.paintHUDraceTime(g);
        if (gameState == 8) {
            this.paintHUDshade(g);
        }
        this.paintHUDavatar(g);
        if (gameState != 0 && gameMode != 3 && gameMode != 2) {
            this.paintHUDplayerPosition(g);
        }
        this.paintHUDkartsFinished(g);
        if (gameState == 6 && !this.paintHUDwrongWay(g)) {
            this.paintHUDlapFinished(g);
        }
        if (gameState == 7) {
            this.paintHUDafterRaceInfo(g);
            if (MainCanvas.m_CurrTime - this.timer > 2000L) {
                this.paintHUDpressInfo(g);
            }
        }
        if (gameState == 8) {
            this.paintHUDafterRaceSummary(g);
            if (MainCanvas.m_CurrTime - this.timer > 2000L) {
                this.paintHUDpressInfo(g);
            }
        }
        if (gameState == 9) {
            this.paintHUDshade(g);
            this.paintHUDafterRaceUnlock(g);
            if (MainCanvas.m_CurrTime - this.timer > 2000L) {
                this.paintHUDpressInfo(g);
            }
        }
        if (gameState < 7 && gameState > 0) {
            this.paintHUDpauseArrow(g);
        }
        if (gameState == 0) {
            this.paintHUDshade(g);
        }
    }
}

