/*
 * Decompiled with CFR 0.152.
 */
import java.util.Stack;

public class PhysicalEntity
extends TrackObject {
    private float collisionModifier;
    private float mass;
    private Vector3D momentOfInertia;
    protected Vector3D vDirection;
    public Vector3D vOldPosition;
    public Vector3D vVelocity;
    public Vector3D vOldEngineVelocity;
    public Vector3D vAltitudeVelocity;
    private Vector3D oldvAltitudeVelocity;
    private Vector3D vCollisionVelocity;
    private Vector3D vEngineVelocity;
    private Vector3D vDriftForce;
    private Vector3D vFrictionForce;
    private Vector3D vDriftAcceleration;
    private Vector3D vDriftVelocity;
    private float engineForce = 0.0f;
    private float engineReactionForce = 0.0f;
    private float engineAcceleration = 0.0f;
    private Vector3D movementPlaneRot;
    private float groundLevel;
    private Vector3D groundPlaneNormal;
    private Vector3D movementPlaneNormal;
    private float frictionCoefficient;
    private float trackFriction;
    private float tireFriction;
    protected float jumpSpeed;
    private Vector3D entityRotation;
    public float height;
    private float width;
    private float length;
    private float turnBase;
    private float turningRadius = 0.0f;
    private Vector3D currentTurnAngle;
    private float minTurnAngle;
    private float maxTurnAngle;
    private float turnAngle;
    private float maxNominalSpeed;
    private float maxCurrentSpeed;
    private float maxEnginePull;
    private float maxBrake;
    private boolean handbrakeActive = false;
    private boolean handbrakeReleased = false;
    private boolean handbrakeProperlyEnded = false;
    private byte isAccelerate = 0;
    protected byte isTurn = 0;
    protected byte isDirection = 0;
    private Vector3D[] boundingBox = new Vector3D[8];
    private boolean isCollision;
    private Stack colVectors;
    private boolean driftActive;
    private boolean jumpButtonReleased = true;
    private boolean isJumpDrift = false;
    private boolean isJumpTriggered = false;
    private Vector3D vGravityVelocity;
    private boolean hillJumpPossible = false;
    private boolean slippery = false;
    protected boolean canMove = true;
    public static final float absoluteForwardX = 0.0f;
    public static final float absoluteForwardY = 0.0f;
    public static final float absoluteForwardZ = -1.0f;
    public static final float absoluteUpX = 0.0f;
    public static final float absoluteUpY = 1.0f;
    public static final float absoluteUpZ = 0.0f;
    public static final int TYPE_VEHICLE = 0;
    public static final int TYPE_OBSTACLE = 1;
    protected int entityType;
    private float variableCollisionModifier;
    private float staticCollisionModifier;
    public int[] prevNearestPoint = new int[2];
    public static float cutoffLevel = 1.0f;
    private float handbrakeTurnAngle = 0.0f;
    private boolean boosted = false;
    private boolean slowed = false;
    public boolean isOnShortcut = false;
    public Vector3D actualSpeed = new Vector3D();
    private float oldHeight = 0.0f;
    private boolean upHillJump = false;
    public boolean isPlayer = false;
    private float jumpScale = 50.0f;
    Vector3D sg_tmp = new Vector3D();
    private boolean noTurn = false;
    private boolean turnBlock = false;
    private float handbrakeMaxAngle = 60.0f;
    private float handbrakeBlockAngle = 80.0f;
    private float handbreakeReturnSmootheness = 5.0f;
    private float turnAngleChange = 2.0f;

    public void setBoosted(boolean b) {
        this.boosted = b;
    }

    public void setSlowed(boolean s) {
        this.slowed = s;
    }

    PhysicalEntity() {
        this.entityRotation = new Vector3D();
        this.vVelocity = new Vector3D();
        this.vPosition = new Vector3D();
        this.vDirection = new Vector3D();
        this.vOldPosition = new Vector3D();
        this.vOldEngineVelocity = new Vector3D();
        this.currentTurnAngle = new Vector3D();
        this.momentOfInertia = new Vector3D();
        this.vVelocity = new Vector3D();
        this.vCollisionVelocity = new Vector3D();
        this.oldvAltitudeVelocity = new Vector3D();
        this.vEngineVelocity = new Vector3D();
        this.vDriftForce = new Vector3D();
        this.vFrictionForce = new Vector3D();
        this.vDriftAcceleration = new Vector3D();
        this.vDriftVelocity = new Vector3D();
        this.vAltitudeVelocity = new Vector3D();
        this.vGravityVelocity = new Vector3D();
        this.groundPlaneNormal = new Vector3D();
        this.movementPlaneNormal = new Vector3D();
        this.movementPlaneRot = new Vector3D();
        this.colVectors = new Stack();
        this.objectInfo = "Unamed Entity";
    }

    public void init(float m, Vector3D pos, Vector3D dir, float engine, float brake, float v, float mt, float ts, float tf) {
        this.maxEnginePull = engine;
        this.maxCurrentSpeed = v;
        this.maxNominalSpeed = v;
        this.maxTurnAngle = mt;
        this.minTurnAngle = ts;
        this.maxBrake = -this.maxEnginePull * brake;
        this.mass = m;
        this.momentOfInertia.setx(0.083333336f * this.mass * (this.height * this.height + this.length * this.length));
        this.momentOfInertia.sety(0.083333336f * this.mass * (this.width * this.width + this.length * this.length));
        this.momentOfInertia.setz(0.083333336f * this.mass * (this.height * this.height + this.width * this.width));
        this.tireFriction = tf;
        this.vPosition.set(pos);
        this.vOldPosition.set(pos);
        this.setDirection(dir);
        this.groundLevel = pos.gety();
        float timeout = 8.0f * this.jumpScale;
        this.jumpSpeed = -(Stats.GRAVITY_ACCELERATION * Stats.GRAVITY_ACCELERATION * (timeout / 2.0f) * (timeout / 2.0f)) / (1.0f - timeout / 2.0f);
        this.jumpSpeed = 50.0f;
        for (int i = 0; i < 8; ++i) {
            this.boundingBox[i] = new Vector3D();
        }
    }

    public static void resetIndexes() {
        cutoffLevel = 1.0f;
    }

    public final int getType() {
        return this.entityType;
    }

    protected final void setHeight(float h) {
        this.height = h;
    }

    protected final float getHeight() {
        return this.height;
    }

    protected final void setWidth(float w) {
        this.width = w;
    }

    protected final float getWidth() {
        return this.width;
    }

    protected final void setLength(float l) {
        this.length = l;
    }

    protected final float getLength() {
        return this.length;
    }

    protected final void setBoundingBox(Vector3D[] bb) {
        for (int i = 0; i < bb.length; ++i) {
            this.boundingBox[i] = bb[i];
        }
    }

    public Vector3D[] getBoundingBox() {
        Vector3D[] v = new Vector3D[8];
        for (int i = 0; i < 8; ++i) {
            v[i] = new Vector3D(this.boundingBox[i].getx() * (float)mMath.cos(mMath.toRadians(this.entityRotation.gety())) + this.boundingBox[i].getz() * (float)mMath.sin(mMath.toRadians(this.entityRotation.gety())) + this.vPosition.getx(), this.boundingBox[i].gety() + this.vPosition.gety(), -this.boundingBox[i].getx() * (float)mMath.sin(mMath.toRadians(this.entityRotation.gety())) + this.boundingBox[i].getz() * (float)mMath.cos(mMath.toRadians(this.entityRotation.gety())) + this.vPosition.getz());
        }
        return v;
    }

    public void setVariableCollisionModifier(float mod) {
        this.variableCollisionModifier = mod;
    }

    public void setStaticCollisionModifier(int mod) {
        this.staticCollisionModifier = mod;
    }

    public float getTurningRadius() {
        return this.turningRadius;
    }

    public float getStaticCollisionModifier() {
        return this.staticCollisionModifier;
    }

    public float getVariableCollisionModifier() {
        return this.variableCollisionModifier;
    }

    protected void setTurnBase(float tb) {
        this.turnBase = tb;
    }

    public float getMass() {
        return this.mass;
    }

    public Vector3D getOldPosition() {
        return this.vOldPosition;
    }

    public void setDirection(Vector3D v) {
        this.vDirection.set(v);
        if (v.getx() > 0.0f) {
            this.entityRotation.sety(-((float)mMath.toDegrees(mMath.acos((v.getx() * 0.0f + v.getz() * -1.0f) / v.length()))));
        } else {
            this.entityRotation.sety((float)mMath.toDegrees(mMath.acos((v.getx() * 0.0f + v.getz() * -1.0f) / v.length())));
        }
    }

    public Vector3D getDirection() {
        if (this.isDirection == -1) {
            return Vector3D.reverse(this.vDirection);
        }
        return this.vDirection;
    }

    public void setTrackFriction(float f) {
        this.trackFriction = f;
        this.frictionCoefficient = this.trackFriction + this.tireFriction;
    }

    public byte getForwardBackward() {
        return this.isDirection;
    }

    public Vector3D getVelocity() {
        return this.vVelocity;
    }

    protected void setCurrentMaxSpeed(float mv) {
        this.maxCurrentSpeed = mv;
    }

    protected float getCurrentMaxSpeed() {
        return this.maxCurrentSpeed;
    }

    protected float getNominalMaxSpeed() {
        return this.maxNominalSpeed;
    }

    public float getSpeed() {
        return this.vVelocity.length();
    }

    protected Vector3D getCollisionVelocity() {
        return new Vector3D(this.vCollisionVelocity);
    }

    protected Vector3D getEngineVelocity() {
        return this.vEngineVelocity;
    }

    protected Vector3D getDriftVelocity() {
        return this.vDriftVelocity;
    }

    protected Vector3D getGravityVelocity() {
        return new Vector3D(this.vGravityVelocity);
    }

    protected void initiateJump(float v) {
        this.vAltitudeVelocity.set(new Vector3D(0.0f, v, 0.0f));
    }

    protected Vector3D getAltitudeVelocity() {
        return this.vAltitudeVelocity;
    }

    protected float getEngineAcceleration() {
        return this.engineAcceleration;
    }

    protected Vector3D getMovementPlaneNormal() {
        return this.movementPlaneNormal;
    }

    protected Vector3D getMovementPlaneRotation() {
        return this.movementPlaneRot;
    }

    protected boolean isSlippery() {
        return this.slippery;
    }

    protected void setSlippery(boolean s) {
        this.slippery = s;
    }

    protected Vector3D getEntityRotation() {
        return this.entityRotation;
    }

    protected Vector3D getCurrentTurnAngle() {
        return this.currentTurnAngle;
    }

    protected boolean getIsJumpDrift() {
        return this.isJumpDrift;
    }

    protected boolean isHandbrakeActive() {
        return this.handbrakeActive;
    }

    protected boolean isHandbrakeReleased() {
        return this.handbrakeReleased;
    }

    protected boolean isHandbrakeProperlyEnded() {
        return this.handbrakeProperlyEnded;
    }

    protected float calculateMaxHeight(float speed) {
        return speed * speed / (2.0f * Stats.GRAVITY_ACCELERATION);
    }

    protected void stopKart(int v) {
        switch (v) {
            case 0: {
                this.setCartRotation();
                this.vEngineVelocity.setLength(0.0f);
                this.engineForce = 0.0f;
                this.isAccelerate = 0;
                break;
            }
            case 1: {
                this.engineForce = this.maxBrake;
                break;
            }
            case 2: {
                this.engineForce = this.maxBrake / 4.0f;
                break;
            }
            default: {
                System.out.println("Unable to stop entity. Unknown value.");
            }
        }
    }

    public boolean isEngineActive() {
        return this.engineForce != 0.0f;
    }

    protected void clearCollisions() {
        this.isCollision = false;
        this.colVectors.removeAllElements();
    }

    public void triggerCollision(Vector3D v) {
        this.isCollision = true;
        this.colVectors.push(new Vector3D(v));
    }

    public void triggerTrackCollision(Vector3D v, float dot) {
        Vector3D u = Vector3D.scalarMul(dot * 1.0f, v);
        this.vPosition.sub(u);
        if (this.vDriftVelocity.length() > 0.0f) {
            this.vDriftVelocity.scalarDiv(1.5f);
            this.vEngineVelocity.add(Vector3D.scalarMul(-1.7f * Stats.GRAVITY_ACCELERATION * this.frictionCoefficient * 1.2f, Vector3D.normalize(this.vEngineVelocity)));
            if (this.vDriftVelocity.length() < 0.2f) {
                this.stopDrift();
            }
        }
        if (this.handbrakeActive) {
            this.handbrakeActive = false;
            this.handbrakeReleased = true;
            this.handbrakeProperlyEnded = false;
        }
    }

    public void triggerObjectCollision(Vector3D dist, Vector3D v, float opMass, float myPower, float opPower, float myMod, float opMod) {
        Vector3D dir = Vector3D.normalize(dist);
        Vector3D un = Vector3D.normalize(dir);
        Vector3D ut = new Vector3D(-un.getz(), un.gety(), un.getx());
        float v1n = un.dotProduct(this.vVelocity);
        float v1t = ut.dotProduct(this.vVelocity);
        float v2n = un.dotProduct(v);
        if (v1n > 0.0f && v2n < 0.0f && v1n != -v2n) {
            return;
        }
        float mod = Math.max(opPower * opMod - myPower - myMod, -10.0f);
        this.triggerCollision(dir);
        float v1n_prime = (v1n * (this.mass - opMass) + 2.0f * opMass * v2n) / (this.mass + opMass);
        Vector3D newV = Vector3D.scalarMul(Math.abs(mod), Vector3D.add(Vector3D.scalarMul(v1n_prime, un), Vector3D.scalarMul(v1t, ut)));
        float newlength = Math.max(Math.min(newV.length(), this.maxNominalSpeed), this.maxNominalSpeed / 2.0f);
        newV.setLength(newlength);
        this.vCollisionVelocity = Vector3D.sub(newV, this.vVelocity);
    }

    public void smartAcceleratePush() {
        if (this.vVelocity.length() != 0.0f && this.isDirection == 1) {
            this.handbrakePush();
        } else {
            this.acceleratePush();
            if (this.isPlayer) {
                SoundManager.playSfx(4);
            }
        }
    }

    public void smartAccelerateRelease() {
        this.isAccelerate = 0;
        this.jumpButtonReleased = true;
    }

    public void acceleratePush() {
        this.isAccelerate = 1;
    }

    public void accelerateRelease() {
        this.isAccelerate = 0;
    }

    public void brakePush() {
        if (this.vAltitudeVelocity.quaterLength() != 0.0f) {
            return;
        }
        this.isAccelerate = (byte)-1;
        if (this.handbrakeActive) {
            this.handbrakeActive = false;
            this.handbrakeReleased = true;
            this.handbrakeProperlyEnded = false;
        }
    }

    public void brakeRelease() {
        this.isAccelerate = 0;
    }

    public void handbrakePush() {
        if (this.vEngineVelocity.quaterLength() == 0.0f) {
            return;
        }
        if (this.jumpButtonReleased) {
            this.handbrakeProperlyEnded = false;
            this.isJumpDrift = true;
            this.isJumpTriggered = true;
            if (this.vAltitudeVelocity.quaterLength() == 0.0f) {
                this.vAltitudeVelocity.set(0.0f, this.jumpSpeed + Math.min(2.0f, -Math.min(0.0f, this.oldHeight)), 0.0f);
                if (this.isPlayer) {
                    SoundManager.playSfx(12);
                }
                if (this.oldHeight < 0.0f) {
                    this.upHillJump = true;
                }
            }
            this.jumpButtonReleased = false;
        }
    }

    public void handbrakeRelease() {
        this.jumpButtonReleased = true;
    }

    public void turnPush(byte direction) {
        this.isTurn = direction;
    }

    public void turnRelease() {
        this.isTurn = 0;
        if (this.handbrakeActive && !this.handbrakeReleased) {
            this.handbrakeActive = false;
            this.handbrakeReleased = true;
            this.handbrakeProperlyEnded = true;
        }
    }

    public void release() {
        this.smartAccelerateRelease();
        this.brakeRelease();
        this.turnRelease();
        this.turnRelease();
    }

    public void setGround(float lvl, Vector3D planeNorm) {
        this.sg_tmp.set(this.groundPlaneNormal);
        this.sg_tmp.sub(planeNorm);
        float dif = this.sg_tmp.length();
        this.hillJumpPossible = dif >= 0.25f;
        this.oldHeight = this.groundLevel - lvl;
        this.groundLevel = lvl;
        this.groundPlaneNormal.set(planeNorm);
    }

    protected float getGroundLevel() {
        return this.groundLevel;
    }

    private void reallignVelocity() {
        if (this.isDirection != -1) {
            this.vEngineVelocity.set(Vector3D.scalarMul(this.vEngineVelocity.length(), this.vDirection));
        } else {
            this.vEngineVelocity.set(Vector3D.scalarMul(-this.vEngineVelocity.length(), this.vDirection));
        }
    }

    private void turn(float frame) {
        if (this.handbrakeActive && this.isJumpDrift) {
            frame /= 4.0f;
        }
        if (!this.isJumpDrift && this.vAltitudeVelocity.quaterLength() != 0.0f) {
            if (this.currentTurnAngle.gety() > 0.0f) {
                this.currentTurnAngle.sety(Math.max(this.currentTurnAngle.gety() - this.minTurnAngle * frame, 0.0f));
                if (!this.handbrakeReleased && !this.handbrakeActive) {
                    this.reallignVelocity();
                }
            } else if (this.currentTurnAngle.gety() < 0.0f) {
                this.currentTurnAngle.sety(Math.min(this.currentTurnAngle.gety() + this.minTurnAngle * frame, 0.0f));
                if (!this.handbrakeReleased && !this.handbrakeActive) {
                    this.reallignVelocity();
                }
            }
        } else if (this.isTurn > 0 && this.isDirection != -1 || this.isTurn < 0 && this.isDirection == -1) {
            if (this.isJumpDrift && this.isDirection == 1) {
                this.handbrakeActive = true;
                this.handbrakeReleased = false;
                this.handbrakeTurnAngle = this.currentTurnAngle.gety();
            }
            if (!this.handbrakeActive || !(Math.abs(this.currentTurnAngle.gety()) >= this.turnAngle)) {
                float old = Math.abs(this.currentTurnAngle.gety());
                if (this.currentTurnAngle.gety() < 0.0f) {
                    this.currentTurnAngle.sety(this.currentTurnAngle.gety() + this.minTurnAngle * frame * 10.0f);
                } else {
                    this.currentTurnAngle.sety(this.currentTurnAngle.gety() + this.minTurnAngle * frame);
                }
                if (this.currentTurnAngle.gety() > this.turnAngle) {
                    this.currentTurnAngle.sety(this.turnAngle);
                }
            }
        } else if (this.isTurn < 0 && this.isDirection != -1 || this.isTurn > 0 && this.isDirection == -1) {
            if (this.isJumpDrift && this.isDirection == 1) {
                this.handbrakeActive = true;
                this.handbrakeReleased = false;
                this.handbrakeTurnAngle = this.currentTurnAngle.gety();
            }
            if (!this.handbrakeActive || !(Math.abs(this.currentTurnAngle.gety()) >= this.turnAngle)) {
                float old = Math.abs(this.currentTurnAngle.gety());
                if (this.currentTurnAngle.gety() > 0.0f) {
                    this.currentTurnAngle.sety(this.currentTurnAngle.gety() - this.minTurnAngle * frame * 10.0f);
                } else {
                    this.currentTurnAngle.sety(this.currentTurnAngle.gety() - this.minTurnAngle * frame);
                }
                if (this.currentTurnAngle.gety() < -this.turnAngle) {
                    this.currentTurnAngle.sety(-this.turnAngle);
                }
            }
        } else if (this.currentTurnAngle.gety() > 0.0f) {
            this.currentTurnAngle.sety(Math.max(this.currentTurnAngle.gety() - this.minTurnAngle * frame * 10.0f, 0.0f));
            if (!this.handbrakeReleased && !this.handbrakeActive) {
                this.reallignVelocity();
            }
        } else if (this.currentTurnAngle.gety() < 0.0f) {
            this.currentTurnAngle.sety(Math.min(this.currentTurnAngle.gety() + this.minTurnAngle * frame * 10.0f, 0.0f));
            if (!this.handbrakeReleased && !this.handbrakeActive) {
                this.reallignVelocity();
            }
        }
        if (this.currentTurnAngle.length() < this.minTurnAngle * cutoffLevel * Math.min(1.0f, frame) / 2.0f) {
            this.currentTurnAngle.setLength(0.0f);
        }
        this.turningRadius = this.currentTurnAngle.gety() != 0.0f ? Math.abs(this.turnBase / (float)Math.tan(mMath.toRadians(this.currentTurnAngle.gety()))) : 0.0f;
    }

    private void accelerate(float frame) {
        if (this.canMove) {
            if (this.isAccelerate > 0) {
                if (this.isDirection != -1) {
                    this.engineForce = this.maxEnginePull;
                    this.isDirection = 1;
                } else {
                    this.engineForce = this.maxBrake;
                }
            } else if (this.isAccelerate < 0) {
                if (this.isDirection != 1) {
                    this.engineForce = this.maxEnginePull / 2.0f;
                    this.isDirection = (byte)-1;
                } else {
                    this.engineForce = this.maxBrake;
                }
            }
        }
    }

    private void calculateEngineAcceleration() {
        if (this.isDirection == -1) {
            this.engineReactionForce = this.vVelocity.length() * this.maxEnginePull / this.maxCurrentSpeed;
            this.engineAcceleration = (this.engineForce - this.engineReactionForce) / this.mass;
        } else {
            float force = this.engineForce;
            if (this.boosted) {
                force *= 3.0f;
            } else if (this.slowed) {
                force /= 4.0f;
            }
            this.engineReactionForce = this.vVelocity.length() / this.maxCurrentSpeed * (this.vVelocity.length() / this.maxCurrentSpeed) * this.maxEnginePull;
            this.engineAcceleration = (force - this.engineReactionForce) / this.mass;
        }
    }

    private void calculateDirection(float frame) {
        if (this.currentTurnAngle.gety() != 0.0f && !this.turnBlock) {
            float tempX = this.vDirection.getx();
            float tempZ = this.vDirection.getz();
            float angle = this.currentTurnAngle.gety() > 0.0f ? this.vEngineVelocity.length() / this.turningRadius * frame : -(this.vEngineVelocity.length() / this.turningRadius) * frame;
            if (this.noTurn) {
                angle /= 2.0f;
            }
            this.vDirection.setx(tempX * (float)mMath.cos(angle) + tempZ * (float)mMath.sin(angle));
            this.vDirection.setz(-tempX * (float)mMath.sin(angle) + tempZ * (float)mMath.cos(angle));
        } else if (!this.turnBlock) {
            this.vDirection.set(0.0f * (float)mMath.cos(mMath.toRadians(this.entityRotation.gety())) + -1.0f * (float)mMath.sin(mMath.toRadians(this.entityRotation.gety())), 0.0f, -0.0f * (float)mMath.sin(mMath.toRadians(this.entityRotation.gety())) + -1.0f * (float)mMath.cos(mMath.toRadians(this.entityRotation.gety())));
        }
        this.vDirection.normalize();
    }

    private void calculateEngineVelocity(float frame) {
        if (this.vAltitudeVelocity.gety() > -this.jumpSpeed) {
            if (this.handbrakeActive) {
                if (!this.turnBlock) {
                    float len = this.vEngineVelocity.length();
                    this.vEngineVelocity.normalize();
                    this.vEngineVelocity.add(Vector3D.scalarMul(0.05f, this.vDirection));
                    this.vEngineVelocity.setLength(len + frame * this.engineAcceleration);
                    float angle = (float)mMath.toDegrees(mMath.acos((this.vEngineVelocity.getx() * this.vDirection.getx() + this.vEngineVelocity.getz() * this.vDirection.getz()) / (this.vEngineVelocity.length() * this.vDirection.length())));
                    if (Math.abs(angle) > this.handbrakeMaxAngle) {
                        this.noTurn = true;
                    }
                    if (Math.abs(angle) > this.handbrakeBlockAngle) {
                        this.turnBlock = true;
                    }
                } else {
                    this.vEngineVelocity.add(Vector3D.scalarMul(frame * this.engineAcceleration, Vector3D.normalize(this.vDirection)));
                }
            } else if (this.handbrakeReleased) {
                this.noTurn = false;
                this.turnBlock = false;
                if (this.vEngineVelocity.length() > 0.0f) {
                    float angle = (float)mMath.acos((this.vDirection.getx() * this.vEngineVelocity.getx() + this.vDirection.getz() * this.vEngineVelocity.getz()) / (this.vDirection.length() * this.vEngineVelocity.length()));
                    this.vEngineVelocity.set(Vector3D.scalarMul(this.vEngineVelocity.length(), Vector3D.normalize(Vector3D.add(Vector3D.scalarMul(this.handbreakeReturnSmootheness, Vector3D.normalize(this.vEngineVelocity)), this.vDirection))));
                    if ((double)angle < mMath.toRadians(this.minTurnAngle)) {
                        this.reallignVelocity();
                        this.handbrakeReleased = false;
                    } else {
                        this.setVelocityCorrection(frame);
                    }
                } else {
                    this.handbrakeReleased = false;
                }
            } else {
                if (this.vEngineVelocity.quaterLength() == 0.0f && this.engineAcceleration > 0.0f) {
                    this.vEngineVelocity.set(this.vDirection);
                    if (this.isDirection == -1) {
                        this.vEngineVelocity.reverse();
                    }
                }
                if (this.engineAcceleration < 0.0f && this.vEngineVelocity.quaterLength() < frame * this.engineAcceleration * frame * this.engineAcceleration) {
                    this.vEngineVelocity.setLength(0.0f);
                    this.engineAcceleration = 0.0f;
                } else {
                    this.vEngineVelocity.add(Vector3D.scalarMul(frame * this.engineAcceleration, Vector3D.normalize(this.vEngineVelocity)));
                }
                this.setVelocityCorrection(frame);
            }
        }
        if (this.vEngineVelocity.quaterLength() == 0.0f && this.handbrakeActive) {
            this.handbrakeActive = false;
            this.handbrakeReleased = true;
            this.handbrakeProperlyEnded = false;
            this.engineForce = 0.0f;
        }
    }

    private void setVelocityCorrection(float frame) {
        if (this.vEngineVelocity.length() < 0.5f * cutoffLevel) {
            this.vEngineVelocity.setLength(0.0f);
            this.engineForce = 0.0f;
            this.isDirection = 0;
        } else if (this.vEngineVelocity.length() > this.maxCurrentSpeed) {
            this.vEngineVelocity.setLength(this.maxCurrentSpeed);
        }
        if (this.currentTurnAngle.gety() != 0.0f) {
            float tempX = this.vEngineVelocity.getx();
            float tempZ = this.vEngineVelocity.getz();
            float angle = this.currentTurnAngle.gety() > 0.0f ? this.vEngineVelocity.length() / this.turningRadius * frame : -(this.vEngineVelocity.length() / this.turningRadius) * frame;
            this.vEngineVelocity.setx(tempX * (float)mMath.cos(angle) + tempZ * (float)mMath.sin(angle));
            this.vEngineVelocity.setz(-tempX * (float)mMath.sin(angle) + tempZ * (float)mMath.cos(angle));
        }
    }

    private void setCartRotation() {
        if (this.vEngineVelocity.quaterLength() != 0.0f && this.currentTurnAngle.gety() != 0.0f) {
            if (this.vDirection.getx() > 0.0f) {
                this.entityRotation.sety(-((float)mMath.toDegrees(mMath.acos((this.vDirection.getx() * 0.0f + this.vDirection.getz() * -1.0f) / this.vDirection.length()))));
            } else {
                this.entityRotation.sety((float)mMath.toDegrees(mMath.acos((this.vDirection.getx() * 0.0f + this.vDirection.getz() * -1.0f) / this.vDirection.length())));
            }
        }
    }

    private void stopDrift() {
        this.vDriftVelocity.setLength(0.0f);
        this.vFrictionForce.setLength(0.0f);
        this.vDriftForce.setLength(0.0f);
        this.vDriftAcceleration.setLength(0.0f);
        this.reallignVelocity();
        this.driftActive = false;
    }

    private void calculateDrift(float frame) {
        if (this.currentTurnAngle.gety() != 0.0f) {
            if (this.currentTurnAngle.gety() > 0.0f) {
                this.vDriftForce.setx(-this.vVelocity.getz());
                this.vDriftForce.setz(this.vVelocity.getx());
                this.vFrictionForce.setx(this.vVelocity.getz());
                this.vFrictionForce.setz(-this.vVelocity.getx());
            } else {
                this.vDriftForce.setx(this.vVelocity.getz());
                this.vDriftForce.setz(-this.vVelocity.getx());
                this.vFrictionForce.setx(-this.vVelocity.getz());
                this.vFrictionForce.setz(this.vVelocity.getx());
            }
            this.vDriftForce.normalize();
            this.vFrictionForce.normalize();
            float v = this.vVelocity.length();
            this.vDriftForce.scalarMul(this.mass * (v * v / this.turningRadius));
            this.vFrictionForce.scalarMul(this.mass * Stats.GRAVITY_ACCELERATION * this.frictionCoefficient);
            this.vDriftAcceleration.set(Vector3D.sub(this.vDriftForce, this.vFrictionForce));
            this.vDriftAcceleration.scalarDiv(this.mass);
            this.vDriftAcceleration.scalarDiv(1.5f);
            if (this.vFrictionForce.length() < this.vDriftForce.length()) {
                this.vDriftVelocity.add(Vector3D.scalarMul(frame, this.vDriftAcceleration));
                this.driftActive = true;
            } else if (this.vDriftVelocity.length() > 0.0f) {
                float val = frame * Stats.GRAVITY_ACCELERATION * this.frictionCoefficient * 0.4f;
                if (val > this.vDriftVelocity.length()) {
                    this.stopDrift();
                } else {
                    this.vDriftVelocity.add(Vector3D.scalarMul(-val, Vector3D.normalize(this.vDriftVelocity)));
                }
            }
        } else if (this.vDriftVelocity.length() > 0.0f) {
            float val = frame * Stats.GRAVITY_ACCELERATION * this.frictionCoefficient * 0.8f;
            if (val > this.vDriftVelocity.length()) {
                this.stopDrift();
            } else {
                this.vDriftVelocity.add(Vector3D.scalarMul(-val, Vector3D.normalize(this.vDriftVelocity)));
            }
        }
        if (this.vDriftVelocity.length() < 0.3f && this.driftActive) {
            this.stopDrift();
        }
    }

    public void setPhysicalConstraints(float frame) {
        this.setCollisionConstrains(frame);
        this.setGroundConstrains(frame);
    }

    private void setCollisionConstrains(float frame) {
        if (this.isCollision) {
            if (this.vEngineVelocity.length() > this.vOldEngineVelocity.length()) {
                this.vEngineVelocity.setLength(this.vOldEngineVelocity.length());
            }
            Vector3D newV = new Vector3D(this.vVelocity);
            Vector3D colVector = new Vector3D();
            boolean validCollsion = true;
            while (!this.colVectors.empty()) {
                colVector.set((Vector3D)this.colVectors.pop());
                if (colVector.isFdir(Vector3D.normalize(newV))) continue;
                Vector3D B = Vector3D.crossProduct(colVector, new Vector3D(0.0f, 1.0f, 0.0f));
                B.normalize();
                Vector3D A = new Vector3D(newV);
                newV.set(Vector3D.scalarMul(Vector3D.dotProduct(A, B) / Vector3D.dotProduct(B, B), B));
                validCollsion = true;
            }
            if (validCollsion) {
                this.vPosition.set(this.vOldPosition);
                this.vPosition.add(Vector3D.scalarMul(frame, newV));
                this.calculateDirection(frame);
                if (this.vDriftVelocity.length() > 0.0f) {
                    this.vDriftVelocity.scalarDiv(1.5f);
                    this.vEngineVelocity.add(Vector3D.scalarMul(-frame * Stats.GRAVITY_ACCELERATION * this.frictionCoefficient * 1.2f, Vector3D.normalize(this.vEngineVelocity)));
                    if (this.vDriftVelocity.length() < 0.2f) {
                        this.stopDrift();
                    }
                }
                this.setVelocityCorrection(frame);
                this.setCartRotation();
                if (this.handbrakeActive) {
                    this.handbrakeActive = false;
                    this.handbrakeReleased = true;
                    this.handbrakeProperlyEnded = false;
                }
                this.vGravityVelocity.scalarDiv(2.0f);
            }
            this.isCollision = false;
        }
    }

    public void setGroundConstrains(float frame) {
        if (this.vPosition.gety() - this.height / 2.0f < this.groundLevel) {
            this.vPosition.sety(this.groundLevel + this.height / 2.0f);
            if (this.vAltitudeVelocity.quaterLength() != 0.0f) {
                if (!this.isJumpDrift) {
                    float ratio = 1.0f - 0.5f / (2.0f * this.maxCurrentSpeed - Stats.GRAVITY_ACCELERATION * frame) * this.vAltitudeVelocity.length();
                    this.vEngineVelocity.scalarMul(ratio);
                    this.setVelocityCorrection(frame);
                    this.setCartRotation();
                }
                if (this.vAltitudeVelocity.gety() < 0.0f) {
                    this.vAltitudeVelocity.setLength(0.0f);
                    this.upHillJump = false;
                }
                this.isJumpDrift = false;
                this.isJumpTriggered = false;
            }
        }
        if (this.vAltitudeVelocity.quaterLength() == 0.0f && !this.hillJumpPossible) {
            this.vPosition.sety(this.groundLevel + this.height / 2.0f);
        }
    }

    private void calculateCollisions(float frame) {
        this.vCollisionVelocity.add(Vector3D.scalarMul(-frame * Stats.GRAVITY_ACCELERATION * this.frictionCoefficient * 0.5f, Vector3D.normalize(this.vCollisionVelocity)));
        if (this.vCollisionVelocity.length() < 0.45f * cutoffLevel) {
            this.vCollisionVelocity.setLength(0.0f);
        }
    }

    private void updateGravityVelocity(float frame) {
        if (this.vAltitudeVelocity.length() == 0.0f) {
            if (this.slippery) {
                Vector3D dir = Vector3D.sub(this.groundPlaneNormal, new Vector3D(0.0f, 1.0f, 0.0f));
                dir.normalize();
                dir.scalarMul(Stats.GRAVITY_ACCELERATION * frame / (this.frictionCoefficient * 2.0f));
                this.vGravityVelocity.add(dir);
                if (this.vGravityVelocity.length() > this.maxNominalSpeed) {
                    this.vGravityVelocity.setLength(this.maxNominalSpeed);
                }
            } else if (this.vEngineVelocity.length() != 0.0f) {
                float l = Vector3D.sub(new Vector3D(0.0f, 1.0f, 0.0f), this.groundPlaneNormal).length() / this.frictionCoefficient;
                float finl = (this.vGravityVelocity.length() + l) / 2.0f;
                Vector3D grav = new Vector3D(this.groundPlaneNormal.getx(), 0.0f, this.groundPlaneNormal.getz());
                grav.normalize();
                grav.scalarMul(l * (this.mass / 5.0f));
                this.vGravityVelocity.add(grav);
                this.vGravityVelocity.setLength(finl);
            } else {
                this.vGravityVelocity.scalarMul(0.8f);
                if (this.vGravityVelocity.length() < 0.4f * cutoffLevel) {
                    this.vGravityVelocity.setLength(0.0f);
                }
            }
        } else {
            this.vGravityVelocity.scalarMul(0.8f);
            if (this.vGravityVelocity.length() < 0.4f * cutoffLevel) {
                this.vGravityVelocity.setLength(0.0f);
            }
        }
    }

    public float getAltitude() {
        return this.vPosition.gety() - this.height / 2.0f - this.groundLevel;
    }

    public void updateAltitude(float frame) {
        float grav;
        Vector3D pos;
        float h;
        if (this.isPlayer) {
            this.oldvAltitudeVelocity.set(this.vAltitudeVelocity);
        }
        if (this.upHillJump && this.oldHeight < 0.0f) {
            this.vPosition.sety(this.vPosition.gety() - this.oldHeight);
        }
        if ((h = (pos = Vector3D.add(this.vPosition, Vector3D.scalarMul(frame, this.vVelocity))).gety() - this.height / 2.0f - this.groundLevel) > (grav = Stats.GRAVITY_ACCELERATION * (frame * frame) / 2.0f) && this.hillJumpPossible && this.vAltitudeVelocity.length() == 0.0f || this.vAltitudeVelocity.length() != 0.0f) {
            this.vAltitudeVelocity.add(new Vector3D(0.0f, -Stats.GRAVITY_ACCELERATION * frame, 0.0f));
        } else if (!this.isJumpTriggered && this.canMove || !this.hillJumpPossible && this.vAltitudeVelocity.length() == 0.0f) {
            this.vPosition.sety(this.groundLevel + this.height / 2.0f);
            this.vAltitudeVelocity.setLength(0.0f);
            this.upHillJump = false;
            this.canMove = true;
        } else if (!this.hillJumpPossible && this.vAltitudeVelocity.length() == 0.0f && this.getAltitude() > 2.0f) {
            this.vAltitudeVelocity.add(new Vector3D(0.0f, -Stats.GRAVITY_ACCELERATION * frame, 0.0f));
        }
        if (this.vAltitudeVelocity.gety() < -this.jumpSpeed) {
            this.isJumpDrift = false;
        }
    }

    public void updateGroundPlane(float frame) {
        if ((this.groundPlaneNormal.getx() != this.movementPlaneNormal.getx() || this.groundPlaneNormal.gety() != this.movementPlaneNormal.gety() || this.groundPlaneNormal.getz() != this.movementPlaneNormal.getz()) && this.vAltitudeVelocity.quaterLength() == 0.0f) {
            float vel = Math.max(this.vVelocity.length(), 5.0f);
            Vector3D v = Vector3D.scalarMul(vel / this.mass * frame, Vector3D.sub(this.groundPlaneNormal, this.movementPlaneNormal));
            if (v.quaterLength() == 0.0f) {
                this.movementPlaneNormal.set(this.groundPlaneNormal);
            }
            this.movementPlaneNormal.add(v);
            this.movementPlaneNormal.normalize();
            this.movementPlaneRot.setz(-((float)mMath.toDegrees(mMath.asin(this.movementPlaneNormal.getx()))));
            this.movementPlaneRot.setx((float)mMath.toDegrees(mMath.asin(this.movementPlaneNormal.getz())));
        } else if (this.vAltitudeVelocity.quaterLength() != 0.0f) {
            Vector3D dir = new Vector3D(this.vDirection);
            float val = 2.0f;
            if (this.isDirection == -1) {
                dir.reverse();
                val *= 2.0f;
            }
            Vector3D v = Vector3D.scalarMul(this.vVelocity.length() * frame / (this.maxCurrentSpeed * this.mass * val), Vector3D.sub(dir, this.movementPlaneNormal));
            this.movementPlaneNormal.add(v);
            this.movementPlaneNormal.normalize();
            this.movementPlaneRot.setz(-((float)mMath.toDegrees(mMath.asin(this.movementPlaneNormal.getx()))));
            this.movementPlaneRot.setx((float)mMath.toDegrees(mMath.asin(this.movementPlaneNormal.getz())));
        }
    }

    public void calculateTurnAngle() {
        float maxSpeed = this.maxNominalSpeed;
        if (this.maxCurrentSpeed > maxSpeed) {
            maxSpeed = this.maxCurrentSpeed;
        }
        this.turnAngle = this.turnAngleChange * this.maxTurnAngle / (this.vEngineVelocity.length() / maxSpeed * (this.vEngineVelocity.length() / maxSpeed) * (this.turnAngleChange - 1.0f) + 1.0f);
    }

    public void update(float frame) {
        if (!this.sleeping) {
            this.vOldPosition.set(this.vPosition);
            this.vOldEngineVelocity.set(this.vEngineVelocity);
            this.calculateTurnAngle();
            this.accelerate(frame);
            this.turn(frame);
            this.calculateEngineAcceleration();
            this.calculateDirection(frame);
            this.calculateEngineVelocity(frame);
            this.setCartRotation();
            this.vVelocity.set(this.vEngineVelocity);
            this.calculateCollisions(frame);
            this.vVelocity.add(this.vCollisionVelocity);
            this.updateGroundPlane(frame);
            if (this.isPlayer && Math.abs(this.oldvAltitudeVelocity.gety()) - Math.abs(this.vAltitudeVelocity.gety()) > 0.0f && this.vAltitudeVelocity.gety() == 0.0f) {
                SoundManager.playSfx(1);
            }
            this.updateGravityVelocity(frame);
            this.updateAltitude(frame);
            this.vVelocity.add(this.vGravityVelocity);
            this.vPosition.add(Vector3D.scalarMul(frame, Vector3D.add(this.vVelocity, this.vAltitudeVelocity)));
        }
    }
}

