/*
 * Decompiled with CFR 0.152.
 */
import com.mascotcapsule.micro3d.v3.Effect3D;
import com.mascotcapsule.micro3d.v3.FigureLayout;
import com.mascotcapsule.micro3d.v3.Graphics3D;
import com.mascotcapsule.micro3d.v3.Texture;

public class Sprite3D {
    private int COMMAND = 0x5001010;
    private int[] textureCoords = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    private int[] POINT = new int[]{0, 0, 0};
    private int[] NORMAL = new int[0];
    private int[] colors = new int[0];
    private Texture texture;
    private int cropX;
    private int cropY;
    private int width;
    private int height;

    public Sprite3D(boolean scaled, Texture image, Appearance appearance) {
        this.texture = image;
    }

    public void setCrop(int cropX, int cropY, int w, int h) {
        this.cropX = cropX;
        this.cropY = cropY;
        this.textureCoords[0] = this.width;
        this.textureCoords[1] = this.height;
        this.textureCoords[2] = 0;
        this.textureCoords[3] = cropX;
        this.textureCoords[4] = cropY;
        this.textureCoords[5] = cropX + w - 1;
        this.textureCoords[6] = cropY + h - 1;
    }

    public void render(Graphics3D g3d, FigureLayout layout, Effect3D effect) {
        g3d.renderPrimitives(this.texture, 0, 0, layout, effect, this.COMMAND, 1, this.POINT, this.NORMAL, this.textureCoords, this.colors);
    }

    public void setSize(int w, int h) {
        this.width = w;
        this.height = h;
        this.textureCoords[0] = this.width;
        this.textureCoords[1] = this.height;
    }
}

