/*
 * Decompiled with CFR 0.152.
 */
import com.mascotcapsule.micro3d.v3.FigureLayout;
import com.mascotcapsule.micro3d.v3.Graphics3D;
import com.mascotcapsule.micro3d.v3.Texture;
import java.io.DataInputStream;
import java.util.Vector;

public class Track {
    public static final String TRACK_DIR = "/Track/";
    public static final int ROADSIDE_WALL_HEIGHT = 100;
    public static int mScale = 10;
    public static final int MAINROAD_QUADS_PER_ROW = 3;
    public static final int MAINROAD_QUADS_PER_COL = 3;
    public static final int ROADSIDE_QUADS_PER_ROW = 2;
    public static final int ROADSIDE_QUADS_PER_COL = 2;
    public static final int WALL_QUADS_PER_ROW = 2;
    public static final int WALL_QUADS_PER_COL = 2;
    public static final int[][] TXT_TILES_COORDINATES = new int[][]{{0, 63, 63, 63, 0, 0, 63, 0}, {64, 63, 127, 63, 64, 0, 127, 0}, {128, 63, 191, 63, 128, 0, 191, 0}, {192, 63, 255, 63, 192, 0, 255, 0}, {0, 127, 63, 127, 0, 64, 63, 64}, {64, 127, 127, 127, 64, 64, 127, 64}, {128, 127, 191, 127, 128, 64, 191, 64}, {192, 64, 192, 127, 255, 64, 255, 127}, {0, 191, 63, 191, 0, 128, 63, 128}, {64, 191, 127, 191, 64, 128, 127, 128}, {128, 191, 191, 191, 128, 128, 191, 128}, {192, 191, 255, 191, 192, 128, 255, 128}, {0, 255, 63, 255, 0, 192, 63, 192}, {64, 255, 127, 255, 64, 192, 127, 192}, {128, 255, 191, 255, 128, 192, 191, 192}, {192, 255, 255, 255, 192, 192, 255, 192}};
    public int numBasePoints;
    public int numInterpolationSteps;
    private int m_versionNumber;
    private int[] m_tBasePoints;
    public Vector3D[] iPoints;
    public float[] iPointsWidth;
    private float[] iPointsAngle;
    public short[] roadVertices;
    public short[] leftSideVertices;
    public short[] rightSideVertices;
    public short[] leftWallVertices;
    public short[] rightWallVertices;
    public float roadSideWidth;
    public int m_numTextures;
    public String[] m_TextureNames;
    public int m_startPoint;
    public Vector[] mItemArray;
    public boolean[][] mItemMovableArray;
    public float[] mItemScale;
    public Vector[] mHelperArray;
    public Vector mShortcutsArray = new Vector();
    public Vector3D[] mArchPos;
    public Vector3D[] mGatePos;
    public int[] mainRoadTextureNr;
    public int[] leftSideTextureNr;
    public int[] rightSideTextureNr;
    public int[] leftWallTextureNr;
    public int[] rightWallTextureNr;
    int tx;
    int ty;
    int tz;
    float sx;
    float sy;
    float sz;
    public int[][] mscRoadVertices;
    public int[][] mscRoadCoordinates;
    public int[][] mscLeftSideVertices;
    public int[][] mscLeftSideCoordinates;
    public int[][] mscRightSideVertices;
    public int[][] mscRightSideCoordinates;
    public int[][] mscLeftWallVertices;
    public int[][] mscLeftWallCoordinates;
    public int[][] mscRightWallVertices;
    public int[][] mscRightWallCoordinates;
    public Texture mTexture;
    private FigureLayout mLayout = new FigureLayout();
    Vector3D v1 = new Vector3D();
    Vector3D v2 = new Vector3D();
    Vector3D v3 = new Vector3D();
    Vector3D v4 = new Vector3D();
    Vector3D vb1;
    Vector3D vb2;
    Vector3D vb3;
    Vector3D vb4;
    Vector3D vcd1;
    Vector3D vcd2;
    Vector3D vrd1;
    Vector3D vrd2;
    static /* synthetic */ Class class$Track;

    public void init(String fileName) {
        this.sz = 1.0f;
        this.sy = 1.0f;
        this.sx = 1.0f;
        if (GameLogic.gameWorld == 3 && GameLogic.gameTrack == 2) {
            this.tx = 700;
            this.ty = 700;
            this.tz = 700;
        } else {
            this.tz = 0;
            this.ty = 0;
            this.tx = 0;
        }
        if (GameLogic.gameWorld == 2 && GameLogic.gameTrack == 2) {
            this.ty = 200;
        }
        this.setupTrackAppearance();
        this.loadTrackData(fileName);
        this.generateTrackVertices();
        this.generateTrackMeshes();
    }

    private void setupTrackAppearance() {
        try {
            int wnr = GameLogic.gameWorld + 1;
            this.mTexture = new Texture("/Track/txt_theme_" + wnr + ".bmp", true);
        }
        catch (Exception e) {
            System.out.println("Error while initializing track textures.");
        }
    }

    private void loadTrackData(String fileName) {
        try {
            int i;
            DataInputStream din = new DataInputStream((class$Track == null ? (class$Track = Track.class$("Track")) : class$Track).getResourceAsStream(TRACK_DIR + fileName));
            this.m_versionNumber = din.readInt();
            this.numBasePoints = din.readInt();
            this.numInterpolationSteps = din.readInt();
            this.m_startPoint = din.readInt();
            this.roadSideWidth = din.readInt();
            int bpSize = this.numBasePoints * 5;
            this.m_tBasePoints = new int[bpSize];
            for (i = 0; i < bpSize; ++i) {
                if (i < this.m_startPoint * 5) {
                    this.m_tBasePoints[bpSize + i - this.m_startPoint * 5] = din.readInt();
                    continue;
                }
                this.m_tBasePoints[i - this.m_startPoint * 5] = din.readInt();
            }
            for (i = 0; i < this.numBasePoints; ++i) {
                int n = i * 5 + 0;
                this.m_tBasePoints[n] = this.m_tBasePoints[n] + this.tx;
                int n2 = i * 5 + 1;
                this.m_tBasePoints[n2] = this.m_tBasePoints[n2] + this.ty;
                int n3 = i * 5 + 2;
                this.m_tBasePoints[n3] = this.m_tBasePoints[n3] + this.tz;
            }
            this.mainRoadTextureNr = new int[this.numBasePoints * this.numInterpolationSteps + 1];
            this.leftSideTextureNr = new int[this.mainRoadTextureNr.length];
            this.rightSideTextureNr = new int[this.mainRoadTextureNr.length];
            this.leftWallTextureNr = new int[this.mainRoadTextureNr.length];
            this.rightWallTextureNr = new int[this.mainRoadTextureNr.length];
            for (int i2 = 0; i2 < this.mainRoadTextureNr.length; ++i2) {
                int index = i2 < this.m_startPoint * this.numInterpolationSteps ? this.mainRoadTextureNr.length + i2 - this.m_startPoint * this.numInterpolationSteps : i2 - this.m_startPoint * this.numInterpolationSteps;
                if (GameLogic.gameMode != 5) {
                    this.mainRoadTextureNr[index] = din.readByte();
                    this.leftSideTextureNr[index] = din.readByte();
                    this.rightSideTextureNr[index] = din.readByte();
                    this.leftWallTextureNr[index] = din.readByte();
                    this.rightWallTextureNr[index] = din.readByte();
                    if (i2 != this.mainRoadTextureNr.length - 1) continue;
                    this.mainRoadTextureNr[index] = this.mainRoadTextureNr[index - 1];
                    this.leftSideTextureNr[index] = this.leftSideTextureNr[index - 1];
                    this.rightSideTextureNr[index] = this.rightSideTextureNr[index - 1];
                    this.leftWallTextureNr[index] = this.leftWallTextureNr[index - 1];
                    this.rightWallTextureNr[index] = this.rightWallTextureNr[index - 1];
                    continue;
                }
                this.mainRoadTextureNr[this.mainRoadTextureNr.length - index - 1] = din.readByte();
                if (this.mainRoadTextureNr[this.mainRoadTextureNr.length - index - 1] == 1) {
                    this.mainRoadTextureNr[this.mainRoadTextureNr.length - index - 1] = 2;
                } else if (this.mainRoadTextureNr[this.mainRoadTextureNr.length - index - 1] == 2) {
                    this.mainRoadTextureNr[this.mainRoadTextureNr.length - index - 1] = 1;
                }
                if (this.mainRoadTextureNr[this.mainRoadTextureNr.length - index - 1] == 5) {
                    this.mainRoadTextureNr[this.mainRoadTextureNr.length - index - 1] = 6;
                } else if (this.mainRoadTextureNr[this.mainRoadTextureNr.length - index - 1] == 6) {
                    this.mainRoadTextureNr[this.mainRoadTextureNr.length - index - 1] = 5;
                }
                if (this.mainRoadTextureNr[this.mainRoadTextureNr.length - index - 1] == 9) {
                    this.mainRoadTextureNr[this.mainRoadTextureNr.length - index - 1] = 10;
                } else if (this.mainRoadTextureNr[this.mainRoadTextureNr.length - index - 1] == 10) {
                    this.mainRoadTextureNr[this.mainRoadTextureNr.length - index - 1] = 9;
                }
                this.leftSideTextureNr[this.mainRoadTextureNr.length - index - 1] = din.readByte();
                this.rightSideTextureNr[this.mainRoadTextureNr.length - index - 1] = din.readByte();
                this.leftWallTextureNr[this.mainRoadTextureNr.length - index - 1] = din.readByte();
                this.rightWallTextureNr[this.mainRoadTextureNr.length - index - 1] = din.readByte();
                if (i2 != this.mainRoadTextureNr.length - 1) continue;
                this.mainRoadTextureNr[this.mainRoadTextureNr.length - index - 1] = this.mainRoadTextureNr[this.mainRoadTextureNr.length - index];
                this.leftSideTextureNr[this.mainRoadTextureNr.length - index - 1] = this.leftSideTextureNr[this.mainRoadTextureNr.length - index];
                this.rightSideTextureNr[this.mainRoadTextureNr.length - index - 1] = this.rightSideTextureNr[this.mainRoadTextureNr.length - index];
                this.leftWallTextureNr[this.mainRoadTextureNr.length - index - 1] = this.leftWallTextureNr[this.mainRoadTextureNr.length - index];
                this.rightWallTextureNr[this.mainRoadTextureNr.length - index - 1] = this.rightWallTextureNr[this.mainRoadTextureNr.length - index];
            }
            if (this.m_versionNumber >= 7) {
                float z;
                float y;
                int j;
                int numItem;
                int i3;
                int numItemType = din.readInt();
                boolean helpers = false;
                if (numItemType > 19) {
                    helpers = true;
                    numItemType -= 5;
                }
                this.mItemArray = new Vector[numItemType];
                this.mItemScale = new float[numItemType];
                if (this.m_versionNumber >= 10) {
                    this.mItemMovableArray = new boolean[numItemType][0];
                }
                for (i3 = 0; i3 < numItemType; ++i3) {
                    this.mItemArray[i3] = new Vector();
                    numItem = din.readInt();
                    this.mItemScale[i3] = din.readInt();
                    if (this.m_versionNumber >= 10) {
                        this.mItemMovableArray[i3] = new boolean[numItem];
                    }
                    for (j = 0; j < numItem; ++j) {
                        if (this.m_versionNumber >= 10) {
                            this.mItemMovableArray[i3][j] = din.readBoolean();
                        }
                        float x = (float)((din.readInt() + this.tx) * mScale) * this.sx;
                        y = (float)((din.readInt() + this.ty) * mScale) * this.sy;
                        z = (float)((din.readInt() + this.tz) * mScale) * this.sz;
                        Vector3D tmp = GameLogic.gameMode == 5 ? new Vector3D(-x, -y, z) : new Vector3D(x, y, z);
                        this.mItemArray[i3].addElement(tmp);
                    }
                }
                if (helpers) {
                    this.mHelperArray = new Vector[3];
                    for (i3 = 0; i3 < 3; ++i3) {
                        this.mHelperArray[i3] = new Vector();
                        numItem = din.readInt();
                        float scale = din.readInt();
                        for (int j2 = 0; j2 < numItem; ++j2) {
                            float x = (float)((din.readInt() + this.tx) * mScale) * this.sx;
                            y = (float)((din.readInt() + this.ty) * mScale) * this.sy;
                            z = (float)((din.readInt() + this.tz) * mScale) * this.sz;
                            Vector3D tmp = GameLogic.gameMode == 5 ? new Vector3D(-x, -y, z) : new Vector3D(x, y, z);
                            this.mHelperArray[i3].addElement(tmp);
                        }
                    }
                    int numItem2 = din.readInt();
                    float scale = din.readInt();
                    this.mArchPos = new Vector3D[numItem2];
                    for (j = 0; j < numItem2; ++j) {
                        float x = (float)((din.readInt() + this.tx) * mScale) * this.sx;
                        y = (float)((din.readInt() + this.ty) * mScale) * this.sy;
                        z = (float)((din.readInt() + this.tz) * mScale) * this.sz;
                        this.mArchPos[j] = GameLogic.gameMode == 5 ? new Vector3D(-x, -y, z) : new Vector3D(x, y, z);
                        int rot = din.readInt();
                    }
                    numItem2 = din.readInt();
                    scale = din.readInt();
                    this.mGatePos = new Vector3D[numItem2];
                    for (j = 0; j < numItem2; ++j) {
                        float x = (float)((din.readInt() + this.tx) * mScale) * this.sx;
                        y = (float)((din.readInt() + this.ty) * mScale) * this.sy;
                        z = (float)((din.readInt() + this.tz) * mScale) * this.sz;
                        this.mGatePos[j] = GameLogic.gameMode == 5 ? new Vector3D(-x, -y, z) : new Vector3D(x, y, z);
                        int rot = din.readInt();
                        int gateNr = din.readInt();
                    }
                }
            }
            if (this.m_versionNumber >= 8) {
                int numArrays = din.readInt();
                for (int j = 0; j < numArrays; ++j) {
                    TrackShortcut sc;
                    int i4;
                    int endSide;
                    int startSide;
                    int n = din.readInt();
                    int steps = din.readInt();
                    int rw = din.readInt();
                    int sp = din.readInt();
                    int ep = din.readInt();
                    int[] startPoints = new int[4];
                    int[] endPoints = new int[4];
                    if (GameLogic.gameMode != 5) {
                        startSide = din.readInt();
                        endSide = din.readInt();
                        for (i4 = 0; i4 < startPoints.length; ++i4) {
                            startPoints[i4] = din.readInt() - this.m_startPoint * this.numInterpolationSteps;
                            if (startPoints[i4] >= 0) continue;
                            startPoints[i4] = this.numInterpolationSteps * this.numBasePoints + startPoints[i4];
                        }
                        for (i4 = 0; i4 < endPoints.length; ++i4) {
                            endPoints[i4] = din.readInt() - this.m_startPoint * this.numInterpolationSteps;
                            if (endPoints[i4] >= 0) continue;
                            endPoints[i4] = this.numInterpolationSteps * this.numBasePoints + endPoints[i4];
                        }
                        sc = new TrackShortcut(this, sp, ep, n, steps, rw);
                        for (i4 = 0; i4 < sc.numBasePoints; ++i4) {
                            sc.xPoints[i4] = (float)((din.readInt() + this.tx) * mScale) * this.sx;
                            sc.zPoints[i4] = (float)((din.readInt() + this.ty) * mScale) * this.sy;
                            sc.yPoints[i4] = (float)((din.readInt() + this.tz) * mScale) * this.sz;
                            sc.wPoints[i4] = din.readInt() * mScale;
                            sc.aPoints[i4] = din.readInt();
                        }
                    } else {
                        endSide = din.readInt();
                        startSide = din.readInt();
                        for (i4 = 0; i4 < endPoints.length; ++i4) {
                            endPoints[endPoints.length - 1 - i4] = (this.numBasePoints + this.m_startPoint) * this.numInterpolationSteps - din.readInt();
                            if (endPoints[endPoints.length - 1 - i4] <= this.numInterpolationSteps * this.numBasePoints) continue;
                            int n4 = endPoints.length - 1 - i4;
                            endPoints[n4] = endPoints[n4] - this.numInterpolationSteps * this.numBasePoints;
                        }
                        for (i4 = 0; i4 < startPoints.length; ++i4) {
                            startPoints[startPoints.length - 1 - i4] = (this.numBasePoints + this.m_startPoint) * this.numInterpolationSteps - din.readInt();
                            if (startPoints[startPoints.length - 1 - i4] <= this.numInterpolationSteps * this.numBasePoints) continue;
                            int n5 = startPoints.length - 1 - i4;
                            startPoints[n5] = startPoints[n5] - this.numInterpolationSteps * this.numBasePoints;
                        }
                        sc = new TrackShortcut(this, sp, ep, n, steps, rw);
                        for (i4 = 0; i4 < sc.numBasePoints; ++i4) {
                            sc.xPoints[sc.numBasePoints - 1 - i4] = (float)((-din.readInt() + this.tx) * mScale) * this.sx;
                            sc.zPoints[sc.numBasePoints - 1 - i4] = (float)((-din.readInt() + this.ty) * mScale) * this.sy;
                            sc.yPoints[sc.numBasePoints - 1 - i4] = (float)((din.readInt() + this.tz) * mScale) * this.sz;
                            sc.wPoints[sc.numBasePoints - 1 - i4] = din.readInt() * mScale;
                            sc.aPoints[sc.numBasePoints - 1 - i4] = din.readInt();
                        }
                    }
                    sc.mainRoadTextureNr = new int[(sc.numBasePoints - 1) * sc.numInterpolationSteps];
                    sc.leftSideTextureNr = new int[sc.mainRoadTextureNr.length];
                    sc.rightSideTextureNr = new int[sc.mainRoadTextureNr.length];
                    sc.leftWallTextureNr = new int[sc.mainRoadTextureNr.length];
                    sc.rightWallTextureNr = new int[sc.mainRoadTextureNr.length];
                    for (i4 = 0; i4 < (sc.numBasePoints - 1) * sc.numInterpolationSteps; ++i4) {
                        if (GameLogic.gameMode != 5) {
                            sc.mainRoadTextureNr[i4] = din.readByte();
                            sc.leftSideTextureNr[i4] = din.readByte();
                            sc.rightSideTextureNr[i4] = din.readByte();
                            sc.leftWallTextureNr[i4] = din.readByte();
                            sc.rightWallTextureNr[i4] = din.readByte();
                            continue;
                        }
                        sc.mainRoadTextureNr[sc.mainRoadTextureNr.length - i4 - 1] = din.readByte();
                        if (sc.mainRoadTextureNr[sc.mainRoadTextureNr.length - i4 - 1] == 1) {
                            sc.mainRoadTextureNr[sc.mainRoadTextureNr.length - i4 - 1] = 2;
                        } else if (sc.mainRoadTextureNr[sc.mainRoadTextureNr.length - i4 - 1] == 2) {
                            sc.mainRoadTextureNr[sc.mainRoadTextureNr.length - i4 - 1] = 1;
                        }
                        if (sc.mainRoadTextureNr[sc.mainRoadTextureNr.length - i4 - 1] == 5) {
                            sc.mainRoadTextureNr[sc.mainRoadTextureNr.length - i4 - 1] = 6;
                        } else if (sc.mainRoadTextureNr[sc.mainRoadTextureNr.length - i4 - 1] == 6) {
                            sc.mainRoadTextureNr[sc.mainRoadTextureNr.length - i4 - 1] = 5;
                        }
                        if (sc.mainRoadTextureNr[sc.mainRoadTextureNr.length - i4 - 1] == 9) {
                            sc.mainRoadTextureNr[sc.mainRoadTextureNr.length - i4 - 1] = 10;
                        } else if (sc.mainRoadTextureNr[sc.mainRoadTextureNr.length - i4 - 1] == 10) {
                            sc.mainRoadTextureNr[sc.mainRoadTextureNr.length - i4 - 1] = 9;
                        } else if (sc.mainRoadTextureNr[sc.mainRoadTextureNr.length - i4 - 1] == 11) {
                            sc.mainRoadTextureNr[sc.mainRoadTextureNr.length - i4 - 1] = 12;
                        } else if (sc.mainRoadTextureNr[sc.mainRoadTextureNr.length - i4 - 1] == 12) {
                            sc.mainRoadTextureNr[sc.mainRoadTextureNr.length - i4 - 1] = 11;
                        }
                        sc.leftSideTextureNr[sc.mainRoadTextureNr.length - i4 - 1] = din.readByte();
                        sc.rightSideTextureNr[sc.mainRoadTextureNr.length - i4 - 1] = din.readByte();
                        sc.leftWallTextureNr[sc.mainRoadTextureNr.length - i4 - 1] = din.readByte();
                        sc.rightWallTextureNr[sc.mainRoadTextureNr.length - i4 - 1] = din.readByte();
                    }
                    sc.createGeometry();
                    sc.startSide = startSide;
                    sc.endSide = endSide;
                    for (i4 = 0; i4 < startPoints.length; ++i4) {
                        sc.startPoints[i4] = startPoints[i4];
                    }
                    for (i4 = 0; i4 < endPoints.length; ++i4) {
                        sc.endPoints[i4] = endPoints[i4];
                    }
                    this.mShortcutsArray.addElement(sc);
                }
            }
            din.close();
        }
        catch (Exception e) {
            System.out.println("Error while loading track data.");
        }
    }

    private void generateTrackVertices() {
        Vector3D v3;
        int i;
        int i2;
        float[] xPoints = new float[this.numBasePoints];
        float[] yPoints = new float[this.numBasePoints];
        float[] zPoints = new float[this.numBasePoints];
        float[] wPoints = new float[this.numBasePoints];
        float[] aPoints = new float[this.numBasePoints];
        if (GameLogic.gameMode != 5) {
            for (i2 = 0; i2 < this.numBasePoints; ++i2) {
                xPoints[i2] = (float)(this.m_tBasePoints[i2 * 5 + 0] * mScale) * this.sx;
                yPoints[i2] = (float)(this.m_tBasePoints[i2 * 5 + 1] * mScale) * this.sy;
                zPoints[i2] = (float)(this.m_tBasePoints[i2 * 5 + 2] * mScale) * this.sz;
                wPoints[i2] = this.m_tBasePoints[i2 * 5 + 3] * mScale;
                aPoints[i2] = this.m_tBasePoints[i2 * 5 + 4];
            }
        } else {
            xPoints[0] = (float)(-this.m_tBasePoints[0] * mScale) * this.sx;
            yPoints[0] = (float)(-this.m_tBasePoints[1] * mScale) * this.sy;
            zPoints[0] = (float)(this.m_tBasePoints[2] * mScale) * this.sz;
            wPoints[0] = this.m_tBasePoints[3] * mScale;
            aPoints[0] = this.m_tBasePoints[4];
            for (i2 = 1; i2 < this.numBasePoints; ++i2) {
                xPoints[this.numBasePoints - i2] = (float)(-this.m_tBasePoints[i2 * 5 + 0] * mScale) * this.sx;
                yPoints[this.numBasePoints - i2] = (float)(-this.m_tBasePoints[i2 * 5 + 1] * mScale) * this.sy;
                zPoints[this.numBasePoints - i2] = (float)(this.m_tBasePoints[i2 * 5 + 2] * mScale) * this.sz;
                wPoints[this.numBasePoints - i2] = this.m_tBasePoints[i2 * 5 + 3] * mScale;
                aPoints[this.numBasePoints - i2] = this.m_tBasePoints[i2 * 5 + 4];
            }
        }
        Spline[] xSpline = Spline.calculateClosedCubic(this.numBasePoints - 1, xPoints);
        Spline[] ySpline = Spline.calculateClosedCubic(this.numBasePoints - 1, yPoints);
        Spline[] zSpline = Spline.calculateClosedCubic(this.numBasePoints - 1, zPoints);
        Spline[] wSpline = Spline.calculateClosedCubic(this.numBasePoints - 1, wPoints);
        Spline[] aSpline = Spline.calculateClosedCubic(this.numBasePoints - 1, aPoints);
        int size = this.numInterpolationSteps * this.numBasePoints;
        this.iPoints = new Vector3D[size];
        this.iPointsWidth = new float[size];
        this.iPointsAngle = new float[size];
        int iPointNr = 0;
        for (int i3 = 0; i3 < this.numBasePoints; ++i3) {
            for (int j = 0; j < this.numInterpolationSteps; ++j) {
                float u = (float)j / (float)this.numInterpolationSteps;
                this.iPoints[iPointNr] = new Vector3D(xSpline[i3].eval(u), ySpline[i3].eval(u), zSpline[i3].eval(u));
                this.iPointsWidth[iPointNr] = wSpline[i3].eval(u);
                this.iPointsAngle[iPointNr] = aSpline[i3].eval(u);
                ++iPointNr;
            }
        }
        this.roadVertices = new short[this.iPoints.length * 2 * 3];
        this.leftSideVertices = new short[this.iPoints.length * 2 * 3];
        this.rightSideVertices = new short[this.iPoints.length * 2 * 3];
        this.leftWallVertices = new short[this.iPoints.length * 2 * 3];
        this.rightWallVertices = new short[this.iPoints.length * 2 * 3];
        int vCount = 0;
        for (i = 0; i < this.iPoints.length; ++i) {
            Vector3D vTmp = i < this.iPoints.length - 1 ? Vector3D.sub(this.iPoints[i + 1], this.iPoints[i]) : Vector3D.sub(this.iPoints[0], this.iPoints[i]);
            vTmp.normalize();
            Vector3D vUp = new Vector3D(0.0f, 1.0f, 0.0f);
            float angle = (float)((double)this.iPointsAngle[i] * Math.PI / 180.0);
            if (angle != 0.0f) {
                float nx = (float)((double)vUp.getx() * mMath.cos(angle) - (double)vUp.gety() * mMath.sin(angle));
                float ny = (float)((double)vUp.getx() * mMath.sin(angle) + (double)vUp.gety() * mMath.cos(angle));
                float nz = vUp.getz();
                vUp.set(nx, ny, nz);
            }
            Vector3D vC = Vector3D.crossProduct(vTmp, vUp);
            Vector3D vD = new Vector3D(vC);
            vC.scalarMul(this.iPointsWidth[i]);
            vD.scalarMul(this.iPointsWidth[i] + this.roadSideWidth * (float)mScale);
            Vector3D v1 = Vector3D.sub(this.iPoints[i], vC);
            Vector3D v2 = Vector3D.add(this.iPoints[i], vC);
            v3 = Vector3D.sub(this.iPoints[i], vD);
            Vector3D v4 = Vector3D.add(this.iPoints[i], vD);
            this.roadVertices[vCount + 0] = (short)v1.getx();
            this.roadVertices[vCount + 1] = (short)v1.gety();
            this.roadVertices[vCount + 2] = (short)v1.getz();
            this.leftSideVertices[vCount + 0] = (short)v3.getx();
            this.leftSideVertices[vCount + 1] = (short)v3.gety();
            this.leftSideVertices[vCount + 2] = (short)v3.getz();
            this.rightSideVertices[vCount + 0] = (short)v2.getx();
            this.rightSideVertices[vCount + 1] = (short)v2.gety();
            this.rightSideVertices[vCount + 2] = (short)v2.getz();
            this.leftWallVertices[vCount + 0] = (short)v3.getx();
            this.leftWallVertices[vCount + 1] = (short)(v3.gety() + (float)(100 * mScale));
            this.leftWallVertices[vCount + 2] = (short)v3.getz();
            this.rightWallVertices[vCount + 0] = (short)v4.getx();
            this.rightWallVertices[vCount + 1] = (short)(v4.gety() + (float)(100 * mScale));
            this.rightWallVertices[vCount + 2] = (short)v4.getz();
            this.roadVertices[(vCount += 3) + 0] = (short)v2.getx();
            this.roadVertices[vCount + 1] = (short)v2.gety();
            this.roadVertices[vCount + 2] = (short)v2.getz();
            this.leftSideVertices[vCount + 0] = (short)v1.getx();
            this.leftSideVertices[vCount + 1] = (short)v1.gety();
            this.leftSideVertices[vCount + 2] = (short)v1.getz();
            this.rightSideVertices[vCount + 0] = (short)v4.getx();
            this.rightSideVertices[vCount + 1] = (short)v4.gety();
            this.rightSideVertices[vCount + 2] = (short)v4.getz();
            this.leftWallVertices[vCount + 0] = (short)v3.getx();
            this.leftWallVertices[vCount + 1] = (short)v3.gety();
            this.leftWallVertices[vCount + 2] = (short)v3.getz();
            this.rightWallVertices[vCount + 0] = (short)v4.getx();
            this.rightWallVertices[vCount + 1] = (short)v4.gety();
            this.rightWallVertices[vCount + 2] = (short)v4.getz();
            vCount += 3;
        }
        for (i = 0; i < this.mShortcutsArray.size(); ++i) {
            TrackShortcut sc = (TrackShortcut)this.mShortcutsArray.elementAt(i);
            sc.updateFitPoints();
            sc.createMeshes();
        }
        for (int k = 0; k < this.mShortcutsArray.size(); ++k) {
            int index;
            int j;
            Vector3D v12;
            Vector3D v2;
            Vector3D v1;
            TrackShortcut sc = (TrackShortcut)this.mShortcutsArray.elementAt(k);
            int da = sc.startPoints[2] - sc.startPoints[1];
            if (da > 1) {
                int j2;
                if (sc.startSide == 0) {
                    v1 = new Vector3D(this.leftSideVertices[sc.startPoints[1] * 2 * 3 + 0], this.leftSideVertices[sc.startPoints[1] * 2 * 3 + 1], this.leftSideVertices[sc.startPoints[1] * 2 * 3 + 2]);
                    v2 = new Vector3D(this.leftSideVertices[sc.startPoints[2] * 2 * 3 + 0], this.leftSideVertices[sc.startPoints[2] * 2 * 3 + 1], this.leftSideVertices[sc.startPoints[2] * 2 * 3 + 2]);
                    v12 = Vector3D.sub(v2, v1);
                    v12.scalarDiv(da);
                    for (j2 = 1; j2 <= da - 1; ++j2) {
                        int index2 = sc.startPoints[1] + j2;
                        v3 = Vector3D.add(v1, Vector3D.scalarMul(j2, v12));
                        this.leftSideVertices[index2 * 2 * 3 + 0] = (short)v3.getx();
                        this.leftSideVertices[index2 * 2 * 3 + 1] = (short)v3.gety();
                        this.leftSideVertices[index2 * 2 * 3 + 2] = (short)v3.getz();
                    }
                } else {
                    v1 = new Vector3D(this.rightSideVertices[sc.startPoints[1] * 2 * 3 + 0 + 3], this.rightSideVertices[sc.startPoints[1] * 2 * 3 + 1 + 3], this.rightSideVertices[sc.startPoints[1] * 2 * 3 + 2 + 3]);
                    v2 = new Vector3D(this.rightSideVertices[sc.startPoints[2] * 2 * 3 + 0 + 3], this.rightSideVertices[sc.startPoints[2] * 2 * 3 + 1 + 3], this.rightSideVertices[sc.startPoints[2] * 2 * 3 + 2 + 3]);
                    v12 = Vector3D.sub(v2, v1);
                    v12.scalarDiv(da);
                    for (j2 = 1; j2 <= da - 1; ++j2) {
                        int index3 = sc.startPoints[1] + j2;
                        v3 = Vector3D.add(v1, Vector3D.scalarMul(j2, v12));
                        this.rightSideVertices[index3 * 2 * 3 + 0 + 3] = (short)v3.getx();
                        this.rightSideVertices[index3 * 2 * 3 + 1 + 3] = (short)v3.gety();
                        this.rightSideVertices[index3 * 2 * 3 + 2 + 3] = (short)v3.getz();
                    }
                }
            }
            if ((da = sc.endPoints[2] - sc.endPoints[1]) <= 1) continue;
            if (sc.endSide == 0) {
                v1 = new Vector3D(this.leftSideVertices[sc.endPoints[1] * 2 * 3 + 0], this.leftSideVertices[sc.endPoints[1] * 2 * 3 + 1], this.leftSideVertices[sc.endPoints[1] * 2 * 3 + 2]);
                v2 = new Vector3D(this.leftSideVertices[sc.endPoints[2] * 2 * 3 + 0], this.leftSideVertices[sc.endPoints[2] * 2 * 3 + 1], this.leftSideVertices[sc.endPoints[2] * 2 * 3 + 2]);
                v12 = Vector3D.sub(v2, v1);
                v12.scalarDiv(da);
                for (j = 1; j <= da - 1; ++j) {
                    index = sc.endPoints[1] + j;
                    v3 = Vector3D.add(v1, Vector3D.scalarMul(j, v12));
                    this.leftSideVertices[index * 2 * 3 + 0] = (short)v3.getx();
                    this.leftSideVertices[index * 2 * 3 + 1] = (short)v3.gety();
                    this.leftSideVertices[index * 2 * 3 + 2] = (short)v3.getz();
                }
                continue;
            }
            v1 = new Vector3D(this.rightSideVertices[sc.endPoints[1] * 2 * 3 + 0 + 3], this.rightSideVertices[sc.endPoints[1] * 2 * 3 + 1 + 3], this.rightSideVertices[sc.endPoints[1] * 2 * 3 + 2 + 3]);
            v2 = new Vector3D(this.rightSideVertices[sc.endPoints[2] * 2 * 3 + 0 + 3], this.rightSideVertices[sc.endPoints[2] * 2 * 3 + 1 + 3], this.rightSideVertices[sc.endPoints[2] * 2 * 3 + 2 + 3]);
            v12 = Vector3D.sub(v2, v1);
            v12.scalarDiv(da);
            for (j = 1; j <= da - 1; ++j) {
                index = sc.endPoints[1] + j;
                v3 = Vector3D.add(v1, Vector3D.scalarMul(j, v12));
                this.rightSideVertices[index * 2 * 3 + 0 + 3] = (short)v3.getx();
                this.rightSideVertices[index * 2 * 3 + 1 + 3] = (short)v3.gety();
                this.rightSideVertices[index * 2 * 3 + 2 + 3] = (short)v3.getz();
            }
        }
    }

    private void generateTrackMeshes() {
        int m;
        int j;
        boolean skipThisQuad;
        int dtnr;
        int txtMode;
        int m2;
        int inr;
        int j2;
        int j3;
        int k;
        int i;
        int mqpr = 3;
        int mqpc = 3;
        int sqpr = 2;
        int sqpc = 2;
        int wqpr = 2;
        int wqpc = 2;
        this.mscRoadVertices = new int[this.numBasePoints][this.numInterpolationSteps * mqpc * mqpr * 4 * 3];
        this.mscRoadCoordinates = new int[this.numBasePoints][this.numInterpolationSteps * mqpc * mqpr * 4 * 2];
        this.mscLeftSideVertices = new int[this.numBasePoints][this.numInterpolationSteps * sqpc * sqpr * 4 * 3];
        this.mscLeftSideCoordinates = new int[this.numBasePoints][this.numInterpolationSteps * sqpc * sqpr * 4 * 2];
        this.mscRightSideVertices = new int[this.numBasePoints][this.numInterpolationSteps * sqpc * sqpr * 4 * 3];
        this.mscRightSideCoordinates = new int[this.numBasePoints][this.numInterpolationSteps * sqpc * sqpr * 4 * 2];
        this.mscLeftWallVertices = new int[this.numBasePoints][this.numInterpolationSteps * wqpc * wqpr * 4 * 3];
        this.mscLeftWallCoordinates = new int[this.numBasePoints][this.numInterpolationSteps * wqpc * wqpr * 4 * 2];
        this.mscRightWallVertices = new int[this.numBasePoints][this.numInterpolationSteps * wqpc * wqpr * 4 * 3];
        this.mscRightWallCoordinates = new int[this.numBasePoints][this.numInterpolationSteps * wqpc * wqpr * 4 * 2];
        int vIndex = 0;
        for (i = 0; i < this.numBasePoints; ++i) {
            for (k = 0; k < this.numInterpolationSteps; ++k) {
                for (j3 = 0; j3 < 12; ++j3) {
                    if (vIndex + j3 > this.roadVertices.length - 1) {
                        vIndex = -j3;
                    }
                    this.mscRoadVertices[i][k * mqpc * mqpr * 12 + j3] = this.roadVertices[vIndex + j3];
                }
                vIndex += 6;
                this.splitMainQuadVertices(this.mscRoadVertices, i, k, mqpc, mqpr);
            }
            for (j2 = 0; j2 < this.numInterpolationSteps; ++j2) {
                inr = i * this.numInterpolationSteps + j2;
                boolean lmode = false;
                boolean rmode = false;
                int ftile = 0;
                for (m2 = 0; m2 < this.mShortcutsArray.size(); ++m2) {
                    TrackShortcut sc = (TrackShortcut)this.mShortcutsArray.elementAt(m2);
                    if (inr >= sc.startPoints[1] && inr < sc.startPoints[2] && sc.startSide == 0 || inr >= sc.endPoints[1] && inr < sc.endPoints[2] && sc.startSide == 0) {
                        lmode = true;
                        if (inr == sc.startPoints[1] || inr == sc.endPoints[1]) {
                            ftile = 1;
                        } else if (inr == sc.startPoints[2] - 1 || inr == sc.endPoints[2] - 1) {
                            ftile = 2;
                        }
                    }
                    if ((inr < sc.startPoints[1] || inr >= sc.startPoints[2] || sc.startSide != 1) && (inr < sc.endPoints[1] || inr >= sc.endPoints[2] || sc.startSide != 1)) continue;
                    rmode = true;
                    if (inr == sc.startPoints[1] || inr == sc.endPoints[1]) {
                        ftile = 1;
                        continue;
                    }
                    if (inr != sc.startPoints[2] - 1 && inr != sc.endPoints[2] - 1) continue;
                    ftile = 2;
                }
                int mode = 0;
                if (lmode) {
                    ++mode;
                }
                if (rmode) {
                    mode += 2;
                }
                mode = 0;
                switch (mode) {
                    case 0: {
                        for (int m3 = 0; m3 < 8; ++m3) {
                            this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + m3] = (short)TXT_TILES_COORDINATES[this.mainRoadTextureNr[inr]][m3];
                        }
                        break;
                    }
                    case 1: {
                        if (ftile == 1) {
                            this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 0] = (short)TXT_TILES_COORDINATES[14][2];
                            this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 1] = (short)TXT_TILES_COORDINATES[14][3];
                            this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 2] = (short)TXT_TILES_COORDINATES[14][0];
                            this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 3] = (short)TXT_TILES_COORDINATES[14][1];
                            this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 4] = (short)TXT_TILES_COORDINATES[14][6];
                            this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 5] = (short)TXT_TILES_COORDINATES[14][7];
                            this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 6] = (short)TXT_TILES_COORDINATES[14][4];
                            this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 7] = (short)TXT_TILES_COORDINATES[14][5];
                            break;
                        }
                        if (ftile == 2) {
                            this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 0] = (short)TXT_TILES_COORDINATES[15][2];
                            this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 1] = (short)TXT_TILES_COORDINATES[15][3];
                            this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 2] = (short)TXT_TILES_COORDINATES[15][0];
                            this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 3] = (short)TXT_TILES_COORDINATES[15][1];
                            this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 4] = (short)TXT_TILES_COORDINATES[15][6];
                            this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 5] = (short)TXT_TILES_COORDINATES[15][7];
                            this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 6] = (short)TXT_TILES_COORDINATES[15][4];
                            this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 7] = (short)TXT_TILES_COORDINATES[15][5];
                            break;
                        }
                        if (ftile != 0) break;
                        this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 0] = (short)TXT_TILES_COORDINATES[13][2];
                        this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 1] = (short)TXT_TILES_COORDINATES[13][3];
                        this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 2] = (short)TXT_TILES_COORDINATES[13][0];
                        this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 3] = (short)TXT_TILES_COORDINATES[13][1];
                        this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 4] = (short)TXT_TILES_COORDINATES[13][6];
                        this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 5] = (short)TXT_TILES_COORDINATES[13][7];
                        this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 6] = (short)TXT_TILES_COORDINATES[13][4];
                        this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 7] = (short)TXT_TILES_COORDINATES[13][5];
                        break;
                    }
                    case 2: {
                        if (ftile == 1) {
                            this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 0] = (short)TXT_TILES_COORDINATES[14][0];
                            this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 1] = (short)TXT_TILES_COORDINATES[14][1];
                            this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 2] = (short)TXT_TILES_COORDINATES[14][2];
                            this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 3] = (short)TXT_TILES_COORDINATES[14][3];
                            this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 4] = (short)TXT_TILES_COORDINATES[14][4];
                            this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 5] = (short)TXT_TILES_COORDINATES[14][5];
                            this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 6] = (short)TXT_TILES_COORDINATES[14][6];
                            this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 7] = (short)TXT_TILES_COORDINATES[14][7];
                            break;
                        }
                        if (ftile == 2) {
                            this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 0] = (short)TXT_TILES_COORDINATES[15][0];
                            this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 1] = (short)TXT_TILES_COORDINATES[15][1];
                            this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 2] = (short)TXT_TILES_COORDINATES[15][2];
                            this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 3] = (short)TXT_TILES_COORDINATES[15][3];
                            this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 4] = (short)TXT_TILES_COORDINATES[15][4];
                            this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 5] = (short)TXT_TILES_COORDINATES[15][5];
                            this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 6] = (short)TXT_TILES_COORDINATES[15][6];
                            this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 7] = (short)TXT_TILES_COORDINATES[15][7];
                            break;
                        }
                        if (ftile != 0) break;
                        this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 0] = (short)TXT_TILES_COORDINATES[13][0];
                        this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 1] = (short)TXT_TILES_COORDINATES[13][1];
                        this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 2] = (short)TXT_TILES_COORDINATES[13][2];
                        this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 3] = (short)TXT_TILES_COORDINATES[13][3];
                        this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 4] = (short)TXT_TILES_COORDINATES[13][4];
                        this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 5] = (short)TXT_TILES_COORDINATES[13][5];
                        this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 6] = (short)TXT_TILES_COORDINATES[13][6];
                        this.mscRoadCoordinates[i][j2 * mqpc * mqpr * 8 + 7] = (short)TXT_TILES_COORDINATES[13][7];
                    }
                }
                this.splitMainQuadCoordinates(this.mscRoadCoordinates, i, j2, mqpc, mqpr);
            }
        }
        vIndex = 0;
        for (i = 0; i < this.numBasePoints; ++i) {
            for (k = 0; k < this.numInterpolationSteps; ++k) {
                for (j3 = 0; j3 < 12; ++j3) {
                    if (vIndex + j3 > this.leftSideVertices.length - 1) {
                        vIndex = -j3;
                    }
                    this.mscLeftSideVertices[i][k * sqpc * sqpr * 12 + j3] = this.leftSideVertices[vIndex + j3];
                }
                vIndex += 6;
                this.splitMainQuadVertices(this.mscLeftSideVertices, i, k, sqpc, sqpr);
            }
            for (j2 = 0; j2 < this.numInterpolationSteps; ++j2) {
                inr = i * this.numInterpolationSteps + j2;
                txtMode = 0;
                float dtx = 0.0f;
                dtnr = 0;
                for (m2 = 0; m2 < this.mShortcutsArray.size(); ++m2) {
                    TrackShortcut sc = (TrackShortcut)this.mShortcutsArray.elementAt(m2);
                    if (inr >= sc.startPoints[1] && inr < sc.startPoints[2] && sc.startSide == 0) {
                        dtx = 64.0f / (float)(sc.startPoints[2] - sc.startPoints[1]);
                        dtnr = inr - sc.startPoints[1];
                        txtMode = 1;
                        break;
                    }
                    if (inr < sc.endPoints[1] || inr >= sc.endPoints[2] || sc.startSide != 0) continue;
                    dtx = 64.0f / (float)(sc.endPoints[2] - sc.endPoints[1]);
                    dtnr = inr - sc.endPoints[1];
                    txtMode = 1;
                    break;
                }
                txtMode = 0;
                switch (txtMode) {
                    case 0: {
                        for (m2 = 0; m2 < 8; ++m2) {
                            this.mscLeftSideCoordinates[i][j2 * sqpc * sqpr * 8 + m2] = (short)TXT_TILES_COORDINATES[this.leftSideTextureNr[inr]][m2];
                        }
                        break;
                    }
                    case 1: {
                        this.mscLeftSideCoordinates[i][j2 * sqpc * sqpr * 8 + 0] = (short)((float)TXT_TILES_COORDINATES[0][4] + (float)dtnr * dtx);
                        this.mscLeftSideCoordinates[i][j2 * sqpc * sqpr * 8 + 1] = (short)TXT_TILES_COORDINATES[0][5];
                        this.mscLeftSideCoordinates[i][j2 * sqpc * sqpr * 8 + 2] = (short)((float)TXT_TILES_COORDINATES[0][0] + (float)dtnr * dtx);
                        this.mscLeftSideCoordinates[i][j2 * sqpc * sqpr * 8 + 3] = (short)TXT_TILES_COORDINATES[0][1];
                        this.mscLeftSideCoordinates[i][j2 * sqpc * sqpr * 8 + 4] = (short)((float)TXT_TILES_COORDINATES[0][4] + (float)(dtnr + 1) * dtx);
                        this.mscLeftSideCoordinates[i][j2 * sqpc * sqpr * 8 + 5] = (short)TXT_TILES_COORDINATES[0][7];
                        this.mscLeftSideCoordinates[i][j2 * sqpc * sqpr * 8 + 6] = (short)((float)TXT_TILES_COORDINATES[0][0] + (float)(dtnr + 1) * dtx);
                        this.mscLeftSideCoordinates[i][j2 * sqpc * sqpr * 8 + 7] = (short)TXT_TILES_COORDINATES[0][3];
                    }
                }
                this.splitMainQuadCoordinates(this.mscLeftSideCoordinates, i, j2, sqpc, sqpr);
            }
        }
        vIndex = 0;
        for (i = 0; i < this.numBasePoints; ++i) {
            for (k = 0; k < this.numInterpolationSteps; ++k) {
                for (j3 = 0; j3 < 12; ++j3) {
                    if (vIndex + j3 > this.rightSideVertices.length - 1) {
                        vIndex = -j3;
                    }
                    this.mscRightSideVertices[i][k * sqpc * sqpr * 12 + j3] = this.rightSideVertices[vIndex + j3];
                }
                vIndex += 6;
                this.splitMainQuadVertices(this.mscRightSideVertices, i, k, sqpc, sqpr);
            }
            for (j2 = 0; j2 < this.numInterpolationSteps; ++j2) {
                inr = i * this.numInterpolationSteps + j2;
                txtMode = 0;
                float dtx = 0.0f;
                dtnr = 0;
                for (m2 = 0; m2 < this.mShortcutsArray.size(); ++m2) {
                    TrackShortcut sc = (TrackShortcut)this.mShortcutsArray.elementAt(m2);
                    if (inr >= sc.startPoints[1] && inr < sc.startPoints[2] && sc.startSide == 1) {
                        dtx = 64.0f / (float)(sc.startPoints[2] - sc.startPoints[1]);
                        dtnr = inr - sc.startPoints[1];
                        txtMode = 1;
                        break;
                    }
                    if (inr < sc.endPoints[1] || inr >= sc.endPoints[2] || sc.startSide != 1) continue;
                    dtx = 64.0f / (float)(sc.endPoints[2] - sc.endPoints[1]);
                    dtnr = inr - sc.endPoints[1];
                    txtMode = 1;
                    break;
                }
                txtMode = 0;
                switch (txtMode) {
                    case 0: {
                        for (m2 = 0; m2 < 8; ++m2) {
                            this.mscRightSideCoordinates[i][j2 * sqpc * sqpr * 8 + m2] = (short)TXT_TILES_COORDINATES[this.rightSideTextureNr[inr]][m2];
                        }
                        break;
                    }
                    case 1: {
                        this.mscRightSideCoordinates[i][j2 * sqpc * sqpr * 8 + 0] = (short)((float)TXT_TILES_COORDINATES[0][4] + (float)dtnr * dtx);
                        this.mscRightSideCoordinates[i][j2 * sqpc * sqpr * 8 + 1] = (short)TXT_TILES_COORDINATES[0][5];
                        this.mscRightSideCoordinates[i][j2 * sqpc * sqpr * 8 + 2] = (short)((float)TXT_TILES_COORDINATES[0][0] + (float)dtnr * dtx);
                        this.mscRightSideCoordinates[i][j2 * sqpc * sqpr * 8 + 3] = (short)TXT_TILES_COORDINATES[0][1];
                        this.mscRightSideCoordinates[i][j2 * sqpc * sqpr * 8 + 4] = (short)((float)TXT_TILES_COORDINATES[0][4] + (float)(dtnr + 1) * dtx);
                        this.mscRightSideCoordinates[i][j2 * sqpc * sqpr * 8 + 5] = (short)TXT_TILES_COORDINATES[0][7];
                        this.mscRightSideCoordinates[i][j2 * sqpc * sqpr * 8 + 6] = (short)((float)TXT_TILES_COORDINATES[0][0] + (float)(dtnr + 1) * dtx);
                        this.mscRightSideCoordinates[i][j2 * sqpc * sqpr * 8 + 7] = (short)TXT_TILES_COORDINATES[0][3];
                    }
                }
                this.splitMainQuadCoordinates(this.mscRightSideCoordinates, i, j2, sqpc, sqpr);
            }
        }
        vIndex = 0;
        for (i = 0; i < this.numBasePoints; ++i) {
            for (k = 0; k < this.numInterpolationSteps; ++k) {
                skipThisQuad = false;
                for (j = 0; j < 12; ++j) {
                    if (j == 0) {
                        for (int l = 0; l < this.mShortcutsArray.size(); ++l) {
                            TrackShortcut sc = (TrackShortcut)this.mShortcutsArray.elementAt(l);
                            if ((vIndex < sc.startPoints[0] * 3 * 2 || vIndex >= sc.startPoints[3] * 3 * 2 || sc.startSide != 0) && (vIndex < sc.endPoints[0] * 3 * 2 || vIndex >= sc.endPoints[3] * 3 * 2 || sc.endSide != 0)) continue;
                            skipThisQuad = true;
                            break;
                        }
                    }
                    if (vIndex + j > this.leftWallVertices.length - 1) {
                        vIndex = -j;
                    }
                    this.mscLeftWallVertices[i][k * wqpc * wqpr * 12 + j] = !skipThisQuad ? this.leftWallVertices[vIndex + j] : 0;
                }
                vIndex += 6;
                this.splitMainQuadVertices(this.mscLeftWallVertices, i, k, wqpc, wqpr);
            }
            for (j2 = 0; j2 < this.numInterpolationSteps; ++j2) {
                for (m = 0; m < 8; ++m) {
                    this.mscLeftWallCoordinates[i][j2 * wqpc * wqpr * 8 + m] = (short)TXT_TILES_COORDINATES[7][m];
                }
                this.splitMainQuadCoordinates(this.mscLeftWallCoordinates, i, j2, wqpc, wqpr);
            }
        }
        vIndex = 0;
        for (i = 0; i < this.numBasePoints; ++i) {
            for (k = 0; k < this.numInterpolationSteps; ++k) {
                skipThisQuad = false;
                for (j = 0; j < 12; ++j) {
                    if (j == 0) {
                        for (int l = 0; l < this.mShortcutsArray.size(); ++l) {
                            TrackShortcut sc = (TrackShortcut)this.mShortcutsArray.elementAt(l);
                            if ((vIndex < sc.startPoints[0] * 3 * 2 || vIndex >= sc.startPoints[3] * 3 * 2 || sc.startSide != 1) && (vIndex < sc.endPoints[0] * 3 * 2 || vIndex >= sc.endPoints[3] * 3 * 2 || sc.endSide != 1)) continue;
                            skipThisQuad = true;
                            break;
                        }
                    }
                    if (vIndex + j > this.rightWallVertices.length - 1) {
                        vIndex = -j;
                    }
                    this.mscRightWallVertices[i][k * wqpc * wqpr * 12 + j] = !skipThisQuad ? this.rightWallVertices[vIndex + j] : 0;
                }
                vIndex += 6;
                this.splitMainQuadVertices(this.mscRightWallVertices, i, k, wqpc, wqpr);
            }
            for (j2 = 0; j2 < this.numInterpolationSteps; ++j2) {
                for (m = 0; m < 8; ++m) {
                    this.mscRightWallCoordinates[i][j2 * wqpc * wqpr * 8 + m] = (short)TXT_TILES_COORDINATES[7][m];
                }
                this.splitMainQuadCoordinates(this.mscRightWallCoordinates, i, j2, wqpc, wqpr);
            }
        }
    }

    private void splitMainQuadVertices(int[][] vertices, int i, int k, int mqpc, int mqpr) {
        int x = vertices[i][k * mqpc * mqpr * 12 + 6];
        int y = vertices[i][k * mqpc * mqpr * 12 + 7];
        int z = vertices[i][k * mqpc * mqpr * 12 + 8];
        vertices[i][k * mqpc * mqpr * 12 + 6] = vertices[i][k * mqpc * mqpr * 12 + 9];
        vertices[i][k * mqpc * mqpr * 12 + 7] = vertices[i][k * mqpc * mqpr * 12 + 10];
        vertices[i][k * mqpc * mqpr * 12 + 8] = vertices[i][k * mqpc * mqpr * 12 + 11];
        vertices[i][k * mqpc * mqpr * 12 + 9] = x;
        vertices[i][k * mqpc * mqpr * 12 + 10] = y;
        vertices[i][k * mqpc * mqpr * 12 + 11] = z;
        this.v1.set(vertices[i][k * mqpc * mqpr * 12 + 0], vertices[i][k * mqpc * mqpr * 12 + 1], vertices[i][k * mqpc * mqpr * 12 + 2]);
        this.v2.set(vertices[i][k * mqpc * mqpr * 12 + 3], vertices[i][k * mqpc * mqpr * 12 + 4], vertices[i][k * mqpc * mqpr * 12 + 5]);
        this.v3.set(vertices[i][k * mqpc * mqpr * 12 + 6], vertices[i][k * mqpc * mqpr * 12 + 7], vertices[i][k * mqpc * mqpr * 12 + 8]);
        this.v4.set(vertices[i][k * mqpc * mqpr * 12 + 9], vertices[i][k * mqpc * mqpr * 12 + 10], vertices[i][k * mqpc * mqpr * 12 + 11]);
        this.vcd1 = Vector3D.sub(this.v4, this.v1);
        this.vcd1.scalarDiv(mqpc);
        this.vcd2 = Vector3D.sub(this.v3, this.v2);
        this.vcd2.scalarDiv(mqpc);
        for (int m = 0; m < mqpc; ++m) {
            this.vb1 = Vector3D.add(this.v1, Vector3D.scalarMul(m, this.vcd1));
            this.vb2 = Vector3D.add(this.v2, Vector3D.scalarMul(m, this.vcd2));
            this.vb3 = Vector3D.add(this.v2, Vector3D.scalarMul(m + 1, this.vcd2));
            this.vb4 = Vector3D.add(this.v1, Vector3D.scalarMul(m + 1, this.vcd1));
            this.vrd1 = Vector3D.sub(this.vb2, this.vb1);
            this.vrd1.scalarDiv(mqpr);
            this.vrd2 = Vector3D.sub(this.vb3, this.vb4);
            this.vrd2.scalarDiv(mqpr);
            for (int j = 0; j < mqpr; ++j) {
                Vector3D vt1 = Vector3D.add(this.vb1, Vector3D.scalarMul(j, this.vrd1));
                Vector3D vt2 = Vector3D.add(this.vb4, Vector3D.scalarMul(j, this.vrd2));
                vertices[i][k * mqpc * mqpr * 12 + m * mqpr * 12 + j * 12 + 0] = (int)vt1.getx();
                vertices[i][k * mqpc * mqpr * 12 + m * mqpr * 12 + j * 12 + 1] = (int)vt1.gety();
                vertices[i][k * mqpc * mqpr * 12 + m * mqpr * 12 + j * 12 + 2] = (int)vt1.getz();
                vertices[i][k * mqpc * mqpr * 12 + m * mqpr * 12 + j * 12 + 9] = (int)vt2.getx();
                vertices[i][k * mqpc * mqpr * 12 + m * mqpr * 12 + j * 12 + 10] = (int)vt2.gety();
                vertices[i][k * mqpc * mqpr * 12 + m * mqpr * 12 + j * 12 + 11] = (int)vt2.getz();
                vt1 = Vector3D.add(this.vb1, Vector3D.scalarMul(j + 1, this.vrd1));
                vt2 = Vector3D.add(this.vb4, Vector3D.scalarMul(j + 1, this.vrd2));
                vertices[i][k * mqpc * mqpr * 12 + m * mqpr * 12 + j * 12 + 3] = (int)vt1.getx();
                vertices[i][k * mqpc * mqpr * 12 + m * mqpr * 12 + j * 12 + 4] = (int)vt1.gety();
                vertices[i][k * mqpc * mqpr * 12 + m * mqpr * 12 + j * 12 + 5] = (int)vt1.getz();
                vertices[i][k * mqpc * mqpr * 12 + m * mqpr * 12 + j * 12 + 6] = (int)vt2.getx();
                vertices[i][k * mqpc * mqpr * 12 + m * mqpr * 12 + j * 12 + 7] = (int)vt2.gety();
                vertices[i][k * mqpc * mqpr * 12 + m * mqpr * 12 + j * 12 + 8] = (int)vt2.getz();
            }
        }
    }

    private void splitMainQuadCoordinates(int[][] coordinates, int i, int j, int mqpc, int mqpr) {
        int tx = coordinates[i][j * mqpc * mqpr * 8 + 4];
        int ty = coordinates[i][j * mqpc * mqpr * 8 + 5];
        coordinates[i][j * mqpc * mqpr * 8 + 4] = coordinates[i][j * mqpc * mqpr * 8 + 6];
        coordinates[i][j * mqpc * mqpr * 8 + 5] = coordinates[i][j * mqpc * mqpr * 8 + 7];
        coordinates[i][j * mqpc * mqpr * 8 + 6] = tx;
        coordinates[i][j * mqpc * mqpr * 8 + 7] = ty;
        this.v1.set(coordinates[i][j * mqpc * mqpr * 8 + 0], coordinates[i][j * mqpc * mqpr * 8 + 1], 0.0f);
        this.v2.set(coordinates[i][j * mqpc * mqpr * 8 + 2], coordinates[i][j * mqpc * mqpr * 8 + 3], 0.0f);
        this.v3.set(coordinates[i][j * mqpc * mqpr * 8 + 4], coordinates[i][j * mqpc * mqpr * 8 + 5], 0.0f);
        this.v4.set(coordinates[i][j * mqpc * mqpr * 8 + 6], coordinates[i][j * mqpc * mqpr * 8 + 7], 0.0f);
        this.vcd1 = Vector3D.sub(this.v4, this.v1);
        this.vcd1.scalarDiv(mqpc);
        this.vcd2 = Vector3D.sub(this.v3, this.v2);
        this.vcd2.scalarDiv(mqpc);
        for (int m = 0; m < mqpc; ++m) {
            this.vb1 = Vector3D.add(this.v1, Vector3D.scalarMul(m, this.vcd1));
            this.vb2 = Vector3D.add(this.v2, Vector3D.scalarMul(m, this.vcd2));
            this.vb3 = Vector3D.add(this.v2, Vector3D.scalarMul(m + 1, this.vcd2));
            this.vb4 = Vector3D.add(this.v1, Vector3D.scalarMul(m + 1, this.vcd1));
            this.vrd1 = Vector3D.sub(this.vb2, this.vb1);
            this.vrd1.scalarDiv(mqpr);
            this.vrd2 = Vector3D.sub(this.vb3, this.vb4);
            this.vrd2.scalarDiv(mqpr);
            for (int k = 0; k < mqpr; ++k) {
                Vector3D vt1 = Vector3D.add(this.vb1, Vector3D.scalarMul(k, this.vrd1));
                Vector3D vt2 = Vector3D.add(this.vb4, Vector3D.scalarMul(k, this.vrd2));
                coordinates[i][j * mqpc * mqpr * 8 + m * mqpr * 8 + k * 8 + 0] = (int)vt1.getx();
                coordinates[i][j * mqpc * mqpr * 8 + m * mqpr * 8 + k * 8 + 1] = (int)vt1.gety();
                coordinates[i][j * mqpc * mqpr * 8 + m * mqpr * 8 + k * 8 + 6] = (int)vt2.getx();
                coordinates[i][j * mqpc * mqpr * 8 + m * mqpr * 8 + k * 8 + 7] = (int)vt2.gety();
                vt1 = Vector3D.add(this.vb1, Vector3D.scalarMul(k + 1, this.vrd1));
                vt2 = Vector3D.add(this.vb4, Vector3D.scalarMul(k + 1, this.vrd2));
                coordinates[i][j * mqpc * mqpr * 8 + m * mqpr * 8 + k * 8 + 2] = (int)vt1.getx();
                coordinates[i][j * mqpc * mqpr * 8 + m * mqpr * 8 + k * 8 + 3] = (int)vt1.gety();
                coordinates[i][j * mqpc * mqpr * 8 + m * mqpr * 8 + k * 8 + 4] = (int)vt2.getx();
                coordinates[i][j * mqpc * mqpr * 8 + m * mqpr * 8 + k * 8 + 5] = (int)vt2.gety();
            }
        }
    }

    public void renderMainRoad(Graphics3D g3d, int[][] nearestPoint) {
        int currSegNr = nearestPoint[0][0] / this.numInterpolationSteps;
        int prevSegNr = currSegNr - 1;
        int prevPrevSegNr = prevSegNr - 1;
        int nextSegNr = currSegNr + 1;
        int nextNextSegNr = nextSegNr + 1;
        if (prevSegNr < 0) {
            prevSegNr = this.numBasePoints + prevSegNr;
        }
        if (nextSegNr > this.numBasePoints - 1) {
            nextSegNr -= this.numBasePoints;
        }
        if (prevPrevSegNr < 0) {
            prevPrevSegNr = this.numBasePoints + prevPrevSegNr;
        }
        if (nextNextSegNr > this.numBasePoints - 1) {
            nextNextSegNr -= this.numBasePoints;
        }
        if (nearestPoint[0][1] == 0) {
            int command = 67121168;
            int[] normals = new int[]{};
            int[] colors = new int[]{};
            int mqpr = 3;
            int mqpc = 3;
            int sqpr = 2;
            int sqpc = 2;
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * mqpr * mqpc, this.mscRoadVertices[prevSegNr], normals, this.mscRoadCoordinates[prevSegNr], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * mqpr * mqpc, this.mscRoadVertices[currSegNr], normals, this.mscRoadCoordinates[currSegNr], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * mqpr * mqpc, this.mscRoadVertices[nextSegNr], normals, this.mscRoadCoordinates[nextSegNr], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * mqpr * mqpc, this.mscRoadVertices[nextNextSegNr], normals, this.mscRoadCoordinates[nextNextSegNr], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * sqpc * sqpr, this.mscLeftSideVertices[prevSegNr], normals, this.mscLeftSideCoordinates[prevSegNr], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * sqpc * sqpr, this.mscLeftSideVertices[currSegNr], normals, this.mscLeftSideCoordinates[currSegNr], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * sqpc * sqpr, this.mscLeftSideVertices[nextSegNr], normals, this.mscLeftSideCoordinates[nextSegNr], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * sqpc * sqpr, this.mscLeftSideVertices[nextNextSegNr], normals, this.mscLeftSideCoordinates[nextNextSegNr], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * sqpc * sqpr, this.mscRightSideVertices[prevSegNr], normals, this.mscRightSideCoordinates[prevSegNr], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * sqpc * sqpr, this.mscRightSideVertices[currSegNr], normals, this.mscRightSideCoordinates[currSegNr], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * sqpc * sqpr, this.mscRightSideVertices[nextSegNr], normals, this.mscRightSideCoordinates[nextSegNr], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * sqpc * sqpr, this.mscRightSideVertices[nextNextSegNr], normals, this.mscRightSideCoordinates[nextNextSegNr], colors);
        } else {
            TrackShortcut sc = (TrackShortcut)this.mShortcutsArray.elementAt(nearestPoint[0][1] - 1);
            currSegNr = sc.startPoints[1] / this.numInterpolationSteps;
            int command = 67121168;
            int[] normals = new int[]{};
            int[] colors = new int[]{};
            int mqpr = 3;
            int mqpc = 3;
            int sqpr = 2;
            int sqpc = 2;
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * mqpc * mqpr, this.mscRoadVertices[currSegNr - 1], normals, this.mscRoadCoordinates[currSegNr - 1], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * mqpc * mqpr, this.mscRoadVertices[currSegNr], normals, this.mscRoadCoordinates[currSegNr], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * mqpc * mqpr, this.mscRoadVertices[currSegNr + 1], normals, this.mscRoadCoordinates[currSegNr + 1], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * sqpc * sqpr, this.mscLeftSideVertices[currSegNr - 1], normals, this.mscLeftSideCoordinates[currSegNr - 1], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * sqpc * sqpr, this.mscLeftSideVertices[currSegNr], normals, this.mscLeftSideCoordinates[currSegNr], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * sqpc * sqpr, this.mscLeftSideVertices[currSegNr + 1], normals, this.mscLeftSideCoordinates[currSegNr + 1], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * sqpc * sqpr, this.mscRightSideVertices[currSegNr - 1], normals, this.mscRightSideCoordinates[currSegNr - 1], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * sqpc * sqpr, this.mscRightSideVertices[currSegNr], normals, this.mscRightSideCoordinates[currSegNr], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * sqpc * sqpr, this.mscRightSideVertices[currSegNr + 1], normals, this.mscRightSideCoordinates[currSegNr + 1], colors);
            currSegNr = sc.endPoints[1] / this.numInterpolationSteps;
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * mqpc * mqpr, this.mscRoadVertices[currSegNr - 1], normals, this.mscRoadCoordinates[currSegNr - 1], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * mqpc * mqpr, this.mscRoadVertices[currSegNr], normals, this.mscRoadCoordinates[currSegNr], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * mqpc * mqpr, this.mscRoadVertices[currSegNr + 1], normals, this.mscRoadCoordinates[currSegNr + 1], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * sqpc * sqpr, this.mscLeftSideVertices[currSegNr - 1], normals, this.mscLeftSideCoordinates[currSegNr - 1], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * sqpc * sqpr, this.mscLeftSideVertices[currSegNr], normals, this.mscLeftSideCoordinates[currSegNr], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * sqpc * sqpr, this.mscLeftSideVertices[currSegNr + 1], normals, this.mscLeftSideCoordinates[currSegNr + 1], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * sqpc * sqpr, this.mscRightSideVertices[currSegNr - 1], normals, this.mscRightSideCoordinates[currSegNr - 1], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * sqpc * sqpr, this.mscRightSideVertices[currSegNr], normals, this.mscRightSideCoordinates[currSegNr], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * sqpc * sqpr, this.mscRightSideVertices[currSegNr + 1], normals, this.mscRightSideCoordinates[currSegNr + 1], colors);
        }
    }

    public void renderShortcut(Graphics3D g3d, int[][] nearestPoint) {
        int mqpr = 3;
        int mqpc = 3;
        int sqpr = 2;
        int sqpc = 2;
        int wqpr = 2;
        int wqpc = 2;
        if (this.mShortcutsArray.size() > 0) {
            for (int j = 0; j < this.mShortcutsArray.size(); ++j) {
                TrackShortcut sc = (TrackShortcut)this.mShortcutsArray.elementAt(j);
                if (nearestPoint[0][1] != 0) {
                    if (nearestPoint[0][1] - 1 != j) continue;
                    for (int i = 0; i < sc.mscRoadVertices.length; ++i) {
                        int command = 67121168;
                        int[] normals = new int[]{};
                        int[] colors = new int[]{};
                        g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, sc.numInterpolationSteps * mqpc * mqpr, sc.mscRoadVertices[i], normals, sc.mscRoadCoordinates[i], colors);
                        g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, sc.numInterpolationSteps * sqpc * sqpr, sc.mscLeftSideVertices[i], normals, sc.mscLeftSideCoordinates[i], colors);
                        g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, sc.numInterpolationSteps * sqpc * sqpr, sc.mscRightSideVertices[i], normals, sc.mscRightSideCoordinates[i], colors);
                        g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, sc.numInterpolationSteps * wqpc * wqpr, sc.mscLeftWallVertices[i], normals, sc.mscLeftWallCoordinates[i], colors);
                        g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, sc.numInterpolationSteps * wqpc * wqpr, sc.mscRightWallVertices[i], normals, sc.mscRightWallCoordinates[i], colors);
                    }
                    continue;
                }
                int d1 = Math.abs(nearestPoint[0][0] - sc.startPoints[0]);
                int d2 = Math.abs(nearestPoint[0][0] - sc.startPoints[3]);
                int tolerance = 10;
                if (d1 < tolerance || d2 < tolerance) {
                    int command = 67121168;
                    int[] normals = new int[]{};
                    int[] colors = new int[]{};
                    g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, sc.numInterpolationSteps * mqpc * mqpr, sc.mscRoadVertices[0], normals, sc.mscRoadCoordinates[0], colors);
                    g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, sc.numInterpolationSteps * sqpc * sqpr, sc.mscLeftSideVertices[0], normals, sc.mscLeftSideCoordinates[0], colors);
                    g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, sc.numInterpolationSteps * sqpc * sqpr, sc.mscRightSideVertices[0], normals, sc.mscRightSideCoordinates[0], colors);
                    g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, sc.numInterpolationSteps * wqpc * wqpr, sc.mscLeftWallVertices[0], normals, sc.mscLeftWallCoordinates[0], colors);
                    g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, sc.numInterpolationSteps * wqpc * wqpr, sc.mscRightWallVertices[0], normals, sc.mscRightWallCoordinates[0], colors);
                    continue;
                }
                int d3 = Math.abs(nearestPoint[0][0] - sc.endPoints[0]);
                int d4 = Math.abs(nearestPoint[0][0] - sc.endPoints[3]);
                if (d3 >= tolerance && d4 >= tolerance) continue;
                int command = 67121168;
                int[] normals = new int[]{};
                int[] colors = new int[]{};
                g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, sc.numInterpolationSteps * mqpc * mqpr, sc.mscRoadVertices[sc.mscRoadVertices.length - 1], normals, sc.mscRoadCoordinates[sc.mscRoadVertices.length - 1], colors);
                g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, sc.numInterpolationSteps * sqpc * sqpr, sc.mscLeftSideVertices[sc.mscRoadVertices.length - 1], normals, sc.mscLeftSideCoordinates[sc.mscRoadVertices.length - 1], colors);
                g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, sc.numInterpolationSteps * wqpc * wqpr, sc.mscRightSideVertices[sc.mscRoadVertices.length - 1], normals, sc.mscRightSideCoordinates[sc.mscRoadVertices.length - 1], colors);
                g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, sc.numInterpolationSteps * wqpc * wqpr, sc.mscLeftWallVertices[sc.mscRoadVertices.length - 1], normals, sc.mscLeftWallCoordinates[sc.mscRoadVertices.length - 1], colors);
                g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, sc.numInterpolationSteps * wqpc * wqpr, sc.mscRightWallVertices[sc.mscRoadVertices.length - 1], normals, sc.mscRightWallCoordinates[sc.mscRoadVertices.length - 1], colors);
            }
        }
    }

    public void renderRoadWalls(Graphics3D g3d, int[][] nearestPoint) {
        int currSegNr = nearestPoint[0][0] / this.numInterpolationSteps;
        int prevSegNr = currSegNr - 1;
        int prevPrevSegNr = prevSegNr - 1;
        int nextSegNr = currSegNr + 1;
        int nextNextSegNr = nextSegNr + 1;
        if (prevSegNr < 0) {
            prevSegNr = this.numBasePoints + prevSegNr;
        }
        if (nextSegNr > this.numBasePoints - 1) {
            nextSegNr -= this.numBasePoints;
        }
        if (prevPrevSegNr < 0) {
            prevPrevSegNr = this.numBasePoints + prevPrevSegNr;
        }
        if (nextNextSegNr > this.numBasePoints - 1) {
            nextNextSegNr -= this.numBasePoints;
        }
        if (nearestPoint[0][1] == 0) {
            int command = 67121168;
            int[] normals = new int[]{};
            int[] colors = new int[]{};
            int wqpr = 2;
            int wqpc = 2;
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * wqpc * wqpr, this.mscLeftWallVertices[prevSegNr], normals, this.mscLeftWallCoordinates[prevSegNr], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * wqpc * wqpr, this.mscLeftWallVertices[currSegNr], normals, this.mscLeftWallCoordinates[currSegNr], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * wqpc * wqpr, this.mscLeftWallVertices[nextSegNr], normals, this.mscLeftWallCoordinates[nextSegNr], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * wqpc * wqpr, this.mscLeftWallVertices[nextNextSegNr], normals, this.mscLeftWallCoordinates[nextNextSegNr], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * wqpc * wqpr, this.mscRightWallVertices[prevSegNr], normals, this.mscRightWallCoordinates[prevSegNr], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * wqpc * wqpr, this.mscRightWallVertices[currSegNr], normals, this.mscRightWallCoordinates[currSegNr], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * wqpc * wqpr, this.mscRightWallVertices[nextSegNr], normals, this.mscRightWallCoordinates[nextSegNr], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * wqpc * wqpr, this.mscRightWallVertices[nextNextSegNr], normals, this.mscRightWallCoordinates[nextNextSegNr], colors);
        } else {
            TrackShortcut sc = (TrackShortcut)this.mShortcutsArray.elementAt(nearestPoint[0][1] - 1);
            currSegNr = sc.startPoints[1] / this.numInterpolationSteps;
            int command = 67121168;
            int[] normals = new int[]{};
            int[] colors = new int[]{};
            int wqpr = 2;
            int wqpc = 2;
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * wqpc * wqpr, this.mscLeftWallVertices[currSegNr], normals, this.mscLeftWallCoordinates[currSegNr], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * wqpc * wqpr, this.mscLeftWallVertices[currSegNr - 1], normals, this.mscLeftWallCoordinates[currSegNr - 1], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * wqpc * wqpr, this.mscRightWallVertices[currSegNr], normals, this.mscRightWallCoordinates[currSegNr], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * wqpc * wqpr, this.mscRightWallVertices[currSegNr - 1], normals, this.mscRightWallCoordinates[currSegNr - 1], colors);
            currSegNr = sc.endPoints[1] / this.numInterpolationSteps;
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * wqpc * wqpr, this.mscLeftWallVertices[currSegNr], normals, this.mscLeftWallCoordinates[currSegNr], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * wqpc * wqpr, this.mscLeftWallVertices[currSegNr - 1], normals, this.mscLeftWallCoordinates[currSegNr - 1], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * wqpc * wqpr, this.mscRightWallVertices[currSegNr], normals, this.mscRightWallCoordinates[currSegNr], colors);
            g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, this.numInterpolationSteps * wqpc * wqpr, this.mscRightWallVertices[currSegNr - 1], normals, this.mscRightWallCoordinates[currSegNr - 1], colors);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

