/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public class TranslatedList
extends List
implements CommandListener {
    Dictionary dictionary;
    TranslatedWord[] words;
    TranslatedWord[] wordsByTime;
    TranslatedWord[] wordsByFreq;

    TranslatedList(Dictionary dictionary) {
        super("\u0418\u0441\u0442\u043e\u0440\u0438\u044f", 3);
        int n;
        this.dictionary = dictionary;
        this.wordsByTime = new TranslatedWord[dictionary.translatedWords.size()];
        int[] nArray = new int[256];
        int n2 = this.wordsByTime.length;
        for (n = 0; n < n2; ++n) {
            TranslatedWord translatedWord = (TranslatedWord)dictionary.translatedWords.elementAt(n);
            this.append(translatedWord.word, null);
            int n3 = translatedWord.frequency;
            nArray[n3] = nArray[n3] + 1;
            this.wordsByTime[n] = translatedWord;
        }
        n = 0;
        int n4 = nArray.length;
        while (--n4 >= 0) {
            int n5 = nArray[n4];
            nArray[n4] = n;
            n += n5;
        }
        this.words = this.wordsByTime;
        this.wordsByFreq = new TranslatedWord[n2];
        for (n4 = 0; n4 < n2; ++n4) {
            int n6 = this.words[n4].frequency;
            int n7 = nArray[n6];
            nArray[n6] = n7 + 1;
            this.wordsByFreq[n7] = this.words[n4];
        }
        this.setCommandListener(this);
        this.addCommand(Dictionary.BACK_CMD);
        this.addCommand(Dictionary.ORDER_BY_FREQUENCY_CMD);
        Display.getDisplay((MIDlet)dictionary).setCurrent((Displayable)this);
    }

    private void resetList() {
        int n = this.words.length;
        for (int i = 0; i < n; ++i) {
            this.set(i, this.words[i].word, null);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == Dictionary.BACK_CMD) {
            Display.getDisplay((MIDlet)this.dictionary).setCurrent((Displayable)this.dictionary.mainMenu);
        } else if (command == Dictionary.ORDER_BY_FREQUENCY_CMD) {
            this.removeCommand(Dictionary.ORDER_BY_FREQUENCY_CMD);
            this.addCommand(Dictionary.ORDER_BY_TIME_CMD);
            this.words = this.wordsByFreq;
            this.resetList();
        } else if (command == Dictionary.ORDER_BY_TIME_CMD) {
            this.addCommand(Dictionary.ORDER_BY_FREQUENCY_CMD);
            this.removeCommand(Dictionary.ORDER_BY_TIME_CMD);
            this.words = this.wordsByTime;
            this.resetList();
        } else {
            int n = this.getSelectedIndex();
            if (n >= 0) {
                Vector vector = this.dictionary.getSelection(this.words[n].word);
                new TranslationBox(this.dictionary, (Displayable)this, (Translation)vector.elementAt(0));
            }
        }
    }
}

