/*
 * Decompiled with CFR 0.152.
 */
package com.wordsteps.ui.screen;

import com.wordsteps.model.Language;

class LanguagePair {
    private Language src;
    private Language dst;
    private int count = 0;

    public LanguagePair(Language src, Language dst) {
        this.src = src;
        this.dst = dst;
    }

    public LanguagePair(Language src, Language dst, int count) {
        this.src = src;
        this.dst = dst;
        this.count = count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int count() {
        return this.count;
    }

    public void countPlus() {
        ++this.count;
    }

    public void countMinus() {
        --this.count;
    }

    public Language getSourceLanguage() {
        return this.src;
    }

    public Language getTargetLanguage() {
        return this.dst;
    }

    public int hashCode() {
        int code = 0;
        if (this.src != null) {
            code += this.src.hashCode();
        }
        if (this.dst != null) {
            code += this.dst.hashCode();
        }
        return code;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        LanguagePair pair = (LanguagePair)obj;
        return this.src.equals(pair.src) && this.dst.equals(pair.dst);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{ src = ").append(this.src != null ? this.src.getName() : "null").append(", dst = ").append(this.dst != null ? this.dst.getName() : "null").append(", count = " + this.count).append(" }");
        return buf.toString();
    }
}

