/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.html;

import com.sun.lwuit.Button;
import com.sun.lwuit.CheckBox;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Form;
import com.sun.lwuit.Label;
import com.sun.lwuit.List;
import com.sun.lwuit.RadioButton;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.TextField;
import com.sun.lwuit.animations.Motion;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.html.CSSElement;
import com.sun.lwuit.html.CSSEngine;
import com.sun.lwuit.html.CSSParser;
import com.sun.lwuit.html.CellConstraint;
import com.sun.lwuit.html.DocumentInfo;
import com.sun.lwuit.html.DocumentRequestHandler;
import com.sun.lwuit.html.ForLabel;
import com.sun.lwuit.html.HTMLBullet;
import com.sun.lwuit.html.HTMLCallback;
import com.sun.lwuit.html.HTMLComboBox;
import com.sun.lwuit.html.HTMLElement;
import com.sun.lwuit.html.HTMLFont;
import com.sun.lwuit.html.HTMLForm;
import com.sun.lwuit.html.HTMLInputFormat;
import com.sun.lwuit.html.HTMLLink;
import com.sun.lwuit.html.HTMLListIndex;
import com.sun.lwuit.html.HTMLListItem;
import com.sun.lwuit.html.HTMLParser;
import com.sun.lwuit.html.HTMLTable;
import com.sun.lwuit.html.HTMLTableModel;
import com.sun.lwuit.html.MultiComboBox;
import com.sun.lwuit.html.OptionItem;
import com.sun.lwuit.html.RedirectThread;
import com.sun.lwuit.html.ResourceThreadQueue;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.FlowLayout;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class HTMLComponent
extends Container
implements ActionListener {
    static final boolean FIXED_WIDTH = false;
    static final boolean SUPPORT_INPUT_FORMAT = true;
    static final boolean SUPPORT_CSS = true;
    private static final boolean CLEAN_ON_PAGE_REQUEST = true;
    private static final boolean CJK_SUPPORT = true;
    static final boolean TABLES_LOCK_SIZE = true;
    private static final int INDENT_BLOCKQUOTE = 20;
    private static final int INDENT_DD = 20;
    private static final int INDENT_OL = 15;
    private static final int INDENT_UL = 15;
    private static final int MIN_MULTI_COMBOBOX_ITEMS = 4;
    private static final int MAX_MULTI_COMBOBOX_ITEMS = 6;
    private static final int DEFAULT_TEXTFIELD_SIZE = 12;
    private static final int DEFAULT_TEXTAREA_COLS = 20;
    private static final int DEFAULT_TEXTAREA_ROWS = 2;
    static final int JUSTIFY = 5;
    private static final int HR_THICKNESS = 3;
    private static final int MARQUEE_DELAY = 6000;
    private static final boolean MATCH_EXACT_FONTS_ONLY = false;
    private static final boolean MATCH_BITMAP_FONTS_ONLY = true;
    private static final boolean MATCH_SAME_FONT_FAMILY_ONLY = true;
    private static HTMLFont DEFAULT_FONT = new HTMLFont(null, Font.createSystemFont(0, 0, 0));
    private static final int COLOR_VISITED_LINKS = 0x990099;
    static Hashtable fonts = new Hashtable();
    private static final int INPUT_CHECKBOX = 0;
    private static final int INPUT_HIDDEN = 1;
    private static final int INPUT_PASSWORD = 2;
    private static final int INPUT_RADIO = 3;
    private static final int INPUT_RESET = 4;
    private static final int INPUT_SUBMIT = 5;
    private static final int INPUT_TEXT = 6;
    private static final int INPUT_IMAGE = 7;
    private static String[] INPUT_TYPE_STRINGS = new String[]{"checkbox", "hidden", "password", "radio", "reset", "submit", "text", "image"};
    private static Vector INPUT_TYPES = new Vector();
    private static final char[] ORDERED_LIST_TYPE_IDENTIFIERS = new char[]{'1', 'A', 'a', 'I', 'i'};
    boolean loadCSS = true;
    HTMLParser parser;
    int contCount = 0;
    private Vector embeddedCSS;
    private Vector externalCSS;
    static final int DEFAULT_BGCOLOR = 0xFFFFFF;
    static final int DEFAULT_TEXT_COLOR = 0;
    private static final int DEFAULT_LINK_COLOR = 255;
    private int bgColor = 0xFFFFFF;
    private int textColor = 0;
    private int linkColor = 255;
    private DocumentRequestHandler handler;
    private RedirectThread redirectThread;
    private ResourceThreadQueue threadQueue;
    private HTMLCallback htmlCallback;
    private DocumentInfo docInfo;
    private HTMLElement document;
    private String pageURL;
    private int pageStatus = -3;
    private boolean pageError;
    private String title;
    private int displayWidth;
    private boolean cancelled;
    private boolean cancelledCaught;
    boolean showImages = true;
    private Style pageStyle;
    private Hashtable accessKeys = new Hashtable();
    private Hashtable anchors;
    private Hashtable inputFields;
    Component firstFocusable;
    private HTMLFont defaultFont = DEFAULT_FONT;
    private Container mainContainer;
    private Container curContainer;
    private Container curLine;
    private int x;
    private int width;
    private int leftIndent;
    private boolean lastWasEmpty;
    private HTMLFont font;
    private String link;
    private HTMLLink mainLink;
    private char accesskey = '\u0000';
    private String anchor;
    private boolean linkVisited;
    private HTMLForm curForm;
    private TextArea curTextArea;
    private List curComboBox;
    private boolean optionTag;
    private boolean optionSelected;
    private String optionValue;
    private Hashtable textfieldsToForms;
    private int ulLevel;
    private int olIndex;
    private Vector olUpperLevelIndex;
    private int listType;
    private int listIndent;
    private Vector tables;
    private Vector tableCells;
    HTMLTableModel curTable;
    private Vector fieldsets;
    private int preTagCount = 0;
    private int quoteTagCount = 0;
    private String labelForID;
    private Vector containers = new Vector();
    Vector marqueeComponents = new Vector();
    private Motion marqueeMotion;

    public static void addFont(String fontKey, Font font) {
        if (fontKey != null) {
            fontKey = fontKey.toLowerCase();
        } else if (font.getCharset() != null) {
            throw new IllegalArgumentException("Font key must be non-null for bitmap fonts");
        }
        fonts.put(fontKey, new HTMLFont(fontKey, font));
    }

    public void setParser(HTMLParser parser) {
        this.parser.setParserCallback(null);
        this.parser.setHTMLComponent(null);
        this.parser = parser;
        parser.setHTMLComponent(this);
        parser.setParserCallback(this.htmlCallback);
    }

    public void addCharEntity(String symbol, int code) {
        this.parser.addCharEntity(symbol, code);
    }

    public static void addSpecialKey(String specialKeyName, int specialKeyCode) {
        CSSEngine.addSpecialKey(specialKeyName, specialKeyCode);
    }

    public void addCharEntitiesRange(String[] symbols, int startcode) {
        this.parser.addCharEntitiesRange(symbols, startcode);
    }

    public static void setMaxThreads(int threadsNum) {
        ResourceThreadQueue.setMaxThreads(threadsNum);
    }

    public static void setCSSSupportedMediaTypes(String[] supportedMediaTypes) {
        CSSParser.setCSSSupportedMediaTypes(supportedMediaTypes);
    }

    public HTMLComponent(DocumentRequestHandler handler) {
        this.setLayout(new BorderLayout());
        this.handler = handler;
        this.threadQueue = new ResourceThreadQueue(this);
        this.setHandlesInput(true);
        this.setScrollableY(true);
        this.setScrollableX(false);
        this.setSmoothScrolling(true);
        HTMLFont italic = new HTMLFont(null, Font.createSystemFont(0, 2, 0));
        HTMLFont monospace = new HTMLFont(null, Font.createSystemFont(32, 0, 0));
        fonts.put(HTMLElement.TAG_NAMES[13], italic);
        fonts.put(HTMLElement.TAG_NAMES[26], new HTMLFont(null, Font.createSystemFont(0, 1, 0)));
        fonts.put(HTMLElement.TAG_NAMES[11], italic);
        fonts.put(HTMLElement.TAG_NAMES[10], monospace);
        fonts.put(HTMLElement.TAG_NAMES[24], monospace);
        fonts.put(HTMLElement.TAG_NAMES[20], monospace);
        fonts.put(HTMLElement.TAG_NAMES[27], italic);
        fonts.put(HTMLElement.TAG_NAMES[9], italic);
        fonts.put(HTMLElement.TAG_NAMES[22], monospace);
        fonts.put(HTMLElement.TAG_NAMES[14], new HTMLFont(null, Font.createSystemFont(0, 1, 16)));
        fonts.put(HTMLElement.TAG_NAMES[15], new HTMLFont(null, Font.createSystemFont(0, 2, 16)));
        fonts.put(HTMLElement.TAG_NAMES[16], new HTMLFont(null, Font.createSystemFont(0, 1, 0)));
        this.parser = new HTMLParser();
        this.parser.setHTMLComponent(this);
    }

    public DocumentRequestHandler getRequestHandler() {
        return this.handler;
    }

    public DocumentInfo getDocumentInfo() {
        return this.docInfo;
    }

    public void setHTMLCallback(HTMLCallback callback) {
        this.htmlCallback = callback;
        this.parser.setParserCallback(this.htmlCallback);
        CSSParser.getInstance().setCSSParserCallback(this.htmlCallback);
    }

    public HTMLCallback getHTMLCallback() {
        return this.htmlCallback;
    }

    public void setDefaultFont(String fontKey, Font font) {
        if (fontKey != null) {
            fontKey = fontKey.toLowerCase();
        }
        this.defaultFont = new HTMLFont(fontKey, font);
        if (fontKey != null) {
            fonts.put(fontKey, this.defaultFont);
        }
    }

    public void setShowImages(boolean show) {
        this.showImages = show;
    }

    public void setIgnoreCSS(boolean ignore) {
        this.loadCSS = !ignore;
    }

    public void scrollPixels(int pixels, boolean animate) {
        int scrollToY = this.getScrollY() + pixels;
        this.scrollTo(scrollToY, animate);
    }

    public void scrollPages(int pages, boolean animate) {
        int scrollToY = this.getScrollY() + this.getHeight() * pages;
        this.scrollTo(scrollToY, animate);
    }

    public void scrollToElement(HTMLElement element, boolean animate) {
        if (!this.pageLoading()) {
            Component cmp;
            if (!this.document.contains(element)) {
                throw new IllegalArgumentException("The specified element is not contained in the current document.");
            }
            Vector v = element.getUi();
            if (v != null && v.size() > 0 && (cmp = (Component)v.firstElement()) != null) {
                int y = cmp.getY();
                for (Container parent = cmp.getParent(); parent != null && parent != this; parent = parent.getParent()) {
                    y += parent.getY();
                }
                this.scrollTo(y, animate);
            }
        } else {
            throw new IllegalStateException("Page is still loading");
        }
    }

    private void scrollTo(int y, boolean animate) {
        if (y < 0) {
            y = 0;
        } else if (y > this.getPreferredH() - this.getHeight()) {
            y = this.getPreferredH() - this.getHeight();
        }
        if (animate) {
            this.scrollRectToVisible(this.getX(), y, this.getWidth(), this.getHeight(), this);
        } else {
            this.setScrollY(y);
        }
    }

    public void setBodyText(String htmlText) {
        this.setBodyText(htmlText, null);
    }

    public boolean setBodyText(String htmlText, String encoding) {
        return this.setHTML(htmlText, encoding, null, false);
    }

    public boolean setHTML(String htmlText, String encoding, String title, boolean isFullHTML) {
        boolean success = true;
        InputStreamReader isr = this.getStream(htmlText, encoding, title, isFullHTML);
        if (isr == null) {
            isr = this.getStream("Encoding error loading string", null, title, isFullHTML);
            success = false;
        }
        final InputStreamReader isReader = isr;
        new Thread(){

            public void run() {
                HTMLElement doc = HTMLComponent.this.parser.parseHTML(isReader);
                HTMLComponent.this.documentReady(null, doc);
            }
        }.start();
        return success;
    }

    private InputStreamReader getStream(String htmlText, String encoding) {
        return this.getStream(htmlText, encoding, null, false);
    }

    private InputStreamReader getStream(String htmlText, String encoding, String title, boolean isFullHTML) {
        if (!isFullHTML) {
            String titleStr = "";
            if (title != null) {
                titleStr = "<head><title>" + title + "</title></head>";
            }
            htmlText = "<html>" + titleStr + "<body>" + htmlText + "</body></html>";
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(htmlText.getBytes());
        InputStreamReader isr = null;
        if (encoding != null) {
            try {
                isr = new InputStreamReader((InputStream)bais, encoding);
            }
            catch (UnsupportedEncodingException uee) {
                uee.printStackTrace();
            }
        }
        if (isr == null) {
            isr = new InputStreamReader(bais);
        }
        return isr;
    }

    public void cancel() {
        this.cancelled = true;
        this.cancelRedirectsAndImages();
    }

    void addToExternalCSS(CSSElement cssElement) {
        if (this.externalCSS == null) {
            this.externalCSS = new Vector();
        }
        this.externalCSS.addElement(cssElement);
    }

    void addToEmebeddedCSS(CSSElement cssElement) {
        if (this.embeddedCSS == null) {
            this.embeddedCSS = new Vector();
        }
        this.embeddedCSS.addElement(cssElement);
    }

    public void setPage(String pageURL) {
        this.setPage(new DocumentInfo(pageURL));
    }

    public void setPageStyle(Style pageStyle) {
        this.pageStyle = pageStyle;
        if (this.mainContainer != null && pageStyle != null) {
            this.applyPageStyle();
        }
    }

    private void applyPageStyle() {
        Style pageStyleCopy = new Style(this.pageStyle);
        this.mainContainer.setUnselectedStyle(pageStyleCopy);
        this.mainContainer.setSelectedStyle(pageStyleCopy);
    }

    private void cancelCurrent() {
        this.cancelRedirectsAndImages();
        if (this.pageStatus == 0 || this.pageStatus == 1 || this.pageStatus == 2) {
            this.cancel();
            int waitTime = 0;
            while (true) {
                if (this.pageStatus == -1 || waitTime >= 2500) break;
                System.out.println("Waiting for previous page to cancel " + System.currentTimeMillis());
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                waitTime += 50;
            }
        }
        this.cancelled = false;
        this.cancelledCaught = false;
        this.cleanup();
        this.removeAll();
        this.revalidate();
    }

    void setPage(final DocumentInfo docInfo) {
        this.cancelCurrent();
        this.docInfo = docInfo;
        new Thread(){

            public void run() {
                InputStreamReader isr = null;
                HTMLComponent.this.setPageStatus(0);
                try {
                    InputStream is = HTMLComponent.this.handler.resourceRequested(docInfo);
                    if (is != null) {
                        isr = new InputStreamReader(is, docInfo.getEncoding());
                    }
                }
                catch (Exception uee) {
                    boolean cont = true;
                    if (HTMLComponent.this.htmlCallback != null) {
                        cont = HTMLComponent.this.htmlCallback.parsingError(9, null, null, null, "Page encoding " + docInfo.getEncoding() + " failed: " + uee.getMessage());
                    }
                    if (cont) {
                        try {
                            isr = new InputStreamReader(HTMLComponent.this.handler.resourceRequested(docInfo));
                        }
                        catch (Exception e) {
                            HTMLComponent.this.htmlCallback.parsingError(9, null, null, null, "Page loading failed, porbably due to wrong encoding. " + e.getMessage());
                            isr = HTMLComponent.this.getStream("Page loading failed, probably due to encoding mismatch.", null);
                            HTMLComponent.this.setPageStatus(-2);
                        }
                    }
                    isr = HTMLComponent.this.getStream("Page encoding not supported", null);
                    HTMLComponent.this.setPageStatus(-2);
                }
                if (HTMLComponent.this.cancelled) {
                    isr = HTMLComponent.this.getStream("Page loading cancelled by user", null);
                    HTMLComponent.this.setPageStatus(-1);
                }
                if (isr == null) {
                    if (HTMLComponent.this.htmlCallback != null) {
                        HTMLComponent.this.htmlCallback.parsingError(100, null, null, null, "Error connecting to stream");
                    }
                    HTMLComponent.this.setPageStatus(-2);
                    isr = HTMLComponent.this.getStream("Error connecting to stream", null);
                } else {
                    HTMLComponent.this.setPageStatus(1);
                }
                HTMLElement newDoc = null;
                try {
                    newDoc = HTMLComponent.this.parser.parseHTML(isr);
                }
                catch (IllegalArgumentException iae) {
                    iae.printStackTrace();
                    HTMLComponent.this.setPageStatus(-2);
                    isr = HTMLComponent.this.getStream("Parsing error " + iae.getMessage(), null);
                    newDoc = HTMLComponent.this.parser.parseHTML(isr);
                }
                if (HTMLComponent.this.cancelled) {
                    isr = HTMLComponent.this.getStream("Page loading cancelled by user", null);
                    newDoc = HTMLComponent.this.parser.parseHTML(isr);
                    HTMLComponent.this.setPageStatus(-1);
                }
                HTMLComponent.this.setPageStatus(2);
                HTMLComponent.this.documentReady(docInfo, newDoc);
            }
        }.start();
    }

    public void setDOM(HTMLElement dom) {
        this.setDOM(dom, null);
    }

    public void setDOM(HTMLElement dom, String baseURL) {
        if (dom.getId() != 2) {
            throw new IllegalArgumentException("HTML root element must be 'html'");
        }
        this.cancelCurrent();
        this.docInfo = baseURL != null ? new DocumentInfo(baseURL) : null;
        this.documentReady(this.docInfo, dom);
    }

    private boolean pageLoading() {
        return this.pageStatus == 0 || this.pageStatus == 1 || this.pageStatus == 2;
    }

    public HTMLElement getDOM() {
        if (this.pageLoading()) {
            throw new IllegalStateException("Page is still loading");
        }
        return this.document;
    }

    public void refreshDOM() {
        this.documentReady(this.docInfo, this.document);
    }

    void documentReady(DocumentInfo docInfo, HTMLElement newDocument) {
        this.pageURL = null;
        if (docInfo != null) {
            this.pageURL = docInfo.getUrl();
        }
        this.cleanup();
        this.document = newDocument;
        this.rebuildPage();
        if (!this.cancelled || this.cancelledCaught) {
            Display.getInstance().callSerially(new Runnable(){

                public void run() {
                    int hash;
                    if (HTMLComponent.this.threadQueue.getCSSCount() == -1) {
                        HTMLComponent.this.displayPage();
                    }
                    if (HTMLComponent.this.threadQueue.getQueueSize() == 0) {
                        HTMLComponent.this.setPageStatus(4);
                    } else {
                        HTMLComponent.this.threadQueue.startRunning();
                    }
                    if (HTMLComponent.this.pageURL != null && (hash = HTMLComponent.this.pageURL.indexOf(35)) != -1 && HTMLComponent.this.pageURL.length() > hash + 1) {
                        String anchorName = HTMLComponent.this.pageURL.substring(hash + 1);
                        HTMLComponent.this.goToAnchor(anchorName);
                    }
                }
            });
        } else {
            this.setPageStatus(-1);
            InputStreamReader isr = this.getStream("Page loading cancelled by user", null);
            HTMLElement newDoc = this.parser.parseHTML(isr);
            this.documentReady(docInfo, newDoc);
        }
    }

    void cssCompleted() {
        Display.getInstance().callSerially(new Runnable(){

            public void run() {
                HTMLComponent.this.displayPage();
            }
        });
    }

    void displayPage() {
        this.removeAll();
        this.addComponent("Center", (Component)this.mainContainer);
        this.setScrollY(0);
        this.revalidate();
        this.repaint();
        if (this.getComponentForm() != null) {
            if (this.firstFocusable != null) {
                if (this.firstFocusable.getY() < this.getHeight()) {
                    this.getComponentForm().setFocused(this.firstFocusable);
                } else {
                    this.getComponentForm().setFocused(this.mainContainer);
                }
            } else {
                this.mainContainer.setFocusable(true);
                this.getComponentForm().setFocused(this.mainContainer);
            }
            if (this.marqueeComponents.size() > 0) {
                this.getComponentForm().registerAnimated(this);
                int dir = UIManager.getInstance().getLookAndFeel().isRTL() ? 1 : -1;
                this.marqueeMotion = Motion.createLinearMotion(0, dir * this.getWidth(), 3000);
                this.marqueeMotion.start();
            }
        }
        this.setPageStatus(3);
    }

    public boolean animate() {
        boolean result = super.animate();
        if (this.marqueeMotion == null) {
            return result;
        }
        Enumeration e = this.marqueeComponents.elements();
        while (e.hasMoreElements()) {
            Component cmp = (Component)e.nextElement();
            cmp.setX(this.marqueeMotion.getValue());
        }
        if (this.marqueeMotion.isFinished()) {
            int dir = UIManager.getInstance().getLookAndFeel().isRTL() ? 1 : -1;
            this.marqueeMotion = Motion.createLinearMotion(dir * -this.getWidth(), dir * this.getWidth(), 6000);
            this.marqueeMotion.start();
        }
        return true;
    }

    public String getTitle() {
        return this.title;
    }

    public String getPageURL() {
        return this.pageURL;
    }

    public int getPageStatus() {
        return this.pageStatus;
    }

    void setPageStatus(final int status) {
        if (!this.pageError || status == 0) {
            this.pageStatus = status;
            if (this.htmlCallback != null) {
                if (Display.getInstance().isEdt()) {
                    this.htmlCallback.pageStatusChanged(this, status, this.pageURL);
                } else {
                    Display.getInstance().callSerially(new Runnable(){

                        public void run() {
                            HTMLComponent.this.htmlCallback.pageStatusChanged(HTMLComponent.this, status, HTMLComponent.this.pageURL);
                        }
                    });
                }
            }
            this.pageError = status == -2 || status == -1;
            this.cancelledCaught = status == -1;
        }
    }

    Font getClosestFont(String family, int size, int style, int weight) {
        int FACTOR_FONT_FAMILY = 30;
        int FACTOR_FONT_SIZE = 5;
        int FACTOR_FONT_STYLE = 10;
        HTMLFont bestFit = null;
        int bestFitDistance = 10000;
        Enumeration e = fonts.elements();
        while (e.hasMoreElements()) {
            int curFontDistance = 0;
            HTMLFont hFont = (HTMLFont)e.nextElement();
            if (hFont.isSystemFont() || family != null && (hFont.getFamily() == null || !hFont.getFamily().equalsIgnoreCase(family))) continue;
            if (size > 0) {
                curFontDistance += Math.abs(size - hFont.getSizeInPixels()) * 5;
            }
            if (weight >= 0 && (weight & 1) != (hFont.getStyle() & 1)) {
                curFontDistance += 10;
            }
            if (style >= 0 && (style & 2) != (hFont.getStyle() & 2)) {
                curFontDistance += 10;
            }
            if (curFontDistance >= bestFitDistance) continue;
            bestFitDistance = curFontDistance;
            bestFit = hFont;
            if (curFontDistance != 0) continue;
            break;
        }
        if (bestFit == null) {
            return null;
        }
        return bestFit.getFont();
    }

    HTMLFont getHTMLFont(Font font) {
        Enumeration e = fonts.elements();
        while (e.hasMoreElements()) {
            HTMLFont hFont = (HTMLFont)e.nextElement();
            if (hFont.getFont() != font) continue;
            return hFont;
        }
        return null;
    }

    boolean isSmallCapsFontAvailable() {
        Enumeration e = fonts.elements();
        while (e.hasMoreElements()) {
            HTMLFont hFont = (HTMLFont)e.nextElement();
            if (hFont.getFamily() == null || !hFont.getFamily().equals("small-caps")) continue;
            return true;
        }
        return false;
    }

    private HTMLFont getCounterpartFont(int tag, HTMLFont font) {
        int attribute = -1;
        switch (tag) {
            case 55: {
                attribute = 0;
                break;
            }
            case 56: {
                attribute = 1;
                break;
            }
            case 57: {
                attribute = 2;
                break;
            }
            case 58: {
                attribute = 3;
            }
        }
        if (attribute == -1) {
            return font;
        }
        return this.getCounterpartFontByAttribute(attribute, font);
    }

    HTMLFont getCounterpartFontByAttribute(int attribute, HTMLFont font) {
        HTMLFont cFont = font.getCounterpartFont(attribute);
        if (cFont != null) {
            return cFont;
        }
        HTMLFont bestFit = null;
        Enumeration e = fonts.elements();
        while (e.hasMoreElements()) {
            HTMLFont hFont = (HTMLFont)e.nextElement();
            if (!hFont.isCounterpart(attribute, font)) continue;
            if (attribute == 2) {
                if (bestFit != null && bestFit.getSize() <= hFont.getSize()) continue;
                bestFit = hFont;
                continue;
            }
            if (attribute == 3) {
                if (bestFit != null && bestFit.getSize() >= hFont.getSize()) continue;
                bestFit = hFont;
                continue;
            }
            font.setCounterpartFont(attribute, hFont);
            return hFont;
        }
        if (bestFit == null) {
            bestFit = font;
        }
        font.setCounterpartFont(attribute, bestFit);
        return bestFit;
    }

    private void cleanElementUI(HTMLElement element) {
        element.clearAssociatedComponents();
        int children = element.getNumChildren();
        for (int i = 0; i < children; ++i) {
            HTMLElement child = (HTMLElement)element.getChildAt(i);
            this.cleanElementUI(child);
        }
    }

    private void cleanup() {
        if (this.document != null) {
            this.cleanElementUI(this.document);
        }
        this.displayWidth = Display.getInstance().getDisplayWidth();
        this.leftIndent = 0;
        this.x = 0;
        this.containers = new Vector();
        this.marqueeComponents = new Vector();
        this.marqueeMotion = null;
        this.anchors = new Hashtable();
        this.anchor = null;
        this.accesskey = '\u0000';
        Enumeration e = this.accessKeys.keys();
        while (e.hasMoreElements()) {
            int keyCode = (Integer)e.nextElement();
            this.getComponentForm().removeKeyListener(keyCode, this);
        }
        this.accessKeys.clear();
        this.fieldsets = new Vector();
        this.curTable = null;
        this.tables = new Vector();
        this.tableCells = new Vector();
        this.ulLevel = 0;
        this.olIndex = Integer.MIN_VALUE;
        this.olUpperLevelIndex = new Vector();
        this.listType = 0;
        this.font = this.defaultFont;
        this.labelForID = null;
        this.inputFields = new Hashtable();
        this.link = null;
        this.linkVisited = false;
        this.mainLink = null;
        this.firstFocusable = null;
        this.curForm = null;
        this.curTextArea = null;
        this.curComboBox = null;
        this.textfieldsToForms = new Hashtable();
        this.optionTag = false;
        this.optionSelected = false;
        this.preTagCount = 0;
        this.quoteTagCount = 0;
        this.mainContainer = new Container();
        if (this.pageStyle != null) {
            this.applyPageStyle();
        }
        this.mainContainer.setScrollableX(false);
        this.mainContainer.setLayout(new BoxLayout(2));
        this.curContainer = this.mainContainer;
        this.curLine = new Container();
        this.lastWasEmpty = false;
        this.width = Display.getInstance().getDisplayWidth() - this.getStyle().getMargin(1) - this.getStyle().getPadding(1) - this.getStyle().getMargin(3) - this.getStyle().getPadding(3) - 10;
    }

    private void handleLinkTag(HTMLElement linkTag) {
        String linkType = linkTag.getAttributeById(19);
        String media = linkTag.getAttributeById(51);
        String href = linkTag.getAttributeById(14);
        String charset = linkTag.getAttributeById(13);
        if (linkType != null && linkType.equalsIgnoreCase("text/css") && href != null && CSSParser.getInstance().mediaTypeMatches(media)) {
            if (this.docInfo != null) {
                this.threadQueue.addCSS(this.docInfo.convertURL(href), charset);
            } else if (DocumentInfo.isAbsoluteURL(href)) {
                this.threadQueue.addCSS(href, charset);
            } else if (this.htmlCallback != null) {
                this.htmlCallback.parsingError(103, linkTag.getName(), linkTag.getAttributeName(new Integer(14)), href, "Ignoring CSS file referred in a LINK tag (" + href + "), since page was set by setBody/setHTML/setDOM so there's no way to access relative URLs");
            }
        }
    }

    private void rebuildPage() {
        HTMLElement html = null;
        if (this.document.getId() == 2) {
            html = this.document;
        }
        HTMLElement body = null;
        HTMLElement head = null;
        String dir = null;
        if (html != null) {
            dir = html.getAttributeById(59);
            body = html.getFirstChildById(0);
            head = html.getFirstChildById(1);
        }
        this.title = null;
        if (head != null) {
            HTMLElement titleText;
            HTMLElement titleTag;
            String baseURL;
            HTMLElement baseTag = head.getFirstChildById(51);
            if (baseTag != null && (baseURL = baseTag.getAttributeById(14)) != null && this.docInfo != null) {
                this.docInfo.setBaseURL(baseURL);
            }
            if ((titleTag = head.getFirstChildById(3)) != null && titleTag.getNumChildren() > 0 && (titleText = (HTMLElement)titleTag.getChildAt(0)) != null) {
                this.title = titleText.getText();
            }
            if (this.loadCSS) {
                for (int i = 0; i < head.getNumChildren(); ++i) {
                    HTMLElement child = (HTMLElement)head.getChildAt(i);
                    if (child.getId() != 50) continue;
                    this.handleLinkTag(child);
                }
            }
        }
        if (this.htmlCallback != null) {
            Display.getInstance().callSerially(new Runnable(){

                public void run() {
                    HTMLComponent.this.htmlCallback.titleUpdated(HTMLComponent.this, HTMLComponent.this.title);
                }
            });
        }
        if (body != null) {
            this.bgColor = HTMLElement.getColor(body.getAttributeById(7), -1);
            this.textColor = HTMLElement.getColor(body.getAttributeById(9), 0);
            this.linkColor = HTMLElement.getColor(body.getAttributeById(8), 255);
            if (this.bgColor != -1) {
                this.mainContainer.getUnselectedStyle().setBgColor(this.bgColor);
                this.mainContainer.getUnselectedStyle().setBgTransparency(255);
                this.mainContainer.getSelectedStyle().setBgColor(this.bgColor);
                this.mainContainer.getSelectedStyle().setBgTransparency(255);
            } else if (this.pageStyle == null) {
                this.mainContainer.getUnselectedStyle().setBgColor(0xFFFFFF);
                this.mainContainer.getUnselectedStyle().setBgTransparency(255);
                this.mainContainer.getSelectedStyle().setBgColor(0xFFFFFF);
                this.mainContainer.getSelectedStyle().setBgTransparency(255);
            }
            this.processTag(body, 1);
            this.newLineIfNotEmpty(1);
            this.newLine(1);
            this.mainContainer.applyRTL(dir != null && dir.equalsIgnoreCase("rtl"));
            if (this.loadCSS) {
                body.setAssociatedComponents(this.mainContainer);
                if (this.threadQueue.getCSSCount() == -1) {
                    this.applyAllCSS();
                }
            }
        } else {
            System.out.println("no BODY tag was found in page.");
        }
        if (!this.cancelled) {
            this.checkRedirect(head);
        }
    }

    void applyAllCSS() {
        HTMLElement html = null;
        if (this.document.getId() == 2) {
            html = this.document;
        }
        HTMLElement body = null;
        if (html != null) {
            body = html.getFirstChildById(0);
        }
        if (body != null) {
            CSSEngine.getInstance().applyCSS(body, this, this.externalCSS, this.embeddedCSS);
        }
    }

    private void checkRedirect(HTMLElement head) {
        String content;
        String httpequiv;
        HTMLElement meta;
        if (head != null && (meta = head.getFirstChildById(49)) != null && (httpequiv = meta.getAttributeById(55)) != null && httpequiv.equalsIgnoreCase("refresh") && (content = meta.getAttributeById(54)) != null) {
            int seperator = content.indexOf(59);
            String redirectURL = null;
            if (seperator != -1) {
                String tempUrl = content.substring(seperator + 1);
                redirectURL = "";
                for (int i = 0; i < tempUrl.length(); ++i) {
                    char ch = tempUrl.charAt(i);
                    if (CSSParser.isWhiteSpace(ch)) continue;
                    redirectURL = redirectURL + ch;
                }
                if (redirectURL.startsWith("url=")) {
                    redirectURL = redirectURL.substring(4);
                }
                content = content.substring(0, seperator);
            }
            int redirectTime = -1;
            try {
                redirectTime = Integer.parseInt(content);
                this.redirectThread = new RedirectThread(this, redirectTime, redirectURL);
                new Thread(this.redirectThread).start();
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
    }

    void cancelRedirectsAndImages() {
        if (this.redirectThread != null) {
            this.redirectThread.cancel();
            this.redirectThread = null;
        }
        this.threadQueue.discardQueue();
        this.embeddedCSS = null;
        this.externalCSS = null;
        if (this.getComponentForm() != null) {
            this.marqueeMotion = null;
            this.getComponentForm().deregisterAnimated(this);
        }
    }

    private void newLine(int align) {
        if (this.curLine.getComponentCount() == 0) {
            this.curLine.setPreferredH(this.font.getHeight());
        }
        this.lastWasEmpty = this.curLine.getComponentCount() == 0;
        this.curContainer.addComponent(this.curLine);
        this.curLine = new Container();
        this.curLine.getStyle().setBgTransparency(0);
        this.curLine.setLayout(new FlowLayout(align));
        this.curLine.setScrollableX(false);
        this.curLine.getStyle().setMargin(1, this.leftIndent);
        this.x = this.leftIndent;
    }

    private void newLineIfNotEmpty(int align) {
        if (this.curLine.getComponentCount() > 0) {
            this.newLine(align);
        }
    }

    private void newLineIfLastWasNotEmpty(int align) {
        if (!this.lastWasEmpty) {
            this.newLine(align);
        }
    }

    Vector showPreTagText(String text, int align) {
        Vector<Label> comps = new Vector<Label>();
        if (text == null || text.equals("")) {
            return comps;
        }
        String line = "";
        for (int c = 0; c < text.length(); ++c) {
            char ch = text.charAt(c);
            if (ch == '\n' || ch == '\r') {
                if (line.equals("")) continue;
                comps.addElement(this.addString(line, align));
                this.newLine(align);
                line = "";
                continue;
            }
            line = line + ch;
        }
        if (!line.equals("")) {
            comps.addElement(this.addString(line, align));
            this.newLine(align);
        }
        return comps;
    }

    Vector getWords(String text, int align, boolean returnComps) {
        Vector<Object> words = new Vector<Object>();
        String word = "";
        for (int c = 0; c < text.length(); ++c) {
            char ch = text.charAt(c);
            if (ch >= '\u3400' && ch <= '\u9fff' || ch >= '\uf900' && ch <= '\ufaff') {
                word = word + ch;
                if (returnComps) {
                    words.addElement(this.addString(word, align));
                } else {
                    words.addElement(word);
                }
                word = "";
                continue;
            }
            if (ch == ' ' || ch == '\n' || ch == '\r' || ch == '\t' || ch == '\n') {
                if (word.equals("")) continue;
                if (returnComps) {
                    words.addElement(this.addString(word + ' ', align));
                } else {
                    words.addElement(word);
                }
                word = "";
                continue;
            }
            if (!returnComps && this.font.stringWidth(word + ch) > this.width - this.leftIndent) {
                words.addElement(word);
                word = "" + ch;
                continue;
            }
            word = word + ch;
        }
        if (!word.equals("")) {
            if (returnComps) {
                words.addElement(this.addString(word, align));
            } else {
                words.addElement(word);
            }
        }
        return words;
    }

    private Vector showText(String text, int align) {
        return this.getWords(text, align, true);
    }

    private Vector showTextFixedWidth(String text, int align) {
        Vector<Label> comps = new Vector<Label>();
        if (text == null || text.equals("")) {
            return comps;
        }
        int spaceW = this.width - this.x;
        Vector words = this.getWords(text, align, false);
        if (words.size() > 0) {
            int w = 0;
            String wordStr = "";
            if (CSSParser.isWhiteSpace(text.charAt(0)) && this.curLine.getComponentCount() != 0) {
                wordStr = " ";
            }
            while (w < words.size()) {
                String nextWord = (String)words.elementAt(w);
                String space = "";
                if (!wordStr.equals("") && !wordStr.equals(" ")) {
                    space = " ";
                }
                if (this.font.stringWidth(wordStr + space + nextWord) > spaceW - 2) {
                    comps.addElement(this.addString(wordStr, align));
                    this.newLineIfNotEmpty(align);
                    spaceW = this.width - this.x;
                    wordStr = nextWord;
                } else {
                    wordStr = wordStr + space + nextWord;
                }
                ++w;
            }
            if (CSSParser.isWhiteSpace(text.charAt(text.length() - 1))) {
                wordStr = wordStr + " ";
            }
            comps.addElement(this.addString(wordStr, align));
        }
        return comps;
    }

    private Label addString(String str, int align) {
        Label lbl = null;
        int color = this.textColor;
        if (this.link != null) {
            lbl = new HTMLLink(str, this.link, this, this.mainLink, this.linkVisited);
            color = this.linkColor;
            if (this.linkVisited) {
                color = 0x990099;
            }
            lbl.getSelectedStyle().setFont(this.font.getFont());
            if (this.mainLink == null) {
                this.mainLink = (HTMLLink)lbl;
            }
            if (this.accesskey != '\u0000') {
                this.addAccessKey(this.accesskey, lbl, false);
                this.accesskey = '\u0000';
            }
            lbl.getSelectedStyle().setMargin(0, 0, 0, 0);
            lbl.getSelectedStyle().setPadding(0, 0, 0, 0);
        } else if (this.labelForID != null) {
            lbl = new ForLabel(str, this, this.labelForID);
            if (this.accesskey != '\u0000') {
                this.addAccessKey(this.accesskey, lbl, false);
                this.accesskey = '\u0000';
            }
            this.labelForID = null;
        } else {
            lbl = new Label(str);
        }
        lbl.getStyle().setMargin(0, 0, 0, 0);
        lbl.getStyle().setPadding(0, 0, 0, 0);
        lbl.getUnselectedStyle().setFgColor(color);
        lbl.getSelectedStyle().setFgColor(color);
        lbl.getUnselectedStyle().setFont(this.font.getFont());
        lbl.setGap(0);
        lbl.setTickerEnabled(false);
        lbl.setEndsWith3Points(false);
        if (align != 5) {
            lbl.setAlignment(align);
        }
        lbl.getUnselectedStyle().setBgTransparency(0);
        this.curLine.addComponent(lbl);
        if (this.anchor != null) {
            this.anchors.put(this.anchor, lbl);
        }
        return lbl;
    }

    void addAccessKey(int accessKey, Component cmp, boolean override) {
        if (override && this.accessKeys.contains(cmp)) {
            Hashtable newAccessKeys = new Hashtable();
            Enumeration e = this.accessKeys.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                Component c = (Component)this.accessKeys.get(key);
                if (c == cmp) continue;
                newAccessKeys.put(key, c);
            }
            this.accessKeys = newAccessKeys;
        }
        this.accessKeys.put(new Integer(accessKey), cmp);
        Form form = this.getComponentForm();
        if (form != null) {
            form.addKeyListener(accessKey, this);
        }
    }

    protected void initComponent() {
        super.initComponent();
        Enumeration e = this.accessKeys.keys();
        while (e.hasMoreElements()) {
            int keyCode = (Integer)e.nextElement();
            this.getComponentForm().addKeyListener(keyCode, this);
        }
    }

    protected void deinitialize() {
        super.deinitialize();
        Enumeration e = this.accessKeys.keys();
        while (e.hasMoreElements()) {
            int keyCode = (Integer)e.nextElement();
            this.getComponentForm().removeKeyListener(keyCode, this);
        }
    }

    private void handleImage(HTMLElement imgElement, int align, Command cmd) {
        String imageUrl = imgElement.getAttributeById(30);
        Label imgLabel = null;
        if (imageUrl != null) {
            String alignStr = imgElement.getAttributeById(6);
            int iWidth = HTMLComponent.calcSize(this.getWidth(), imgElement.getAttributeById(23), 0, false);
            int iHeight = HTMLComponent.calcSize(this.getHeight(), imgElement.getAttributeById(24), 0, false);
            int hspace = HTMLComponent.getInt(imgElement.getAttributeById(26));
            int vspace = HTMLComponent.getInt(imgElement.getAttributeById(27));
            int totalWidth = iWidth + hspace * 2;
            String altText = imgElement.getAttributeById(25);
            if (this.link != null) {
                imgLabel = new HTMLLink(altText, this.link, this, this.mainLink, false);
                if (this.mainLink == null) {
                    this.mainLink = (HTMLLink)imgLabel;
                }
                if (this.accesskey != '\u0000') {
                    this.addAccessKey(this.accesskey, imgLabel, false);
                }
            } else if (cmd != null) {
                imgLabel = new Button(cmd);
                if (altText != null && !altText.equals("")) {
                    imgLabel.setText(altText);
                }
                if (this.firstFocusable == null) {
                    this.firstFocusable = imgLabel;
                }
            } else {
                imgLabel = new Label(altText);
            }
            if (iWidth != 0 || iHeight != 0) {
                imgLabel.setPreferredSize(new Dimension(iWidth += imgLabel.getStyle().getPadding(1) + imgLabel.getStyle().getPadding(3), iHeight += imgLabel.getStyle().getPadding(0) + imgLabel.getStyle().getPadding(2)));
            } else if (imgLabel.getText() == null || imgLabel.getText().equals("")) {
                imgLabel.setText(" ");
            }
            imgLabel.getSelectedStyle().setPadding(0, 0, 0, 0);
            imgLabel.getUnselectedStyle().setPadding(0, 0, 0, 0);
            imgLabel.getSelectedStyle().setFont(this.font.getFont());
            imgLabel.getUnselectedStyle().setFont(this.font.getFont());
            imgLabel.getUnselectedStyle().setBorder(Border.createLineBorder(1));
            imgLabel.getSelectedStyle().setBorder(Border.createLineBorder(1));
            imgLabel.getUnselectedStyle().setBgTransparency(0);
            imgLabel.getSelectedStyle().setBgTransparency(0);
            Container imgCont = new Container(new BorderLayout());
            imgCont.addComponent("Center", (Component)imgLabel);
            imgCont.getSelectedStyle().setMargin(vspace, vspace, hspace, hspace);
            imgCont.getUnselectedStyle().setMargin(vspace, vspace, hspace, hspace);
            this.curLine.addComponent(imgCont);
            this.x += totalWidth;
            imgLabel.setAlignment(this.getHorizAlign(alignStr, align, false));
            imgLabel.setVerticalAlignment(this.getVertAlign(alignStr, 4));
            if (this.showImages) {
                if (this.docInfo != null) {
                    imageUrl = this.docInfo.convertURL(imageUrl);
                    this.threadQueue.add(imgLabel, imageUrl);
                } else if (DocumentInfo.isAbsoluteURL(imageUrl)) {
                    this.threadQueue.add(imgLabel, imageUrl);
                } else if (this.htmlCallback != null) {
                    this.htmlCallback.parsingError(103, imgElement.getName(), imgElement.getAttributeName(new Integer(30)), imageUrl, "Ignoring Image file referred in an IMG tag (" + imageUrl + "), since page was set by setBody/setHTML/setDOM so there's no way to access relative URLs");
                }
            }
            if (this.loadCSS) {
                imgElement.setAssociatedComponents(imgCont);
            }
        }
    }

    private void handleInput(HTMLElement element, int align) {
        String type = element.getAttributeById(19);
        if (type == null) {
            return;
        }
        int typeID = INPUT_TYPES.indexOf(type.toLowerCase());
        if (typeID == -1) {
            if (this.htmlCallback != null && !this.htmlCallback.parsingError(2, element.getName(), element.getAttributeName(new Integer(19)), type, "Unsupported input type '" + type + "'. Supported types: text, password, checkbox, radio, submit, reset, hidden, image")) {
                this.cancel();
            }
            return;
        }
        String name = element.getAttributeById(37);
        String id = element.getAttributeById(1);
        String value = element.getAttributeById(38);
        if (value == null) {
            value = "";
        }
        Component cmp = null;
        switch (typeID) {
            case 0: {
                CheckBox cb = new CheckBox();
                if (element.getAttributeById(32) != null) {
                    cb.setSelected(true);
                }
                cmp = cb;
                if (this.curForm == null) break;
                this.curForm.addCheckBox(name, cb, value);
                break;
            }
            case 1: {
                if (this.curForm == null) break;
                this.curForm.addInput(name, value, null);
                break;
            }
            case 2: 
            case 6: {
                String emptyOk;
                HTMLInputFormat inputFormat;
                TextField tf = new TextField(value);
                if (typeID == 2) {
                    tf.setConstraint(65536);
                }
                if ((inputFormat = HTMLInputFormat.getInputFormat(element.getAttributeById(34))) != null) {
                    tf = (TextField)inputFormat.applyConstraints(tf);
                    if (this.curForm != null) {
                        this.curForm.setInputFormat(tf, inputFormat);
                    }
                }
                if ((emptyOk = element.getAttributeById(33)) != null && this.curForm != null) {
                    if (emptyOk.equalsIgnoreCase("true")) {
                        this.curForm.setEmptyOK(tf, true);
                    } else if (emptyOk.equalsIgnoreCase("false")) {
                        this.curForm.setEmptyOK(tf, false);
                    }
                }
                int size = HTMLComponent.getInt(element.getAttributeById(31));
                int maxlen = HTMLComponent.getInt(element.getAttributeById(36));
                if (size == 0) {
                    size = 12;
                }
                if (maxlen != 0) {
                    tf.setMaxSize(maxlen);
                    if (size > maxlen) {
                        size = maxlen;
                    }
                }
                tf.setPreferredW(tf.getStyle().getFont().stringWidth("W") * size);
                tf.getSelectedStyle().setFont(this.font.getFont());
                tf.getUnselectedStyle().setFont(this.font.getFont());
                cmp = tf;
                if (this.curForm == null) break;
                this.curForm.addInput(name, cmp, value);
                this.textfieldsToForms.put(tf, this.curForm);
                break;
            }
            case 3: {
                RadioButton rb = new RadioButton(" ");
                if (element.getAttributeById(32) != null) {
                    rb.setSelected(true);
                }
                cmp = rb;
                if (this.curForm == null) break;
                this.curForm.addRadioButton(name, rb, value);
                break;
            }
            case 4: {
                Command resetCmd = null;
                if (this.curForm != null) {
                    resetCmd = this.curForm.createResetCommand(value);
                }
                if (resetCmd == null) {
                    resetCmd = new Command(HTMLForm.getDefaultResetText());
                }
                Button resetButton = new Button(resetCmd);
                cmp = resetButton;
                break;
            }
            case 5: {
                Command submitCmd = null;
                if (this.curForm != null) {
                    submitCmd = this.curForm.createSubmitCommand(name, value);
                }
                if (submitCmd == null) {
                    submitCmd = new Command(value.equals("") ? HTMLForm.getDefaultSubmitText() : value);
                }
                Button submitButton = new Button(submitCmd);
                cmp = submitButton;
                break;
            }
            case 7: {
                Command submitCmd = null;
                if (this.curForm != null) {
                    submitCmd = this.curForm.createSubmitCommand(name, value);
                }
                this.handleImage(element, align, submitCmd);
            }
        }
        if (cmp != null) {
            String aKey = element.getAttributeById(12);
            if (aKey != null && aKey.length() == 1) {
                this.addAccessKey(aKey.charAt(0), cmp, false);
            }
            if (this.loadCSS) {
                element.setAssociatedComponents(cmp);
            }
            if (this.curForm != null && this.curForm.action == null) {
                cmp.setEnabled(false);
            } else if (this.firstFocusable == null) {
                this.firstFocusable = cmp;
            }
            if (id != null) {
                this.inputFields.put(id, cmp);
            }
        }
        this.addCmp(cmp, align);
    }

    TextArea setInputFormat(final TextArea inputField, String inputFormat) {
        HTMLInputFormat format;
        TextArea returnInputField = inputField;
        HTMLForm form = (HTMLForm)this.textfieldsToForms.get(inputField);
        if (form != null && (format = HTMLInputFormat.getInputFormat(inputFormat)) != null) {
            TextArea newInputField;
            form.setInputFormat(inputField, format);
            returnInputField = newInputField = format.applyConstraints(inputField);
            if (Display.getInstance().getCurrent() != inputField.getComponentForm()) {
                inputField.getParent().replace(inputField, newInputField, null);
            } else {
                Display.getInstance().callSerially(new Runnable(){

                    public void run() {
                        inputField.getParent().replace(inputField, newInputField, null);
                    }
                });
            }
            if (this.firstFocusable == inputField) {
                this.firstFocusable = newInputField;
            }
        }
        return returnInputField;
    }

    void setInputRequired(TextArea inputField, boolean inputRequired) {
        HTMLForm form = (HTMLForm)this.textfieldsToForms.get(inputField);
        if (form != null) {
            if (inputRequired) {
                form.setEmptyOK(inputField, false);
            } else {
                form.setEmptyOK(inputField, true);
            }
        }
    }

    private void addCmp(Component cmp, int align) {
        if (cmp != null) {
            this.curLine.addComponent(cmp);
            this.x += cmp.getPreferredW();
        }
    }

    private void updateMargin(int delta) {
        this.leftIndent += delta;
        this.x += delta;
        this.curLine.getStyle().setMargin(1, this.leftIndent);
    }

    private void handleTableCell(HTMLElement tdTag, int align) {
        String cHeight;
        int pH;
        HTMLElement trTag;
        this.newLineIfNotEmpty(align);
        this.tableCells.addElement(this.curContainer);
        Container cell = new Container();
        cell.getStyle().setBgTransparency(0);
        cell.setLayout(new BoxLayout(2));
        int border = 0;
        for (trTag = (HTMLElement)tdTag.getParent(); trTag != null && trTag.getId() != 45; trTag = (HTMLElement)trTag.getParent()) {
        }
        if (trTag != null) {
            HTMLElement tableTag;
            for (tableTag = (HTMLElement)trTag.getParent(); tableTag != null && tableTag.getId() != 42; tableTag = (HTMLElement)tableTag.getParent()) {
            }
            if (tableTag != null) {
                border = HTMLComponent.getInt(tableTag.getAttributeById(60));
            }
        }
        cell.getUnselectedStyle().setPadding(border, border, border, border);
        cell.getSelectedStyle().setPadding(border, border, border, border);
        CellConstraint constraint = new CellConstraint();
        int halign = this.getHorizAlign(((HTMLElement)tdTag.getParent()).getAttributeById(6), align, false);
        int valign = this.getVertAlign(((HTMLElement)tdTag.getParent()).getAttributeById(49), 4);
        halign = this.getHorizAlign(tdTag.getAttributeById(6), halign, false);
        valign = this.getVertAlign(tdTag.getAttributeById(49), valign);
        int colspan = HTMLComponent.getInt(tdTag.getAttributeById(45));
        int rowspan = HTMLComponent.getInt(tdTag.getAttributeById(47));
        String cWidth = tdTag.getAttributeById(23);
        int pW = this.getPercentage(cWidth);
        if ((pW <= 0 || pW >= 100) && (pW = HTMLComponent.getInt(cWidth)) != 0) {
            cell.setPreferredW(pW);
        }
        if (((pH = this.getPercentage(cHeight = tdTag.getAttributeById(24))) <= 0 || pH >= 100) && (pH = HTMLComponent.getInt(cHeight)) != 0) {
            cell.setPreferredH(pH);
        }
        constraint.setHorizontalAlign(halign);
        constraint.setVerticalAlign(valign);
        if (colspan > 1) {
            constraint.setHorizontalSpan(colspan);
        }
        if (rowspan > 1) {
            constraint.setVerticalSpan(rowspan);
        }
        this.curContainer = cell;
        if (this.curTable != null) {
            this.curTable.addCell(cell, tdTag.getId() == 44, constraint);
        }
        if (this.loadCSS) {
            tdTag.setAssociatedComponents(cell);
            if (trTag != null) {
                trTag.addAssociatedComponent(cell);
            }
        }
    }

    private void processTag(HTMLElement element, int align) {
        if (this.cancelled && !this.cancelledCaught) {
            return;
        }
        int curAlign = align;
        HTMLFont oldFont = this.font;
        block58: for (int i = 0; i < element.getNumChildren() && (!this.cancelled || this.cancelledCaught); ++i) {
            HTMLElement child = (HTMLElement)element.getChildAt(i);
            switch (child.getId()) {
                case 60: {
                    String text = child.getText();
                    if (this.curComboBox != null && this.optionTag) {
                        OptionItem oi = new OptionItem(text, this.optionValue);
                        this.curComboBox.addItem(oi);
                        if (!this.optionSelected) break;
                        this.curComboBox.setSelectedItem(oi);
                        if (this.curForm == null) break;
                        this.curForm.setDefaultValue(this.curComboBox, oi);
                        break;
                    }
                    if (this.curTextArea != null) {
                        this.curTextArea.setText(text);
                        if (this.curForm == null) break;
                        this.curForm.setDefaultValue(this.curTextArea, text);
                        break;
                    }
                    Vector comps = null;
                    comps = this.preTagCount != 0 ? this.showPreTagText(text, curAlign) : this.showText(text, curAlign);
                    if (!this.loadCSS) break;
                    child.setAssociatedComponents(comps);
                    break;
                }
                case 28: {
                    String aKey;
                    this.link = child.getAttributeById(14);
                    if (this.link != null && this.docInfo == null && !DocumentInfo.isAbsoluteURL(this.link)) {
                        if (this.htmlCallback != null) {
                            this.htmlCallback.parsingError(103, child.getName(), child.getAttributeName(new Integer(14)), this.link, "Disabling relative link (" + this.link + "), since page was set by setBody/setHTML/setDOM so there's no way to access relative URLs");
                        }
                        this.link = null;
                    }
                    if (this.link != null && this.htmlCallback != null) {
                        int linkProps = this.htmlCallback.getLinkProperties(this, this.convertURL(this.link));
                        if ((linkProps & 2) != 0) {
                            this.link = null;
                        } else if ((linkProps & 1) != 0) {
                            this.linkVisited = true;
                        }
                    }
                    this.anchor = child.getAttributeById(37);
                    if (this.link == null || (aKey = child.getAttributeById(12)) == null || aKey.length() != 1) break;
                    this.accesskey = aKey.charAt(0);
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    this.font = (HTMLFont)fonts.get(child.getName());
                    if (this.font == null) {
                        this.font = oldFont;
                    }
                }
                case 21: {
                    curAlign = this.getHorizAlign(child.getAttributeById(6), align, true);
                    this.adjustAlignment(align, curAlign);
                    this.newLineIfNotEmpty(curAlign);
                    this.newLineIfLastWasNotEmpty(curAlign);
                    this.pushContainer(child);
                    break;
                }
                case 12: {
                    curAlign = this.getHorizAlign(child.getAttributeById(6), align, true);
                    this.adjustAlignment(align, curAlign);
                    this.newLineIfNotEmpty(curAlign);
                    this.pushContainer(child);
                    break;
                }
                case 59: {
                    this.newLineIfNotEmpty(curAlign);
                    Container newCont = new Container();
                    newCont.setUIID("HTMLFieldset");
                    if (this.fieldsets.size() == 0) {
                        newCont.getStyle().setMargin(1, 0);
                    }
                    newCont.setLayout(new BoxLayout(2));
                    this.curContainer.addComponent(newCont);
                    this.fieldsets.addElement(this.curContainer);
                    this.curContainer = newCont;
                    if (!this.loadCSS) break;
                    child.setAssociatedComponents(newCont);
                    break;
                }
                case 8: {
                    if (this.loadCSS) {
                        child.setAssociatedComponents(this.curLine);
                    }
                    this.newLine(curAlign);
                    break;
                }
                case 29: {
                    this.newLineIfNotEmpty(curAlign);
                    this.newLine(curAlign);
                    this.pushContainer(child);
                    break;
                }
                case 30: {
                    this.newLineIfNotEmpty(curAlign);
                    this.pushContainer(child);
                    break;
                }
                case 33: {
                    this.newLineIfNotEmpty(curAlign);
                    ++this.ulLevel;
                    this.listIndent += 15;
                    if (this.ulLevel == 1 && this.olIndex == Integer.MIN_VALUE) {
                        this.newLine(curAlign);
                    }
                    this.pushContainer(child);
                    break;
                }
                case 32: {
                    this.newLineIfNotEmpty(curAlign);
                    if (this.olIndex != Integer.MIN_VALUE) {
                        String indexStr = ORDERED_LIST_TYPE_IDENTIFIERS[this.listType] + "" + this.olIndex;
                        this.olUpperLevelIndex.addElement(indexStr);
                    }
                    this.olIndex = HTMLComponent.getInt(child.getAttributeById(50), 1);
                    this.listType = this.getOrderedListType(child);
                    this.listIndent += 15;
                    if (this.olUpperLevelIndex.size() == 0 && this.ulLevel == 0) {
                        this.newLine(curAlign);
                    }
                    this.pushContainer(child);
                    break;
                }
                case 34: {
                    Container listItemCont = new Container(new BorderLayout());
                    listItemCont.getStyle().setMargin(1, this.leftIndent + this.listIndent);
                    this.curContainer.addComponent(listItemCont);
                    this.containers.addElement(this.curContainer);
                    HTMLListItem bullet = null;
                    if (((HTMLElement)child.getParent()).getId() == 32) {
                        this.olIndex = HTMLComponent.getInt(child.getAttributeById(38), this.olIndex);
                        int itemListType = this.getOrderedListType(child, this.listType);
                        HTMLListIndex listIndex = new HTMLListIndex(this.olIndex, itemListType);
                        listIndex.getUnselectedStyle().setFgColor(this.textColor);
                        listIndex.getSelectedStyle().setFgColor(this.textColor);
                        listIndex.getUnselectedStyle().setFont(this.font.getFont());
                        bullet = listIndex;
                    } else {
                        bullet = new HTMLBullet(this.getUnorderedListType(child, this.ulLevel), this.font.getFont().getHeight(), this.textColor, this);
                    }
                    Container bulletCont = new Container(new BorderLayout());
                    bulletCont.addComponent("North", (Component)bullet);
                    listItemCont.addComponent("West", (Component)bulletCont);
                    Container listItemText = new Container(new BoxLayout(2));
                    listItemCont.addComponent("Center", (Component)listItemText);
                    this.curContainer = listItemText;
                    if (!this.loadCSS) break;
                    child.setAssociatedComponents(listItemText);
                    break;
                }
                case 7: {
                    this.newLineIfNotEmpty(curAlign);
                    this.updateMargin(20);
                    this.newLine(curAlign);
                    this.pushContainer(child);
                    break;
                }
                case 31: {
                    this.newLineIfNotEmpty(curAlign);
                    this.updateMargin(20);
                    this.pushContainer(child);
                    break;
                }
                case 52: {
                    this.newLineIfNotEmpty(curAlign);
                    Label hr = new Label();
                    hr.setUIID("HTMLHR");
                    int hrWidth = HTMLComponent.calcSize(this.width, child.getAttributeById(23), this.width, false);
                    int hrHeight = HTMLComponent.getInt(child.getAttributeById(31), 3);
                    hr.setPreferredW(hrWidth);
                    hr.setPreferredH(hrHeight);
                    this.curLine.addComponent(hr);
                    this.newLine(curAlign);
                    if (!this.loadCSS) break;
                    child.setAssociatedComponents(hr);
                    break;
                }
                case 54: {
                    break;
                }
                case 46: {
                    this.handleImage(child, curAlign, null);
                    break;
                }
                case 22: {
                    ++this.preTagCount;
                    this.pushContainer(child);
                }
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 20: 
                case 24: 
                case 26: 
                case 27: {
                    this.font = (HTMLFont)fonts.get(child.getName());
                    if (this.font != null) break;
                    this.font = oldFont;
                    break;
                }
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    this.font = this.getCounterpartFont(child.getId(), this.font);
                    break;
                }
                case 35: {
                    this.curForm = new HTMLForm(this, child.getAttributeById(20), child.getAttributeById(22), child.getAttributeById(21));
                    this.pushContainer(child);
                    break;
                }
                case 36: {
                    this.handleInput(child, curAlign);
                    break;
                }
                case 38: {
                    String multi = child.getAttributeById(41);
                    if (multi != null) {
                        this.curComboBox = new MultiComboBox(true);
                        Container comboCont = new Container(new BorderLayout());
                        this.curComboBox.setItemGap(0);
                        comboCont.setUIID("ComboBox");
                        this.curComboBox.setUIID("List");
                        comboCont.addComponent("Center", (Component)this.curComboBox);
                    } else {
                        this.curComboBox = new HTMLComboBox();
                    }
                    String name = child.getAttributeById(37);
                    if (this.curForm != null) {
                        this.curForm.addInput(name, this.curComboBox, null);
                    }
                    if (!this.loadCSS) break;
                    child.setAssociatedComponents(this.curComboBox);
                    break;
                }
                case 53: {
                    String label;
                    if (this.curComboBox == null || (label = child.getAttributeById(52)) == null) break;
                    this.curComboBox.addItem(label);
                    break;
                }
                case 39: {
                    this.optionTag = true;
                    this.optionValue = child.getAttributeById(38);
                    if (this.curComboBox == null || child.getAttributeById(42) == null) break;
                    this.optionSelected = true;
                    break;
                }
                case 40: {
                    String aKey;
                    this.curTextArea = new TextArea(HTMLComponent.getInt(child.getAttributeById(58), 2), HTMLComponent.getInt(child.getAttributeById(57), 20));
                    this.addCmp(this.curTextArea, curAlign);
                    if (this.loadCSS) {
                        child.setAssociatedComponents(this.curTextArea);
                    }
                    if ((aKey = element.getAttributeById(12)) == null || aKey.length() != 1) break;
                    this.addAccessKey(aKey.charAt(0), this.curTextArea, false);
                    break;
                }
                case 23: {
                    this.addQuote(curAlign);
                    ++this.quoteTagCount;
                    break;
                }
                case 42: {
                    this.newLineIfNotEmpty(curAlign);
                    if (this.curTable != null) {
                        HTMLTableModel newTable;
                        this.tables.addElement(this.curTable);
                        this.curTable = newTable = new HTMLTableModel();
                    } else {
                        this.curTable = new HTMLTableModel();
                    }
                    this.width /= 2;
                    break;
                }
                case 45: {
                    break;
                }
                case 43: 
                case 44: {
                    if (this.curTable == null) break;
                    this.handleTableCell(child, curAlign);
                    break;
                }
                case 37: {
                    this.labelForID = child.getAttributeById(39);
                    String aKey = child.getAttributeById(12);
                    if (aKey == null || aKey.length() != 1) break;
                    this.accesskey = aKey.charAt(0);
                }
            }
            if (child.getNumChildren() > 0) {
                this.processTag(child, curAlign);
            }
            switch (child.getId()) {
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    this.font = oldFont;
                }
                case 21: {
                    curAlign = align;
                    this.newLineIfNotEmpty(curAlign);
                    this.popContainer();
                    this.newLine(curAlign);
                    continue block58;
                }
                case 12: {
                    curAlign = align;
                    this.newLineIfNotEmpty(curAlign);
                    this.popContainer();
                    continue block58;
                }
                case 59: {
                    Container upperContainer;
                    this.newLineIfNotEmpty(curAlign);
                    this.curContainer = upperContainer = (Container)this.fieldsets.lastElement();
                    this.fieldsets.removeElement(this.curContainer);
                    continue block58;
                }
                case 7: {
                    this.newLineIfNotEmpty(curAlign);
                    this.newLine(curAlign);
                    this.updateMargin(-20);
                    this.popContainer();
                    continue block58;
                }
                case 30: {
                    this.popContainer();
                    continue block58;
                }
                case 31: {
                    this.newLineIfNotEmpty(curAlign);
                    this.updateMargin(-20);
                    this.popContainer();
                    continue block58;
                }
                case 29: {
                    this.newLine(curAlign);
                    this.popContainer();
                    continue block58;
                }
                case 28: {
                    this.link = null;
                    this.linkVisited = false;
                    this.mainLink = null;
                    this.anchor = null;
                    this.accesskey = '\u0000';
                    continue block58;
                }
                case 33: {
                    --this.ulLevel;
                    if (this.ulLevel == 0 && this.olIndex == Integer.MIN_VALUE) {
                        this.newLine(curAlign);
                    }
                    this.listIndent -= 15;
                    this.popContainer();
                    continue block58;
                }
                case 32: {
                    if (this.olUpperLevelIndex.size() != 0) {
                        String indexStr = (String)this.olUpperLevelIndex.lastElement();
                        this.olUpperLevelIndex.removeElementAt(this.olUpperLevelIndex.size() - 1);
                        this.listType = this.getOrderedListType(indexStr.charAt(0), 0);
                        this.olIndex = HTMLComponent.getInt(indexStr.substring(1));
                    } else {
                        this.olIndex = Integer.MIN_VALUE;
                    }
                    if (this.olIndex == Integer.MIN_VALUE && this.ulLevel == 0) {
                        this.newLine(curAlign);
                    }
                    this.listIndent -= 15;
                    this.popContainer();
                    continue block58;
                }
                case 34: {
                    Container prevContainer;
                    if (this.olIndex != Integer.MIN_VALUE) {
                        ++this.olIndex;
                    }
                    this.newLineIfNotEmpty(curAlign);
                    this.curContainer = prevContainer = (Container)this.containers.lastElement();
                    this.containers.removeElement(this.curContainer);
                    continue block58;
                }
                case 22: {
                    --this.preTagCount;
                    this.popContainer();
                }
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 20: 
                case 24: 
                case 26: 
                case 27: 
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    this.font = oldFont;
                    continue block58;
                }
                case 35: {
                    if (this.curForm != null && !this.curForm.hasSubmitButton && this.curForm.getNumFields() > 0) {
                        Button submitButton = new Button(this.curForm.createSubmitCommand(null, null));
                        this.addCmp(submitButton, curAlign);
                    }
                    this.curForm = null;
                    this.popContainer();
                    continue block58;
                }
                case 40: {
                    String name = child.getAttributeById(37);
                    if (this.curForm != null) {
                        this.curForm.addInput(name, this.curTextArea, null);
                    }
                    this.curTextArea = null;
                    continue block58;
                }
                case 38: {
                    if (this.curComboBox instanceof MultiComboBox) {
                        Container comboCont = this.curComboBox.getParent();
                        int minSize = Math.min(4, this.curComboBox.size());
                        int maxSize = Math.min(this.curComboBox.size(), 6);
                        int size = Math.min(maxSize, Math.max(HTMLComponent.getInt(child.getAttributeById(31)), minSize));
                        Component renderCmp = this.curComboBox.getRenderer().getListCellRendererComponent(this.curComboBox, "X", 0, false);
                        comboCont.setPreferredH((renderCmp.getPreferredH() + renderCmp.getStyle().getMargin(0) + renderCmp.getStyle().getMargin(2) + this.curComboBox.getItemGap()) * size + this.curComboBox.getStyle().getPadding(0) + this.curComboBox.getStyle().getPadding(2));
                        comboCont.setPreferredW(100);
                        this.addCmp(comboCont, curAlign);
                    } else {
                        this.addCmp(this.curComboBox, curAlign);
                    }
                    this.curComboBox = null;
                    continue block58;
                }
                case 39: {
                    this.optionTag = false;
                    this.optionSelected = false;
                    this.optionValue = null;
                    continue block58;
                }
                case 23: {
                    --this.quoteTagCount;
                    this.addQuote(curAlign);
                    continue block58;
                }
                case 42: {
                    this.newLineIfNotEmpty(curAlign);
                    this.curTable.commitRowIfNotEmpty();
                    if (this.curTable.getRowCount() != 0) {
                        int border;
                        for (int r = 0; r < this.curTable.getRowCount(); ++r) {
                            for (int c = 0; c < this.curTable.getColumnCount(); ++c) {
                                Component cmp = (Component)this.curTable.getValueAt(r, c);
                                if (cmp == null) continue;
                                cmp.setPreferredSize(cmp.getPreferredSize());
                            }
                        }
                        HTMLTable table = new HTMLTable(this.curTable);
                        table.getStyle().setBgTransparency(0);
                        if (this.loadCSS) {
                            child.setAssociatedComponents(table);
                        }
                        if ((border = HTMLComponent.getInt(child.getAttributeById(60))) > 0) {
                            table.getUnselectedStyle().setBorder(Border.createLineBorder(border));
                            table.getSelectedStyle().setBorder(Border.createLineBorder(border));
                            table.getUnselectedStyle().setPadding(border, border, border, border);
                            table.getSelectedStyle().setPadding(border, border, border, border);
                        } else {
                            table.getUnselectedStyle().setBorder(null);
                            table.getSelectedStyle().setBorder(null);
                            table.setDrawBorder(false);
                        }
                        this.addCmp(table, curAlign);
                        this.newLineIfNotEmpty(curAlign);
                    }
                    if (this.tables.size() == 0) {
                        this.curTable = null;
                    } else {
                        this.curTable = (HTMLTableModel)this.tables.lastElement();
                        this.tables.removeElement(this.curTable);
                    }
                    this.width *= 2;
                    if (this.width <= this.displayWidth) continue block58;
                    this.width = this.displayWidth;
                    continue block58;
                }
                case 45: {
                    if (this.curTable == null) continue block58;
                    this.curTable.commitRow();
                    continue block58;
                }
                case 43: 
                case 44: {
                    if (this.curTable == null) continue block58;
                    this.newLineIfNotEmpty(curAlign);
                    this.curContainer = (Container)this.tableCells.lastElement();
                    this.tableCells.removeElement(this.curContainer);
                    continue block58;
                }
                case 37: {
                    this.labelForID = null;
                    this.accesskey = '\u0000';
                }
            }
        }
    }

    private void adjustAlignment(int align, int curAlign) {
        if (align != curAlign && this.curLine.getComponentCount() == 0) {
            this.curLine.setLayout(new FlowLayout(curAlign));
        }
    }

    private int getUnorderedListType(HTMLElement element, int defaultType) {
        String listTypeStr = element.getAttributeById(19);
        int type = HTMLBullet.convertULString(listTypeStr);
        if (type == -1) {
            type = defaultType;
        }
        return type;
    }

    private int getOrderedListType(HTMLElement element) {
        return this.getOrderedListType(element, 0);
    }

    private int getOrderedListType(HTMLElement element, int defaultListType) {
        String listTypeStr = element.getAttributeById(19);
        if (listTypeStr != null && listTypeStr.length() > 0) {
            char c = listTypeStr.charAt(0);
            return this.getOrderedListType(c, defaultListType);
        }
        return defaultListType;
    }

    private int getOrderedListType(char c, int defaultListType) {
        for (int j = 0; j < ORDERED_LIST_TYPE_IDENTIFIERS.length; ++j) {
            if (c != ORDERED_LIST_TYPE_IDENTIFIERS[j]) continue;
            return j;
        }
        return defaultListType;
    }

    private void pushContainer(HTMLElement element) {
        if (this.loadCSS) {
            Container cont = new Container(new BoxLayout(2));
            cont.setScrollableX(false);
            cont.getStyle().setBgTransparency(0);
            element.setAssociatedComponents(cont);
            this.curContainer.addComponent(cont);
            this.containers.addElement(this.curContainer);
            this.curContainer = cont;
        }
    }

    private void popContainer() {
        if (this.loadCSS) {
            Container prevContainer;
            this.curContainer = prevContainer = (Container)this.containers.lastElement();
            this.containers.removeElement(this.curContainer);
        }
    }

    private void addQuote(int curAlign) {
        String quote = null;
        quote = this.quoteTagCount == 0 ? "\"" : "'";
        this.addString(quote, curAlign);
    }

    private int getHorizAlign(String alignment, int defaultAlign, boolean allowJustify) {
        if (alignment != null) {
            if (alignment.equals("left")) {
                return 1;
            }
            if (alignment.equals("right")) {
                return 3;
            }
            if (alignment.equals("center") || alignment.equals("middle")) {
                return 4;
            }
            if (alignment.equals("justify")) {
                if (allowJustify) {
                    // empty if block
                }
                return 4;
            }
        }
        return defaultAlign;
    }

    private int getVertAlign(String alignment, int defaultAlign) {
        if (alignment != null) {
            if (alignment.equals("top")) {
                return 0;
            }
            if (alignment.equals("bottom")) {
                return 2;
            }
            if (alignment.equals("center") || alignment.equals("middle")) {
                return 4;
            }
        }
        return defaultAlign;
    }

    static int getInt(String intStr, int defaultValue) {
        try {
            int num = Integer.parseInt(intStr);
            return num;
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    static int getInt(String intStr) {
        return HTMLComponent.getInt(intStr, 0);
    }

    private int getPercentage(String percent) {
        if (percent == null || !percent.endsWith("%")) {
            return 0;
        }
        return HTMLComponent.getInt(percent.substring(0, percent.length() - 1));
    }

    static int calcSize(int origDim, String requestedDim, int defaultDim, boolean negativeAllowed) {
        if (requestedDim == null) {
            return defaultDim;
        }
        boolean percent = false;
        if (requestedDim.endsWith("%")) {
            percent = true;
            requestedDim = requestedDim.substring(0, requestedDim.length() - 1);
        } else if (requestedDim.endsWith("px")) {
            requestedDim = requestedDim.substring(0, requestedDim.length() - 2);
        }
        int dim = 0;
        try {
            dim = Integer.parseInt(requestedDim);
        }
        catch (Exception e) {
            return origDim;
        }
        if (dim < 0 && !negativeAllowed) {
            return origDim;
        }
        if (percent) {
            return origDim * dim / 100;
        }
        return dim;
    }

    Hashtable getInputFields() {
        return this.inputFields;
    }

    void selectComponent(Component cmp) {
        this.getComponentForm().setFocused(cmp);
        this.getComponentForm().scrollComponentToVisible(cmp);
        if (cmp instanceof RadioButton) {
            ((RadioButton)cmp).setSelected(true);
        } else if (cmp instanceof CheckBox) {
            CheckBox cb;
            cb.setSelected(!(cb = (CheckBox)cmp).isSelected());
        }
    }

    String convertURL(String url) {
        if (this.docInfo != null) {
            return this.docInfo.convertURL(url);
        }
        return url;
    }

    void goToAnchor(String anchorName) {
        Label anchorCmp = (Label)this.anchors.get(anchorName);
        if (anchorCmp != null) {
            int cx = anchorCmp.getX();
            int cy = anchorCmp.getY();
            int h = this.getHeight();
            if (anchorCmp.getAbsoluteY() - this.getY() + h > this.getPreferredH()) {
                h = this.getPreferredH() - (anchorCmp.getAbsoluteY() - this.getY());
            }
            this.scrollRectToVisible(cx, cy, this.getWidth(), h, anchorCmp);
        }
    }

    public void layoutContainer() {
        super.layoutContainer();
    }

    public void actionPerformed(ActionEvent evt) {
        if (this.getComponentForm().getFocused() instanceof TextField) {
            return;
        }
        int keyCode = evt.getKeyEvent();
        Object obj = this.accessKeys.get(new Integer(keyCode));
        if (obj != null) {
            if (obj instanceof HTMLLink) {
                HTMLLink htmlLink = (HTMLLink)obj;
                htmlLink.actionPerformed(null);
            } else if (obj instanceof ForLabel) {
                ((ForLabel)obj).triggerAction();
            } else if (obj instanceof Component) {
                this.selectComponent((Component)obj);
            }
        }
    }

    ResourceThreadQueue getThreadQueue() {
        return this.threadQueue;
    }

    static {
        for (int i = 0; i < INPUT_TYPE_STRINGS.length; ++i) {
            INPUT_TYPES.addElement(INPUT_TYPE_STRINGS[i]);
        }
    }
}

