/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.xml;

import com.sun.lwuit.html.HTMLUtils;
import com.sun.lwuit.xml.Element;
import com.sun.lwuit.xml.ParserCallback;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;

public class XMLParser {
    ParserCallback parserCallback;
    private Hashtable userDefinedCharEntities;

    protected String getSupportedStandardName() {
        return "XML";
    }

    public void addCharEntity(String symbol, int code) {
        if (this.userDefinedCharEntities == null) {
            this.userDefinedCharEntities = new Hashtable();
        }
        this.userDefinedCharEntities.put(XMLParser.trimCharEntity(symbol), new Integer(code));
    }

    public void addCharEntitiesRange(String[] symbols, int startcode) {
        if (this.userDefinedCharEntities == null) {
            this.userDefinedCharEntities = new Hashtable();
        }
        for (int i = 0; i < symbols.length; ++i) {
            if (symbols[i] == null) continue;
            this.userDefinedCharEntities.put(XMLParser.trimCharEntity(symbols[i]), new Integer(startcode + i));
        }
    }

    private static String trimCharEntity(String symbol) {
        if (symbol.startsWith("&")) {
            symbol = symbol.substring(1);
        }
        if (symbol.endsWith(";")) {
            symbol = symbol.substring(0, symbol.length() - 1);
        }
        return symbol;
    }

    protected String convertCharEntity(String charEntity) {
        try {
            return HTMLUtils.convertCharEntity(charEntity, false, this.userDefinedCharEntities);
        }
        catch (IllegalArgumentException iae) {
            this.notifyError(4, null, null, null, "Unrecognized char entity: " + charEntity);
            return "&" + charEntity + ";";
        }
    }

    public Element parse(InputStreamReader is) {
        Element rootElement = this.createNewElement("ROOT");
        try {
            this.parseTagContent(rootElement, is);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (rootElement.getNumChildren() == 0) {
            this.notifyError(8, null, null, null, "XML document contains no root element.");
            return null;
        }
        if (rootElement.getNumChildren() > 1) {
            String roots = "";
            for (int i = 1; i < rootElement.getNumChildren(); ++i) {
                roots = roots + rootElement.getChildAt(i).getName() + ",";
            }
            if (roots.endsWith(",")) {
                roots = roots.substring(0, roots.length() - 1);
            }
            this.notifyError(7, null, null, null, "XML document contains multiple root elements, only the first root (" + rootElement.getChildAt(0).getName() + ") will be used. Excessive roots: " + roots);
        }
        rootElement = rootElement.getChildAt(0);
        return rootElement;
    }

    protected Element createNewElement(String name) {
        return new Element(name);
    }

    protected Element createNewTextElement(String text) {
        return new Element(text, true);
    }

    protected void parseTagContent(Element element, InputStreamReader is) throws IOException {
        String text = null;
        boolean leadingSpace = false;
        char c = (char)is.read();
        String charEntity = null;
        while ((byte)c != -1) {
            if (c == '<') {
                Element childElement;
                if (text != null) {
                    if (charEntity != null) {
                        text = text + "&" + charEntity;
                        charEntity = null;
                    }
                    if (leadingSpace) {
                        text = " " + text;
                    }
                    Element textElement = this.createNewTextElement(text);
                    element.addChild(textElement);
                    text = null;
                    leadingSpace = false;
                }
                if ((childElement = this.parseTag(is)) == null) {
                    String closingTag = "";
                    c = (char)is.read();
                    while (c != '>') {
                        closingTag = closingTag + c;
                        c = (char)is.read();
                    }
                    if (closingTag.equalsIgnoreCase(element.getName())) {
                        return;
                    }
                    if (!this.isEmptyTag(closingTag)) {
                        this.notifyError(3, element.getName(), null, null, "Malformed XML - no appropriate closing tag for " + element.getName());
                    }
                } else if (!childElement.isComment) {
                    element.addChild(childElement);
                }
            } else if (text != null) {
                if (charEntity != null) {
                    if (c == ';') {
                        text = text + this.convertCharEntity(charEntity);
                        charEntity = null;
                    } else {
                        charEntity = charEntity + c;
                    }
                } else if (c == '&') {
                    charEntity = "";
                } else {
                    text = text + c;
                }
            } else if (!this.isWhiteSpace(c)) {
                if (c == '&') {
                    charEntity = "";
                    text = "";
                } else {
                    text = "" + c;
                }
            } else if (c == ' ') {
                leadingSpace = true;
            }
            c = (char)is.read();
        }
    }

    protected boolean isWhiteSpace(char ch) {
        return ch == ' ' || ch == '\n' || ch == '\t' || ch == '\n' || ch == '\r';
    }

    protected Element parseTag(InputStreamReader is) throws IOException {
        String tagName = "";
        String curAttribute = "";
        String curValue = "";
        char c = (char)is.read();
        if (c == '/') {
            return null;
        }
        if (c == '!') {
            c = (char)is.read();
            char c2 = (char)is.read();
            if (c == '-' && c2 == '-') {
                return this.parseCommentOrXMLDeclaration(is, "-->");
            }
            return this.parseCommentOrXMLDeclaration(is, ">");
        }
        if (c == '?') {
            return this.parseCommentOrXMLDeclaration(is, ">");
        }
        while (this.isWhiteSpace(c)) {
            c = (char)is.read();
        }
        while (!this.isWhiteSpace(c) && c != '>' && c != '/') {
            tagName = tagName + c;
            c = (char)is.read();
        }
        while (this.isWhiteSpace(c)) {
            c = (char)is.read();
        }
        Element element = this.createNewElement(tagName = tagName.toLowerCase());
        if (!this.isSupported(element)) {
            this.notifyError(0, tagName, null, null, "The tag '" + tagName + "' is not supported in " + this.getSupportedStandardName());
            if (!this.shouldEvaluate(element)) {
                char lastChar = c;
                while (c != '>') {
                    lastChar = c;
                    c = (char)is.read();
                }
                if (lastChar != '/') {
                    String endTag = "</" + tagName + ">";
                    int index = 0;
                    while (index < endTag.length()) {
                        c = (char)is.read();
                        if (c >= 'A' && c <= 'Z') {
                            c = (char)(c - 65 + 97);
                        }
                        if (c == endTag.charAt(index)) {
                            ++index;
                            continue;
                        }
                        index = 0;
                    }
                }
                return element;
            }
        }
        if (c == '>') {
            if (!this.isEmptyTag(tagName)) {
                this.parseTagContent(element, is);
            }
            return element;
        }
        if (c == '/') {
            c = (char)is.read();
            if (c == '>') {
                return element;
            }
            this.notifyError(6, tagName, null, null, "XML malformed - no > after /");
        }
        while (true) {
            int error;
            curAttribute = "" + c;
            c = (char)is.read();
            while (!this.isWhiteSpace(c) && c != '=' && c != '>') {
                curAttribute = curAttribute + c;
                c = (char)is.read();
            }
            if (c == '>') {
                this.notifyError(5, tagName, curAttribute, null, "Unexpected tag closing in tag " + tagName + ", attribute=" + curAttribute);
                if (!this.isEmptyTag(tagName)) {
                    this.parseTagContent(element, is);
                }
                return element;
            }
            while (this.isWhiteSpace(c)) {
                c = (char)is.read();
            }
            if (c != '=') {
                this.notifyError(6, tagName, curAttribute, null, "Unexpected character " + c + ", expected '=' after attribute " + curAttribute + " in tag " + tagName);
                if (c != '>') continue;
                if (!this.isEmptyTag(tagName)) {
                    this.parseTagContent(element, is);
                }
                return element;
            }
            c = (char)is.read();
            while (this.isWhiteSpace(c)) {
                c = (char)is.read();
            }
            char quote = ' ';
            if (c == '\"' || c == '\'') {
                quote = c;
            } else {
                curValue = curValue + c;
            }
            String charEntity = null;
            boolean ended = false;
            while (!ended) {
                c = (char)is.read();
                if (c == quote) {
                    ended = true;
                    c = (char)is.read();
                    continue;
                }
                if (quote == ' ' && (c == '/' || c == '>' || this.isWhiteSpace(c))) {
                    ended = true;
                    continue;
                }
                if (c == '&') {
                    if (charEntity != null) {
                        curValue = curValue + "&" + charEntity;
                    }
                    charEntity = "";
                    continue;
                }
                if (charEntity != null) {
                    if (c == ';') {
                        curValue = curValue + this.convertCharEntity(charEntity);
                        charEntity = null;
                        continue;
                    }
                    charEntity = charEntity + c;
                    continue;
                }
                curValue = curValue + c;
            }
            if (charEntity != null) {
                curValue = curValue + "&" + charEntity;
                charEntity = null;
            }
            if ((error = element.setAttribute(curAttribute = curAttribute.toLowerCase(), curValue)) == 1) {
                this.notifyError(error, tagName, curAttribute, curValue, "Attribute '" + curAttribute + "' is not supported for tag '" + tagName + "'.");
            } else if (error == 2) {
                this.notifyError(error, tagName, curAttribute, curValue, "Attribute '" + curAttribute + "' in tag '" + tagName + "' has an invalid value (" + curValue + ")");
            }
            while (this.isWhiteSpace(c)) {
                c = (char)is.read();
            }
            if (c == '>') {
                if (!this.isEmptyTag(tagName)) {
                    this.parseTagContent(element, is);
                }
                return element;
            }
            if (c == '/') {
                c = (char)is.read();
                if (c == '>') {
                    return element;
                }
                this.notifyError(6, tagName, curAttribute, curValue, "XML malformed - no > after /");
            }
            curAttribute = "";
            curValue = "";
        }
    }

    protected Element parseCommentOrXMLDeclaration(InputStreamReader is, String endTag) throws IOException {
        int endTagPos = 0;
        String text = "";
        boolean ended = false;
        while (!ended) {
            char c = (char)is.read();
            if (c == endTag.charAt(endTagPos)) {
                if (++endTagPos != endTag.length()) continue;
                ended = true;
                continue;
            }
            if (endTagPos != 0) {
                text = text + endTag.substring(0, endTagPos);
                endTagPos = 0;
            }
            text = text + c;
        }
        String elementName = null;
        elementName = endTag.equals("-->") ? "comment" : "XML declaration";
        Element comment = this.createNewElement(elementName);
        comment.setAttribute("content", text);
        comment.isComment = true;
        return comment;
    }

    protected boolean isEmptyTag(String tagName) {
        return false;
    }

    protected void notifyError(int errorId, String tag, String attribute, String value, String description) {
        boolean cont;
        if (this.parserCallback != null && !(cont = this.parserCallback.parsingError(errorId, tag, attribute, value, description))) {
            throw new IllegalArgumentException(description);
        }
    }

    protected boolean isSupported(Element element) {
        return true;
    }

    protected boolean shouldEvaluate(Element element) {
        return true;
    }

    public void setParserCallback(ParserCallback parserCallback) {
        this.parserCallback = parserCallback;
    }
}

