/*
 * Decompiled with CFR 0.152.
 */
package com.wordsteps.ui.common.renderers;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Label;
import com.sun.lwuit.List;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.list.ListCellRenderer;
import com.wordsteps.model.Word;
import com.wordsteps.ui.common.ProgressBar;
import com.wordsteps.ui.common.TransparentLabel;
import com.wordsteps.ui.common.UIProfile;
import com.wordsteps.ui.util.ImageRegistry;

public class WordListCellRenderer
extends Container
implements ListCellRenderer {
    private Label focus = new Label();
    private TransparentLabel sourceWord;
    private TransparentLabel translation;
    private TransparentLabel transcription;
    private ProgressBar status;

    public WordListCellRenderer() {
        this.focus.getStyle().setBgColor(14608594);
        this.sourceWord = new TransparentLabel("");
        this.translation = new TransparentLabel("");
        this.transcription = new TransparentLabel("");
        this.status = new ProgressBar();
        this.setLayout(new BoxLayout(2));
        this.sourceWord.getStyle().setPadding(1, 0, 2, 2);
        this.translation.getStyle().setPadding(0, 0, 2, 5);
        this.transcription.getStyle().setPadding(0, 0, 2, 2);
        UIProfile.applyFont(this.sourceWord.getStyle(), "preview.word.font");
        UIProfile.applyFont(this.translation.getStyle(), "preview.translation.font");
        UIProfile.applyFont(this.transcription.getStyle(), "preview.transcription.font");
        Container topContainer = new Container(new BoxLayout(2));
        topContainer.addComponent(this.sourceWord);
        topContainer.addComponent(this.translation);
        this.translation.setAlignment(3);
        this.addComponent(topContainer);
        Container bottom = new Container(new BorderLayout());
        bottom.addComponent("Center", (Component)this.transcription);
        bottom.addComponent("East", (Component)this.status);
        this.addComponent(bottom);
        this.addComponent(new TransparentLabel(ImageRegistry.getImage("word-list.separator")));
    }

    public Component getListCellRendererComponent(List list, Object value, int index, boolean isSelected) {
        Word word = (Word)value;
        this.sourceWord.setText(word.getWord());
        this.translation.setText(word.getTranslation());
        this.transcription.setText("");
        this.status.setCurrentValue(word.getExercises().size() * 100 / 5);
        return this;
    }

    public Component getListFocusComponent(List list) {
        return this.focus;
    }
}

