/*
 * Decompiled with CFR 0.152.
 */
package com.wordsteps.ui.screen;

import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Image;
import com.sun.lwuit.List;
import com.sun.lwuit.TabbedPane;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.list.DefaultListModel;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.UIManager;
import com.sun.lwuit.table.TableLayout;
import com.wordsteps.model.Dictionary;
import com.wordsteps.model.DictionarySelectionProvider;
import com.wordsteps.model.Language;
import com.wordsteps.ui.common.Constants;
import com.wordsteps.ui.common.TransparentLabel;
import com.wordsteps.ui.common.UIProfile;
import com.wordsteps.ui.common.commands.BackCommand;
import com.wordsteps.ui.common.commands.LearnCommand;
import com.wordsteps.ui.common.renderers.WordListCellRenderer;
import com.wordsteps.ui.screen.ScreenForm;
import com.wordsteps.ui.screen.exercise.ExerciseFormBundle;
import com.wordsteps.ui.util.ImageRegistry;

public class PreviewScreenForm
extends ScreenForm
implements ActionListener,
DictionarySelectionProvider {
    private TextArea dictionaryName = new TextArea();
    private TransparentLabel langLabel;
    private TransparentLabel langSrcLabel;
    private TransparentLabel langDstLabel;
    private TransparentLabel langValue;
    private TransparentLabel wordCountLabel;
    private TransparentLabel wordCountValue;
    private TransparentLabel authorLabel;
    private TransparentLabel authorValue;
    private TransparentLabel ratingLabel;
    private TransparentLabel ratingValue;
    private TransparentLabel complexityLabel;
    private TransparentLabel[] complexityValue;
    private TransparentLabel progressLabel;
    private TransparentLabel progressValue;
    private TransparentLabel categoriesLabel;
    private TextArea categoriesValue;
    private List wordList;
    TabbedPane tabs;
    private Component[] tabCmps;
    private Command backCommand;
    private Command learnCommand;
    private Dictionary dictionary;

    public PreviewScreenForm(Form prevForm) {
        super(prevForm);
        this.dictionaryName.setFocusable(false);
        this.dictionaryName.setEditable(false);
        this.dictionaryName.getStyle().setFgColor(4034476);
        UIProfile.applyFont(this.dictionaryName.getStyle(), "preview.dicname.font");
        this.dictionaryName.getStyle().setBorder(null);
        this.langLabel = new TransparentLabel("preview.language");
        this.langSrcLabel = new TransparentLabel("");
        this.langDstLabel = new TransparentLabel("");
        this.langValue = new TransparentLabel("");
        this.wordCountLabel = new TransparentLabel("preview.words.count");
        this.wordCountValue = new TransparentLabel("");
        this.authorLabel = new TransparentLabel("preview.addedby");
        this.authorValue = new TransparentLabel("");
        this.ratingLabel = new TransparentLabel("preview.rating");
        this.ratingValue = new TransparentLabel("");
        this.complexityLabel = new TransparentLabel("preview.complexity");
        this.complexityValue = new TransparentLabel[5];
        for (int i = 0; i < 5; ++i) {
            this.complexityValue[i] = new TransparentLabel(ImageRegistry.getImage("star.grey"));
        }
        this.progressLabel = new TransparentLabel("preview.learnt.count");
        this.progressValue = new TransparentLabel("");
        this.categoriesLabel = new TransparentLabel("preview.categories");
        this.categoriesValue = new TextArea();
        this.categoriesValue.setFocusable(false);
        this.categoriesValue.setEditable(false);
        this.categoriesValue.setStyle(this.categoriesLabel.getStyle());
        this.wordList = new List(){

            protected boolean isSelectableInteraction() {
                return false;
            }
        };
        this.wordList.setIgnoreFocusComponentWhenUnfocused(true);
        this.tabs = new TabbedPane();
        this.tabCmps = new Component[2];
        this.setScrollable(false);
        this.setLayout(new BoxLayout(2));
        this.createComponents();
        this.createCommands();
    }

    public void setDictionary(Dictionary dict) {
        this.dictionary = dict;
        ExerciseFormBundle.getInstance().dictionaryUpdated(dict);
        this.dictionaryName.setText(dict.getInfo().getName());
        this.wordCountValue.setText(String.valueOf(dict.getWords().length));
        this.authorValue.setText(dict.getInfo().getAuthor());
        this.ratingValue.setText(String.valueOf(dict.getInfo().getRate()));
        int k = dict.getInfo().getComplexity() / 10;
        k = k < 5 ? k : 4;
        for (int i = 0; i < 5; ++i) {
            this.complexityValue[i].setIcon(ImageRegistry.getImage(i < k ? "star.yellow" : "star.grey"));
        }
        String[] cats = dict.getInfo().getCategories();
        StringBuffer catsValue = new StringBuffer();
        for (int i = 0; i < cats.length; ++i) {
            catsValue.append(cats[i]).append('\n');
        }
        this.categoriesValue.setText(catsValue.toString());
        Language srcLang = dict.getInfo().getSourceLanguage();
        Language dstLang = dict.getInfo().getTargetLanguage();
        this.langSrcLabel.setIcon(ImageRegistry.getImage(srcLang.getCode()));
        this.langDstLabel.setIcon(ImageRegistry.getImage(dstLang.getCode()));
        this.langValue.setText('(' + srcLang.getCode() + '-' + dstLang.getCode() + ')');
        this.wordList.setModel(new DefaultListModel(dict.getWords()));
        this.wordList.setListCellRenderer(new WordListCellRenderer());
        this.wordList.addActionListener(this);
    }

    private void createComponents() {
        Container infoContainer = new Container(new BoxLayout(2));
        infoContainer.addComponent(this.dictionaryName);
        Container container = new Container(new TableLayout(7, 2));
        container.addComponent(this.langLabel);
        Container langContainer = new Container(new BoxLayout(1));
        langContainer.addComponent(this.langSrcLabel);
        langContainer.addComponent(new TransparentLabel("\u2192"));
        langContainer.addComponent(this.langDstLabel);
        langContainer.addComponent(this.langValue);
        UIProfile.applyFont(this.langLabel.getStyle(), "preview.info.font");
        container.addComponent(langContainer);
        container.addComponent(this.categoriesLabel);
        container.addComponent(this.categoriesValue);
        container.addComponent(this.wordCountLabel);
        container.addComponent(this.wordCountValue);
        container.addComponent(this.authorLabel);
        container.addComponent(this.authorValue);
        container.addComponent(this.ratingLabel);
        container.addComponent(this.ratingValue);
        UIProfile.applyFont(this.categoriesLabel.getStyle(), "preview.info.font");
        UIProfile.applyFont(this.categoriesValue.getStyle(), "preview.info.font");
        UIProfile.applyFont(this.wordCountLabel.getStyle(), "preview.info.font");
        UIProfile.applyFont(this.wordCountValue.getStyle(), "preview.info.font");
        UIProfile.applyFont(this.authorLabel.getStyle(), "preview.info.font");
        UIProfile.applyFont(this.authorValue.getStyle(), "preview.info.font");
        UIProfile.applyFont(this.ratingLabel.getStyle(), "preview.info.font");
        UIProfile.applyFont(this.ratingValue.getStyle(), "preview.info.font");
        container.addComponent(this.complexityLabel);
        UIProfile.applyFont(this.complexityLabel.getStyle(), "preview.info.font");
        Container complexityContainer = new Container(new BoxLayout(1));
        for (int i = 0; i < 5; ++i) {
            complexityContainer.addComponent(this.complexityValue[i]);
        }
        container.addComponent(complexityContainer);
        container.addComponent(this.progressLabel);
        container.addComponent(this.progressValue);
        UIProfile.applyFont(this.progressLabel.getStyle(), "preview.info.font");
        UIProfile.applyFont(this.progressValue.getStyle(), "preview.info.font");
        container.getStyle().setBorder(Border.createRoundBorder(15, 15, 12508914));
        container.getStyle().setBgColor(15333118);
        infoContainer.addComponent(container);
        infoContainer.setScrollableY(true);
        this.tabs.addTab("preview.words", this.wordList);
        this.tabs.addTab("preview.info", infoContainer);
        this.tabCmps[0] = this.wordList;
        this.tabCmps[1] = infoContainer;
        this.setFocused(this.wordList);
        this.addComponent(this.tabs);
    }

    public void createCommands() {
        this.learnCommand = new LearnCommand(this, this);
        this.backCommand = new BackCommand(this.getPreviousScreenForm());
        this.addCommand(this.backCommand, 0);
        this.addCommand(Constants.NULL_COMMAND_0, 1);
        this.addCommand(this.learnCommand, 2);
    }

    public Image getImage() {
        throw new RuntimeException("Not supported yet.");
    }

    public String getName() {
        return "preview.title";
    }

    public String getShortName() {
        return "preview.title";
    }

    public Dictionary getSelectedDictionary() {
        return this.dictionary;
    }

    public void actionPerformed(ActionEvent ae) {
        this.learnCommand.actionPerformed(ae);
    }

    public void keyPressed(int keyCode) {
        int game = Display.getInstance().getGameAction(keyCode);
        if (!(game != 5 && game != 2 || this.tabs.hasFocus())) {
            this.tabs.requestFocus();
        }
        super.keyPressed(keyCode);
        this.setFocused(this.tabCmps[this.tabs.getSelectedIndex()]);
        if (this.tabs.getSelectedIndex() == 1) {
            this.progressValue.setText(this.dictionary.getLearntWordsCount() + " " + UIManager.getInstance().localize("preview.of", "[NULL]") + ' ' + this.dictionary.getWords().length);
        }
    }

    public void pointerPressed(int x, int y) {
        Component cmp = this.getComponentAt(x, y);
        if (cmp != null && cmp instanceof List && this.tabs.equals(cmp.getParent()) && cmp.isFocusable()) {
            this.setFocused(this.tabs);
            cmp.pointerPressed(x, y);
            this.tactileTouchVibe(cmp);
            if (this.tabs.getSelectedIndex() == 1) {
                this.progressValue.setText(this.dictionary.getLearntWordsCount() + " " + UIManager.getInstance().localize("preview.of", "[NULL]") + ' ' + this.dictionary.getWords().length);
            }
            return;
        }
        super.pointerPressed(x, y);
    }

    private void tactileTouchVibe(Component cmp) {
        int dur = UIManager.getInstance().getLookAndFeel().getTactileTouchDuration();
        if (dur > 0 && cmp.isTactileTouch()) {
            Display.getInstance().vibrate(dur);
        }
    }

    public void pointerReleased(int x, int y) {
        Component cmp = this.getComponentAt(x, y);
        if (cmp != null && cmp instanceof List && this.tabs.equals(cmp.getParent())) {
            cmp.pointerReleased(x, y);
            this.setFocused(this.tabCmps[this.tabs.getSelectedIndex()]);
            return;
        }
        super.pointerReleased(x, y);
    }

    public void pointerDragged(int x, int y) {
        Component cmp = this.getComponentAt(x, y);
        if (cmp != null && cmp instanceof List && this.tabs.equals(cmp.getParent())) {
            return;
        }
        super.pointerDragged(x, y);
    }
}

