/*
 * Decompiled with CFR 0.152.
 */
package com.wordsteps.ui.screen.exercise;

import com.sun.lwuit.Form;
import com.wordsteps.model.Dictionary;
import com.wordsteps.model.DictionaryChangeListener;
import com.wordsteps.model.exercise.Exercise;
import com.wordsteps.model.exercise.ExerciseFactory;
import com.wordsteps.ui.screen.exercise.ExerciseForm;
import com.wordsteps.ui.screen.exercise.FlashCardsExerciseForm;
import com.wordsteps.ui.screen.exercise.SelectionExerciseForm;
import com.wordsteps.ui.screen.exercise.TranslateExerciseForm;

public class ExerciseFormBundle
implements DictionaryChangeListener {
    private static ExerciseFormBundle instance;
    private Exercise[] exs = new Exercise[]{ExerciseFactory.createFlashCards(), ExerciseFactory.createDirectSelection(), ExerciseFactory.createReverseSelection(), ExerciseFactory.createDirectTranslation(), ExerciseFactory.createReverseTranslation()};
    private ExerciseForm[] forms = new ExerciseForm[this.exs.length];

    private ExerciseFormBundle() {
        this.initialize();
    }

    public void reload() {
        this.initialize();
    }

    private void initialize() {
        this.forms[0] = new FlashCardsExerciseForm(this.exs[0]);
        this.forms[1] = new SelectionExerciseForm(this.exs[1]);
        this.forms[2] = new SelectionExerciseForm(this.exs[2]);
        this.forms[3] = new TranslateExerciseForm(this.exs[3]);
        this.forms[4] = new TranslateExerciseForm(this.exs[4]);
    }

    public static ExerciseFormBundle getInstance() {
        if (instance == null) {
            instance = new ExerciseFormBundle();
        }
        return instance;
    }

    public ExerciseForm[] getForms() {
        return this.forms;
    }

    public ExerciseForm[] getForms(Form prevForm) {
        for (int i = 0; i < this.forms.length; ++i) {
            this.forms[i].setPreviousScreenForm(prevForm);
        }
        return this.forms;
    }

    public ExerciseForm getNextForm(ExerciseForm form) {
        for (int i = 0; i < this.forms.length; ++i) {
            if (!this.forms[i].equals(form) || i >= this.forms.length - 1) continue;
            return this.forms[i + 1];
        }
        return null;
    }

    public void dictionaryUpdated(Dictionary dic) {
        for (int i = 0; i < this.forms.length; ++i) {
            this.forms[i].getExercise().setDictionary(dic);
        }
    }

    public void dictionaryDeleted(Dictionary dic) {
    }
}

